import { commonSetupModule } from 'common/js/modules';

commonSetupModule.directive('askForDefault', [
	function() {
		return {
			controller: [
				'$scope',
				'userPrefService',
				'$transitions',
				function($scope, userPrefService, $transitions) {
					if (cv.isAdmin) {
						userPrefService.getLoadedUserPrefs().success(function() {
							if (!+cv.userPref.dashboardDefault && !+cv.userPref.dontAskAboutDefault) {
								var deregisterListenerFunc = $transitions.onStart({}, function(transition) {
									if (transition.to().name === 'dashboard') {
										$scope.showMessage = true;
									} else {
										$scope.showMessage = false;
									}
								});

								$scope.makeDefault = function() {
									$scope.dashboardIsDefault = +cv.userPref.dashboardDefault;
									userPrefService
										.setBooleanUserPref('dashboardDefault', !$scope.dashboardIsDefault)
										.success(function() {
											$scope.showMessage = false;
											userPrefService.updateUserPrefs();
										});
									deregisterListenerFunc();
								};

								$scope.dontAskAgain = function() {
									userPrefService.setBooleanUserPref('dontAskAboutDefault', true).success(function() {
										$scope.showMessage = false;
										userPrefService.updateUserPrefs();
									});
									deregisterListenerFunc();
								};
							}
						});
					}
				}
			],
			template:
				'<div class="alert alert-warning action-alert" data-ng-if="showMessage">Make this dashboard your default landing page? <a href="" data-ng-click="makeDefault()">Yes</a> <a href="" data-ng-click="dontAskAgain()">Don\'t ask me again</a> <span data-ng-click="$parent.showMessage = false" class="close">x</span></div>'
		};
	}
]);

export default commonSetupModule;
