import 'modules/servers/js/services/servers.svc.js';

import { commonSetupModule } from 'common/js/modules';

/**
 * A controller for setting whether or not the user wants to be an MSP admin or not.
 */
commonSetupModule.controller('setMspAdminController', [
	'$scope',
	'userPrefService',
	'serverService',
	function($scope, userPrefService, serverService) {
		$scope.showMSP = cvApp.showMSP;

		/**
		 * Save whether or not
		 */
		$scope.saveIsMSPCommcell = function(setUserPref) {
			if ($scope.showMSP) {
				serverService.setIsMSPCommcell($scope.showMSP).success(function() {
					if (setUserPref) {
						userPrefService.setBooleanUserPref('mspConfigured', true);
					}
					$scope.$emit('mspConfigured', $scope.showMSP);
				});
			} else {
				$scope.$emit('mspConfigured', $scope.showMSP);
			}
		};
	}
]);

export default commonSetupModule;
