import 'modules/setup/js/factory/coreSetup.factory.js';
import 'webScale/js/controllers/createStoragePool.ctrl.js';
import 'modules/setup/js/directives/setup-steps.js';

import { commonSetupModule } from 'common/js/modules';

/**
 * A controller for handling the functionality on the Welcome Setup page.
 */
commonSetupModule.controller('coreSetupController', [
	'$scope',
	'$state',
	'$stateParams',
	'coreSetup',
	'cvLoc',
	'userPrefService',
	function($scope, $state, $stateParams, coreSetup, cvLoc, userPrefService) {
		$scope.coreSetupEnabled = true;
		let steps = [
			{
				template: appUtil.appRoot + 'webScale/partials/addStoragePoolSetup.jsp',
				name: cvLoc('title.addLibrary')
			}
		];

		/* do not show server plan setup for Zeal brand */
		if (cvApp.oemId !== 118) {
			steps.push({
				template: appUtil.appRoot + 'dlo/partials/addServerPlan.jsp',
				name: cvLoc('label.createServerPlan')
			});
		}

		coreSetup.newSetup(steps, coreSetup.getMap('CORE_SETUP') || [], $stateParams.forceStep, 'CORE_SETUP');
		angular.extend($scope, coreSetup);
		coreSetup.defaultPage = 'gettingStarted';

		//for VSA OEM, after CORE_SETUP completion redirect the user to complete Virtualization setup
		//for Endpoint OEM, after CORE_SETUP completion redirect the user to complete Endpoint setup

		switch (cvApp.oemId) {
			case 106:
				coreSetup.defaultPage = 'vsaSetup';
				break;
			case 113:
				coreSetup.defaultPage = 'dloSetup';
				break;
			default:
				coreSetup.defaultPage = 'gettingStarted';
		}

		$scope.canMarkAsComplete = false;
		$scope.isSetup = true;
		$scope.customizeForMetallic = false;

		angular.forEach(['emailAdded', 'storageAdded', 'planAdded'], function(event) {
			$scope.$on(event, function() {
				$scope.handleNext();
			});
		});
	}
]);

/**
 * A controller for handling the functionality on the Welcome Setup page.
 */
commonSetupModule.controller('coreSetupTenantControllerOS', [
	'$scope',
	'$state',
	'$stateParams',
	'coreSetup',
	'cvLoc',
	'userPrefService',
	'$http',
	function($scope, $state, $stateParams, coreSetup, cvLoc, userPrefService, $http) {
		$scope.coreSetupEnabled = true;

		var loadStorageConfig = function() {
			coreSetup.newSetup(
				[
					{
						template: appUtil.appRoot + 'modules/settings/partials/downloadOVAPackage.jsp',
						name: cvLoc('pageHeader.addMediaAgent')
					},
					{
						template: appUtil.appRoot + 'webScale/partials/addStoragePoolSetup.jsp',
						name: cvLoc('title.addLibrary')
					}
				],
				coreSetup.getMap('CORE_SETUP_TENANT_OS') || [],
				$stateParams.forceStep,
				'CORE_SETUP_TENANT_OS'
			);
			angular.extend($scope, coreSetup);
			coreSetup.defaultPage = 'gettingStarted';
			$scope.canMarkAsComplete = false;

			$scope.isSetup = true;

			angular.forEach(['downloadPackageComplete', 'storageAdded'], function(event) {
				$scope.$on(event, function() {
					$scope.handleNext();
				});
			});
		};
		//We have to do refresh.do because when LetsGetStarted is Clicked we need to make sure the TENANT_OS_SETUP is initiated in acApp.java
		if (cv.sessionContext.infrastructureType === 'OWN_STORAGE') {
			$http
				.get('refreshSession.do', {
					params: {
						url: $state.current.url
					}
				})
				.then(function(output) {
					cv.sessionContext = output.data;
					loadStorageConfig();
				});
		} else if (cv.sessionContext.infrastructureType === 'HYBRID') {
			loadStorageConfig();
		}
	}
]);

export default commonSetupModule;
