<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.settingsJs"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1>
		<cv:msg bundle="settingsJs" key="header.label.configureMsp" />
	</h1>
</div>
<div class="setup-content configure-msp-setup"
	data-ng-controller="setMspAdminController">
	<div data-ng-switch="showMSP">
		<div data-ng-switch-when="false">
			<form data-cv-submit="saveIsMSPCommcell()" autocomplete="off">
				<p>
					<cv:msg key="label.setEnvironmentAsManagedServiceProvider" bundle="settingsJs" />
				</p>
				<p class="error">
					<cv:msg key="label.cantChangeMSP" bundle="settingsJs" />
				</p>
				<div class="radio-inline">
					<label><input type="radio" data-ng-value="false"
						data-ng-model="showMSP" /> {{'no' | cvLoc}}</label>
				</div>
				<div class="radio-inline">
					<label><input type="radio" data-ng-value="true"
						data-ng-model="showMSP" /> {{'yes' | cvLoc}}</label>
				</div>
				<div class="button-container" data-ng-class="{'centered' : isSetup}">
					<fmt:bundle basename="localization.messages">
						<button id="setMspAdmin_button_#5814" data-ng-if="!isSetup" type="button" 
							class="btn btn-default cvBusyOnAjax" data-ng-click="cancel()">
							<fmt:message key="Cancel" />
						</button>
						<button id="setMspAdmin_button_#5475" type="submit" class="btn btn-primary cvBusyOnAjax"> 
							<fmt:message key="Save" />
						</button>
					</fmt:bundle>
				</div>
			</form>
		</div>
		<div data-ng-switch-when="true">
			<p><cv:msg key="label.mspConfigured" bundle="settingsJs" /></p>
			<div class="button-container" data-ng-class="{'centered' : isSetup}">
				<fmt:bundle basename="localization.messages">
					<button id="setMspAdmin_button_#3340" type="button" class="btn btn-default cvBusyOnAjax" 
						data-ng-click="skip()">
						<cv:msg key="Continue" bundle="messages" />
					</button>
				</fmt:bundle>
			</div>
		</div>
	</div>
</div>