<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.users"></cv:cvMessages>
	<cv:cvMessages bundle="localization.settings"></cv:cvMessages>
</script>
<div>
	<div class="setup-title">
		<h1><cv:msg key="label.httpProxy" bundle="navJs"/></h1>
	</div>
</div>
<div class="setup-content reduced-padding-top" >
	<span class="{{modalCtrl.editPlanMessage.type}} serverMessage">{{modalCtrl.editPlanMessage.message}}</span>
	<form  name="httpProxyForm" novalidate cv-submit="modalCtrl.setProxySettings()" autocomplete="off">
		<div class='addServerModal' >
			<div class="modal-content-padding" data-ng-if="modalCtrl.type !== 'useProxyAuthentication'">
				<label for="proxyServer">
					<cv:msg key="label.proxyServer" bundle="settings"/>
					<input type="text" name="proxyServer" id="proxyServer" data-ng-model="modalCtrl.proxyInfo.proxyServer" data-ng-required="modalCtrl.proxyInfo.useHttpProxy"/>
					<span class="help-block" data-ng-show="cv.httpProxyForm.needsAttention(httpProxyForm.proxyServer)"><cv:msg key="error.proxyServer" bundle="settings"/></span>
				</label>
				<label for="proxyPort"><cv:msg key="label.proxyPort"  bundle="settings"/>
					<input type="number" name="proxyPort" id="proxyPort" data-ng-model="modalCtrl.proxyInfo.preProxyPort" max="61000" min="1" data-ng-required="modalCtrl.proxyInfo.useHttpProxy"/>
					<span class="help-block" data-ng-show="cv.httpProxyForm.needsAttention(httpProxyForm.proxyPort)"><cv:msg key="error.proxyPort" bundle="settings"/></span>
					
				</label>	
				<input type="checkbox" name="ignoreHttpProxyForSendLog" id="ignoreHttpProxyForSendLog" data-ng-model="modalCtrl.proxyInfo.ignoreHttpProxyForSendLog" />
                <label for="ignoreHttpProxyForSendLog"><cv:msg key="label.ignoreHttpProxyForSendLog" bundle="settings" /></label>
			</div>
			<!-- Authentication -->
			<div class="modal-content-padding" data-ng-if="modalCtrl.type != 'useHttpProxy'">
				<div class="proxy-content" >
					<label for="userName">
						<cv:msg key="label.userName" bundle="users"/>
						<input type="text" name="userName" id="userName" data-ng-model="modalCtrl.proxyInfo.proxyCredentials.userName" data-ng-required="true"/>
						<span class="help-block" data-ng-show="cv.httpProxyForm.needsAttention(httpProxyForm.userName)"><cv:msg key="error.userName" bundle="settings"/></span>					
					</label>
					<label for="password"><cv:msg key="label.password" bundle="users"/>
						<input type="password" name="password" id="password" data-ng-model="modalCtrl.proxyInfo.proxyCredentials.password" data-ng-required="true"/>
						<span class="help-block" data-ng-show="cv.httpProxyForm.needsAttention(httpProxyForm.password)"><cv:msg key="error.password" bundle="settings"/></span>				
					</label>
					<label for="confirmPassword"><cv:msg key="label.confirmPassword" bundle="users"/>
						<input type="password" name="confirmPassword" id="confirmPassword" data-ng-model="modalCtrl.proxyInfo.proxyCredentials.confirmPassword" data-ng-required="true" data-cv-equals="{{modalCtrl.proxyInfo.proxyCredentials.password}}"/>
						<span class="help-block" data-ng-show="httpProxyForm.confirmPassword.$error && cv.httpProxyForm.needsAttention(httpProxyForm.confirmPassword)"><cv:msg key="error.confirmPassword" bundle="settings"/></span>
					</label>
				</div>
			</div>
		</div>
		
		<div class="button-container">
			  	<button id="proxySettingsModal_button_#6715" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="modalCtrl.cancel()"><cv:msg key="action.cancel" bundle="settings" /></button> 
			  	<button id="proxySettingsModal_button_#7625" type="submit" class="btn btn-primary cvBusyOnAjax"><cv:msg key="action.save" bundle="settings" /></button> 
		</div>
	</form>
</div>
