<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
<cv:cvMessages bundle="localization.settingsJs"></cv:cvMessages>
</script>
<fmt:bundle basename="localization.settings">
<span class="center-container">
	<div class="center-container__center-el">
		<div class="back-strip">
			<div class="set-up-page" >
				<div class="setup-title">
					<h1>Getting started</h1>
				</div>
				<br/>
				<div class="" data-ng-controller="mspSettingController">
					<div>
						Before you continue : <br/><br/>
						
						<ul class="checklist-setup">
						  <li>Ensure you have read the Quick Start Guide</li>
						  <li>Ensure a COMMVAULT DataMover bundle has been deployed and configured to the COMMVAULT Server</li>
						  <li>Ensure you have configured and formatted LUN(s) inside the COMMVAULT DataMover for your Index Cache, Deduplication Database, Target Storage (Such as E:\, F:\, G:\) according to the specification outlined in the quick start guide</li>
						  <li>Ensure VMWare vCenter and/or Microsoft Hyper-V Cluster details (including credentials) are readily available</li>
						  <li>Ensure you have at least 1 provisioned Virtual Machine in your VMWare vCenter and/or Microsoft Hyper-V environment</li>
						</ul>  
						<br/>
						Once you have verified all details are available, you may proceed by clicking Next.
					</div>
					
					<div class="setup-content">
						<div class="button-container centered">
							<fmt:bundle basename="localization.messages">
								<button id="mspGettingStarted_button_#8830" type="button" class="btn btn-primary" data-ng-click="skip()"><cv:msg key="action.next" bundle="settingsJs"/></button> 
							</fmt:bundle>
						</div>
					</div>
				</div>
				
			</div>
		</div>
	</div>
</span>
</fmt:bundle>
