<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.restore"></cv:cvMessages>
	<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
	<cv:cvEnum name="EVGui.ProxyGatewayConfigurationType"></cv:cvEnum>
	<cv:cvEnum name="EVGui.SoftwareDownloadProtocolType"></cv:cvEnum>
	<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
	<cv:cvMessages bundle="localization.settings"></cv:cvMessages>
	<cv:cvMessages bundle="localization.schedule"></cv:cvMessages>
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
	<cv:cvMessages bundle="localization.storage"></cv:cvMessages>
	<cv:cvMessages bundle="localization.scheduleJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.dr"></cv:cvMessages>
	<cv:cvMessages bundle="localization.alerts"></cv:cvMessages>
	<cv:cvMessages bundle="localization.ediscovery"></cv:cvMessages>
	<cv:cvMessages bundle="localization.sqlserver"></cv:cvMessages>
</script>
<div class="cv-material-page cv-tile-tooltip">
<div class="row">
	<div class="cv-material-menubar col-xs-12">
		<h2 class="cv-material-headline"><cv:msg key="pageHeader.maintenance" bundle="settings"/></h2>
	</div>
</div>
	<!--internet Proxy  -->
<!--internet Proxy  -->
<div class="group row">
	<div class="col-xs-12 col-sm-6"  >
	<div data-ng-controller="internetProxyController as proxyCtrl">
		<cv-tile-component  data-ac-id="maintenance-label_httpProxy-settings" included-svg='proxyCtrl.httpProxySvg' data-title='<cv:msg key="label.httpProxy" bundle="navJs"/>' min-height="true" loader="proxyCtrl.showResult" load-manually="true" load-func="proxyCtrl.loadData" help-text='<cv:msg key="tooltip.httpProxy" bundle="settings"/>'>
			<div class="error serverMessage">{{proxyCtrl.serverMessage}}</div>
			<ul class="list-style-secondary no-margin">
				<li class="group">
					<span class="pageDetail-three-columns-first"><cv:msg key="label.proxyServer" bundle="settings"/></span>
                	<span class="pageDetail-three-columns-second"><toggle-control status="proxyCtrl.proxyInfo.useHttpProxy? 'enabled-activity' : 'disabled-activity'" title="{{'label.enableDisable' | cvLoc}}" data-ng-click="proxyCtrl.editHTTPProxyModal('useHttpProxy',true)"></toggle-control>
                	</span>
                	<a class="pageDetail-three-columns-third" id="internetProxy_button_#6160"  data-ng-if="proxyCtrl.proxyInfo.useHttpProxy"   data-ng-click="proxyCtrl.editHTTPProxyModal('useHttpProxy', false)"><cv:msg key="action.editModal" bundle="profiles"/></a>
				</li>
				<li class="group" data-ng-if="proxyCtrl.proxyInfo.useHttpProxy">
					<span class="pageDetail-three-columns-first"><cv:msg key="label.availableAuthentication" bundle="settings"/></span>
					<span class="pageDetail-three-columns-second"><toggle-control status="proxyCtrl.proxyInfo.useProxyAuthentication? 'enabled-activity' : 'disabled-activity'" title="{{'label.enableDisable' | cvLoc}}" data-ng-click="proxyCtrl.editHTTPProxyModal('useProxyAuthentication',true)"></toggle-control>
					</span>
					<a class="pageDetail-three-columns-third" id="internetProxy_button_#6304"  data-ng-if="proxyCtrl.proxyInfo.useProxyAuthentication" data-ng-click="proxyCtrl.editHTTPProxyModal('useProxyAuthentication',false)"><cv:msg key="action.editModal" bundle="profiles"/></a>
				</li>
			</ul>
		</cv-tile-component>
	</div>
	<div data-ng-controller="internetProxyController as proxyCtrl">
		<cv-tile-component  data-ac-id="maintenance-label_internetOptions-settings" included-svg='::proxyCtrl.internetOptionSvg' data-title='<cv:msg key="label.internetOptions" bundle="navJs"/>' min-height="true" loader="proxyCtrl.showResult"  load-manually="true" load-func="proxyCtrl.loadData" help-text='<cv:msg key="tooltip.internetOptions" bundle="settings"/>'>
			<div class="error serverMessage">{{proxyCtrl.serverMessage}}</div>
			<ul class="list-style-secondary no-margin">
				<li class="group">
					<span class="pageDetailColumn"><cv:msg key="label.internetGateway" bundle="settings"/></span>
					<span class="pageDetailColumn">{{proxyCtrl.proxyInfo.proxyTypeDisplayName}}<span ng-if="proxyCtrl.proxyInfo.proxyType=='useClient'"> ({{proxyCtrl.proxyInfo.proxyClient.clientName}})</span></span>
				</li>
				<div class="page-details-box-links">
					<button id="internetProxy_button_#8016" class="icon-style cv-material-button" data-ng-click="proxyCtrl.editInternetOptionsModal()">
						<div class="cv-material-button-icon"  data-ng-include="'${pageContext.request.contextPath}/common/svg/gear.svg'"></div>
						<div class="cv-material-button-tooltip"><cv:msg key="action.edit" bundle="settings" /></div>
					</button>
				</div>
			</ul>
		</cv-tile-component>
	</div>
	<div data-ng-controller="installUpdateController">
		 <cv-tile-component included-svg='installUpdatesSvg' data-title='<cv:msg key="label.installUpdateSchedules" bundle="navJs"/>' min-height="true" loader="isInstallUpdateScheduleLoaded"  load-manually="true" load-func="loadScheduleList" >
		 	<cv-kendo-grid data-cv-grid-options="gridOptions" class="installUpdateKendo"></cv-kendo-grid>
            <div class="page-details-box-links">
				<button id="internetProxy_button_#0958" class="icon-style cv-material-button" data-ng-click="runInstallUpdateJob()">
						<div class="cv-material-button-icon" data-ng-include="'${pageContext.request.contextPath}/common/svg/run.svg'"></div>
						<div class="cv-material-button-tooltip"><cv:msg key="action.runJob" bundle="settings"/></div>
				</button>
				<button id="internetProxy_button_#6092" class="icon-style cv-material-button" data-ng-click="addInstallUpdateSchedule()">
					<div class="cv-material-button-icon"  data-ng-include="'${pageContext.request.contextPath}/common/svg/add_schdule.svg'"></div>
					<div class="cv-material-button-tooltip"><cv:msg key="label.addSchedule" bundle="schedule"/></div>
				</button>
            </div>
        </cv-tile-component>
	</div>
	<div data-ng-controller="smartMAStateManagementController as stmCtrl" >
		<cv-tile-component  data-ng-if="showSmartMAStateManagement" data-ac-id="maintenance-label_internetOptions-settings"  data-title='<cv:msg key="label.smartMAStateManagement" bundle="storage"/>' min-height="true"  load-manually="true" load-func="loadData" help-text='<cv:msg key="tooltip.smartMAStateManagement" bundle="storage"/>'>
			<ul class="list-style-secondary no-margin" >
				<li class="group">
					<span class="pageDetail-three-columns-first"><cv:msg key="label.enabled" bundle="schedule"/></span>
					<span class="pageDetail-three-columns-second"><toggle-control status="enabled" title="{{'label.enableDisable' | cvLoc}}" data-ng-click="toggleState()"></toggle-control></span>
					<a id="internetProxy_button_smartMA" class="pageDetail-three-columns-third" data-ng-if="state" href="" data-ng-click="loadModal()"><cv:msg key="action.editModal" bundle="profiles"/></a>
				</li>
			</ul>
		</cv-tile-component>
	</div>
	</div>
	<!-- dr backup -->
	<div class="col-xs-12 col-sm-6" >
	<div data-ng-controller="drBackupController as drCtrl" >
		<cv-tile-component data-ac-id="maintenance-pageHeader_drBackup-settings" included-svg='drCtrl.drBackupSvg' data-title='<cv:msg key="pageHeader.drBackup" bundle="navJs"/>' min-height="true" loader="drCtrl.exportSettings" load-manually="true" load-func="drCtrl.loadData" help-text='<cv:msg key="tooltip.drBackup" bundle="settings"/>'>
			<div class="error serverMessage">{{drCtrl.serverMessage}}</div>
			<ul class="list-style-secondary no-margin" data-ng-if="drCtrl.exportSettings.DRNumFulls" >
				<li class="group">
					<span class="pageDetailColumn"><cv:msg key="label.numberofMetadata" bundle="settings"/> </span>
					<span class="pageDetailColumn">{{drCtrl.exportSettings.DRNumFulls}}</span>
				</li>
				<li class="group">
					<span class="pageDetailColumn"><cv:msg key="label.fsServer" bundle="restore"/></span>
					<span class="pageDetailColumn">
						<span>
							<span data-ng-if="drCtrl.exportSettings.UseLocalDrive"><cv:msg key="label.localDrive" bundle="settings"/></span>
							<span data-ng-if="!drCtrl.exportSettings.UseLocalDrive"><cv:msg key="label.networkShare" bundle="settings"/></span>
							<span>[{{drCtrl.exportSettings.DRDumpLocation}}]</span>
						</span>
					</span>
				</li>
			</ul>
			<span data-ng-if="!drCtrl.exportSettings.DRNumFulls && drCtrl.exportSettings && drCtrl.showEdit">
				<p class="info-place-holder"><cv:msg key="info.noConfigured" bundle="settings"/></p>
			</span>
			<div class="page-details-box-links" data-ng-if="drCtrl.showEdit">
				<button id="internetProxy_button_#7749" class="icon-style cv-material-button" data-ng-click="drCtrl.openRunJob()">
					<div class="cv-material-button-icon"  data-ng-include="'${pageContext.request.contextPath}/common/svg/run.svg'"></div>
					<div class="cv-material-button-tooltip"><cv:msg key="action.runJob" bundle="settings"/></div>
				</button>
				<button id="internetProxy_button_#0368" class="icon-style cv-material-button" data-ng-click="drCtrl.editDRBackup()">
					<div class="cv-material-button-icon"  data-ng-include="'${pageContext.request.contextPath}/common/svg/gear.svg'"></div>
					<div class="cv-material-button-tooltip"><cv:msg key="action.edit" bundle="settings"/></div>
				</button>
			</div>
		</cv-tile-component>
	</div>
	<div data-ng-controller="loadDefaultSoftwareController">
		<cv-tile-component data-ng-if="model.showCopySoftware" included-svg='copySoftwareSvg' extra-class="help-text-absolute" data-ac-id="maintenance-label_downloadSoftware-servers" data-title='<cv:msg key="label.manageSoftware" bundle="settings"/>' min-height="true" loader="isDownloadSoftwareLoaded"  load-manually="true" load-func="loadData" help-text='<cv:msg key="tooltip.downloadSoftware" bundle="settings"/>'>
		
		    <div class="error serverMessage">{{serverErrorMessage}}</div>
			<ul class="list-style-secondary no-margin">
			    <li class="group" data-ng-if="model.currentSPInstalled">
					<span class="pageDetailColumn"><cv:msg key="label.currentServicePackInstalled" bundle="serversJs"/></span>
					<span class="pageDetailColumn" data-ng-bind="model.currentSPInstalled | getVersionString"></span>
				</li>
				<li class="group" data-ng-if="model.availableSP">
					<span class="pageDetailColumn"><cv:msg key="label.latestAvailableServicePack" bundle="serversJs"/></span>
					<span class="pageDetailColumn" data-ng-bind="model.availableSP | getVersionString"></span>
				</li>
				<li class="group" data-ng-if="model.updateCachePath">
					<span class="pageDetailColumn"><cv:msg key="label.updateCachePath" bundle="settings"/></span>
					<span class="pageDetailColumn" data-ng-bind="model.updateCachePath"></span>
				</li>
				<li class="group" data-ng-if="model.downloadSoftwareInfo.pattern">
					<span class="pageDetailColumn"><cv:msg key="label.downloadScheduleSummary" bundle="serversJs"/></span>
					<span class="pageDetailColumn" data-ng-bind="model.downloadSoftwareInfo.pattern.description"></span>
				</li>
				<li class="group" data-ng-if="model.description">
					<span class="pageDetailColumn"><cv:msg key="label.copyScheduleSummary" bundle="serversJs"/></span>
					<span class="pageDetailColumn" data-ng-bind="model.description"></span>
				</li>
				<li class="group" data-ng-if="existingJob">
					<span class=""><cv:msg key="label.narrativeJob1" bundle="settings"/> <a data-ng-bind="existingJob.jobId" href="#/jobs/{{existingJob.jobId}}"></a> <cv:msg key="label.narrativeJob2" bundle="settings"/></span>
				</li>
			</ul>
			<div class="page-details-box-links">
				<button class="icon-style cv-material-button" data-ng-click="openDownloadSoftwareDialog(0, '', false)">
					<div class="cv-material-button-icon"  data-ng-include="'${pageContext.request.contextPath}/common/svg/run.svg'"></div>
					<div class="cv-material-button-tooltip"><cv:msg key="action.runJob" bundle="settings"/></div>
				</button>
				<button class="icon-style cv-material-button" data-ng-click="openDownloadSoftwareDialog(0, '', true)">
					<div class="cv-material-button-icon" data-ng-include="'${pageContext.request.contextPath}/common/svg/add_schdule.svg'"></div>
					<div class="cv-material-button-tooltip"><cv:msg key="action.scheduleJob" bundle="settings" /></div>
				</button>
			</div>
		</cv-tile-component>
		<cv-tile-component data-ng-if="!model.showCopySoftware" included-svg='downloadSoftwareSvg' data-ac-id="maintenance-label_downloadSoftware-servers" data-title='<cv:msg key="label.downloadSoftware" bundle="navJs"/>' min-height="true" loader="isDownloadSoftwareLoaded"  load-manually="true" load-func="loadData" help-text='<cv:msg key="tooltip.downloadSoftware" bundle="settings"/>'>
		    <div class="error serverMessage">{{serverErrorMessage}}</div>
			<ul class="list-style-secondary no-margin">
			    <li class="group" data-ng-if="model.currentSPInstalled">
					<span class="pageDetailColumn"><cv:msg key="label.currentServicePackInstalled" bundle="serversJs"/></span>
					<span class="pageDetailColumn">{{model.currentSPInstalled | getVersionString}}</span>
				</li>
				<li class="group" data-ng-if="model.availableSP">
					<span class="pageDetailColumn"><cv:msg key="label.latestAvailableServicePack" bundle="serversJs"/></span>
					<span class="pageDetailColumn">{{model.availableSP | getVersionString}}</span>
				</li>
				<li class="group" data-ng-if="model.downloadSoftwareInfo.pattern">
					<span class="pageDetailColumn"><cv:msg key="label.scheduleSummary" bundle="serversJs"/></span>
					<span class="pageDetailColumn">{{model.downloadSoftwareInfo.pattern.description}}</span>
				</li>
			</ul>
			<div class="page-details-box-links">
				<button id="internetProxy_button_#4903" class="icon-style cv-material-button" data-ng-click="openDownloadSoftwareDialog(0, '', false)">
					<div class="cv-material-button-icon"  data-ng-include="'${pageContext.request.contextPath}/common/svg/run.svg'"></div>
					<div class="cv-material-button-tooltip"><cv:msg key="action.runJob" bundle="settings"/></div>
				</button>
				<button id="internetProxy_button_#7751" class="icon-style cv-material-button" data-ng-click="openDownloadSoftwareDialog(0, '', true)">
					<div class="cv-material-button-icon"  data-ng-include="'${pageContext.request.contextPath}/common/svg/gear.svg'"></div>
					<div class="cv-material-button-tooltip"><cv:msg key="action.edit" bundle="settings" /></div>
				</button>
			</div>
		</cv-tile-component>
	</div>
	<div data-ng-controller="WebDomainsController as domainCtrl" >
		<cv-tile-component  data-ac-id="maintenance-label_internetOptions-settings"  included-svg='domainCtrl.webDomiansSvg' data-title='Web Domains' min-height="true" loader="domainCtrl.showWebDomains"  load-manually="true" load-func="domainCtrl.loadData" help-text='<cv:msg key="tooltip.webDomains" bundle="settings"/>'>
			<div class="domainCtrl.serverMessage.type serverMessage">{{domainCtrl.serverMessage.message}}</div>
				<ul class="list-style__row group">
					<li data-ng-if="domainCtrl.domainObj.domainList.length == 0" class="info-place-holder"><cv:msg key="info.noDomains" bundle="settings" /></li>
					<li data-ng-repeat="domain in domainCtrl.domainObj.domainList track by $index" >{{domain}}</li>
				</ul>
				<div class="page-details-box-links">
					<button id="internetProxy_button_#1472" class="icon-style cv-material-button" data-ng-click="domainCtrl.editDomainList()">
						<div class="cv-material-button-icon"  data-ng-include="'${pageContext.request.contextPath}/common/svg/gear.svg'"></div>
						<div class="cv-material-button-tooltip"><cv:msg key="action.edit" bundle="settings" /></div>
					</button>
				</div>
		</cv-tile-component>
	</div>
	</div>
</div>
</div>
