<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.users"></cv:cvMessages>
	<cv:cvMessages bundle="localization.settings"></cv:cvMessages>
</script>
<div>
	<div class="setup-title">
		<h1><cv:msg key="label.internetOptions" bundle="navJs"/></h1>
	</div>
</div>
<div class="bootstrap-wrapper">
	<div>
		<form  name="internetOptionsForm" novalidate cv-submit="internetOptionsCtrl.setProxySettings()" autocomplete="off"  >
		<div class="panel form-panel-holder">
		<div class="panel-body"> 
			<div>
				<h4 class="modal-underline">
				<cv:msg key="label.internetGateway" bundle="settings" />				
				</h4>
				<div class="form-group">
					<label class="col-xs-12 col-lg-12" for="noGateway">
						<input type="radio" data-ng-model="internetOptionsCtrl.proxyInfo.proxyType" value="noGateway" name="noGateway" id="noGateway">
						<cv:msg key="label.noGateway" bundle="settings"/>
					</label>
				</div>	 
				<div class="form-group">
					<label class="col-xs-12 col-lg-12" for="useMetricsServer" title="{{internetOptionsCtrl.getReasonForDisablingMetricsServerOption()}}">
						<input type="radio" data-ng-disabled="internetOptionsCtrl.shouldMetricsServerOptionBeDisabled()" data-ng-model="internetOptionsCtrl.proxyInfo.proxyType" value="useMetricsServer" name="useMetricsServer" id="useMetricsServer">
						<span data-ng-disabled="internetOptionsCtrl.shouldMetricsServerOptionBeDisabled()"><cv:msg key="label.useMetricsServer" bundle="settings"/></span>
					</label>
				</div>	
				<div class="form-group">
					<label class=" col-xs-4" for="useClient">
						<input type="radio" data-ng-model="internetOptionsCtrl.proxyInfo.proxyType" value="useClient" name="useClient" id="useClient">
						<cv:msg key="label.useClient" bundle="settings"/>
					</label>
					<div class=" col-xs-7" data-ng-disabled="internetOptionsCtrl.proxyInfo.proxyType != 'useClient'">
						<select id="gatewayClient" name="gatewayClient"  data-ng-required="internetOptionsCtrl.proxyInfo.proxyType == 'useClient'"
							data-ng-model="internetOptionsCtrl.proxyInfo.proxyClient"
							data-ng-options="ds as ds.displayName || ds.clientName for ds in internetOptionsCtrl.clientsList track by (ds.clientName|lowercase)">
							<!-- <option value=""></option> -->
						</select>
						<input type="checkbox" name="useCloudMetrics" id="useCloudMetrics" data-ng-model="internetOptionsCtrl.proxyInfo.useInternetGatewayPublic" />
						<label for="useCloudMetrics"><cv:msg key="label.useCloudMetrics" bundle="settings" /></label>
						<input type="checkbox" name="usePrivateMetrics" id="usePrivateMetrics" data-ng-model="internetOptionsCtrl.proxyInfo.useInternetGatewayPrivate" />
						<label for="usePrivateMetrics"><cv:msg key="label.usePrivateMetrics" bundle="settings" /></label>
						<input type="checkbox" name="useSendLogFile" id="useSendLogFile" data-ng-model="internetOptionsCtrl.proxyInfo.useInternetGatewaySendLogFile" />
						<label for="useSendLogFile"><cv:msg key="label.useSendLogFile" bundle="settings" /></label>
						<span class="help-block" data-ng-show="internetOptionsCtrl.checkInvalidClientSelection()"><cv:msg key="error.internetGatewayClient" bundle="settings"/></span>
					</div>
				</div>
			</div>
			</div>
			</div>
		<div class="button-container">
			  	<button id="internetOptionsModal_button_#5374" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="internetOptionsCtrl.cancel()"><cv:msg key="action.cancel" bundle="settings" /></button> 
			  	<button id="internetOptionsModal_button_#6105" type="submit" data-ng-disabled="internetOptionsCtrl.checkInvalidClientSelection()" class="btn btn-primary cvBusyOnAjax"><cv:msg key="action.save" bundle="settings" /></button> 
		</div>
	</form>
</div>
</div>
	
