<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
		<cv:cvMessages bundle="localization.settings"></cv:cvMessages>
</script>
<div class="center-container" data-ng-class="{'feedback-padding': !isCoreSetupComplete}">
	<h1 class="page-title"><cv:msg key="pageHeader.feedback" bundle="settings" /></h1>
	<div class="row feedback-content bootstrap-wrapper">
		<!--
			The sprite is first so that in the case where the image and the text/inputs overlap,
			the sprite will be drawn under the text/inputs.
		-->
		<div class="col-lg-5 col-lg-push-7 hidden-md hidden-sm hidden-xs">
			<span class="feedback-sprite"></span>
		</div>
		<div class="col-lg-7 col-lg-pull-5 col-xs-12">
			<div class="info-text">
				<p><cv:msg key="label.feedbackDescPart1" bundle="settings" /></p>
				<p><cv:msg key="label.feedbackDescPart2" bundle="settings" /></p>
				<p>
					<span><cv:msg key="label.feedbackDescPart3" bundle="settings" /></span>
					<a ng-href="{{documentationPageLink}}" target="_blank"><cv:msg key="label.feedbackDescPart4" bundle="settings" /></a>
					<span><cv:msg key="label.feedbackDescPart5" bundle="settings" /></span></p>
			</div>
			<div class="row"> <!-- Spacing -->
				<div class="col-xs-10 col-xs-offset-1">
					<hr />
				</div>
			</div>
			<form id="feedbackForm" name="feedbackForm" class="row" novalidate
					autocomplete="off" data-cv-submit="submitFeedback()">
				<div class="col-md-10 col-xs-12">
					<div class="form-group">
						<label for="feedbackSubject"><cv:msg key="label.subject" bundle="settings" /></label>
						<select id="feedbackSubject" name="feedbackSubject" class="form-control" data-ng-model="selectedSubject" required
								data-ng-class="{'has-error': cv.feedbackForm.needsAttention(feedbackForm.feedbackSubject)}" data-ng-change="onSubjectChange()"
								data-ng-options="subject.value as subject.label for subject in subjectsList">
						</select>
						<div class="help-block" data-ng-show="cv.feedbackForm.needsAttention(feedbackForm.feedbackSubject)">
							<i class="ion-alert-circled"></i>
							<cv:msg key="error.subject" bundle="settings" />
						</div>
					</div>
					<div class="form-group">
						<label for="feedbackMessage"><cv:msg key="label.message" bundle="settings" /></label>
						<textarea id="feedbackMessage" name="feedbackMessage" class="textbox form-control"
								data-ng-class="{'has-error': cv.feedbackForm.needsAttention(feedbackForm.feedbackMessage)}"
								data-ng-model="message" rows="6" maxlength="1000" required></textarea>
						<div class="help-block" data-ng-show="cv.feedbackForm.needsAttention(feedbackForm.feedbackMessage)">
							<i class="ion-alert-circled"></i>
							<cv:msg key="error.message.empty" bundle="settings" />
						</div>
						<div class="feedback-subtext">
							<cv:msg key="info.privacy" bundle="settings" />
						</div>
					</div>
					<div class="button-container">
						<a id="feedback-cancel" class="btn btn-default cvBusyOnAjax"
								name="feedback-cancel" data-ng-href="{{returnUrl}}">
							<cv:msg key="action.cancel" bundle="settings" />
						</a>
						<button id="feedback-submit" class="btn btn-primary cvBusyOnAjax"
								name="feedback-submit" type="submit">
							<cv:msg key="action.submit" bundle="settings" />
						</button>
					</div>
				</div>
			</form>
		</div>
	</div>
</div>