<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.settingsJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1 data-ng-if="!model.isPrivate"><cv:msg key="header.cloudMetricsReporting"   bundle="settingsJs" /></h1>
	<h1 data-ng-if=" model.isPrivate"><cv:msg key="header.privateMetricsReporting" bundle="settingsJs" /></h1>
</div>
<div class="bootstrap-wrapper">
	<div class="margin-bottom-10">&nbsp;</div>
	<div class="text-center {{model.serverMessage.type}}" data-ng-bind="model.serverMessage.message"></div>
	<div class="text-center {{model.serverMessage.type}}" data-ng-if="model.proactiveSupportTouched && uiModel.services[model.serviceIds.PROACTIVE_SUPPORT] && !model.serverMessage.message">
		<cv:msg key="label.proactiveSupportHelp" bundle="settingsJs" /><a href="{{model.workflowLink}}" target="_blank"><cv:msg key="label.softwareStore" bundle="settingsJs"/></a>
	</div>
	<form name="editMetricsReporting" class="reduced-padding-top" data-ng-submit="saveConfiguration()" novalidate autocomplete="off">
		<uib-accordion close-others="true">
			<div uib-accordion-group is-open="model.accordionStatus.generalTab" data-scroll-to-when-open>
				<uib-accordion-heading><cv:msg key="header.label.general" bundle="settingsJs" /><i class="pull-right glyphicon"
					data-ng-class="{'glyphicon-chevron-down': model.accordionStatus.generalTab, 'glyphicon-chevron-right': !model.accordionStatus.generalTab}"></i>
				</uib-accordion-heading>

				<div class="form-group row">
					<div class="col-xs-12 col-md-6 col-lg-6">
						<div class="multiple-checkbox-group">
							<input id="healthCheck" type="checkbox" data-ng-model="uiModel.services[model.serviceIds.HEALTH_CHECK]" />
							<label for="healthCheck" class="checkbox-label"><cv:msg key="label.healthCheck" bundle="settingsJs"/></label>
						</div>
						<div class="multiple-checkbox-group" data-ng-if="model.isPrivate">
							<input id="spBilling" type="checkbox" data-ng-model="uiModel.services[model.serviceIds.SERVICE_PROVIDER_BILLING]" />
							<label for="spBilling" class="checkbox-label"><cv:msg key="label.spBilling" bundle="settingsJs"/></label>
						</div>
					</div>
					<div class="col-xs-12 col-md-6 col-lg-6">
						<div class="multiple-checkbox-group">
							<input id="activity" type="checkbox" data-ng-model="uiModel.services[model.serviceIds.ACTIVITY]" />
							<label for="activity" class="checkbox-label"><cv:msg key="label.activity" bundle="settingsJs"/></label>
						</div>
						<div class="multiple-checkbox-group" data-ng-if="model.isPrivate">
							<input id="audit" type="checkbox" data-ng-model="uiModel.services[model.serviceIds.AUDIT]" />
							<label for="audit" class="checkbox-label"><cv:msg key="label.audit" bundle="settingsJs"/></label>
						</div>
					</div>

					<div class="col-xs-12 col-md-6 col-lg-6" id="allowRemoteTroubleshootingDiv" data-ng-if="!model.isPrivate">
						<div class="multiple-checkbox-group">
							<input id="allowRemoteTroubleshooting" type="checkbox" data-ng-model="uiModel.services[model.serviceIds.ALLOW_REMOTE_TROUBLESHOOTING]" />
							<label for="allowRemoteTroubleshooting" class="checkbox-label"><cv:msg key="label.allowRemoteTroubleshooting" bundle="settingsJs"/></label>
						</div>
					</div>

					<div class="col-xs-6 col-md-6 col-lg-6" id="chargebackDiv" data-ng-if="model.isPrivate">
						<div class="multiple-checkbox-group">
							<input id="chargeback" type="checkbox" data-ng-model="uiModel.services[model.serviceIds.CHARGE_BACK]"/>
							<label for="chargeback" class="checkbox-label"><cv:msg key="label.chargeBack" bundle="settingsJs"/></label>
						</div>
					</div>

					<div class="col-xs-12 col-md-6 col-lg-6"  id="upgradeReadinessDiv" data-ng-if="!model.isPrivate">
						<div class="multiple-checkbox-group">
							<input id="upgradeReadiness" type="checkbox" data-ng-model="uiModel.services[model.serviceIds.UPGRADE_READINESS]" />
							<label for="upgradeReadiness" class="checkbox-label"><cv:msg key="label.upgradeReadiness" bundle="settingsJs"/></label>
						</div>
					</div>

					<div class="col-xs-offset-1 col-xs-11 col-md-offset-1 col-md-6 col-lg-offset-1 col-lg-6" id="proactiveSupportDiv" data-ng-if="!model.isPrivate">
						<div class="multiple-checkbox-group" data-ng-disabled="!uiModel.services[model.serviceIds.ALLOW_REMOTE_TROUBLESHOOTING]">
							<input id="proactiveSupport" name="proactiveSupport" type="checkbox"
									data-ng-model="uiModel.services[model.serviceIds.PROACTIVE_SUPPORT]" data-ng-change="model.proactiveSupportTouched=true;"/>
							<label for="proactiveSupport" class="checkbox-label"><cv:msg key="label.proactiveSupport" bundle="settingsJs"/></label>
						</div>
					</div>

					<div data-ng-if="model.isPrivate" id="chargebackOptionsDiv" data-ng-hide="!uiModel.services[model.serviceIds.CHARGE_BACK]">
						<div class="col-xs-12 col-md-12 col-lg-12" >
							<div class="col-xs-offset-1 col-xs-3 col-md-offset-1 col-md-3 col-lg-offset-1 col-lg-3">
								<div class="multiple-checkbox-groups">
									<input id="chargeBackDaily" type="checkbox" data-ng-model="uiModel.services.chargeBackDaily"
																					data-ng-change="resetChargeBackErrorMessage()"/>
									<label for="chargeBackDaily" class="checkbox-label"><cv:msg key="option.daily" bundle="schedule"/></label>
								</div>
							</div>
							<div class="col-xs-2 col-md-3 col-lg-3">
								<div class="multiple-checkbox-groups">
									<input id="chargeBackWeekly" type="checkbox" data-ng-model="uiModel.services.chargeBackWeekly"
																		data-ng-change="resetChargeBackErrorMessage()"/>
									<label for="chargeBackWeekly" class="checkbox-label"><cv:msg key="option.weekly" bundle="schedule"/></label>
								</div>
							</div>
							<div class="col-xs-3 col-md-3 col-lg-3">
								<div class="multiple-checkbox-groups">
									<input id="chargeBackMonthly" type="checkbox" data-ng-model="uiModel.services.chargeBackMonthly"
																					data-ng-change="resetChargeBackErrorMessage()"/>
									<label for="chargeBackMonthly" class="checkbox-label"><cv:msg key="option.monthly" bundle="schedule"/></label>
								</div>
							</div>
						</div>
					</div>
				</div>

				<div data-ng-if="model.isPrivate">
					<div class="form-group row">
						<div class="col-sm-5">
							<label for="metricsServerURL"><cv:msg key="label.metricsServerURL" bundle="settingsJs" />
							   <cv-help-component help-text='<cv:msg key="info.metricsServerURL" bundle="settingsJs"/>'</cv-help-component>
							</label>
						</div>
						<div class="col-sm-7">
							<input type="text" id="metricsServerURL" name="metricsServerURL" data-ng-model="uiModel.metricsServerURL" data-ng-required="uiModel.commcellDiagUsage" placeholder='<cv:msg key="info.metricsServerURL" bundle="settingsJs"/>'>
							<span class="help-block" data-ng-show="needsAttention(editMetricsReporting.metricsServerURL)"><cv:msg key="error.metricsServerURL" bundle="settingsJs"/></span>
							  <span class="help-block" data-ng-show="!isURLValid(uiModel.metricsServerURL)  && !needsAttention(editMetricsReporting.metricsServerURL)"><cv:msg key="error.invalidUrl" bundle="settingsJs"/></span>
						</div>
					</div>
				</div>
			</div>

			<div uib-accordion-group is-open="model.accordionStatus.configurationTab" data-scroll-to-when-open data-ng-disabled="!uiModel.commcellDiagUsage">
				<uib-accordion-heading><cv:msg key="label.configuration" bundle="settingsJs" /><i class="pull-right glyphicon"
					data-ng-class="{'glyphicon-chevron-down': model.accordionStatus.configurationTab, 'glyphicon-chevron-right': !model.accordionStatus.configurationTab}"></i>
				</uib-accordion-heading>

				<div class="form-group row">
					<div class="col-sm-5">
						<input id="allClientGroups" type="checkbox" data-ng-model="uiModel.allClientGroups" />
						<label for="allClientGroups" class="checkbox-label"><cv:msg key="label.allClientGroups" bundle="settingsJs"/></label>
					</div>
					<div class="col-sm-7">
						<div class="clientGroups-multi-select" data-ng-disabled="uiModel.allClientGroups">
							<isteven-multi-select
				   				  input-model="uiModel.clientGroups"
				  				  button-label="clientGroupName"
				  				  item-label="clientGroupName"
				   				  tick-property="selected"
				   				  class="isteven-multi-select user-group-select"
				   				  id="clientGroups"
				   				  name="clientGroups"
				   				  on-close="resetClientGroupErrorMessage()"
				   				  helper-elements="all none reset filter"
				   				  max-labels="2"
				   				  translation="model.localLang"
				   				  required>
							</isteven-multi-select>
						</div>
						<span class="help-block" data-ng-show="model.showClientGroupSelectionError"><cv:msg key="error.selectClientGroup" bundle="settingsJs"/></span>
					</div>
				</div>

				<div class="form-group row">
					<div class="col-sm-5">
						<input type="checkbox" name="dataCollectionTime" id="dataCollectionTime" data-ng-model="uiModel.dataCollectionEnabled"/>
						<label for="dataCollectionTime"><cv:msg key="label.dataCollectionTime" bundle="settingsJs"/></label>
					</div>
					<div class="col-sm-7">
						<div data-ng-disabled="!uiModel.dataCollectionEnabled">
							<div uib-timepicker id="startTime" name="startTime" data-ng-model="uiModel.dataCollectionTime"  minute-step="5" show-spinners="false"></div>
						</div>
					</div>
				</div>
				<div class="form-group">
					<label for="dataCollectionNote"
						data-ng-disabled="!uiModel.dataCollectionEnabled"><cv:msg
							key="label.dataCollectionNote" bundle="settingsJs" /><span
						data-ng-bind="uiModel.dataCollectionTime | readableDataCollectionTime"></span></label>
				</div>

				<div class="form-group row">
					<div class="col-sm-5">
						<label for="uploadFrequency"><cv:msg key="label.uploadFrequency" bundle="settingsJs" /></label>
					</div>
					<div class="col-sm-7">
						<input type="number" id="uploadFrequency" name="uploadFrequency" min="1" max="7" data-ng-model="uiModel.uploadFrequency" required>
						<span class="help-block" data-ng-show="needsAttention(editMetricsReporting.uploadFrequency)"><cv:msg key="error.uploadFrequency" bundle="settingsJs"/></span>
					</div>
				</div>
			</div>

			<div uib-accordion-group is-open="model.accordionStatus.tieredTab" data-scroll-to-when-open data-ng-disabled="!uiModel.commcellDiagUsage" data-ng-if="model.isPrivate && uiModel.isMetricsReportPackageInstalled">
				<uib-accordion-heading><cv:msg key="label.forwarding" bundle="settingsJs" /><i class="pull-right glyphicon"
					data-ng-class="{'glyphicon-chevron-down': model.accordionStatus.tieredTab, 'glyphicon-chevron-right': !model.accordionStatus.tieredTab}"></i>
				</uib-accordion-heading>
				<div class="form-group row">
					<div class="col-sm-5">
						<label for="uploadURLs" >
						<cv-help-text help-label='<cv:msg key="label.uploadURLs" bundle="settingsJs"/>' help-text="info.metricsForwardingURL" use-icon="true"/>
						</label>
					</div>
					<div class="tiered-metrics col-sm-7">
							<input type="text" id="uploadURLs" name="uploadURLs" data-ng-model="uiModel.uploadURLs" data-ng-required="uiModel.commcellDiagUsage">

							<span ng-disabled="!uiModel.uploadURLs" >
											<div class="inline k-icon k-i-plus cursor-pointer" id="add-URL" title="Add" ng-click="addURL()"></div>
							</span>
							<span class="help-block" data-ng-show="uiModel.uploadURLinvalid"><cv:msg key="error.invalidUrl" bundle="settingsJs"/></span>
							<span class="help-block" data-ng-show="uiModel.uploadURLError"><cv:msg key="error.uploadURL" bundle="settingsJs"/></span>
						    <div ng-repeat="URL in uiModel.URLs" class="info-tag">
                                    <div class="cv-flex">
                                                <span class="crop" ng-bind="URL"></span>
                                                <span>
                                                    <a class="close-icon k-icon k-i-close cursor-pointer" ng-click="removeURL($index)"></a>
                                                </span>
                                   </div>
                           </div>
					</div>
				</div>
			</div>

			<div data-ng-if="!model.isPrivate" uib-accordion-group is-open="model.accordionStatus.advancedTab" data-scroll-to-when-open data-ng-disabled="!uiModel.commcellDiagUsage">
				<uib-accordion-heading><cv:msg key="label.advanced" bundle="storage" /><i class="pull-right glyphicon"
					data-ng-class="{'glyphicon-chevron-down': model.accordionStatus.advancedTab, 'glyphicon-chevron-right': !model.accordionStatus.advancedTab}"></i>
				</uib-accordion-heading>
				<div class="form-group row">
					<div class="col-xs-12 col-md-6 col-lg-6">
						<div class="multiple-checkbox-group">
							<input id="audit" type="checkbox" data-ng-model="uiModel.services[model.serviceIds.AUDIT]" />
							<label for="audit" class="checkbox-label"><cv:msg key="label.audit" bundle="settingsJs"/></label>
						</div>
						<div class="multiple-checkbox-group">
							<input id="spBilling" type="checkbox" data-ng-model="uiModel.services[model.serviceIds.SERVICE_PROVIDER_BILLING]" />
							<label for="spBilling" class="checkbox-label"><cv:msg key="label.spBilling" bundle="settingsJs"/></label>
						</div>
					</div>

					<div class="col-xs-12 col-md-6 col-lg-6">
						<div class="multiple-checkbox-group">
							<input id="chargeBack" type="checkbox" data-ng-model="uiModel.services[model.serviceIds.CHARGE_BACK]" />
							<label for="chargeBack" class="checkbox-label"><cv:msg key="label.chargeBack" bundle="settingsJs"/></label>
						</div>
					</div>

				</div>
			</div>
			<div class="margin-bottom-10">&nbsp;</div>
		</uib-accordion>

		<div class="modal-footer">
			<button id="editMetricsReporting_button_#2259" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-click="close()"><cv:msg key="Cancel" bundle="messages" /></button>
			<button id="editMetricsReporting_button_#8555" type="submit" class="btn btn-primary cvBusyOnAjax"><cv:msg key="Save" bundle="messages" /></button>
		</div>
	</form>
</div>