<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.users"></cv:cvMessages>
	<cv:cvMessages bundle="localization.job"></cv:cvMessages>
	<cv:cvMessages bundle="localization.settings"></cv:cvMessages>
	<cv:cvMessages bundle="localization.schedule"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.dr"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1><cv:msg key="pageHeader.drBackup" bundle="navJs" /></h1>
</div>
<div class="bootstrap-wrapper">
	<div class="{{drCtrl.serverMessage.type}} serverMessage">{{drCtrl.serverMessage.message}}</div>
	<form name="drBackupExport" novalidate autocomplete="off">
		<h4 class="col-xs-12"><cv:msg key="label.exportSettings" bundle="settings" /></h4>
		<div class="form-group">
			<label class="col-xs-12 col-sm-5" for="numberMetadata"><cv-help-text help-label="label.numberofMetadata" help-text="info.Metadatabackup" ></label>
			<div class="col-xs-12 col-sm-7">
				<input id="numberMetadata" data-ng-model="drCtrl.exportSettings.DRNumFulls" type="number" value=1 min=1 max=99 name="numberMetadata" required />
				<span class="help-block text-left" data-ng-show="drBackupExport.numberMetadata.$dirty && drBackupExport.numberMetadata.$error.required"><cv:msg key="error.numberMetadata" bundle="settings"/></span>
			</div>
		</div>
		<cv-browse-input  class="row no-margin" form-name="drBackupExport" input-label="drCtrl.pathInputLabels" selected-path="drCtrl.exportSettings.backupFolderType" path="drCtrl.destLocation" browse-func="drCtrl.browse()"></cv-browse-input>
		<div>
		<cv-credential-directive data-ng-if="drCtrl.exportSettings.backupFolderType === 'network'" credentials="drCtrl.exportSettings.userPassword" form-name="drBackupExport" is-edit="drCtrl.exportSettings.isUserAccountEnabled" input-name="drCtrl.credentialsName" password-complexity="1"></cv-credential-directive>
		</div>
		<div class="form-group ">
			<div class="col-xs-12">
				<label data-ng-click="drCtrl.changeToggleState('exportSettings', 'uploadBackupMetadataToCloud', drBackupExport)"><toggle-control status="drCtrl.exportSettings.uploadBackupMetadataToCloud" true-property='true'></toggle-control>&nbsp;<span><cv:msg key="label.uploadToCommvaultCloud" bundle="dr" /></span></label>
			</div>
		</div>
		<div class="form-group ">
			<div class="col-xs-12">
				<label data-ng-click="drCtrl.changeToggleState('exportSettings', 'uploadBackupMetadataToCloudLib', drBackupExport)"><toggle-control status="drCtrl.exportSettings.uploadBackupMetadataToCloudLib" true-property='true'></toggle-control>&nbsp;<span><cv:msg key="label.uploadToCloudLibrary" bundle="dr" /></span></label>
			</div>
		</div>
		<span data-ng-if="drCtrl.exportSettings.uploadBackupMetadataToCloudLib == 'true'">
		<div class="form-group">
				<label class="col-xs-12 col-sm-5" for="cloudLib"><cv:msg key="label.cloudlibrary" bundle="dr" /></label>
				<div class="col-xs-12 col-sm-7">
					<select id="cloudLib" name="cloudLib" data-ng-model="drCtrl.exportSettings.cloudLibrary" data-ng-options="lib.library as lib.library.libraryName for lib in drCtrl.exportSettings.cloudLibList | orderBy:'library.libraryName'" data-ng-class="{'has-error': cv.drBackupExport.needsAttention(drBackupExport.cloudLib )}" class="ng-pristine ng-valid ng-valid-required ng-touched" ></select>
				</div>
		</div>
		<div class="form-group">
				<label class="col-xs-12 col-sm-5" for="cloudlibrary"><cv:msg key="label.libraryVendorName" bundle="dr" /></label>
				<div class="col-xs-12 col-sm-7">
					<label for="cloudlibrary">{{drCtrl.exportSettings.cloudLibrary.libraryVendorName}}</label>
				</div>
		</div>
		</span>
	</form>
	<form name="drBackupSchedule" novalidate autocomplete="off">
		<h4 class="col-xs-12 padding-top-10"><cv:msg key="label.schedule" bundle="settings"/></h4>
		<div class="form-group">
			<label for="startTime" class="col-xs-12 col-sm-5"><cv:msg key="label.drStartTime" bundle="dr" /></label>
			<div class="col-xs-12 col-sm-7"><div uib-timepicker id="startTime" name="startTime" class="timeColumn dr-backup" data-ng-model="drCtrl.exportSettings.pattern.active_start_time"  minute-step="15" show-spinners="false"></div></div>
			<span class="help-block" data-ng-show="drBackupSchedule.startTime.$dirty && drBackupSchedule.startTime.$error.required"><cv:msg key="error.scheduleTime" bundle="schedule" /></span>
		</div>
		<div class="form-group ">
			<div class="col-xs-12">
				<label data-ng-click="drCtrl.changeToggleState('exportSettings', 'isRepeatEvery', drBackupSchedule)"><toggle-control name="isRepeatEvery" status="drCtrl.exportSettings.isRepeatEvery" true-property='true'></toggle-control>&nbsp;<span><cv:msg key="label.repeatSchedule" bundle="settings" /></span></label>
			</div>
		</div>
		<span data-ng-if="drCtrl.exportSettings.isRepeatEvery =='true'">
			<div class="form-group">
				<label class="col-xs-12 col-sm-5" for="repeatHours"><cv:msg key="label.repeat" bundle="settings" /></label>
				<div class="col-xs-12 col-sm-7">
					<input type="number" min="0" max="23" name="repeatHours" id="repeatHours" data-ng-model="drCtrl.exportSettings.pattern.freq_subday_interval.hour"/>&nbsp;<label for="repeatHours" class="inline-label schedule-repeat-label"><cv:msg key="label.hours" bundle="schedule" /></label>
					<input type="number" min="0" max="59" name="repeatMinutes" id="repeatMinutes" data-ng-model="drCtrl.exportSettings.pattern.freq_subday_interval.min"/>&nbsp;<label for="repeatMinutes" class="inline-label schedule-repeat-label extra-margin-left"><cv:msg key="label.minutes" bundle="schedule" /></label>
				</div>
			</div>
			<div class="form-group">
				<label for="endTime" class="col-xs-12 col-sm-5"><cv:msg key="label.until" bundle="settings" /></label>
				<div class="col-xs-12 col-sm-7">
					<div uib-timepicker name="endTime" id="endTime" class="timeColumn dr-backup" data-ng-model="drCtrl.exportSettings.pattern.active_end_time" show-spinners="false"></div>
					<span class="help-block" data-ng-show="drBackupSchedule.endTime.$dirty && drBackupSchedule.endTime.$error.required"><cv:msg key="error.scheduleTime" bundle="schedule"/></span>
				</div>
			</div>
		</span>
	</form>
	<div class="button-container">
		<button id="drBackup_button_#8626" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="drCtrl.cancel()"><cv:msg key="action.cancel" bundle="settings" /></button> 
		<button id="drBackup_button_#6349" type="button" data-ng-disabled="loadingSendLogsMetadata" class="btn btn-primary cvBusyOnAjax" data-ng-click="drCtrl.saveExportSettings(drBackupExport,drBackupSchedule)"><cv:msg key="action.save"  bundle="settings"/></button> 
	</div>
</div>
