<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}">
	<cv:cvMessages bundle="localization.settingsJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
</script>
<h1 class="page-title">
	<span>
		<cv:msg key="header.label.cvLiveSync" bundle="settingsJs"/>
	</span>
</h1>
<div data-ng-if="pageLoaded">
	<div class="horz-center" data-ng-if="isConfigError">
		<svg data-cv-on-grid-empty="" class="add-new-placeholder ng-scope" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" 
		viewBox="0 0 225 190" style="enable-background:new 0 0 225 190;" xml:space="preserve">
			<path d="M0,0v190h90V0H0z M72,72.4H18v-9h54V72.4z M72,54.3H18v-9h54V54.3z M72,36.2H18v-9h54V36.2z M54,162.9H36v-18.1h18V162.9z"/>
			<path d="M135,0v190h90V0H135z M207,72.4h-54v-9h54V72.4z M207,54.3h-54v-9h54V54.3z M207,36.2h-54v-9h54V36.2z M189,162.9h-18v-18.1h18V162.9z"/>
			<path d="M133.3,95l-16.3,9v-4.5H90v-9h27.5v-5.3L133.3,95z"/>
		</svg>
		<h3 class="no-margin" data-ng-if="isActiveConfigPending">
			<cv:msg key="header.label.cvActiveConfigPending" bundle="settingsJs"/>
		</h3>
		<h3 class="no-margin" data-ng-if="!isActiveConfigPending && isDrConfigPending">
			<cv:msg key="header.label.cvDrConfigPending" bundle="settingsJs"/>
		</h3>
		<h3 class="no-margin" data-ng-if="!isActiveConfigPending && !isDrConfigPending && !failoverPackageInstalled">
			<cv:msg key="header.label.cvLiveSyncNotConfigured" bundle="settingsJs"/>
		</h3>
	</div>
	<div class="group row" data-ng-if="!isConfigError">
		<div class="col-xs-12 col-md-6">
			<cv-tile-component data-ac-id="cvlivesync-label_replication" data-title='<cv:msg key="header.label.replication" bundle="settingsJs"/>'>
				<ul class="list-style-secondary">
					<li class="group">
						<span class="pageDetailColumn"><cv:msg key="label.status" bundle="settingsJs"/></span>
						<div class="pageDetailColumn">
							<toggle-control id="proxyConnection"
								status="values.configStatus ? 'enabled-activity' : 'disabled-activity'"
								data-ng-click="onToggleStatus()">
							</toggle-control>
						</div>
					</li>
					<li data-ng-if="values.configStatus && editing !== 'replication'"class="group">
						<span class="pageDetailColumn"><cv:msg key="label.enableAutomaticFailover" bundle="settingsJs"/></span>
						<div class="pageDetailColumn">
							<toggle-control id="automaticFailover"
								status="values.enableAutomaticFailover ? 'enabled-activity' : 'disabled-activity'"
								data-ng-click="onToggleAutomaticFailover()">
							</toggle-control>
						</div>
					</li>				
					<li data-ng-if="values.configStatus && editing !== 'replication'"class="group">
						<span class="pageDetailColumn"><cv:msg key="label.interval" bundle="settingsJs"/></span>
						<div data-ng-if="!edit.liveSyncRPO && editing !== 'replication'" class="pageDetailColumn inline-editor">
							<span class="inline-editor-text">
								{{values.liveSyncRPO}} <cv:msg key="label.minutes" bundle="settingsJs"/>
							</span>
							<span class="inline-editor-buttons">
								<a href class="inline-editor-button text" data-ng-click="onInlineEdit('liveSyncRPO')">
									<cv:msg key="label.inlineEdit" bundle="messagesJs"/>
								</a>
							</span>
						</div>
						<div data-ng-if="edit.liveSyncRPO" class="pageDetailColumn inline-editor">
							<div class="inline-editor-input">
								<input id="syncInterval" type="number" name="input" ng-model="locals.liveSyncRPO" min="1" max="1440">
								<span class="inline-editor-text"><cv:msg key="label.minutes" bundle="settingsJs"/></span>
							</div>							
							<span class="inline-editor-buttons">
								<a class="inline-editor-button" href data-ng-click="onInlineSaveLiveSyncRPO()"><span class="k-icon k-i-check"></span></a>
								<a class="inline-editor-button" href data-ng-click="onInlineCancel('liveSyncRPO')"><span class="k-icon k-i-x"></span></a>
							</span>
						</div>
					</li>
					<li data-ng-if="values.configStatus && editing !== 'replication'" class="group">
						<span class="pageDetailColumn"><cv:msg key="label.storagePolicy" bundle="settingsJs"/></span>
						<div data-ng-if="!edit.backupStoragePolicy" class="pageDetailColumn inline-editor">
							<span data-ng-if="values.backupStoragePolicy.storagePolicyName" class="inline-editor-text" data-ng-bind="values.backupStoragePolicy.storagePolicyName"></span>
							<span data-ng-if="!values.backupStoragePolicy.storagePolicyName" class="inline-editor-text" bundle="clients"><cv:msg key="label.notSet"/></span>
							<span class="inline-editor-buttons">
								<a href class="inline-editor-button text" data-ng-click="onInlineEdit('backupStoragePolicy')">
									<cv:msg key="label.inlineEdit" bundle="messagesJs"/>
								</a>
							</span>
						</div>
						<div data-ng-if="edit.backupStoragePolicy" class="pageDetailColumn inline-editor">
							<div data-ng-if="lists.backupStoragePolicy && lists.backupStoragePolicy.length > 0" class="inline-editor-input">
								<isteven-multi-select id="cvlivesync_isteven-multi-select_#9795" name="ArrayControllers" input-model="lists.backupStoragePolicy" output-model="locals.backupStoragePolicy" 
									button-label="storagePolicyName" item-label="storagePolicyName" tick-property="ticked" 
									class="isteven-multi-select user-group-select auto-width-button"
									helper-elements="reset" disable-property="disabled" hide-search-button="true"
									search-limit="10" selection-mode="single">
								</isteven-multi-select>
							</div>
							<span data-ng-if="!lists.backupStoragePolicy || lists.backupStoragePolicy.length === 0" class="inline-editor-text" bundle="settingsJs"><cv:msg key="label.noDataAvailable" bundle="settingsJs"/></span>
							<span class="inline-editor-buttons">
								<a data-ng-if="lists.backupStoragePolicy && lists.backupStoragePolicy.length > 0" class="inline-editor-button" href data-ng-click="onInlineSaveBackupStoragePolicy()"><span class="k-icon k-i-check"></span></a>
								<a class="inline-editor-button" href data-ng-click="onInlineCancel('backupStoragePolicy')"><span class="k-icon k-i-x"></span></a>
							</span>
						</div>
					</li>
					<li class="group" data-ng-if="values.configStatus && editing !== 'replication'">
						<span class="pageDetailColumn"><cv:msg key="label.schedulePolicy" bundle="settingsJs"/></span>
						<div class="pageDetailColumn max-width-200">{{values.tlSchedule.taskName}}</div>
					</li>
				</ul>
			</cv-tile-component>
			<cv-tile-component data-ac-id="cvlivesync-label_connectivity" data-title='<cv:msg key="header.label.connectivity" bundle="settingsJs"/>'>
				<ul class="list-style-secondary">
					<li class="group">
						<span class="pageDetailColumn"><cv:msg key="label.useExternalGateway" bundle="settingsJs"/></span>
						<div class="pageDetailColumn">
							<toggle-control id="proxyConnection"
								status="values.useExternalGateway ? 'enabled-activity' : 'disabled-activity'"
								data-ng-click="onToggleProxyConnection()">
							</toggle-control>
						</div>
					</li>
					<li class="group" data-ng-if="values.useExternalGateway && editing !== 'connectivity'">
						<span class="pageDetailColumn"><cv:msg key="label.clientGroup" bundle="settingsJs"/></span>
						<div data-ng-if="!edit.proxyClientGroup" class="pageDetailColumn inline-editor">
							<span data-ng-if="values.proxyClientGroup.clientGroupName" class="inline-editor-text" data-ng-bind="values.proxyClientGroup.clientGroupName"></span>
							<span data-ng-if="!values.proxyClientGroup.clientGroupName" class="inline-editor-text" bundle="clients"><cv:msg key="label.notSet" bundle="clients"/></span>
							<span data-ng-if="values.configStatus" class="inline-editor-buttons">
								<a href class="inline-editor-button text" data-ng-click="onInlineEdit('proxyClientGroup')">
									<cv:msg key="label.inlineEdit" bundle="messagesJs"/>
								</a>
							</span>
						</div>
						<div data-ng-if="edit.proxyClientGroup" class="pageDetailColumn inline-editor">
							<div data-ng-if="lists.proxyClientGroup && lists.proxyClientGroup.length > 0" class="inline-editor-input">
								<isteven-multi-select id="cvlivesync_isteven-multi-select_#7608" name="ArrayControllers" input-model="lists.proxyClientGroup" output-model="locals.proxyClientGroup" 
									button-label="clientGroupName" item-label="clientGroupName" tick-property="ticked" 
									class="isteven-multi-select user-group-select auto-width-button"
									helper-elements="reset" disable-property="disabled" hide-search-button="true"
									search-limit="10" selection-mode="single">
								</isteven-multi-select>
							</div>
							<span data-ng-if="!lists.proxyClientGroup || lists.proxyClientGroup.length === 0" class="inline-editor-text" bundle="settingsJs"><cv:msg key="label.noDataAvailable"/></span>
							<span class="inline-editor-buttons">
								<a data-ng-if="lists.proxyClientGroup && lists.proxyClientGroup.length > 0" class="inline-editor-button" href data-ng-click="onInlineSaveProxyClientGroup()"><span class="k-icon k-i-check"></span></a>
								<a class="inline-editor-button" href data-ng-click="onInlineCancel('proxyClientGroup')"><span class="k-icon k-i-x"></span></a>
							</span>
						</div>
					</li>
				</ul>
			</cv-tile-component>
			<cv-tile-component data-ac-id="cvlivesync-label_testfailover" data-ng-if="bShowCommServeLiveSyncTestFailover" data-title='<cv:msg key="header.label.testFailover" bundle="settingsJs"/>'>
				<ul class="list-style-secondary">
					<li class="group">
						<span class="pageDetailColumn"><cv:msg key="label.proxyGroup" bundle="settingsJs"/></span>
						<div data-ng-if="!edit.testFailoverProxyGroup" class="pageDetailColumn inline-editor">
							<span data-ng-if="values.testFailoverProxyGroup.clientGroupName" class="inline-editor-text" data-ng-bind="values.testFailoverProxyGroup.clientGroupName"></span>
							<span data-ng-if="!values.testFailoverProxyGroup.clientGroupName" class="inline-editor-text" bundle="clients"><cv:msg key="label.notSet" bundle="clients"/></span>
							<span data-ng-if="values.configStatus" class="inline-editor-buttons">
								<a href class="inline-editor-button text" data-ng-click="onInlineEdit('testFailoverProxyGroup')">
									<cv:msg key="label.inlineEdit" bundle="messagesJs"/>
								</a>
							</span>
						</div>
						<div data-ng-if="edit.testFailoverProxyGroup" class="pageDetailColumn inline-editor">
							<div data-ng-if="lists.testFailoverProxyGroup && lists.testFailoverProxyGroup.length > 0" class="inline-editor-input">
								<isteven-multi-select id="cvlivesync_isteven-multi-select_#2027" name="ArrayControllers" input-model="lists.testFailoverProxyGroup" output-model="locals.testFailoverProxyGroup" 
									button-label="clientGroupName" item-label="clientGroupName" tick-property="ticked" 
									class="isteven-multi-select user-group-select auto-width-button"
									helper-elements="reset" disable-property="disabled" hide-search-button="true"
									search-limit="10" selection-mode="single">
								</isteven-multi-select>
							</div>
							<span data-ng-if="!lists.testFailoverProxyGroup || lists.testFailoverProxyGroup.length === 0" class="inline-editor-text" bundle="settingsJs"><cv:msg key="label.noDataAvailable"/></span>
							<span class="inline-editor-buttons">
								<a data-ng-if="lists.testFailoverProxyGroup && lists.testFailoverProxyGroup.length > 0" class="inline-editor-button" href data-ng-click="onInlineSaveTestFailoverProxyGroup()"><span class="k-icon k-i-check"></span></a>
								<a class="inline-editor-button" href data-ng-click="onInlineCancel('testFailoverProxyGroup')"><span class="k-icon k-i-x"></span></a>
							</span>
						</div>
					</li>
					<li class="group">
						<span class="pageDetailColumn"><cv:msg key="label.clientGroup" bundle="settingsJs"/></span>
						<div data-ng-if="!edit.testFailoverClientGroup" class="pageDetailColumn inline-editor">
							<span data-ng-if="values.testFailoverClientGroup.clientGroupName" class="inline-editor-text" data-ng-bind="values.testFailoverClientGroup.clientGroupName"></span>
							<span data-ng-if="!values.testFailoverClientGroup.clientGroupName" class="inline-editor-text" bundle="clients"><cv:msg key="label.notSet" bundle="clients"/></span>
							<span data-ng-if="values.configStatus" class="inline-editor-buttons">
								<a href class="inline-editor-button text" data-ng-click="onInlineEdit('testFailoverClientGroup')">
									<cv:msg key="label.inlineEdit" bundle="messagesJs"/>
								</a>
							</span>
						</div>
						<div data-ng-if="edit.testFailoverClientGroup" class="pageDetailColumn inline-editor">
							<div data-ng-if="lists.testFailoverClientGroup && lists.testFailoverClientGroup.length > 0" class="inline-editor-input">
								<isteven-multi-select id="cvlivesync_isteven-multi-select_#2416" name="ArrayControllers" input-model="lists.testFailoverClientGroup" output-model="locals.testFailoverClientGroup" 
									button-label="clientGroupName" item-label="clientGroupName" tick-property="ticked" 
									class="isteven-multi-select user-group-select auto-width-button"
									helper-elements="reset" disable-property="disabled" hide-search-button="true"
									search-limit="10" selection-mode="single">
								</isteven-multi-select>
							</div>
							<span data-ng-if="!lists.testFailoverClientGroup || lists.testFailoverClientGroup.length === 0" class="inline-editor-text" bundle="settingsJs"><cv:msg key="label.noDataAvailable"/></span>
							<span class="inline-editor-buttons">
								<a data-ng-if="lists.testFailoverClientGroup && lists.testFailoverClientGroup.length > 0" class="inline-editor-button" href data-ng-click="onInlineSaveTestFailoverClientGroup()"><span class="k-icon k-i-check"></span></a>
								<a class="inline-editor-button" href data-ng-click="onInlineCancel('testFailoverClientGroup')"><span class="k-icon k-i-x"></span></a>
							</span>
						</div>
					</li>
				</ul>
			</cv-tile-component>
		</div>
		<div class="col-xs-12 col-md-6">
			<cv-tile-component data-ac-id="cvlivesync-label_nodes">
			<div>
				<cv-kendo-grid data-ng-if="nodeGridOptions" cv-grid-options="nodeGridOptions"></cv-kendo-grid>
			</div>
			</cv-tile-component>
			<cv-tile-component data-ac-id="cvlivesync-label_monitoring_nodes" data-ng-if="modal.showMonitoringNodeTile" >
				<div>
					<cv-kendo-grid data-ng-if="modal.monitoringNodeGridOptions" cv-grid-options="modal.monitoringNodeGridOptions"></cv-kendo-grid>
				</div>
				</cv-tile-component>
			<cv-tile-component data-ac-id="cvlivesync-label_alerts" data-title='<cv:msg key="header.label.alerts" bundle="settingsJs" />'>
				<div class="page-details-box-links" data-ng-if="values.configStatus">
					<a ng-if="!alertExists" ng-click="openModalAlert()"><cv:msg key="label.add" bundle="settingsJs"/></a>
					<a ng-if="alertExists" ng-click="onDeleteAlert()"><cv:msg key="action.delete" bundle="settingsJs"/></a>
				</div>
				<ul class="list-style-secondary">
					<li class="group">
						<span class="pageDetailColumnFull">
							<a data-ng-if="alertExists" ng-href="#/alertDetails/{{configDetails.alertEntity.alertId}}">{{configDetails.alertEntity.alertName}}</a>
							<span data-ng-if="!alertExists" class="pageDetailColumn"><cv:msg key="label.noAlertConfigured" bundle="settingsJs"/></span>
						</span>
					</li>
				</ul>
			</cv-tile-component>
		</div>
	</div>
</div>