<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.settingsJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
</script>
<cv-tile-component data-ac-id="retire_devices" loader="manageIdleClientsCtrl.dataLoaded" data-ng-if="manageIdleClientsCtrl.showManageIdleClientsFeature"data-title='<cv:msg key="label.retireDevices" bundle="settingsJs"/>' data-min-height="true" >
	<ul class="list-style-secondary" data-ng-init="manageIdleClientsCtrl.init()">
		<!-- View retire after days config-->
		<li id="viewRetireDaysConfig" class="group" data-ng-if= "!manageIdleClientsCtrl.bRetireDevicesAfter">
			<span class="pageDetail-three-columns-first">
			<cv-help-text help-label="{{manageIdleClientsCtrl.titleLabel.retireDevicesAfterDays}}" help-text="helptext.retireDevicesAfter" bundle="settingJs"/></span>
			<span class="pageDetail-three-columns-second" data-ng-bind="manageIdleClientsCtrl.label.retireDevicesAfterDays"></span>
			<a class="pageDetail-three-columns-third" data-ng-click="manageIdleClientsCtrl.editNumberOfDays(0)"><cv:msg key="action.edit" bundle="settingsJs"/></a>
		</li>
		<!-- Edit retire days after config-->
		<li id="editRetireDaysConfig" class="group no-horizontal-padding" data-ng-if="manageIdleClientsCtrl.bRetireDevicesAfter">
			<span class="pageDetailColumn margin-top-10-important"><cv-help-text help-label="{{manageIdleClientsCtrl.titleLabel.retireDevicesAfterDays}}" help-text="helptext.retireDevicesAfter" bundle="settingJs"/></span>
			<span class="pageDetailColumn form-group">
				<input class="width-15-percentage"  type="number" min="0" data-ng-show="manageIdleClientsCtrl.selectedUnit.retireDevicesAfterDays != -1" data-ng-model="manageIdleClientsCtrl.autoRetireDevicesModel.retireDevicesAfterDays" />
				<select class="width-auto" data-ng-model="manageIdleClientsCtrl.selectedUnit.retireDevicesAfterDays" data-ng-options="unit.value as unit.label for unit in manageIdleClientsCtrl.unitTypes"></select>
				<a  class="horizontal-link-button" data-ng-click="manageIdleClientsCtrl.saveNumberOfDays(0)" data-ng-class="{disabled : manageIdleClientsCtrl.disableSubmitAndCancelButton}"><i class="glyphicon glyphicon-ok"></i></a>
				<a  data-ng-click="manageIdleClientsCtrl.cancelNumberOfDays(0)" data-ng-class="{disabled : manageIdleClientsCtrl.disableSubmitAndCancelButton}" ><i class="glyphicon glyphicon-remove"></i></a>
			</span>
		</li>
		<p data-ng-show="manageIdleClientsCtrl.showInvalidInputError" class="serverMessage error small-width-modal"><cv:msg key="error.retireDevices" bundle="settingsJs"/></p>
		<!-- View auto delete devices after days config-->
		<li id="viewDeleteDaysConfig" class="group" data-ng-if= "!manageIdleClientsCtrl.bDeleteDevicesAfter">
			<span class="pageDetail-three-columns-first">
			<cv-help-text help-label="{{manageIdleClientsCtrl.titleLabel.forceDeleteDevicesAfterDays}}"help-text="helptext.deleteDevicesAfter" bundle="settingJs"/></span>
			<span class="pageDetail-three-columns-second" data-ng-bind="manageIdleClientsCtrl.label.forceDeleteDevicesAfterDays"></span>
			<a class="pageDetail-three-columns-third" data-ng-click="manageIdleClientsCtrl.editNumberOfDays(1)"><cv:msg key="action.edit" bundle="settingsJs"/></a>
		</li>
		<!-- Edit auto delete devices after days config-->
		<li id="editRetireDaysConfig" class="group no-horizontal-padding" data-ng-if="manageIdleClientsCtrl.bDeleteDevicesAfter">
			<span class="pageDetailColumn margin-top-10-important"><cv-help-text help-label="{{manageIdleClientsCtrl.titleLabel.forceDeleteDevicesAfterDays}}" help-text="helptext.deleteDevicesAfter" bundle="settingJs"/></span>
			<span class="pageDetailColumn form-group">
				<input class="width-15-percentage"  type="number" min="0" data-ng-show="manageIdleClientsCtrl.selectedUnit.forceDeleteDevicesAfterDays != -1" data-ng-model="manageIdleClientsCtrl.autoRetireDevicesModel.forceDeleteDevicesAfterDays" />
				<select class="width-auto" data-ng-model="manageIdleClientsCtrl.selectedUnit.forceDeleteDevicesAfterDays" data-ng-options="unit.value as unit.label for unit in manageIdleClientsCtrl.unitTypes"></select>
				<a  class="horizontal-link-button" data-ng-click="manageIdleClientsCtrl.saveNumberOfDays(1)" data-ng-class="{disabled : manageIdleClientsCtrl.disableSubmitAndCancelButton}"><i class="glyphicon glyphicon-ok"></i></a>
				<a  data-ng-click="manageIdleClientsCtrl.cancelNumberOfDays(1)" data-ng-class="{disabled : manageIdleClientsCtrl.disableSubmitAndCancelButton}"><i class="glyphicon glyphicon-remove" ></i></a>
			</span>
		</li>	
	</ul>
</cv-tile-component>