	<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
	<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
	<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.settingsJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.settings"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	</script>
	<div class="row">
		<div class="col-md-12">
			<h2 class="page-title"><cv:msg key="pageHeader.customization" bundle="settings" /></h2>
			<div data-ng-hide="customizationForm.$dirty" class="serverMessage {{cusCtrl.serverMsg.type}}" data-ng-cloak>{{cusCtrl.serverMsg.message}}</div>
		</div>
	</div>	
	<div class="group row" id="customization-wrapper">
		<form name="customizationForm" novalidate autocomplete="off">
		<div class="col-xs-12 col-sm-6"  >
		
			<cv-tile-component  data-ac-id="header_colorTitle-settings" data-title='<cv:msg key="header.colorTitle" bundle="settings"/>'>
			<ul class="list-style-secondary no-margin" >
				<li data-ng-repeat="colorObj in cusCtrl.colorList track by $index">
					<span class="pageDetailColumn color-label"><cv-help-text help-label="{{colorObj.label}}" help-text="colorObj.info"></span>
					<span class="pageDetailColumn color-pallete">
						<input data-ng-attr-name="{{colorObj.formName}}" data-ng-attr-id="{{colorObj.formName}}" data-colorpicker="hex" type="text" data-ng-model="colorObj.color" data-ng-change="cusCtrl.updateStyles(false,colorObj.color)" data-ng-pattern="cusCtrl.colorReg"/>
						<div class="color-pallete-preview" data-ng-style="{'background-color' : colorObj.color}"></div>
					</span>
					<div data-ng-if="customizationForm[colorObj.formName].$dirty && customizationForm[colorObj.formName].$error.pattern" class="color-error full-width">
						<cv:msg key="error.colorvalidate" bundle="settingsJs"/>
					</div>
				</li>
			</ul>
			</cv-tile-component>
			<cv-tile-component  data-ac-id="header_cssTitle-settings" data-title='<cv:msg key="header.cssTitle" bundle="settings"/>'>
				<ul class="list-style-secondary no-margin" >
					<li class="no-padding">
						<span class="pageDetailColumn full-width">
							<cv-css-editor editor-settings="cusCtrl.cssEditorSettings" content="cusCtrl.customizeCSS" change-styles="cusCtrl.updateStyles()"></cv-css-editor>
						</span>
					</li>				
				</ul>
				
				
			</cv-tile-component>
		</div>
		<div class="col-xs-12 col-sm-6">
			<cv-tile-component  data-ac-id="header_headerTitle-settings" data-title='<cv:msg key="header.headerTitle" bundle="settings"/>'>
				<ul class="list-style-secondary no-margin" >
					<cv-image-upload  upload-settings="cusCtrl.logo.small" data-id="header-logo"></cv-image-upload>
					<li data-ng-if="cusCtrl.logo.small.name && cusCtrl.logo.small.name !== ''">
						<cv-toggle toggle-name="sameLogo" toggle-label="label.sameLogo" value="cusCtrl.sameLogo" data-on-click="cusCtrl.setFormDirty()"></cv-toggle>
					</li>
				</ul>
			</cv-tile-component>
			<cv-tile-component  data-ac-id="header_loginTitle-settings" data-title='<cv:msg key="header.loginTitle" bundle="settings"/>' help-text='<cv:msg key="info.loginSettingsSave" bundle="settings"/>' >
				<ul class="list-style-secondary no-margin" >
					<cv-image-upload  data-ng-if="!cusCtrl.sameLogo" upload-settings="cusCtrl.logo.default" data-id="login-logo"></cv-image-upload>
					<div data-ng-class="{'padding-top-20':!cusCtrl.sameLogo}"><cv-image-upload  upload-settings="cusCtrl.bg" data-id="login-bg"></cv-image-upload></div>
					<li class="group">
						<span class="pageDetailColumn full-width"><cv-help-text help-label="label.warningLoginBanner" help-text="info.warningLoginBanner" use-icon="true"/></span>
						<span class="pageDetailColumn full-width">
							<!-- banner-font css class is used by some customers to override style for banner in login page and banner entry in customization screen in adminconsole.
							Do not use this class as your properties might be overridden for such customers-->
							<textarea rows="6" cols="50" id="warningLoginBanner" data-ng-model="cusCtrl.warningLoginBanner" class="banner-font"></textarea>
						</span>
					</li>
				</ul>
			</cv-tile-component>
			<cv-tile-component  data-ac-id="header_favicon-settings" data-title='<cv:msg key="header.favicon" bundle="settings"/>'>
				<ul class="list-style-secondary no-margin" >
					<cv-image-upload  upload-settings="cusCtrl.favicon" data-id="header-favicon"></cv-image-upload>
				</ul>
			</cv-tile-component>
		</div>
		</form>
	</div>
	
	<div class="button-container">
		<button id="customization_button_#2922" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="cusCtrl.resetCustomize()"><cv:msg key="label.customizationReset" bundle="settings" /></button> 
		<button id="customization_button_#5950" type="button" class="btn btn-default cvBusyOnAjax" data-ng-disabled="!customizationForm.$dirty" data-ng-click="cusCtrl.discardChange()"><cv:msg key="label.customizationDiscard" bundle="settings" /></button> 
		<button id="customization_button_#1835" type="button" class="btn btn-primary cvBusyOnAjax no-margin" data-ng-disabled="!customizationForm.$dirty || customizationForm.$error.pattern.length>0" data-ng-click="cusCtrl.saveCustomize()"><cv:msg key="label.customizationSave" bundle="settings" /></button> 
	</div>
	</div>	
		
			
			
