<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.bigData"></cv:cvMessages>
	<cv:cvMessages bundle="localization.alerts"></cv:cvMessages>
	<cv:cvMessages bundle="localization.settings"></cv:cvMessages>
	<cv:cvMessages bundle="localization.settingsJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.schedule"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messagesJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restore"></cv:cvMessages>
</script>
<div class="setup-title">
	<h3><cv:msg key="label.copySoftware" bundle="settings"/></h3>
</div>
<div calss="setup-content">
	<span class="{{serverMessage.type}}" data-ng-bind="serverMessage.message"></span>
    <form id="copySoftwareForm" name="copySoftwareForm" class="margin-top-15" data-ng-submit="ctrl.ok()">
	    <div class="modal-list bootstrap-wrapper  text-left">
			<div class="form-group row">
                <label class="col-xs-12 col-sm-4"><cv:msg key="label.jobType" bundle="schedule"/></label>
                <div class="col-xs-12 col-sm-8">
                    <div class="multiple-radio-group">
                        <label><input name="copy" data-ng-value="false" class="" type="radio" data-ng-model="ctrl.model.syncUpdateCaches"/>
                        <span class="block-indent"><cv:msg key="label.copy" bundle="settings"/></span></label>
                    </div>
                    <div class="multiple-radio-group">
                        <label><input name="copySync" data-ng-value="true" class="" type="radio" data-ng-model="ctrl.model.syncUpdateCaches"/>
                        <span class="block-indent"><cv:msg key="label.copySync" bundle="settings"/></span></label>
                    </div>
                </div>
            </div>
			<div class="form-group row">
                <label class="col-xs-12 col-sm-4"><cv:msg key="label.resourceLocation" bundle="settings"/></label>
                <div class="col-xs-12 col-sm-8">
                    <div class="multiple-radio-group">
                        <label><input name="network" data-ng-value="true" class="" type="radio" data-ng-model="ctrl.model.networkLocation" data-ng-change="ctrl.networkChanged()"/>
                        <span class="block-indent"><cv:msg key="label.readinessNetwork" bundle="messagesJs"/></span></label>
                    </div>
                    <div class="multiple-radio-group">
                        <label><input name="local" data-ng-value="false" class="" type="radio" data-ng-model="ctrl.model.networkLocation" data-ng-change="ctrl.networkChanged()"/>
                        <span class="block-indent"><cv:msg key="viewname.userGroups.local" bundle="messagesJs"/></span></label>
                    </div>
                </div>
            </div>
            <div class="form-group row">
                <label class="col-xs-12 col-sm-4" for="updateCachePath"><cv:msg key="label.updateCachePath" bundle="settings"/></label>
                <div class="col-xs-12 col-sm-8">
                    <div data-ng-class="{ 'input-group': !ctrl.model.networkLocation}">
                        <input type="text" name="updateCachePath" id="updateCachePath" data-ng-model="ctrl.model.updateCachePath">
                        <span class="input-group-btn" data-ng-if="!ctrl.model.networkLocation">
                            <button id="copySoftwareModal_button_#1293" class="icon-style cv-material-button browse" data-ng-click="ctrl.browse()"> 
                                <div class="cv-material-button-icon">
                                    <svg viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path d="M0 0h24v24H0z" fill="none"/><path d="M19 4H5c-1.11 0-2 .9-2 2v12c0 1.1.89 2 2 2h4v-2H5V8h14v10h-4v2h4c1.1 0 2-.9 2-2V6c0-1.1-.89-2-2-2zm-7 6l-4 4h3v6h2v-6h3l-4-4z"/></svg>
                                </div>
                                <div class="cv-material-button-tooltip"><cv:msg key="action.browse" bundle="bigData"/></div>
                            </button>
                        </span>
                    </div>
                    <span class="help-block" data-ng-if="ctrl.inputAlertFlags.updateCachePath"><cv:msg key="error.invalidPath" bundle="clients" /></span>
                </div>
            </div>
            <cv-toggle-accordion accordion-label="label.impersonateUser" collapsed="ctrl.model.impersonateUser" data-ng-if="ctrl.model.networkLocation">
                <cv-credential-directive 
                    credentials="ctrl.model.credentials"
                    form-name="copySoftwareForm"
                    password-complexity="1"
                    need-confirm="true"
                    is-optional="!ctrl.model.impersonateUser"
                    is-edit="false"
                    row-class="true">
                </cv-credential-directive>
            </cv-toggle-accordion>
            <div data-ng-disabled="!ctrl.model.syncUpdateCaches">
                <h4 class="text-left"><cv:msg key="label.remoteCaches" bundle="settings"/></h4>
                <cv-advanced-tree cvparams="ctrl.cvParams" class="advanced-tree"></cv-advanced-tree>
            </div>
		
        </div>
        <div class="modal-footer">
            <button id="copySoftwareModal_button_#4039" type="button" class="btn btn-default" ng-click="ctrl.cancel()"><cv:msg key="label.cancel" bundle="alerts" /></button> 
            <button id="copySoftwareModal_button_#9842" class="btn btn-primary" type="submit"><cv:msg key="action.ok" bundle="bigData" /></button> 
        </div> 
    </form>
</div>