
<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.vms"></cv:cvMessages>
	<cv:cvMessages bundle="localization.vmsJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
	<cv:cvMessages bundle="localization.settingsJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
</script>
<span class="center-container settings-page">
	<div class="center-container__center-el">
		<div class="back-strip">
			<div class="set-up-page" data-ng-controller="pluginController">
					<%-- <div data-ng-if="!showPlugin && !loading">
						<cv:msg key="label.plugin.not.configured" bundle="vms" />
					</div> --%>
				<div class="setup-title">
					<h1>
						<cv:msg key="pageHeader.plugin" bundle="vms" />
					</h1>
				</div>
				<div class="setup-content">
					<div>
						<%-- <span class="setupInfo"><cv:msg key="label.editInfo" /></span> --%>
						<span class="{{serverMessage.type}} serverMessage"
							data-ng-bind-html="serverMessage.message"></span>
						<div data-ng-if="!isDownloadAvailable">
							<form name="pluginForm" novalidate data-cv-submit="manageVMPlugin()" autocomplete="off">
								<div class="global-options remove-border-padding">
									<label for="action" class="select-label add-server">
										<cv:msg key="label.plugin.action" bundle="vms" />
											<select name="action" id="action" data-ng-model="model.action" data-ng-change="pluginActionChanged()">
												<option data-ng-repeat="action in actions | orderBy: 'label'" value="{{action.value}}" data-ng-selected="{{action.value == model.action}}">
													{{action.label}}
												</option>
											</select>
									</label>
									<label for="clientId" class="select-label"><cv:msg key="label.vcenter" bundle="vms" />
								  		<select name="clientId" id="clientId" data-ng-model="model.clientId" data-ng-options="server.clientId as server.name for server in servers" required >
								  		<option  data-ng-if="servers === undefined || servers.length<=0" value="">
								  			<cv:msg key="label.noHosts" bundle="servers" />
								  		</option>
								  		</select>
									</label>
						
									<a data-ng-if="servers === undefined || servers.length<=0"  href="" data-ng-click="showAddServerDialog()" >
										<p>{{addServerLabel}}</p>
									</a>  
									 
									 <label for="vsUserName"><cv:msg key="label.vcenter.username" bundle="vms" /> 
									 	<input type="text" name="userName" id="userName" data-ng-model="model.userName" required 
									 		data-ng-class="{'has-error': cv.pluginForm.needsAttention(pluginForm.userName)}" />
									<span class="help-block" data-ng-show="cv.pluginForm.getAttempted() && cv.pluginForm.needsAttention(pluginForm.userName)">
										<cv:msg key="error.vm.userName" bundle="vms" /></span> </label>
									
									<label for="vsPassword"><cv:msg key="label.vcenter.password" bundle="vms" /> 
										<input type="password" name="password" id="password" data-ng-model="model.password" required 
											data-ng-class="{'has-error': cv.pluginForm.needsAttention(pluginForm.password)}" />
									<span class="help-block" data-ng-show="cv.pluginForm.getAttempted() && cv.pluginForm.needsAttention(pluginForm.password)">
											<cv:msg key="error.vm.password" bundle="vms" /></span> </label>
											
									<label for="pluginVersion" class="select-label"><cv:msg key="label.vsphereplugin.version" bundle="vms" /> 
								 		<select name="pluginVersion" id="pluginVersion" data-ng-model="model.version" data-ng-options="version.value as version.label for version in versions" required >
								  		</select>
								  	</label>
								  	
								  	<label data-ng-if="model.action=='ADD' && model.version==1" for="webConsoleHost"><cv:msg key="label.webconsole.host" bundle="vms" /> 
									 	<input type="text" name="webConsoleHost" id="webConsoleHost" data-ng-model="model.webConsoleHost" required 
									 		data-ng-class="{'has-error': cv.pluginForm.needsAttention(pluginForm.webConsoleHost)}" data-ng-pattern="ipPattern" />
									 		<!-- data-uib-typeahead="url for url in webConsoleHosts | filter:$viewValue" data-typeahead-min-length="0" data-typeahead-editable="true" data-typehead-focus-first="false" -->
									<span class="help-block" data-ng-show="cv.pluginForm.getAttempted() && cv.pluginForm.needsAttention(pluginForm.webConsoleHost)">
										<cv:msg key="error.vm.webconsole.host" bundle="vms" /></span> </label>
									
								  	<label data-ng-if="model.action=='ADD' && model.version==1" class="cv-inline-checkbox">
										<input name="useSAML" id="useSAML" type="checkbox" data-ng-model="model.useSAML" />
										<label for="useSAML" class="cv-checkbox-label">
											<cv:msg key="label.use.saml" bundle="vms" />
										</label>	
									</label>
								</div>
								<div class="button-container">
									<button id="configurePlugin_button_#9741" data-ng-disabled="!model.action || !model.clientId" type="submit" class="btn btn-primary cvBusyOnAjax"> 
										<cv:msg key="Submit" />
									</button>
								</div>
							</form>
						</div>
						<div data-ng-if="isDownloadAvailable">
							<div class="button-container">
							<div class="horz-center">
								<button id="configurePlugin_button_#2072" type="button" class="btn" data-ng-click="clearState()"> 
									<cv:msg key="Back" bundle="messages"/>
								</button>
								<a target="_blank" href="${pageContext.request.contextPath}/downloadSPMetaData.do?clientId={{model.clientId}}">
									<button id="configurePlugin_button_#4339" type="button" class="btn btn-primary"> 
										<cv:msg key="SPMetaData" bundle="vms" />
									</button>
								</a></div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</span>
