
<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.settingsJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.users"></cv:cvMessages>
</script>
<fmt:bundle basename="localization.settings">
	<div class="setup-title">
		<h1>
			<fmt:message key="pageHeader.configurePasswordEncryption" />
			<cv-help-component help-text="<cv:msg key="label.configurePasswordEncryptionText" bundle="settings"/>"></cv-help-component>
		</h1>
	</div>
	<div class="setup-content" data-ng-init="init(keyManagementServer)">
		<span class="{{configurePswEncMessage.type}} serverMessage">{{configurePswEncMessage.message}}</span>
		<form name="configurePswEncConfigForm" id="configurePswEncConfigForm" novalidate data-cv-submit="configurePswEncConfig()" autocomplete="off" data-ng-hide="formConfig.hide">
			<div class="bootstrap-wrapper form-horizontal modal-margin">
                <div class="form-group">
                        <label class="col-xs-12 col-md-4 col-lg-4" for="keyManagementServers"><cv:msg key="title.keyManagement" bundle="security"/></label>
                        <div class="col-xs-12 col-md-8 col-lg-8">
                            <isteven-multi-select id="configurePasswordEncryptionConfig_isteven-multi-select_#6908" 
                            directive-id="keyManagementServers"
                            input-model="keyProviders"
                            output-model="keyManagementServer"
                            button-label="keyProviderName"
                            item-label="keyProviderName"
                            tick-property="selected"
                            class="grid-filter-isteven-multi-select isteven-multi-select user-group-select grid-column-filter"
                            helper-elements="none"
                            selection-mode="single"
                            on-item-click="setPswEncConfig(data)">
                        </isteven-multi-select>
                        </div>
                    </div>
			</div><!-- // close bootstrap-wrapper // -->
            <div class="button-container">
				<fmt:bundle basename="localization.messages">
					<button id="configurePasswordEncryptionConfig_button_#7513" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" 
						data-ng-click="dismissModal()">
						<fmt:message key="Cancel" />
					</button>
					<button id="configurePasswordEncryptionConfig_button_#6376" type="submit" class="btn btn-primary cvBusyOnAjax"
						ng-disabled="submitShouldBeDisabled"> 
						<fmt:message key="Save" />
					</button>
				</fmt:bundle>
			</div>
		</form>
	</div>
</fmt:bundle>
