<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.commcell"></cv:cvMessages>
</script>

<div class="setup-title">
	<h1>
		<cv:msg key="label.configureGlobalCommandCenter" bundle="commcell"/>
	</h1>
</div>

<div class="setup-content">
	<div class="{{configureGlobalCCMsg.type}} serverMessage">{{configureGlobalCCMsg.message}}</div>
	<div class="bootstrap-wrapper modal-margin">
		<form name="configureGlobalCCForm" id="configureGlobalCCForm"
		novalidate data-cv-submit="configureGlobalCC()" autocomplete="off" class="form-horizontal">
			<div class="form-group" ng-if="${cvConfig.isMCCDynamicAppEnabled()}" >
				<label for="configureGlobalCC_selectList" class="col-xs-12 col-md-4 col-lg-4">
					<cv:msg key="label.commandCenters" bundle="commcell"/> <span class="optional-text">
					<cv-help-component help-text="<cv:msg key="label.configureGlobalCommandCenterHelp" bundle="commcell"/>"></cv-help-component>
				</label>
				<div class="col-xs-12 col-md-8 col-lg-8">
					<isteven-multi-select
						id="configureGlobalCC_selectList"
						input-model="inputGlobalCCList"
						output-model="enabledGlobalCCList"
						button-label="ccDisplayName"
						item-label="ccItemDisplayName"
						tick-property="isSupported"
						search-property="ccItemDisplayName"
						class="isteven-multi-select"
						helper-elements="filter all none reset showSelected"
						translation="localLang"
						on-item-click="globalCCModified(data)"
						max-labels="2"
						directive-id="'configureGlobalCC_selectList'"
						disable-property="isPrimary" >
					</isteven-multi-select>
				</div>
			</div>

			 <div class="button-container">
	        	<button id="configureGlobalCC_button_cancel" type="button" class="btn btn-default cvBusyOnAjax" ng-click="cancel()"><cv:msg key="Cancel" bundle="messages"/></button>
	        	<button id="configureGlobalCC_button_save" type="submit" class="btn btn-primary cvBusyOnAjax" ><cv:msg key="Save" bundle="messages"/></button>
	    	</div>
		</form>
	</div>
</div>

