
<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.settingsJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.users"></cv:cvMessages>
</script>
<fmt:bundle basename="localization.settings">
	<div class="setup-title">
		<h1>
			<fmt:message key="pageHeader.configureEmail" />
			<cv-help-component help-text="<cv:msg key="label.configureEmailHelpText" bundle="settings"/>"></cv-help-component>
		</h1>
	</div>
	<div class="setup-content" data-ng-controller="configureEmailController">
		<p data-ng-if="!formConfig.hide"
			class="{{configureEmailMessage.type}} serverMessage">{{configureEmailMessage.message}}</p>
		<p data-ng-if="formConfig.hide"
			class="{{configureEmailMsg.type}} serverMessage">{{configureEmailMsg.message}}</p>
		<a data-ng-click="changeConfig()" data-ng-show="formConfig.hide"><fmt:message
				key="label.editConfiguration" /></a>
		<form name="configureEmailForm" id="configureEmailForm" novalidate data-cv-submit="configureEmail()" autocomplete="off" data-ng-hide="formConfig.hide">
			<div class="bootstrap-wrapper form-horizontal modal-margin">
			<div class="form-group">
				<label class="col-xs-12 col-md-4 col-lg-4" for="smtpServer"><fmt:message key="label.smtpServer" /></label>
				<div class="col-xs-12 col-md-8 col-lg-8">
					<input type="text" name="smtpServer" id="smtpServer" data-ng-model="model.smtpServer" data-ng-required="!formConfig.doNotValidate" />
					<span class="help-block" data-ng-show="cv.configureEmailForm.needsAttention(configureEmailForm.smtpServer)"><fmt:message key="error.smtpServer" /></span>
				</div>
			</div>
			<div class="form-group">
				<label class="col-xs-12 col-md-4 col-lg-4" for="smtpPort"><fmt:message key="label.smtpPort" /></label>
				<div class="col-xs-12 col-md-8 col-lg-8">
					<input type="number" name="smtpPort" id="smtpPort" data-ng-model="model.smtpPort" max="61000" min="1" value="25" data-ng-required="!formConfig.doNotValidate" />
					<span class="help-block" data-ng-show="cv.configureEmailForm.needsAttention(configureEmailForm.smtpPort)"><fmt:message key="error.smtpPort" /></span>
				</div>
			</div>
			<div class="form-group">
				<label class="col-xs-12 col-md-4 col-lg-4" for="senderEmail"><fmt:message key="label.senderEmail" /></label>
				<div class="col-xs-12 col-md-8 col-lg-8">
					<input type="email" name="senderEmail" id="senderEmail" data-ng-model="model.senderInfo.senderAddress" data-ng-pattern="emailRegex" data-ng-required="!formConfig.doNotValidate" />
					<span class="help-block" data-ng-show="cv.configureEmailForm.needsAttention(configureEmailForm.senderEmail) || showError"><fmt:message key="error.senderEmail" /></span>
				</div>
			</div>
			<div class="form-group">
				<label class="col-xs-12 col-md-4 col-lg-4" for="senderName"><fmt:message key="label.senderName" /></label>
				<div class="col-xs-12 col-md-8 col-lg-8">
					<input type="text" name="senderName" id="senderName" data-ng-model="model.senderInfo.senderName" data-ng-required="!formConfig.doNotValidate" />
					<span class="help-block" data-ng-show="cv.configureEmailForm.needsAttention(configureEmailForm.senderName) || showError"><fmt:message key="error.senderName" /></span>
				</div>
			</div>
			<div class="form-group">
				<label class="col-xs-12 col-md-4 col-lg-4" for="encryption"><cv:msg key="label.encryptionAlgorithm" bundle="settingsJs"/></label>
				<div class="col-xs-12 col-md-8 col-lg-8">
					<select name="encryption" id="encryption" data-ng-options="option.value as option.label for option in encryptionOptions" data-ng-change="encryptionChanged()" data-ng-model="dummyModel.encryption" />
				</div>
			</div>
			<div class="form-group">
				<label class="col-xs-12 col-md-4 col-lg-4" for="use-authentication"><fmt:message key="label.useAuthentication" /></label>
				<div class="col-xs-12 col-md-8 col-lg-8">
				<toggle-control id="use-authentication" title="<fmt:message key="label.useAuthentication" />" data-ng-click="toggleAuthentication()" status="model.useAuthentication ? 'enabled-activity' : 'disabled-activity'"></toggle-control>
				</div>
			</div>
			<div data-ng-show="model.useAuthentication">
			<div class="form-group">
				<label class="col-xs-12 col-md-4 col-lg-4" for="username"><fmt:message key="label.userName" /></label>
				<div class="col-xs-12 col-md-8 col-lg-8">
						<input type="text" name="username" id="username" data-ng-model="model.userInfo.userName" data-ng-change="userInfoEdited=true;errors.username=false"/>
						<span class="help-block" data-ng-show="errors.username"><fmt:message key="error.userName" /></span>
				</div>
			</div>
			<div class="form-group">
				<label class="col-xs-12 col-md-4 col-lg-4" for="password"><fmt:message key="label.password" /></label>
				<div class="col-xs-12 col-md-8 col-lg-8">
						<input type="password" name="password" id="password" placeholder="{{formConfig.passwordPlaceholder}}" data-ng-model="model.userInfo.password" data-ng-change="userInfoEdited=true;errors.password = false"/>
						<span class="help-block" data-ng-show="errors.password"><fmt:message key="error.password" /></span>
				</div>
			</div>
			<div class="form-group">
				<label class="col-xs-12 col-md-4 col-lg-4" for="confirmPassword"><cv:msg key="label.confirmPassword" bundle="messagesJs"/></label>
				<div class="col-xs-12 col-md-8 col-lg-8">
						<input type="password" name="confirmPassword" id="confirmPassword" data-ng-model="dummyModel.confirmPassword" data-ng-change="userInfoEdited=true;errors.confirmPassword = false"/>
						<span class="help-block" data-ng-show="errors.confirmPassword"><fmt:message key="error.confirmPassword" /></span>
				</div>
			</div>
			</div>
			</div><!-- // close bootstrap-wrapper // -->
			<div class="button-container">
				<button id="configureEmail_button_#3607" type="button" 
					class="btn btn-default cvBusyOnAjax" data-ng-click="testEmail()">
					<fmt:message key="label.testEmail" />
				</button>
				<fmt:bundle basename="localization.messages">
					<button id="configureEmail_button_#0992" type="button" data-ng-if="isCoreSetupStep" 
						class="btn btn-default cvBusyOnAjax skip-btn--hidden" data-ng-click="skipEmailConfiguration()">
						<fmt:message key="Skip" />
					</button>
					<button id="configureEmail_button_#6897" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" 
						data-ng-click="dismissModal()">
						<fmt:message key="Cancel" />
					</button>
					<button id="configureEmail_button_#8332" type="submit" class="btn btn-primary cvBusyOnAjax"> 
						<fmt:message key="Save" />
					</button>
				</fmt:bundle>
			</div>
		</form>
		<div class="button-container centered"
			data-ng-show="formConfig.hide">
			<fmt:bundle basename="localization.messages">
				<button id="configureEmail_button_#5014" type="button" 
					class="btn btn-default cvBusyOnAjax skip-btn--hidden"
					data-ng-click="skip()">
					<fmt:message key="Continue" />
				</button>
			</fmt:bundle>
		</div>
	</div>
</fmt:bundle>