(function() {
	'use strict';

	var settingsMod = angular.module('cvModule.settings');
	settingsMod.service('settingsService', [
		'$http',
		function($http) {
			this.skipInitialSetup = function() {
				return $http.post('skipInitialSetup.do');
			};

			this.getEmail = function(successcallBack, errorcallback) {
				return $http
					.get('emailSettings.do')
					.success(successcallBack)
					.error(errorcallback);
			};

			this.getClientDetails = function(clientId) {
				return $http.get('clientDetails.do?clientId=' + clientId);
			};

			this.testEmail = function(emailSettings) {
				return $http.post('testEmailSettings.do', emailSettings);
			};
			this.setEmail = function(emailSettings) {
				return $http.post('emailSettings.do', emailSettings);
			};
			this.getHttpProxy = function(successcallBack, errorcallback) {
				return $http
					.get('proxySettings.do')
					.success(successcallBack)
					.error(errorcallback);
			};
			this.getCommserveDetails = function() {
				return $http.get('api/commserv');
			};
			this.setHttpProxy = function(proxyInfo) {
				var userInfo = angular.copy(proxyInfo.proxyCredentials);
				delete proxyInfo.proxyCredentials;
				return $http.post('proxySettings.do', {
					proxyInfo: JSON.stringify(proxyInfo),
					userInfo: JSON.stringify(userInfo)
				});
			};

			this.getDrbackup = function(successcallBack, errorcallBack) {
				return $http.get('drBackSettings.do');
			};

			this.setDrbackup = function(drBackInfo, userInfo, cloudUserPassword, patternInfo) {
				return $http.post('drBackSettings.do', {
					drBackupInfo: JSON.stringify(drBackInfo),
					userInfo: JSON.stringify(userInfo),
					cloudUserPassword: JSON.stringify(cloudUserPassword),
					patternInfo: JSON.stringify(patternInfo)
				});
			};

			this.getDisasterDrBackup = function(drBackup, compression) {
				return $http.post('disasterDRbackup.do', {
					DRBackup: drBackup,
					compression: compression
				});
			};

			this.setPassword = function(credentials) {
				return $http.post('changePassword.do', {
					oldPassword: credentials.oldPassword,
					newPassword: credentials.newPassword
				});
			};

			this.registerWithCloud = function(data) {
				return $http.post('registerWithCloud.do', {
					email: data.cloudEmail,
					password: data.cloudPassword,
					activationCode: data.activationCode
				});
			};

			this.getCloudSettings = function(successcallBack, errorcallback) {
				return $http
					.get('registerWithCloud.do')
					.success(successcallBack)
					.error(errorcallback);
			};

			this.setLocaleName = function(localeStr) {
				return $http.get('setLocaleName.do?localeStr=' + localeStr);
			};

			this.getLocalelist = function() {
				return $http.get('getLocalelist.do');
			};

			this.getInternetGatewayClients = function(successcallBack, errorcallback) {
				return $http
					.get('getInternetGatewayClients.do')
					.success(successcallBack)
					.error(errorcallback);
			};

			this.lockSession = function() {
				return $http.post('lockSession.do');
			};

			this.unLockSession = function(pwd) {
				return $http.post('unLockSession.do', {
					pwd: pwd
				});
			};

			this.getEntityCapabilities = function(entityId, entityType, commcellName, includeNotMappedPermissions) {
				var config = {
					method: 'GET',
					url: 'getEntityCapabilities.do',
					headers: {},
					params: {
						entityId: entityId,
						entityType: entityType,
						includeNotMappedPermissions:
							_.isNull(includeNotMappedPermissions) || _.isUndefined(includeNotMappedPermissions)
								? false
								: includeNotMappedPermissions
					}
				};
				if (commcellName) {
					if (cv.isCometApp) {
						config.headers['Comet-Commcells'] = commcellName;
						config.headers['CVContext'] = 'Comet';
					} else {
						config.headers['_cn'] = commcellName;
					}
				}
				return $http(config);
			};

			this.getUserHasCapability = function(permissionIds, anyCapability) {
				var userCapabilityUrl = 'api/Security/' + permissionIds + '/hasPermissions';
				if (anyCapability) {
					userCapabilityUrl = userCapabilityUrl + '?anyCapability=' + anyCapability;
				}

				var config = {
					method: 'GET',
					url: userCapabilityUrl
				};
				return $http(config);
			};

			this.getGlobalParam = function(key) {
				let requestList = [key];
				if (_.isArray(key)) {
					requestList = key;
				}
				return $http.post(
					'api/CommServ/GlobalParams',
					angular.toJson({
						globalParamsRequestList: requestList
					}),
					{
						headers: {
							'Content-Type': 'application/json'
						}
					}
				);
			};

			this.getHiddenUserSettings = function(globalParamsList) {
				return $http.post('getHiddenUserSettings.do', {
					globalParamsList: globalParamsList
				});
			};

			this.setGlobalParam = function(key, value) {
				let request = angular.toJson({
					name: key,
					value: JSON.stringify(value)
				});
				return $http.post('api/setGlobalParam', request, {
					headers: {
						'Content-Type': 'application/json'
					}
				});
			};

			this.setCompanyForUser = function(providerId) {
				return $http.post('setCompanyForUser.do', {
					providerId: providerId
				});
			};

			this.clearCache = function() {
				return $http.post('clearCache.do');
			};

			this.getProxyApi = function(url) {
				if (url && url.length > 0) {
					url = url.charAt(0) === '/' ? url.substring(1) : url;
					return $http.get(cv.contextPath + '/proxy/' + url);
				}
			};

			this.getSyslogStatus = function() {
				return $http.get(cv.contextPath + '/api/logmonitoring/Syslog/Status');
			};

			this.setSyslog = function(requestConfig) {
				return $http.post(cv.contextPath + '/api/logmonitoring/Syslog/Config', JSON.stringify(requestConfig), {
					headers: {
						'Content-Type': 'application/json',
						Accept: 'application/json'
					}
				});
			};

			this.getGlobalIDPData = function() {
				return $http.get('getCommcellType.do');
			};

			this.getRedirectListForUser = function(user, isGlobalIDPRequest, commcellName) {
				var headers;
				if (commcellName) {
					headers = {
						_cn: commcellName
					};
				}
				return $http.get(
					'getRedirectLists.do?username=' + encodeURIComponent(user) + '&isGlobalIDPRequest=' + isGlobalIDPRequest,
					{
						headers: headers
					}
				);
			};

			this.getPasswordEncryptionConfig = function() {
				return $http.get('api/commcell/passwordencryptionconfig');
			};

			this.getGlobalCCConfig = function() {
				return $http.get('api/webconsole/dynamicapp');
			};
			this.updateGlobalCCList = function(globalCCList) {
				return $http.post('api/webconsole/dynamicapp', JSON.stringify(globalCCList), {
					headers: {
						'Content-Type': 'application/json',
						Accept: 'application/json'
					}
				});
			};

			this.setPasswordEncryptionConfig = function(request) {
				return $http.put(cv.contextPath + '/api/commcell/passwordencryptionconfig', JSON.stringify(request), {
					headers: {
						'Content-Type': 'application/json',
						Accept: 'application/json'
					}
				});
			};

			this.getOperatorCompanies = function() {
				return $http.get('getOperatorCompanies.do');
			};

			this.getSAMLTokenForLoggedInUser = function() {
				return $http.get(cv.contextPath + '/api/Commcell/SamlToken?featureType=5');
			};

			this.getSAMLTokenForHedvig = function() {
				return $http({
					method: 'GET',
					url: cv.contextPath + '/proxy/Commcell/SamlToken?featureType=6',
					headers: {
						Accept: 'application/xml'
					}
				});
			};

			this.getSAMLToken = function(acceptJson) {
				var headers = {
					Accept: 'application/xml'
				};
				if (acceptJson) {
					headers = httpHeader.jsonDefaultHeader;
				}
				return $http({
					method: 'GET',
					url: cv.contextPath + '/api/Commcell/SamlToken',
					headers: headers
				});
			};

			this.saveSessionIndexAndCloudServiceUrl = function(params) {
				return $http.post('saveSessionIndexAndCloudServiceUrl.do', params);
			};
		}
	]);

	settingsMod.service('registrationService', [
		'$http',
		'$q',
		function($http, $q) {
			this.registrationSubmit = function(email, userPass) {};

			this.getOemId = function() {
				return $http.get('getOemId.do');
			};
		}
	]);
	settingsMod.service('licenseService', [
		'$http',
		'$q',
		function($http, $q) {
			this.getDetails = function() {
				return $http.get('getLicenseInfo.do');
			};
			this.updateLicense = function(data) {
				return $http.post('updateLicense.do', {
					licenseFile: data
				});
			};

			this.acceptMetallicEULA = function() {
				return $http.put('setMetallicEula.do');
			};
		}
	]);

	settingsMod.service('submitFeedbackService', [
		'$http',
		function($http) {
			this.submitFeedback = function(params) {
				return $http.post('feedback.do', {
					subject: params.subject,
					body: params.body
				});
			};
		}
	]);

	settingsMod.service('snmpv3Service', [
		'$http',
		function($http) {
			this.getConfiguration = function() {
				return $http.get('getSNMPv3Configuration.do');
			};

			this.updateConfiguration = function(request) {
				return $http.post('updateSNMPv3Configuration.do', {
					request: angular.toJson(request)
				});
			};

			this.getPrivacyAlgorithms = function() {
				return $http.get('getPrivacyAlgorithms.do');
			};

			this.getEncryptionAlgorithms = function() {
				return $http.get('getEncryptionAlgorithms.do');
			};
		}
	]);

	settingsMod.service('metricsReportingService', [
		'$http',
		function($http) {
			this.getCloudMetricsConfiguration = function() {
				return $http.get('getCommcellSurveyConfiguration.do?isPrivateCloud=false');
			};

			this.getPrivateMetricsConfiguration = function() {
				return $http.get('getCommcellSurveyConfiguration.do?isPrivateCloud=true');
			};

			this.updateConfiguration = function(request) {
				return $http.post('updateCommcellSurveyConfiguration.do', {
					commcellSurveyConfiguration: angular.toJson(request.commcellSurveyConfiguration),
					isPrivateCloud: request.isPrivateCloud
				});
			};
		}
	]);

	settingsMod.service('accessControlService', [
		'$http',
		function($http) {
			this.getOwnerPermissions = function() {
				return $http.get('getOwnerPermissions.do');
			};

			this.getCategoryPermissionsTree = function() {
				return $http.get('getOwnerPermissionsTree.do');
			};

			this.updateOwnerPermissions = function(ownerPermissions) {
				return $http.post('updateOwnerPermissions.do', ownerPermissions);
			};
		}
	]);

	settingsMod.service('dataInterfacePairsService', [
		'$http',
		function($http) {
			this.getCommonDataInterfacePairs = function(
				sourceClientOrClientGroupId,
				destClientOrClientGroupId,
				isSourceClientGroup,
				isDestClientGroup
			) {
				var url = 'getDataInterfacePairsForClients.do?sourceClientOrClientGroupId=' + sourceClientOrClientGroupId;

				if (destClientOrClientGroupId) {
					url = url + '&destClientOrClientGroupId=' + destClientOrClientGroupId;
				}
				url = url + '&isSourceClientGroup=' + (isSourceClientGroup == true);
				url = url + '&isDestClientGroup=' + (isDestClientGroup == true);
				return $http.get(url);
			};

			this.getInterfacesForClient = function(clientId) {
				return $http.get('getInterfacesForClient.do?clientId=' + clientId, {
					cache: true
				});
			};

			this.getDataInterfacePairsForAllClients = function() {
				return $http.get('getDataInterfacePairsForAllClients.do');
			};

			this.updateDataInterfacePairs = function(pipeLineInfo) {
				return $http.post('updateDataInterfacePairs.do', pipeLineInfo);
			};
		}
	]);

	settingsMod.service('downloadJobsService', [
		'cvLoc',
		'$http',
		'cvToaster',
		function(cvLoc, $http, cvToaster) {
			this.downloadFilesAndFolders = function(downloadParam) {
				return $http.post('downloadVmFiles.do', {
					downloadParam: JSON.stringify(downloadParam)
				});
			};

			this.downloadJobHandler = function(jobSummary) {
				return $http.post('downloadJobCompletionHandler.do', {
					jobId: jobSummary.jobId,
					status: jobSummary.status
				});
			};

			var getFileDownloadStatus = function(batchGUID) {
				return $http.post('getFileDownloadStatus.do', {
					batchGUID: batchGUID
				});
			};

			var startDownloadProcess = function(downloadurl) {
				//IFrame is used as a way to call the API through which the server can start streaming the file.
				var iframe = document.createElement('iframe');
				iframe.style.display = 'none';
				iframe.onload = function() {
					var iFrameContent = iframe.contentDocument || iframe.contentWindow.document;
					//check if the title is "Error", this means either there was an error during OpenFileRequest or while streaming the response back to the client.
					//TODO:This is pretty hacky, but has to do for now until a better way is found to check and show errors occurred on the server while called from inside an
					//iFrame
					if (iFrameContent.title === 'Error' || iFrameContent.title === 'Warning') {
						cvToaster.showErrorMessage({
							ttl: '5000',
							message: cvLoc('error.downloadFailed')
						});
					}
				};

				iframe.src = window.location.origin + appUtil.appRoot + downloadurl;

				document.body.appendChild(iframe);
			};

			this.startDownload = function(batchGUID) {
				let url = 'handleDownloadReady.do?batchGUID=' + batchGUID;
				startDownloadProcess(url);
			};

			var pollForFileStatusProcess = function(batchGUID, initialTime) {
				let url = 'handleDownloadReady.do?batchGUID=';
				getFileDownloadStatus(batchGUID)
					.success(function(data) {
						if (data) {
							if (data.errorString) {
								cvToaster.showErrorMessage({
									ttl: '5000',
									message: data.errorString
								});
							} else if (data.downloadComplete && data.batchGUID) {
								//download is complete
								startDownloadProcess(url + data.batchGUID);
							} else if (new Date().getTime() - initialTime > 1000 * 60 * 30) {
								//polling has been going on for more than half an hour.
								//normally this situation should not arise, since it is the restore to zip process
								//whose completion is being polled for. Abort in this case. This still might lead to the case
								//that the downloadItem might not be removed from the queue, since we have aborted here and
								//the process in the back-end ultimately succeeded.
								$log.error('Polling for more than half an hour, Aborting!!!');
							} else {
								//data download process is not complete
								//wait for 5 seconds and check again
								setTimeout(function() {
									pollForFileStatusProcess(batchGUID, initialTime);
								}, 5000);
							}
						}
					})
					.error(function(err) {
						cvToaster.showErrorMessage({
							ttl: '5000',
							message: err
						});
					});
			};

			this.pollForFileStatus = function(batchGUID, initialTime) {
				pollForFileStatusProcess(batchGUID, initialTime);
			};

			this.clearIsNewUserSession = function() {
				return $http.get('clearIsNewUserSession.do');
			};

			this.getCurrentDownloads = function() {
				return $http.get('getCurrentDownloads.do');
			};

			this.startFileDownload = function(url) {
				startDownloadProcess(url);
			};

			//this is used to show current downloads icon, as soon as a download is submitted
			this.downloadsProcessing = false;
		}
	]);

	settingsMod.service('globalSearchService', [
		'$http',
		'$stateParams',
		function($http, $stateParams) {
			this.getSearchData = function(searchTerm, type) {
				var urlStr =
					cv.contextPath + '/proxy/Entities/search?detailedProperty=1&name=' + encodeURIComponent(searchTerm);
				if (cv.isCometApp) {
					urlStr += '&isMultiCommcellSearch=1';
				}
				if (type) {
					urlStr += '&pageSize=10&entityType=' + type;
				}
				return $http({
					method: 'GET',
					url: urlStr
				});
			};

			this.getFileSearchData = function(searchTerm, pagingOptions, facetOptions) {
				var limit = 20;
				var start = 0;
				var defaultSort = 'FileName asc';
				if (pagingOptions) {
					limit = pagingOptions.limit;
					start = pagingOptions.limit * (pagingOptions.page - 1);
					if (pagingOptions.sortField) {
						defaultSort = pagingOptions.sortField + ' ' + pagingOptions.sortDir;
					}
				}

				// Escape special characters as encoding is not supported by Dcube API
				let searchTe = searchTerm.replace(/[-[\]{}()*+!<=:?.\/\\^$|#,]/g, '\\$&');

				var searchP = {
					searchParams: [
						{
							key: 'wt',
							value: 'json'
						},
						{
							key: 'q',
							value: 'FileName_idx:*' + searchTe + '*'
						},
						{
							key: 'rows',
							value: JSON.stringify(limit)
						},
						{
							key: 'start',
							value: JSON.stringify(start)
						},
						{
							key: 'fl',
							value: 'FileName'
						},
						{
							key: 'fl',
							value: 'AchiveFileId'
						},
						{
							key: 'fl',
							value: 'ArchiveFileOffset'
						},
						{
							key: 'fl',
							value: 'AppType'
						},
						{
							key: 'fl',
							value: 'CVTurboGUID'
						},
						{
							key: 'fl',
							value: 'ModifiedTime'
						},
						{
							key: 'fl',
							value: 'Size'
						},
						{
							key: 'fl',
							value: 'ClientId'
						},
						{
							key: 'fl',
							value: 'ClientName'
						},
						{
							key: 'fl',
							value: 'FolderPath'
						},
						{
							key: 'fl',
							value: 'ApplicationId'
						},
						{
							key: 'fl',
							value: 'CommcellNumber'
						},
						{
							key: 'fl',
							value: 'VMHypervisor'
						},
						{
							key: 'fl',
							value: 'VMName'
						},
						{
							key: 'fl',
							value: 'VMUniqueIdentifier'
						},
						{
							key: 'fl',
							value: 'FilePath'
						},
						{
							key: 'fl',
							value: 'Url'
						},
						{
							key: 'fq',
							value: 'DocumentType:1'
						},
						{
							key: 'fq',
							value: '{!collapse field=CVObjectGUID sort="BackupStartTime desc"}'
						},
						{
							key: 'fq',
							value: 'AppType:33 OR AppType:29 OR AppType:106' // FS windows, unix and VSA agents
						},
						{
							key: 'facet',
							value: 'true'
						},
						{
							key: 'useDCubeReq',
							value: 'true'
						},
						//												{
						//													key : 'json.facet',
						//													value : '{"_ModifiedTime_Today":{"type":"query","domain":{"excludeTags":["tag_group_ModifiedTime","tag_ModifiedTime","tag_exclude_ModifiedTime"]},"numBuckets":true,"mincount":1,"q":"(ModifiedTime:[NOW/DAY+0DAY TO *])","facet":{}},"_ModifiedTime_Last 7 Days":{"type":"query","domain":{"excludeTags":["tag_group_ModifiedTime","tag_ModifiedTime","tag_exclude_ModifiedTime"]},"numBuckets":true,"mincount":1,"q":"(ModifiedTime:[NOW/DAY-7DAY TO *])","facet":{}},"_ModifiedTime_Last 30 Days":{"type":"query","domain":{"excludeTags":["tag_group_ModifiedTime","tag_ModifiedTime","tag_exclude_ModifiedTime"]},"numBuckets":true,"mincount":1,"q":"(ModifiedTime:[NOW/DAY-30DAY TO *])","facet":{}},"_ModifiedTime_Last Year":{"type":"query","domain":{"excludeTags":["tag_group_ModifiedTime","tag_ModifiedTime","tag_exclude_ModifiedTime"]},"numBuckets":true,"mincount":1,"q":"(ModifiedTime:[NOW/DAY-1YEAR TO *])","facet":{}},"_ModifiedTime_Beyond One Year":{"type":"query","domain":{"excludeTags":["tag_group_ModifiedTime","tag_ModifiedTime","tag_exclude_ModifiedTime"]},"numBuckets":true,"mincount":1,"q":"(ModifiedTime:{* TO NOW/DAY-1YEAR})","facet":{}},"_Size_Below 1 MB":{"type":"query","domain":{"excludeTags":["tag_group_Size","tag_Size","tag_exclude_Size"]},"numBuckets":true,"mincount":1,"q":"(Size:{0 TO *} AND Size:[* TO 1048576])","facet":{}},"_Size_1 MB to 10 MB":{"type":"query","domain":{"excludeTags":["tag_group_Size","tag_Size","tag_exclude_Size"]},"numBuckets":true,"mincount":1,"q":"(Size:{1048576 TO *} AND Size:[* TO 10485760])","facet":{}},"_Size_10 MB to 50 MB":{"type":"query","domain":{"excludeTags":["tag_group_Size","tag_Size","tag_exclude_Size"]},"numBuckets":true,"mincount":1,"q":"(Size:{10485760 TO *} AND Size:[* TO 52428800])","facet":{}},"_Size_50 MB to 1 GB":{"type":"query","domain":{"excludeTags":["tag_group_Size","tag_Size","tag_exclude_Size"]},"numBuckets":true,"mincount":1,"q":"(Size:{52428800 TO *} AND Size:[* TO 1073741824])","facet":{}},"_Size_Above 1 GB":{"type":"query","domain":{"excludeTags":["tag_group_Size","tag_Size","tag_exclude_Size"]},"numBuckets":true,"mincount":1,"q":"(Size:{1073741824 TO *})","facet":{}},"ClientName":{"type":"terms","domain":{"excludeTags":["tag_ClientName","tag_exclude_ClientName"]},"numBuckets":true,"mincount":1,"field":"ClientName","limit":5,"facet":{},"sort":{"count":"desc"}}, "VMName":{"type":"terms","domain":{"excludeTags":["tag_VMName","tag_exclude_VMName"]},"numBuckets":true,"mincount":1,"field":"VMName","limit":5,"facet":{},"sort":{"count":"desc"}}}'
						//												},
						{
							key: 'json.facet',
							value:
								'{"_ModifiedTime_Today":{"type":"query","domain":{"excludeTags":["tag_group_ModifiedTime","tag_ModifiedTime","tag_exclude_ModifiedTime"]},"numBuckets":true,"mincount":1,"q":"(ModifiedTime:[NOW/DAY+0DAY TO *])","facet":{}},"_ModifiedTime_Last 7 Days":{"type":"query","domain":{"excludeTags":["tag_group_ModifiedTime","tag_ModifiedTime","tag_exclude_ModifiedTime"]},"numBuckets":true,"mincount":1,"q":"(ModifiedTime:[NOW/DAY-7DAY TO *])","facet":{}},"_ModifiedTime_Last 30 Days":{"type":"query","domain":{"excludeTags":["tag_group_ModifiedTime","tag_ModifiedTime","tag_exclude_ModifiedTime"]},"numBuckets":true,"mincount":1,"q":"(ModifiedTime:[NOW/DAY-30DAY TO *])","facet":{}},"_ModifiedTime_Last Year":{"type":"query","domain":{"excludeTags":["tag_group_ModifiedTime","tag_ModifiedTime","tag_exclude_ModifiedTime"]},"numBuckets":true,"mincount":1,"q":"(ModifiedTime:[NOW/DAY-1YEAR TO *])","facet":{}},"_ModifiedTime_Beyond One Year":{"type":"query","domain":{"excludeTags":["tag_group_ModifiedTime","tag_ModifiedTime","tag_exclude_ModifiedTime"]},"numBuckets":true,"mincount":1,"q":"(ModifiedTime:{* TO NOW/DAY-1YEAR})","facet":{}},"_Size_Below 1 MB":{"type":"query","domain":{"excludeTags":["tag_group_Size","tag_Size","tag_exclude_Size"]},"numBuckets":true,"mincount":1,"q":"(Size:{0 TO *} AND Size:[* TO 1048576])","facet":{}},"_Size_1 MB to 10 MB":{"type":"query","domain":{"excludeTags":["tag_group_Size","tag_Size","tag_exclude_Size"]},"numBuckets":true,"mincount":1,"q":"(Size:{1048576 TO *} AND Size:[* TO 10485760])","facet":{}},"_Size_10 MB to 50 MB":{"type":"query","domain":{"excludeTags":["tag_group_Size","tag_Size","tag_exclude_Size"]},"numBuckets":true,"mincount":1,"q":"(Size:{10485760 TO *} AND Size:[* TO 52428800])","facet":{}},"_Size_50 MB to 1 GB":{"type":"query","domain":{"excludeTags":["tag_group_Size","tag_Size","tag_exclude_Size"]},"numBuckets":true,"mincount":1,"q":"(Size:{52428800 TO *} AND Size:[* TO 1073741824])","facet":{}},"_Size_Above 1 GB":{"type":"query","domain":{"excludeTags":["tag_group_Size","tag_Size","tag_exclude_Size"]},"numBuckets":true,"mincount":1,"q":"(Size:{1073741824 TO *})","facet":{}},"ClientName":{"type":"terms","domain":{"excludeTags":["tag_ClientName","tag_exclude_ClientName"]},"numBuckets":true,"mincount":1,"field":"ClientName","limit":50,"facet":{},"sort":{"count":"desc"}}}'
						},
						{
							key: 'sort',
							value: defaultSort
						}
					]
				};

				if (facetOptions && facetOptions.length > 0) {
					searchP.searchParams = searchP.searchParams.concat(facetOptions);
				}

				return $http({
					url: cv.contextPath + '/api/dcube/globalfilesearch',
					method: 'POST',
					data: JSON.stringify({
						searchParams: searchP.searchParams,
						applyExtendedFileSecurity: 'true',
						isVirtualServerData: '1',
						entityType: $stateParams['entityType'],
						entityId: $stateParams['entityId']
					})
				});
			};

			this.processNLP = function(command) {
				if (cvConfig.enableNLP) {
					return $http({
						method: 'GET',
						url: 'intent.do?command=' + command
					});
				} else {
					return new Promise(function(resolve, reject) {
						resolve(null);
					});
				}
			};
		}
	]);
})();
