import { cvModuleSettingsModule } from 'common/js/modules';

cvModuleSettingsModule.service('liveSyncService', [
	'$http',
	function($http) {
		this.getFailOverConfig = function() {
			const request = $http.get(`proxy/CommServ/Failover`, httpHeader['jsonDefaultHeader']);
			return request;
		};

		this.getClientGroups = function() {
			const request = $http.get(`proxy/ClientGroup`, httpHeader['jsonDefaultHeader']);
			return request;
		};

		this.getStoragePolicies = function() {
			const request = $http.get(`proxy/V2/StoragePolicy`, httpHeader['jsonDefaultHeader']);
			return request;
		};

		this.setFailOverConfig = function(data) {
			const request = $http.post(`proxy/CommServ/Failover`, JSON.stringify(data), httpHeader['jsonDefaultHeader']);
			return request;
		};

		this.deleteAlert = function(data) {
			const request = $http['delete']('deleteAlertRule.do', { params: { alertId: data } });
			return request;
		};

		this.createAlertDefinition = function(data) {
			const request = $http.post('createAlertDef.do', {
				alertDetail: JSON.stringify(data)
			});
			return request;
		};

		this.getAlertInfo = function(id) {
			return $http.get('getAlertInfo.do', {
				params: {
					alertId: id
				}
			});
		};
	}
]);

export default cvModuleSettingsModule;
