import 'settings/js/factories/globalAddAction.factory.js';
import { commonAllAgentsModule } from 'common/js/modules';

(function() {
	'use strict';

	commonAllAgentsModule.factory('searchEntitiesFactory', [
		'cvLoc',
		'AppTypes',
		'globalAddActionsFactory',
		'cvNavigationFactory',
		'CAPPS_CONSTANTS',
		function(cvLoc, AppTypes, globalAddActionsFactory, cvNavigationFactory, CAPPS_CONSTANTS) {
			const factory = {};
			const ENTITIES = {
				nlp: {
					name: 'nlp',
					displayName: 'You can try',
					actionSupport: true
				},
				JOB_HISTORY: {
					name: 'JOB_HISTORY',
					stateName: 'jobs',
					displayName: cvLoc('label.nav.jobs'),
					entityType: 'JOB_HISTORY',
					views: ['LAST_24_HOURS', 'FAILED_LAST_24_HOURS', 'YESTERDAY_JOBS', 'LAST_WEEK', 'LAST_MONTH', 'LAST_3_MONTHS']
				},
				'0': {
					name: '0',
					stateName: null,
					displayName: cvLoc('label.nav.navcustomization'),
					redirectURL: function(item) {
						return item.id;
					}
				},
				'1': {
					name: '1',
					stateName: 'clientGroupDetails',
					actionSupport: true,
					displayName: cvLoc('label.nav.clients'),
					redirectURL: function(item) {
						if (item.osSubType === 'NAS') {
							return 'nasClientDetails/' + item.id;
						}
						return 'clientDetails/' + item.id;
					},
					entityType: 'SERVER',
					intents: [
						'VIEWJOBS',
						'INSTALLSOFTWARE',
						'SENDLOGS',
						'BACKUP',
						'RESTORE',
						'DOWNLOADSOFTWARE',
						'VIEWLOGS',
						'CHANGECOMPANY',
						'CHECKREADINESS',
						'RETIRE',
						'DELETE',
						'UNINSTALLSOFTWARE',
						'RECONFIGURE',
						'RELEASELICENSE'
					]
				},
				'2': {
					name: '2',
					stateName: 'serverGroups',
					actionSupport: true,
					displayName: cvLoc('label.nav.serverGroups'),
					redirectURL: function(item) {
						return 'clientGroupDetails/' + item.id;
					},
					entityType: 'SERVER_GROUP',
					intents: [
						'VIEWJOBS',
						'INSTALLSOFTWARE',
						'CHANGECOMPANY',
						'EDITASSOCIATIONS',
						'REPAIRSOFTWARE',
						'UNINSTALLSOFTWARE',
						'DOWNLOADSOFTWARE',
						'UPGRADESOFTWARE',
						'CLONE',
						'DELETE',
						'PUSHNETWORKCONF'
					]
				},
				'3': {
					name: '3',
					stateName: 'hypervisors',
					actionSupport: true,
					displayName: cvLoc('label.nav.hypervisors'),
					redirectURL: function(item) {
						return 'servers/' + item.id;
					},
					entityType: 'HYPERVISOR_SERVER',
					intents: ['VIEWJOBS', 'SENDLOGS', 'RESTORE', 'RETIRE', 'CHANGECOMPANY', 'INSTALLVAIO', 'UNINSTALLVAIO']
				},
				'4': {
					name: '4',
					stateName: 'vmGroups',
					actionSupport: true,
					displayName: cvLoc('label.nav.vmGroups'),
					redirectURL: function(item) {
						return 'collectionDetails/' + item.serverId + '/' + item.id;
					},
					entityType: 'VM_GROUPS',
					intents: [
						'VIEWJOBS',
						'BACKUP',
						'RESTORE',
						'DELETE',
						'REPLICATIONMONITOR',
						'REPLICATE',
						'FILEINDEXING',
						'CLONE'
					]
				},
				'5': {
					name: '5',
					stateName: 'userVMs',
					actionSupport: true,
					displayName: cvLoc('label.nav.vms'),
					redirectURL: function(item) {
						return 'vm/' + item.id;
					},
					entityType: 'VM',
					intents: [
						'VIEWJOBS',
						'BACKUP',
						'RESTORE',
						'ASSOCIATEPLAN',
						'CHANGECOMPANY',
						'DELETE',
						'RETIRE',
						'REPLICATE',
						'ACTIVEMOUNTS'
					]
				},
				'6': {
					name: '6',
					stateName: 'schedulePolicies',
					displayName: cvLoc('label.nav.schedulePolicy'),
					redirectURL: function(item) {
						return 'schedulePolicyDetails/' + item.id;
					}
				},
				'7': {
					name: '7',
					stateName: 'subclientPolicies',
					displayName: cvLoc('label.nav.subclientPolicy'),
					redirectURL: function(item) {
						return 'subclientPolicyDetail/' + item.id;
					}
				},
				'8': {
					name: '8',
					stateName: 'storagePolicies',
					displayName: cvLoc('label.nav.storagePolicy'),
					redirectURL: function(item) {
						return 'storagePolicyInfo?storagePolicyId=' + item.id;
					}
				},
				'10': {
					name: '10',
					stateName: 'profile',
					displayName: cvLoc('label.nav.profile'),
					redirectURL: function(item) {
						return 'profileDetails/' + item.id;
					},
					entityType: 'PLAN',
					views: ['LAPTOP_PLAN', 'SERVER_PLAN', 'EXCHANGE_MAILBOX_PLAN', 'DC_PLAN']
				},
				'11': {
					name: '11',
					stateName: 'userGroups',
					actionSupport: true,
					displayName: cvLoc('label.nav.userGroups'),
					redirectURL: function(item) {
						return 'userGroup/' + item.id;
					},
					entityType: 'USERS_GROUPS',
					intents: ['ADDUSERS']
				},
				'12': {
					name: '12',
					stateName: 'users',
					actionSupport: true,
					displayName: cvLoc('label.nav.users'),
					redirectURL: function(item) {
						return 'users/' + item.id;
					},
					entityType: 'USERS',
					intents: ['DELETE', 'EDIT']
				},
				'13': {
					name: '13',
					stateName: 'instances',
					displayName: cvLoc('label.nav.dbInstances'),
					redirectURL: function(item) {
						return 'databaseDetails/' + item.id;
					}
				},
				'14': {
					name: '14',
					stateName: 'devices',
					actionSupport: true,
					displayName: cvLoc('label.nav.devices'),
					redirectURL: function(item) {
						return 'devices/' + item.id;
					},
					entityType: 'LAPTOP',
					intents: [
						'RETIRE',
						'CHANGECOMPANY',
						'RESTORE',
						'SENDLOGS',
						'CHECKREADINESS',
						'DEACTIVATE',
						'DOWNLOADSOFTWARE'
					]
				},
				'15': {
					name: '15',
					stateName: 'sharepoint',
					displayName: cvLoc('label.sharepoint'),
					redirectURL: function(item) {
						return 'clientDetails/' + item.id + '/' + item.appId;
					}
				},
				'16': {
					name: '16',
					stateName: 'subscriptions',
					actionSupport: true,
					displayName: cvLoc('label.nav.subscriptions'),
					redirectURL: function(item) {
						return 'subscriptions/' + item.id;
					}
				},
				'17': {
					name: '17',
					stateName: 'activeJobs',
					displayName: cvLoc('label.nav.jobs'),
					redirectURL: function(item) {
						return 'jobs/' + item.id;
					},
					entityType: 'ACTIVE_JOBS',
					views: []
				},
				'18': {
					name: '18',
					stateName: 'reports',
					displayName: cvLoc('label.nav.reports'),
					redirectURL: function(item) {
						return 'reportDetails?reportId=' + item.id + '&app=ADMIN_CONSOLE';
					}
				},
				'19': {
					name: '19',
					stateName: 'mediaAgent',
					actionSupport: true,
					displayName: cvLoc('label.nav.mediaAgents'),
					redirectURL: function(item) {
						return 'mediaAgent/' + item.id;
					}
				},
				'21': {
					name: '21',
					stateName: 'snapArray',
					displayName: cvLoc('label.nav.snapArrays'),
					redirectURL: function(item) {
						return 'snapArray?arrayId=' + item.id;
					},
					entityType: 'ARRAY',
					intents: ['DELETE', 'LISTSNAPSHOT']
				},
				'22': {
					name: '22',
					stateName: 'sqlserver',
					displayName: cvLoc('label.nav.SQLInstances'),
					redirectURL: function(item) {
						return 'instances/' + item.id + '?clientId=' + item.clientId;
					}
				},
				'23': {
					name: '23',
					stateName: 'sqlserverdatabases',
					displayName: cvLoc('label.dbs'),
					redirectURL: function(item) {
						return item.insId + '/sqlDatabaseDetails/' + item.dbId;
					}
				},
				'24': {
					name: '24',
					stateName: 'sqlClones',
					displayName: cvLoc('label.nav.SQLInstantClones'),
					redirectURL: function(item) {
						return 'sqlCloneDetails/' + item.id;
					}
				},
				'25': {
					name: '25',
					stateName: 'fsServersList',
					actionSupport: true,
					displayName: cvLoc('label.nav.servers'),
					redirectURL: function(item) {
						if (item.osSubType === 'NAS') {
							return 'nasClientDetails/' + item.id;
						} else {
							return 'fsAgentDetails/' + item.id + '/' + item.appId;
						}
					},
					entityType: 'FS_SERVER',
					intents: [
						'VIEWJOBS',
						'INSTALLSOFTWARE',
						'SENDLOGS',
						'DELETE',
						'BACKUP',
						'RESTORE',
						'DOWNLOADSOFTWARE',
						'RETIRE',
						'CHANGECOMPANY',
						'ASSOCIATEPLAN',
						'CHECKREADINESS',
						'VIEWLOGS'
					]
				},
				'26': {
					name: '26',
					stateName: 'replicationGroups',
					displayName: cvLoc('label.nav.replication.groups'),
					redirectURL: function(item) {
						return 'replicationGroups/' + item.id;
					}
				},
				'27': {
					name: '27',
					stateName: 'cloudStorageAccountDetails',
					displayName: cvLoc('label.nav.cloudStorage'),
					redirectURL: function(item) {
						return 'cloudStorageAccountDetails/' + item.id;
					}
				},
				'28': {
					name: '28',
					stateName: 'dbDatabases',
					displayName: cvLoc('label.nav.databases'),
					redirectURL: function(item) {
						const instance = item.instance;
						const backupset = item.backupset;
						if (instance.appName === 'RDS' || instance.appName === 'Redshift' || instance.appName === 'DocumentDB') {
							const database = backupset.backupsetName.replace(']', '').replace(' [', ':');
							return 'dbDatabase/' + instance.instanceId + ':' + database;
						} else if (
							instance.applicationId === AppTypes.DB2 ||
							instance.applicationId === AppTypes.DB2_On_Unix ||
							(instance.applicationId === AppTypes.SAP_HANA && item.clientType === 1)
						) {
							return 'dbBackupsetDetails/' + backupset.backupsetId;
						} else if (instance.applicationId === AppTypes.SQL_SERVER) {
							return instance.instanceId + '/sqlDatabaseDetails/' + backupset.backupsetId;
						} else {
							return 'databaseDetails/' + instance.instanceId;
						}
					}
				},
				'29': {
					name: '29',
					stateName: 'dbInstancesClone',
					displayName: cvLoc('label.nav.DBInstantClones'),
					redirectURL: function(item) {
						return 'cloneDetails/' + item.srcInstId + '/' + item.cloneJobId;
					}
				},
				'30': {
					name: '30',
					stateName: 'gitAppsAccounts', // cloud apps lists page
					displayName: cvLoc('label.devOps'),
					redirectURL: function(item) {
						const instanceType = _.get(item, 'detailedProperty.cloudAppsProperty.account.vendorType', 0);
						const instance = _.get(item, 'detailedProperty.cloudAppsProperty.account.instance');
						if (instanceType === CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.SALESFORCE.value) {
							return `salesforceOrgDetails/${instance.clientId}?instanceId=${instance.instanceId}`;
						}

						return 'gitAppsAccountDetails/' + item.id;
					}
				},
				'31': {
					name: '31',
					stateName: 'archiveFileServers',
					displayName: cvLoc('label.archiveFileservers'),
					actionSupport: true,
					redirectURL: function(item) {
						return 'archivalAgentDetails/' + item.id + '/' + item.appId;
					}
				},
				'32': {
					name: '32',
					stateName: 'clusters',
					actionSupport: true,
					displayName: cvLoc('label.nav.clusters'),
					redirectURL: function(item) {
						return 'clusters/' + item.id;
					},
					entityType: 'KUBERNETES_CLUSTER'
					//intents: ['VIEWJOBS', 'SENDLOGS', 'RESTORE', 'RETIRE', 'CHANGECOMPANY', 'INSTALLVAIO', 'UNINSTALLVAIO']
				},
				'33': {
					name: '33',
					stateName: 'applications',
					actionSupport: true,
					displayName: cvLoc('label.nav.applications'),
					redirectURL: function(item) {
						return 'application/' + item.id;
					},
					entityType: 'KUBERNETES_APPLICATION'
					//intents: ['VIEWJOBS', 'SENDLOGS', 'RESTORE', 'RETIRE', 'CHANGECOMPANY', 'INSTALLVAIO', 'UNINSTALLVAIO']
				},
				'34': {
					name: '34',
					stateName: 'applicationGroups',
					actionSupport: true,
					displayName: cvLoc('label.nav.applicationGroups'),
					redirectURL: function(item) {
						return 'applicationGroupDetails/' + item.serverId + '/' + item.id;
					},
					entityType: 'KUBERNETES_APPLICATION_GROUP'
					//intents: ['VIEWJOBS', 'SENDLOGS', 'RESTORE', 'RETIRE', 'CHANGECOMPANY', 'INSTALLVAIO', 'UNINSTALLVAIO']
				},
				'36': {
					name: '36',
					stateName: 'formsNav',
					displayName: cvLoc('label.nav.webconsole.forms'),
					redirectURL: function(item) {
						return 'forms?workflowId=' + item.id;
					},
					entityType: 'WORKFLOWS'
				},
				'37': {
					name: '37',
					stateName: 'distributedStorages',
					displayName: cvLoc('label.nav.distributedStorage'),
					actionSupport: true,
					redirectURL: function(item) {
						return 'distributedStorages/' + item.id;
					}
				},
				'38': {
					name: '38',
					stateName: 'salesforceOrganizations',
					displayName: cvLoc('label.salesforce'),
					redirectURL: function(item) {
						return 'salesforceOrgDetails/' + item.id;
					}
				}
			};

			factory.COMMCELL_ENTITIES = {
				DISASTER_RECOVERY: {
					name: 'DISASTER_RECOVERY',
					displayName: 'Disaster recovery backup job',
					entityType: 'DISASTER_RECOVERY',
					intents: ['EDIT', 'RUN']
				},
				DOWNLOAD_COPY_SOFTWARE: {
					name: 'DOWNLOAD_COPY_SOFTWARE',
					displayName: 'Download / Copy software job',
					entityType: 'DOWNLOAD_COPY_SOFTWARE',
					intents: ['RUN', 'SCHEDULE']
				},
				INSTALL_UPDATES_SCHEDULE: {
					name: 'INSTALL_UPDATES_SCHEDULE',
					displayName: 'Install update schedule',
					entityType: 'INSTALL_UPDATES_SCHEDULE',
					intents: ['RUN', 'ADD']
				}
			};

			function _getSupportedAddSuggestions(intent, entityType, view, actionMap) {
				let suggestions = [];

				_.forEach(globalAddActionsFactory.ENTITIES, (entity, ind) => {
					if (
						(entityType && !view && _.includes(entity.entityType, entityType)) ||
						(entityType && view && entity.entityType === _.toUpper(intent) + '_' + view) ||
						!entityType
					) {
						suggestions.push({
							type: 'nlp',
							action: intent,
							entityType: entity.entityType,
							name: actionMap.intent + ' ' + _.toLower(entity.addEntityName),
							id: 'add-suggestion-' + ind
						});
					}
				});

				return suggestions;
			}

			var allURLRoutes = [];
			var extractURLRoutes = function(routes, parentName) {
				for (var i = 0; i < routes.length; i++) {
					if (routes[i].url) {
						allURLRoutes.push({
							id: routes[i].state,
							name: parentName + routes[i].cvTitle,
							lastName: routes[i].cvTitle
						});
					}
					if (routes[i].children) {
						// Hiding webconsole apps from global search
						if (!routes[i].cvTitle.includes('Web console')) {
							extractURLRoutes(routes[i].children, parentName + routes[i].cvTitle + ' > ');
						}
					}
				}
			};

			function _getNavigationSuggestions(navItems, intent, entityType, view, locEntityName, actionMap) {
				let suggestions = [];
				let viewName = view && entityType ? 'view=' + _.get(VIEW_NAMES_MAP, view + '.name') : '';
				_.forEach(navItems, nav => {
					nav.cvTitle = _.toLower(nav.cvTitle || (nav.pageTitle ? cvLoc(nav.pageTitle) : undefined));
					if (
						nav.url &&
						nav.cvTitle &&
						(!entityType || _.includes(nav.cvTitle, locEntityName) || _.includes(nav.cvTitle, entityType))
					) {
						let suggestion = {
							type: 'nlp',
							action: intent,
							entityType,
							state: nav.state,
							urlLink: nav.url.substr(0, _.indexOf(nav.url, '?') > -1 ? _.indexOf(nav.url, '?') + 1 : nav.url.length),
							id: intent + '-suggestion-' + nav.id
						};

						if (viewName) {
							suggestion.view = view;
							suggestion.urlLink += _.indexOf(suggestion.urlLink, '?') > -1 ? viewName : '?' + viewName;
							suggestion.name =
								actionMap.intent + ' ' + _.toLower(VIEW_NAMES_MAP[view].label) + ' ' + _.toLower(nav.cvTitle);
						} else {
							suggestion.name = actionMap.intent + ' ' + _.toLower(nav.cvTitle);
						}
						suggestions.push(suggestion);
					}

					if (nav.children && nav.children.length) {
						suggestions = suggestions.concat(
							_getNavigationSuggestions(nav.children, intent, entityType, view, locEntityName, actionMap)
						);
					}
				});

				return suggestions;
			}

			factory.getCommcellEntitySuggestions = (intent, ccEntity, entity, locEntityName) => {
				if (!ccEntity) return [];

				let suggestions = [];
				const INTENTS = ccEntity.intents;
				const INTENT_MATCH = _.includes(INTENTS, intent);
				_.forEach(INTENTS, val => {
					const ACTION_MAP = factory.INTENT_ACTION_MAP[val];

					if (!ACTION_MAP || (INTENT_MATCH && intent !== val)) return;

					suggestions.push({
						type: 'nlp',
						action: val,
						entity: entity,
						isCommCellAction: true,
						localizedEntityName: ccEntity.displayName,
						name: ACTION_MAP.intent + ' ' + _.toLower(ccEntity.displayName),
						id: val + '-commcell-suggestion'
					});
				});

				return suggestions;
			};

			const filterRouteByState = (routes, stateName) => {
				let ROUTE;
				_.forEach(routes, route => {
					if (route.state === stateName) {
						ROUTE = route;
						return false;
					}
					if (route.children) {
						ROUTE = filterRouteByState(route.children, stateName);
						if (ROUTE) {
							return false;
						}
					}
				});

				return ROUTE;
			};

			factory.getSupportedSuggestions = (intent, entityType, view, entityName, locEntityName, actionMap) => {
				let suggestions = [];
				if (intent === 'Navigate') {
					let navItems = _.cloneDeep(cv.nav.routes);
					if (locEntityName || entityName) {
						if (view) {
							const ENTITY = _.find(ENTITIES, entity => entity.entityType === entityType);
							if (ENTITY) {
								const VIEWS = ENTITY.views;
								if (VIEWS) {
									const ROUTE = filterRouteByState(navItems, ENTITY.stateName || '');
									navItems = ROUTE ? [ROUTE] : _.cloneDeep(cv.nav.routes);
								}
							}
						} else {
							navItems = cvNavigationFactory.filterRoutes(navItems, locEntityName || entityName);
						}
					}
					extractURLRoutes(navItems, '');
					suggestions = _getNavigationSuggestions(navItems, intent, entityType, view, locEntityName, actionMap);
				} else if (intent === 'Add') {
					suggestions = _getSupportedAddSuggestions(intent, entityType, view, actionMap);
				} else if (actionMap && actionMap.isCommCellIntent) {
					suggestions.push({
						id: 'nlp',
						action: intent,
						name: actionMap.intent,
						id: intent + '-suggestion',
						isCommCellIntent: true
					});
				} else {
					let suggestion = {
						type: 'nlp',
						action: intent,
						name: actionMap.intent,
						id: intent + '-suggestion'
					};
					if (!entityName || (entityType && entityName)) {
						let entitySuggestions = _.map(factory.ENTITIES, entity => {
							let entitySuggestion = {
								entity: entity.entityType,
								entityName: entityName,
								searchType: entity.name,
								localizedEntityName: entity.displayName,
								name: suggestion.name + ' ' + _.toLower(entity.displayName) + (entityName ? ' ' + entityName : ''),
								id: suggestion.id + '-' + entity.name
							};
							if (entity.intents && _.includes(entity.intents, _.toUpper(intent))) {
								if ((entityType && _.includes(entity.entityType, entityType)) || !entityType) {
									suggestions.push({
										...suggestion,
										...entitySuggestion
									});
									return false;
								} else {
									return {
										...suggestion,
										...entitySuggestion
									};
								}
							}
						});
						let filteredEntitySuggestions = _.filter(entitySuggestions, entitySuggestion => entitySuggestion);
						if (
							!suggestions.length &&
							entityType &&
							!entityName &&
							filteredEntitySuggestions &&
							filteredEntitySuggestions.length
						) {
							suggestions = filteredEntitySuggestions;
						}
					}

					if (!suggestions.length && entityName) {
						suggestions.push({
							...suggestion,
							entityName: entityName,
							name: suggestion.name + ' ' + entityName
						});
					}
				}

				return suggestions;
			};

			const INTENT_ACTION_MAP = {
				ABOUT: {
					actions: ['ABOUT'],
					intent: cvLoc('label.about'),
					isCommCellIntent: true
				},
				ADD: {
					actions: ['ADD'],
					intent: cvLoc('Add')
				},
				ACTIVEMOUNTS: {
					actions: ['ACTIVE_MOUNTS'],
					intent: cvLoc('label.globalActions.viewActiveMounts')
				},
				ADDUSERS: {
					actions: ['ADD_USERS'],
					intent: cvLoc('label.globalActions.addUsers')
				},
				ASSOCIATEPLAN: {
					actions: ['ASSOCIATE_PLAN', 'CHANGE_PLAN'],
					intent: cvLoc('label.globalActions.associatePlan')
				},
				BACKUP: {
					actions: ['BACKUP'],
					intent: cvLoc('label.globalActions.backup')
				},
				CHANGECOMPANY: {
					actions: ['CHANGE_COMPANY'],
					intent: cvLoc('label.globalActions.changeCompany')
				},
				CHANGEPASSWORD: {
					actions: ['CHANGEPASSWORD'],
					intent: cvLoc('label.changePassword'),
					isCommCellIntent: true
				},
				CHECKREADINESS: {
					actions: ['READINESS'],
					intent: cvLoc('action.commonAction.readinessCheck')
				},
				CLONE: {
					actions: ['CLONE'],
					intent: cvLoc('label.globalActions.clone')
				},
				CUSTOMERSUPPORT: {
					actions: ['CUSTOMERSUPPORT'],
					intent: cvLoc('label.customerSupport'),
					isCommCellIntent: true
				},
				DEACTIVATE: {
					actions: ['DEACTIVATE'],
					intent: cvLoc('label.globalActions.deactivate')
				},
				DELETE: {
					actions: ['DELETE', 'REMOVE'],
					intent: cvLoc('label.globalActions.delete')
				},
				DISABLE: {
					actions: ['DISABLE'],
					intent: cvLoc('label.disable')
				},
				DOWNLOADSOFTWARE: {
					actions: ['UPDATE_SOFTWARE'],
					intent: cvLoc('action.commonAction.updateSoftware')
				},
				EDIT: {
					actions: ['EDIT'],
					intent: cvLoc('action.edit')
				},
				EDITASSOCIATIONS: {
					actions: ['EDIT_SERVER_GROUP'],
					intent: cvLoc('label.globalActions.editClientGroupAssociations')
				},
				ENABLE: {
					actions: ['ENABLE'],
					intent: cvLoc('label.enable')
				},
				FEEDBACK: {
					actions: ['FEEDBACK'],
					intent: cvLoc('label.feedback'),
					isCommCellIntent: true
				},
				FILEINDEXING: {
					actions: ['ANALYTICS'],
					intent: cvLoc('label.globalActions.fileIndexing')
				},
				HELP: {
					actions: ['HELP'],
					intent: cvLoc('label.help'),
					isCommCellIntent: true
				},
				INSTALLSOFTWARE: {
					actions: ['ADD_SOFTWARE'],
					intent: cvLoc('label.globalActions.addSoftware')
				},
				INSTALLVAIO: {
					actions: ['INSTALL_VAIO'],
					intent: cvLoc('label.globalActions.installVAIO')
				},
				NAVIGATE: {
					actions: ['NAVIGATE'],
					intent: cvLoc('label.open')
				},
				LISTSNAPSHOT: {
					actions: ['LIST_SNAPSHOT'],
					intent: cvLoc('action.listSnaps')
				},
				LOGOUT: {
					actions: ['LOGOUT'],
					intent: cvLoc('label.logout'),
					isCommCellIntent: true
				},
				PUSHNETWORKCONF: {
					actions: ['PUSH_NETWORKCONF'],
					intent: cvLoc('label.globalActions.pushNetworkConf')
				},
				RECONFIGURE: {
					actions: ['RECONFIGURE'],
					intent: cvLoc('action.commonAction.reconfigure')
				},
				RELEASELICENSE: {
					actions: ['RELEASE_LICENSE'],
					intent: cvLoc('action.commonAction.releaseLicense')
				},
				REPAIRSOFTWARE: {
					actions: ['REPAIR_SOFTWARE'],
					intent: cvLoc('action.commonAction.repairSoftware')
				},
				REPLICATE: {
					actions: ['REPLICATE'],
					intent: cvLoc('action.commonAction.replicate')
				},
				REPLICATIONMONITOR: {
					actions: ['REPLICATION_MONITOR'],
					intent: cvLoc('label.nav.replication.monitor')
				},
				RETIRE: {
					actions: ['RETIRE'],
					intent: cvLoc('action.commonAction.retire')
				},
				RESTORE: {
					actions: ['RESTORE'],
					intent: cvLoc('action.commonAction.restore')
				},
				RUN: {
					actions: ['RUN'],
					intent: cvLoc('label.run')
				},
				SENDLOGS: {
					actions: ['SENDLOGS'],
					intent: cvLoc('action.commonAction.sendLogs')
				},
				SCHEDULE: {
					actions: ['SCHEDULE'],
					intent: 'Schedule'
				},
				TURNOFAC: {
					actions: ['TURNOFAC'],
					intent: cvLoc('label.turnoffaccessibility'),
					isCommCellIntent: true
				},
				TURNONAC: {
					actions: ['TURNONAC'],
					intent: cvLoc('label.turnonaccessibility'),
					isCommCellIntent: true
				},
				UNINSTALLSOFTWARE: {
					actions: ['UNINSTALL_SOFTWARE'],
					intent: cvLoc('action.commonAction.uninstallSoftware')
				},
				UNINSTALLVAIO: {
					actions: ['UNINSTALL_VAIO'],
					intent: cvLoc('label.globalActions.uninstallVAIO')
				},
				UPGRADESOFTWARE: {
					actions: ['UPGRADE_SOFTWARE'],
					intent: cvLoc('action.commonAction.upgradeSoftware')
				},
				USERPREF: {
					actions: ['USERPREF'],
					intent: cvLoc('label.userPreference'),
					isCommCellIntent: true
				},
				VIEWJOBS: {
					actions: ['JOBS', 'VIEW_JOBS'],
					intent: cvLoc('action.commonAction.jobs')
				},
				VIEWLOGS: {
					actions: ['VIEW_LOGS'],
					intent: cvLoc('action.viewLogs')
				}
			};

			const VIEW_NAMES_MAP = {
				LAPTOP_PLAN: { name: 'laptop', label: cvLoc('label.laptop') },
				SERVER_PLAN: { name: 'server', label: cvLoc('label.server') },
				EXCHANGE_MAILBOX_PLAN: { name: 'exchange', label: cvLoc('label.exchangeMailbox') },
				DC_PLAN: { name: 'dataClassification', label: cvLoc('label.dataClassification') },
				FAILED_LAST_24_HOURS: { name: 'failedJobs1', label: cvLoc('viewname.jobs.failedJobs1') },
				LAST_24_HOURS: { name: 'finishedJobs1', label: cvLoc('viewname.jobs.finishedJobs1') },
				YESTERDAY_JOBS: { name: 'yesterdayJobs', label: cvLoc('viewname.jobs.yesterdayJobs') },
				LAST_WEEK: { name: 'finishedJobs7', label: cvLoc('viewname.jobs.finishedJobs7') },
				LAST_MONTH: { name: 'finishedJobs30', label: cvLoc('viewname.jobs.finishedJobs30') },
				LAST_3_MONTHS: { name: 'allJobs', label: cvLoc('viewname.jobs.finishedJobs90') }
			};

			factory.ENTITIES = ENTITIES;
			factory.INTENT_ACTION_MAP = INTENT_ACTION_MAP;
			factory.VIEW_NAMES_MAP = VIEW_NAMES_MAP;

			return factory;
		}
	]);
})();
