import 'modules/settings/js/factories/cvActionsEvent.factory.js';
import 'modules/settings/js/factories/globalSearchEntities.factory.js';
import 'modules/settings/js/factories/commcellUtils.factory.js';
import 'modules/settings/js/controllers/nlpSelectEntity.ctrl.js';
import { commonAllAgentsModule } from 'common/js/modules';

var mod = commonAllAgentsModule;

mod.factory('globalNLPActionFactory', [
	'$location',
	'$state',
	'cvLoc',
	'$uibModal',
	'cvToaster',
	'globalActionsFactory',
	'globalAddActionsFactory',
	'globalSearchService',
	'cvNavigationFactory',
	'searchEntitiesFactory',
	function(
		$location,
		$state,
		cvLoc,
		$modal,
		cvToaster,
		globalActionsFactory,
		globalAddActionsFactory,
		globalSearchService,
		cvNavigationFactory,
		searchEntitiesFactory
	) {
		const factory = {};

		let flags = {
			noResultsFound: true
		};
		let callback = false;

		factory.performAction = (intent, fn) => {
			if (!intent || !intent.action) {
				return;
			}
			let _intent = _.toUpper(intent.action);
			callback = fn;
			let _actionMap = searchEntitiesFactory.INTENT_ACTION_MAP[_intent];
			if (intent.entity) {
				intent.entityType = _intent + '_' + (intent.view || intent.entity);
			}

			if (intent.isCommCellAction) {
				_performCommCellAction(intent, callback);
				return;
			}

			if (intent.isCommCellIntent || _actionMap.isCommCellIntent) {
				_performCommCellIntent(intent, callback);
				return;
			}

			switch (_intent) {
				case 'ADD':
					globalAddActionsFactory.performAction(intent.entityType, callback);
					break;
				case 'NAVIGATE':
					if (!intent.urlLink) {
						let suggestions = searchEntitiesFactory.getSupportedSuggestions(
							'Navigate',
							intent.entity,
							intent.view,
							intent.entityName,
							intent.locEntityName,
							searchEntitiesFactory.INTENT_ACTION_MAP.NAVIGATE
						);
						if (suggestions && suggestions.length > 0) intent.urlLink = suggestions[0].urlLink;
					}

					if (intent.urlLink) {
						callback();
						const URLLINK = intent.urlLink;
						const INDEXOFCOLON = _.indexOf(URLLINK, ':');
						$location.url(_.slice(URLLINK, 0, INDEXOFCOLON > -1 ? INDEXOFCOLON : URLLINK.length).join(''));
					} else {
						callback(flags);
					}
					break;
				default:
					let _entityMap = _.find(searchEntitiesFactory.ENTITIES, { entityType: intent.entity });
					let _searchType = _.get(_entityMap, 'name');
					if (_actionMap) {
						factory.processIntent(
							intent.entityName,
							_searchType != undefined ? parseInt(_searchType) : undefined,
							_intent,
							_actionMap,
							intent.searchEntity
						);
					} else {
						callback(flags);
						cvToaster.showErrorMessage({
							ttl: 5000,
							message: cvLoc('error.intentNotRecognized', _.toLower(intent.action))
						});
					}
					break;
			}
		};

		factory.selectEntity = (entities, actionMap) => {
			const entityModalInstance = $modal.open({
				templateUrl: appUtil.appRoot + 'modules/settings/partials/selectEntity.jsp',
				backdrop: 'static',
				windowClass: 'small-size',
				controller: 'selectNlpEntityController',
				resolve: {
					entities: () => entities,
					intent: () => _.toLower(actionMap.intent),
					entityMap: () => searchEntitiesFactory.ENTITIES
				}
			});

			return entityModalInstance;
		};

		const _performCommCellAction = (intent, callback) => {
			let actions = globalActionsFactory.getCommCellActionsList(intent.entity);

			if (actions && actions.length) {
				let _intentAction = _.find(actions, { value: _.toUpper(intent.action) });

				callback(!_intentAction ? flags : null);
				if (_intentAction) {
					if (_intentAction.onClick) {
						_intentAction.onClick.call(null);
					}
				}
			} else {
				callback(flags);
			}
		};

		const _performCommCellIntent = (intent, callback) => {
			let _actionMap = searchEntitiesFactory.INTENT_ACTION_MAP[_.toUpper(intent.action)];

			if (_actionMap) {
				globalActionsFactory.performCommCellIntent(intent);
				callback();
			} else {
				callback(flags);
			}
		};

		const filterSearchResultsWithSupportedIntentMap = (intent, searchResultInfo) => {
			let _filteredResults = [];
			_filteredResults = _.filter(searchResultInfo, info => {
				return _.includes(_.get(searchEntitiesFactory.ENTITIES, info.searchType, { intents: [] }).intents, intent);
			});

			return _filteredResults;
		};

		const handleAction = (entity, actionMap) => {
			globalActionsFactory.getActionsList(entity.searchType, entity).then(actions => {
				let _action = {};
				_.each(actionMap.actions, _map => {
					let _returnAction = _.find(actions, { value: _map });
					if (_returnAction) {
						_action = _returnAction;
						return false;
					} else {
						_action = undefined;
					}
				});
				if (!_action || (_action && _action.show == false)) {
					cvToaster.showErrorMessage({
						ttl: 5000,
						message: cvLoc('error.noUserPermissions', _.toLower(actionMap.intent), entity.displayName)
					});
					return;
				}
				callback();
				if (_action.onClick && typeof _action.onClick === 'function') {
					globalActionsFactory.doAction(entity.searchType, _action, entity);
				} else if (_action.href) {
					$location.url(_.trimStart(_action.href, '#'));
				}
			});
		};

		factory.processIntent = (serverName, type, intent, action, searchEntity) => {
			if (searchEntity && searchEntity.searchType !== 0) {
				handleAction(searchEntity, action);
				return;
			}
			globalSearchService.getSearchData(serverName, type).then(data => {
				let searchResultInfo = _.get(data, 'data.entitySearchResultInfo');
				if (!searchResultInfo) {
					callback(flags);
					return;
				}

				//Filter only results that support particular intent
				searchResultInfo = filterSearchResultsWithSupportedIntentMap(intent, searchResultInfo);

				if (!searchResultInfo.length) {
					callback(flags);
					return;
				}
				if (
					searchResultInfo.length > 1 ||
					(searchResultInfo.length === 1 && _.get(searchResultInfo[0], 'entityInfo', []).length > 1)
				) {
					factory.selectEntity(searchResultInfo, action).result.then(entity => {
						handleAction(entity, action);
					});
				} else {
					let _intentEntity = _.get(searchResultInfo[0], 'entityInfo[0]');
					_intentEntity.searchType = searchResultInfo[0].searchType;
					handleAction(_intentEntity, action);
				}
			});
		};

		return factory;
	}
]);

export default mod;
