(function() {
	'use strict';

	var cvCommon = angular.module('cvCommon');

	cvCommon.factory('globalJobListener', [
		'cvLoc',
		'cvToaster',
		'$window',
		'downloadJobsService',
		'$log',
		'$rootScope',
		function(cvLoc, cvToaster, $window, downloadJobsService, $log, $rootScope) {
			var factory = {};
			function parseJobListenerResponse(jobsResp) {
				if (jobsResp && jobsResp.jobs) {
					var jobs = jobsResp.jobs;
					jobs.forEach(function(job) {
						if (job && job.jobSummary) {
							var jobUserId =
								job.jobSummary.userName && job.jobSummary.userName.userId ? job.jobSummary.userName.userId : null;
							var jobStartedByLoggedInUser = false;
							var jobStatus = job.jobSummary.status;
							var jobId = job.jobSummary.jobId;
							var jobType = null;
							if (jobUserId && jobUserId.toString() === cv.loggedInUserId) {
								jobStartedByLoggedInUser = true;
							}
							if (job.jobSummary.jobType) {
								jobType = job.jobSummary.jobType;
							} else if (job.jobSummary.opType) {
								jobType = job.jobSummary.opType;
							}

							//Show the error message for failed or failed to start job on if the logged in user started it
							//														if (jobStartedByLoggedInUser && jobType && jobStatus && jobId
							//																&& (jobType === "Backup")) {
							//
							//															if ((jobStatus === "Failed")
							//																	|| (jobStatus === "Failed to Start")) {
							//																var jobFailedMsg = cvLoc('error.jobFailed', jobId)
							//																		+ '<br><a href="#/jobs/' + jobId + '">'
							//																		+ cvLoc('label.viewJobDetails') + '</a>';
							//																cvToaster.showErrorMessage({
							//																	'ttl' : '-1',
							//																	'message' : jobFailedMsg
							//																});
							//															}
							//														}

							//Check the local storage for a power restore job
							//since we are interested only in failed or complete restore jobs
							//Pending state is also included since the user might not want to wait that long for a download
							if (
								jobType &&
								(jobType === 'Restore' || jobType === 'POWERRESTORE') &&
								jobStatus &&
								(jobStatus === 'Completed' ||
									jobStatus === 'Completed_Partial' ||
									jobStatus === 'Failed' ||
									jobStatus === 'Stopped' ||
									jobStatus === 'Killed' ||
									jobStatus === 'Pending') &&
								doesPowerRestoreJobExist(jobId)
							) {
								downloadJobHandler(job.jobSummary);
							}
						}
					});
				}
			}
			var unsubscribeJobListener = null;
			var subscribeJobListener = function(onMessage, onError) {
				var subscribeInfo = {
					msg: 'subscribe',
					type: 'JOB',
					metaData: 'Download'
				};
				unsubscribeJobListener = pushService.subscribe(subscribeInfo, onMessage, onError);
			};
			var unsubscribePrivateJobsListener;
			var subscribePrivateJobsListener = function(onMessage, onError) {
				var subscribeInfo = {
					msg: 'subscribe',
					type: 'JOB',
					subType: 'JOB_DETAIL',
					filter: 'PRIVATE',
					workId: 0
				};
				//the global detail job will listen to all jobs created in the session (*provided they use the subscriptionId as a part of request to WS)
				unsubscribePrivateJobsListener = pushService.subscribe(subscribeInfo, onMessage, onError);
			};
			factory.listenToJobs = function() {
				if (cvConfig.pushEnabled) {
					subscribePrivateJobsListener(
						function(jobsResp) {
							parsePrivateJobResponse(jobsResp);
						},
						function(response) {
							//console.error("unable to subscribe for jobs");
						}
					);

					//console.log("subscribing to jobs");
					subscribeJobListener(
						function(jobsResp) {
							parseJobListenerResponse(jobsResp);
						},
						function(response) {
							//console.error("unable to subscribe for jobs");
						}
					);

					$window.onbeforeunload = function() {
						//console.log("unsubscribing now");
						if (unsubscribeJobListener) {
							unsubscribeJobListener();
						}
						if (unsubscribePrivateJobsListener) {
							unsubscribePrivateJobsListener();
						}
					};
				}
			};
			function showMessageToUser(jobId, msg, type, pendingReason) {
				var jobMessage = jobId ? '<a href="#/jobs/' + jobId + '">' + cvLoc(msg, jobId) + '</a>' : msg;
				if (pendingReason) {
					jobMessage = appendPendingReason(jobMessage, pendingReason);
				}
				$log.info('showing ' + type + ' message:' + jobMessage);
				switch (type) {
					case 'success':
						cvToaster.showSuccessMessage({
							ttl: '10000',
							message: jobMessage
						});
						break;
					case 'warn':
						cvToaster.showWarnMessage({
							ttl: '10000',
							message: jobMessage
						});
						break;
					case 'error':
						cvToaster.showErrorMessage({
							ttl: '10000',
							message: jobMessage
						});
						break;
				}
			}
			function appendPendingReason(msg, pendingReason) {
				var reason = pendingReason ? '<br/>' + pendingReason : '';
				msg = msg + reason;
				return msg;
			}
			function showJobProgressMessage(jobId, status, pendingReason) {
				var msg = '';
				switch (status.toLowerCase()) {
					case 'completed':
						showMessageToUser(jobId, 'notification.jobSuccess', 'success');
						break;
					case 'killed':
						showMessageToUser(jobId, 'notification.jobKilled', 'warn');
						break;
					case 'completed w/ one or more errors':
						showMessageToUser(jobId, 'notification.jobCompletedWithErrors', 'warn');
						break;
					case 'failed':
						showMessageToUser(jobId, 'error.jobFailed', 'warn', pendingReason);
						break;
					case 'committed':
						showMessageToUser(jobId, 'notification.jobCommitted', 'success');
						break;
				}
				return;
			}
			//function to parse the job object and show applicable error/success notifications
			function handleJobDetail(job) {
				if (job && job.jobDetail && job.jobDetail.progressInfo && job.jobDetail.generalInfo) {
					var jobStatus = job.jobDetail.progressInfo.state;
					var jobId = job.jobDetail.generalInfo.jobId;
					var pendingReason = job.jobDetail.progressInfo.reasonForJobDelay
						? job.jobDetail.progressInfo.reasonForJobDelay
						: null;
					//extract job's details
					if (jobStatus && jobId) {
						showJobProgressMessage(jobId, jobStatus, pendingReason);
						//if it is a push install broadcast the status
						if (job.jobDetail.generalInfo.opType == 'INSTALLCLIENT') {
							var jobStatusObj = {
								jobId: jobId,
								state: jobStatus,
								percentComplete: job.jobDetail.progressInfo.percentComplete,
								pendingReason: pendingReason
							};
							$rootScope.$broadcast('INSTALLCLIENT', jobStatusObj);
						}
					}
				}
			} //end of handleJobDetail

			//method to parse the push notification received for the private subscription
			function parsePrivateJobResponse(jobsResp) {
				if (jobsResp && jobsResp.errorResp && jobsResp.errorResp.errorMessage) {
					$log.info('error message:' + jobsResp.errorResp.errorMessage);

					//this is executed in case of failed to start type of operation
					showMessageToUser(jobsResp.jobId, 'error.jobFailedToStart', 'error', jobsResp.errorResp.errorMessage);
				} else if (jobsResp && !jobsResp.jobs && jobsResp.job) {
					//if the job did not fail to start, it should enter this block
					var job = jobsResp.job;
					//go through the job's detail and decide to show job completion messages
					handleJobDetail(job);
				}
			} //end parseprivate

			var downloadJobHandler = function(jobSummary) {
				downloadJobsService
					.downloadJobHandler(jobSummary)
					.success(function(data) {
						removePowerRestoreJob(jobSummary.jobId);
						if (data) {
							if (data.errorString) {
								cvToaster.showErrorMessage({
									ttl: '5000',
									message: data.errorString
								});
							} else {
								if (data.multiFile && !data.downloadComplete && data.batchGUID) {
									//this is the case where polling might be required for multi-file restore, the restore to zip
									//process might not be complete. This would require polling to check for their status
									downloadJobsService.pollForFileStatus(data.batchGUID, new Date().getTime());
								} else if (data.downloadComplete && data.batchGUID) {
									downloadJobsService.startDownload(data.batchGUID);
								}
							}
						}
					})
					.error(function(err) {
						console.log(err);
						removePowerRestoreJob(jobSummary.jobId);
					});
			};

			//utility method to check if the power restore job exists in local storage
			var doesPowerRestoreJobExist = function(jobId) {
				if (localStorage.getItem('powerRestoreJobs') === null) {
					return false;
				}

				var powerRestoreJobList = localStorage.getItem('powerRestoreJobs');
				powerRestoreJobList = JSON.parse(powerRestoreJobList);

				var jobExists = false;
				for (var i = 0; i < powerRestoreJobList.length; i++) {
					if (jobId === powerRestoreJobList[i]) {
						jobExists = true;
						break;
					}
				}

				return jobExists;
			};

			//utility method to remove a job from local storage
			var removePowerRestoreJob = function(jobId) {
				if (localStorage.getItem('powerRestoreJobs') === null) {
					return;
				}

				var powerRestoreJobList = localStorage.getItem('powerRestoreJobs');
				powerRestoreJobList = JSON.parse(powerRestoreJobList);
				var jobIndex = powerRestoreJobList.indexOf(jobId);
				if (jobIndex > -1) {
					powerRestoreJobList.splice(jobIndex, 1);
				}
				//check if that was the last item and list is empty
				//remove the local storage at this point
				if (powerRestoreJobList.length === 0) {
					localStorage.removeItem('powerRestoreJobs');

					//if there is nothing in the power restore local storage then set the downloadsProcessing variable to false
					downloadJobsService.downloadsProcessing = false;
				} else {
					localStorage.setItem('powerRestoreJobs', JSON.stringify(powerRestoreJobList));
				}
			};

			factory.clearPowerRestoreLocalStorage = function() {
				if (localStorage.getItem('powerRestoreJobs') === null) {
					return;
				}

				localStorage.removeItem('powerRestoreJobs');
			};

			return factory;
		}
	]);
})();
