import 'modules/settings/js/factories/cvActionsEvent.factory.js'; //cvActionsEventFactory
import 'modules/settings/js/factories/globalActions.factory.js';
import 'modules/settings/js/factories/globalAddAction.factory.js';
import 'modules/settings/js/factories/globalNLPAction.factory.js';
import 'modules/settings/js/services/settings.svc.js';
import 'common/js/commonShortcutsConfig.js';
import { commonAllAgentsModule } from 'common/js/modules';
var mod = commonAllAgentsModule;
mod.factory('cvPermissionFactory', [
	'cvLoc',
	'cvActionsEventFactory',
	'settingsService',
	'commonShortcutFactory',
	function(cvLoc, cvActionsEventFactory, settingsService, commonShortcutFactory) {
		var factory = {};

		factory.permissionsForActions = {
			UPDATE_SOFTWARE: {
				permissionIds: [7]
			},
			UPGRADE_SOFTWARE: {
				permissionIds: [7]
			},
			REPAIR_SOFTWARE: {
				permissionIds: [7]
			},
			UNINSTALL_SOFTWARE: {
				permissionIds: [7]
			},
			ADD_SOFTWARE: {
				permissionIds: [7]
			},
			RELEASE_LICENSE: {
				permissionIds: [2]
			},
			RECONFIGURE: {
				permissionIds: [2]
			},
			DELETE: {
				permissionIds: [2]
			},
			READINESS: {
				permissionIds: []
			},
			SENDLOGS: {
				permissionIds: [1, 264]
			},
			BACKUP_HISTORY: {
				permissionIds: []
			},
			RESTORE_HISTORY: {
				permissionIds: []
			},
			RESTORE: {
				permissionIds: [20]
			},
			JOBS: {
				permissionIds: []
			},
			BACKUP: {
				permissionIds: []
			},
			RETIRE: {
				permissionIds: [253]
			},
			REPLICATE: {
				permissionIds: [20]
			},
			CLONE: {
				permissionIds: []
			},
			PUSH_NETWORKCONF: {
				permissionIds: []
			},
			VIEW_LOGS: {
				permissionIds: [2, 264]
			},
			DOWNLOAD: {
				permissionIds: [6]
			},
			INSTANT_CLONE: {
				permissionIds: []
			},
			ARCHIVE: {
				permissionIds: []
			},
			DELETE_DATA: {
				permissionIds: [219]
			},
			RESTART_SERVICES: {
				permissionIds: [2]
			},
			MANAGE_TAGS: {
				permissionIds: []
			}
		};

		factory.getPermissionIdsForAction = function(actionName) {
			if (angular.isDefined(actionName) && actionName !== '') {
				return factory.permissionsForActions[actionName].permissionIds;
			}
			return [];
		};

		factory.commonPermittedList = {
			ADD_SOFTWARE: {
				label: 'Add software',
				value: 'ADD_SOFTWARE',
				permissionIds: factory.getPermissionIdsForAction('ADD_SOFTWARE')
			},
			UPDATE_SOFTWARE: {
				label: cvLoc('action.commonAction.updateSoftware'),
				value: 'UPDATE_SOFTWARE',
				permissionIds: factory.getPermissionIdsForAction('UPDATE_SOFTWARE'),
				onClick: cvActionsEventFactory.handleCommonAction
			},
			UPGRADE_SOFTWARE: {
				label: cvLoc('action.commonAction.upgradeSoftware'),
				value: 'UPGRADE_SOFTWARE',
				permissionIds: factory.getPermissionIdsForAction('UPGRADE_SOFTWARE'),
				onClick: cvActionsEventFactory.handleCommonAction
			},
			REPAIR_SOFTWARE: {
				label: cvLoc('action.commonAction.repairSoftware'),
				value: 'REPAIR_SOFTWARE',
				permissionIds: factory.getPermissionIdsForAction('REPAIR_SOFTWARE'),
				onClick: cvActionsEventFactory.handleCommonAction
			},
			UNINSTALL_SOFTWARE: {
				label: cvLoc('action.commonAction.uninstallSoftware'),
				value: 'UNINSTALL_SOFTWARE',
				permissionIds: factory.getPermissionIdsForAction('UNINSTALL_SOFTWARE'),
				onClick: cvActionsEventFactory.handleCommonAction
			},
			RELEASE_LICENSE: {
				label: cvLoc('action.commonAction.releaseLicense'),
				value: 'RELEASE_LICENSE',
				permissionIds: factory.getPermissionIdsForAction('RELEASE_LICENSE'),
				onClick: cvActionsEventFactory.handleCommonAction
			},
			RECONFIGURE: {
				label: cvLoc('action.commonAction.reconfigure'),
				value: 'RECONFIGURE',
				permissionIds: factory.getPermissionIdsForAction('RECONFIGURE'),
				onClick: cvActionsEventFactory.handleCommonAction
			},
			DELETE: {
				label: cvLoc('Delete'),
				value: 'DELETE',
				permissionIds: factory.getPermissionIdsForAction('DELETE'),
				onClick: cvActionsEventFactory.handleCommonAction
			},
			READINESS: {
				label: cvLoc('action.commonAction.readinessCheck'),
				value: 'READINESS',
				permissionIds: factory.getPermissionIdsForAction('READINESS')
			},
			SENDLOGS: {
				label: cvLoc('action.commonAction.sendLogs'),
				value: 'SENDLOGS',
				showIfAtleastOnePermissionIsPresent: true,
				permissionIds: factory.getPermissionIdsForAction('SENDLOGS')
			},
			BACKUP_HISTORY: {
				label: cvLoc('action.commonAction.backupHistory'),
				value: 'BACKUP_HISTORY',
				permissionIds: factory.getPermissionIdsForAction('BACKUP_HISTORY')
			},
			ARCHIVE_HISTORY: {
				label: cvLoc('action.commonAction.archiveHistory'),
				value: 'ARCHIVE_HISTORY',
				permissionIds: factory.getPermissionIdsForAction('BACKUP_HISTORY')
			},
			RESTORE_HISTORY: {
				label: cvLoc('action.commonAction.restoreHistory'),
				value: 'RESTORE_HISTORY',
				permissionIds: factory.getPermissionIdsForAction('RESTORE_HISTORY')
			},
			RESTORE: {
				label: cvLoc('action.commonAction.restore'),
				value: 'RESTORE',
				permissionIds: factory.getPermissionIdsForAction('RESTORE')
			},
			JOBS: {
				label: cvLoc('action.commonAction.jobs'),
				value: 'JOBS',
				permissionIds: factory.getPermissionIdsForAction('JOBS')
			},
			BACKUP: {
				label: cvLoc('action.commonAction.backup'),
				value: 'BACKUP',
				permissionIds: factory.getPermissionIdsForAction('BACKUP')
			},
			ARCHIVE: {
				label: cvLoc('action.commonAction.archive'),
				value: 'ARCHIVE',
				permissionIds: factory.getPermissionIdsForAction('ARCHIVE')
			},
			RETIRE: {
				label: cvLoc('action.commonAction.retire'),
				value: 'RETIRE',
				permissionIds: factory.getPermissionIdsForAction('RETIRE'),
				onClick: cvActionsEventFactory.handleCommonAction
			},
			REPLICATE: {
				label: cvLoc('action.commonAction.replicate'),
				value: 'REPLICATE',
				permissionIds: factory.getPermissionIdsForAction('REPLICATE')
			},
			CLONE: {
				label: cvLoc('action.commonAction.clone'),
				value: 'CLONE',
				permissionIds: factory.getPermissionIdsForAction('CLONE')
			},
			PUSH_NETWORKCONF: {
				label: cvLoc('action.commonAction.pushNetworkConf'),
				value: 'PUSH_NETWORKCONF',
				permissionIds: factory.getPermissionIdsForAction('PUSH_NETWORKCONF')
			},
			VIEW_LOGS: {
				label: cvLoc('action.viewLogs'),
				value: 'VIEW_LOGS',
				permissionIds: factory.getPermissionIdsForAction('VIEW_LOGS'),
				showIfAtleastOnePermissionIsPresent: true,
				onClick: cvActionsEventFactory.handleCommonAction
			},

			DOWNLOAD: {
				label: cvLoc('action.commonAction.download'),
				value: 'DOWNLOAD',
				permissionIds: factory.getPermissionIdsForAction('DOWNLOAD')
			},
			INSTANT_CLONE: {
				label: cvLoc('action.commonAction.instantClone'),
				value: 'INSTANT_CLONE',
				permissionIds: factory.getPermissionIdsForAction('INSTANT_CLONE')
			},
			DELETE_DATA: {
				label: cvLoc('Delete'),
				value: 'DELETE_DATA',
				permissionIds: factory.getPermissionIdsForAction('DELETE_DATA')
			},
			MANAGE_TAGS: {
				label: cvLoc('label.manageTags'),
				value: 'MANAGE_TAGS',
				permissionIds: factory.getPermissionIdsForAction('MANAGE_TAGS'),
				onClick: cvActionsEventFactory.handleCommonAction
			}
		};

		/*
		 * @actualActionItem - Item from factory.commonPermittedList @overrideActionItem - Item which has
		 * override object.
		 *
		 * takes in two objects and returns overriden Object. Iterated over each propery of overrideActionItem
		 * Object and updates copied actualItem properties, if property is not present , that property will be
		 * added and returned.
		 *
		 */
		var _overrideOriginalActionItem = function(actualActionItem, overrideActionItem) {
			if (
				actualActionItem &&
				angular.isDefined(actualActionItem) &&
				overrideActionItem &&
				angular.isDefined(overrideActionItem)
			) {
				for (var prop in overrideActionItem) {
					if (
						overrideActionItem.hasOwnProperty(prop) &&
						prop &&
						angular.isDefined(prop) &&
						prop !== '' &&
						prop !== 'value'
					) {
						actualActionItem[prop] = angular.copy(overrideActionItem[prop]);
					}
				}
			}
			return actualActionItem;
		};

		/*
		 * Input:- @arrayOfActionsToOverride: [{"READINESS" : {label : cvLoc('label.readinessCheckNew')}}]
		 * @includeRemainingActionItems : boolean which determines to include or exclude items which are part
		 * of factory.commonPermittedList but not part of @arrayOfActionsToOverride
		 */

		//this funcction will accept array of object something like [{"READINESS" : {label : cvLoc('label.readinessCheckNew')}}]
		factory.updateAndGetCommonActionsList = function(
			arrayOfActionsToOverride,
			includeRemainingActionItems,
			commonPermittedList
		) {
			var permittedActionsList = [];
			var arrayOfActionNamesToOverride = [];
			if (
				arrayOfActionsToOverride &&
				angular.isArray(arrayOfActionsToOverride) &&
				arrayOfActionsToOverride.length > 0
			) {
				arrayOfActionsToOverride.forEach(function(actionItem) {
					var actionItemName = Object.keys(actionItem)[0];
					arrayOfActionNamesToOverride.push(actionItemName);
				});
			}
			if (commonPermittedList && angular.isDefined(commonPermittedList)) {
				for (var commonPermittedItem in commonPermittedList) {
					if (commonPermittedList.hasOwnProperty(commonPermittedItem)) {
						if (
							arrayOfActionsToOverride &&
							angular.isArray(arrayOfActionsToOverride) &&
							arrayOfActionsToOverride.length > 0
						) {
							if (arrayOfActionNamesToOverride.includes(commonPermittedItem)) {
								//if object key name equals properyName name then do overRides
								var actualActionItem = angular.copy(commonPermittedList[commonPermittedItem]);
								var overrideActionItem =
									arrayOfActionsToOverride[arrayOfActionNamesToOverride.indexOf(commonPermittedItem)][
										commonPermittedItem
									];
								permittedActionsList.push(_overrideOriginalActionItem(actualActionItem, overrideActionItem));
							}
						}
						if (
							includeRemainingActionItems !== null &&
							angular.isDefined(includeRemainingActionItems) &&
							includeRemainingActionItems
						) {
							permittedActionsList.push(commonPermittedList[commonPermittedItem]);
						}
					}
				}
			}
			return permittedActionsList;
		};

		factory.filterPermittedActions = function(action, permissions) {
			const atleastOne = action.showIfAtleastOnePermissionIsPresent
				? action.showIfAtleastOnePermissionIsPresent
				: false;
			if (action.hasOwnProperty('permissionIds') && action.hasOwnProperty('show')) {
				return factory.userHasPermissions(action.permissionIds, permissions, atleastOne) && action.show;
			} else if (action.hasOwnProperty('permissionIds')) {
				return factory.userHasPermissions(action.permissionIds, permissions, atleastOne);
			} else if (action.hasOwnProperty('show')) {
				return action.show;
			} else {
				return true;
			}
		};

		factory.filterPermissionsForEntity = function(entityId, entityType, actions) {
			actions = factory.updateAndGetCommonActionsList(actions, false, factory.commonPermittedList);
			return settingsService.getEntityCapabilities(entityId, entityType).then(result => {
				let permissions = _.map(_.get(result, 'data'), 'permissionId');
				actions = _.filter(actions, action => {
					return factory.userHasPermissions(action.permissionIds, permissions);
				});
				return actions;
			});
		};

		factory.getCVCapabilityConfig = function(entity, skipJsonParse) {
			const metaInfo = _.get(entity, 'metaInfo[0]') || entity;
			let cvCapability = {};

			if (metaInfo.value || skipJsonParse) {
				let permissionInfo, permissionIds;

				if (skipJsonParse) {
					permissionIds = entity;
				} else {
					permissionInfo = JSON.parse(metaInfo.value);
					permissionIds = _.get(permissionInfo, 'permissionIds', []);
				}

				cvCapability = {
					alerts: {
						permissionIds: permissionIds,
						permissionId: 18
					},
					security: {
						permissionIds: permissionIds,
						permissionId: 107
					},
					general: {
						permissionIds: permissionIds,
						permissionId: 2
					}
				};
			}

			return cvCapability;
		};

		factory.userHasPermissions = function(permissionIds, userPermissions, atLeastOne) {
			if (
				_.isNull(permissionIds) ||
				_.isUndefined(permissionIds) ||
				_.isNull(userPermissions) ||
				_.isUndefined(userPermissions)
			) {
				return true;
			} else {
				if (atLeastOne === true) {
					//has atleast one permission
					return permissionIds.some(function(permissionId) {
						return userPermissions.includes(permissionId);
					});
				} else {
					// has all permission
					return permissionIds.every(function(permissionId) {
						return userPermissions.includes(permissionId);
					});
				}
			}
		};
		return factory;
	}
]);
export default mod;
