/*This File has all the call back handlers for common actions on Entity */
import { commonAllAgentsModule } from 'common/js/modules';
import 'commonForAllAgents/js/controllers/updateSoftware.ctrl.js'; //updateSoftwareFactory
import 'commonForAllAgents/js/controllers/upgradeSoftware.ctrl.js';
import 'commonForAllAgents/js/controllers/repairSoftware.ctrl.js';
import 'common/js/cv-dialog-factory.js'; //dialogFactory
import 'commonForAllAgents/js/controllers/uninstallSoftware.ctrl.js'; //uninstallSoftwareFactory
import 'commonForAllAgents/js/controllers/releaseLicenseModal.ctrl.js'; //releaseLicenseFactory
import 'commonForAllAgents/js/controllers/reconfigureClient.ctrl.js'; //reconfigureClientFactory
import 'commonForAllAgents/js/services/clients.svc.js'; //allAgentsService
import 'adminConsole/js/constants/uiStates.constant.js';
import 'common/js/tags/tags.svc.js';
var mod = commonAllAgentsModule;
mod.factory('cvActionsEventFactory', [
	'cvLoc',
	'cvUtil',
	'$dialogs',
	'$state',
	'$window',
	'$location',
	'dialogFactory',
	'updateSoftwareFactory',
	'upgradeSoftwareFactory',
	'repairSoftwareFactory',
	'uninstallSoftwareFactory',
	'releaseLicenseFactory',
	'reconfigureClientFactory',
	'allAgentsService',
	'$httpParamSerializer',
	'$stateParams',
	'globalCacheFactory',
	'cvToaster',
	'$uibModal',
	'ADDITIONAL_SETTING_CATEGORY',
	'LIST_TO_DETAILS_STATE_MAP',
	function(
		cvLoc,
		cvUtil,
		$dialogs,
		$state,
		$window,
		$location,
		dialogFactory,
		updateSoftwareFactory,
		upgradeSoftwareFactory,
		repairSoftwareFactory,
		uninstallSoftwareFactory,
		releaseLicenseFactory,
		reconfigureClientFactory,
		allAgentsService,
		$httpParamSerializer,
		$stateParams,
		globalCacheFactory,
		cvToaster,
		$modal,
		ADDITIONAL_SETTING_CATEGORY,
		LIST_TO_DETAILS_STATE_MAP
	) {
		var factory = {};

		var _removeActionRedirect = function(entityListPageState) {
			if (!entityListPageState) {
				return;
			}

			if (entityListPageState === $state.current.name) {
				$state.reload();
			} else if (
				LIST_TO_DETAILS_STATE_MAP[entityListPageState] &&
				LIST_TO_DETAILS_STATE_MAP[entityListPageState].includes($state.current.name)
			) {
				$state.go(entityListPageState);
			}
		};

		var _deleteV2 = function(entityId, entityName, redirection, callBack, promptMessage, entityListPageState) {
			let modalTitle = cvLoc('label.confirmDelete', entityName);
			let typedConfirmation = cvLoc('action.delete');
			let entityNameMessage = entityName ? '<b>' + entityName + '</b>' : cvLoc('label.entityNamePlaceHolder');
			promptMessage = promptMessage
				? promptMessage
				: cvLoc('prompt.confirmDeleteClient', entityNameMessage, entityNameMessage, entityNameMessage);
			dialogFactory.deleteConfirmDialog(modalTitle, promptMessage, typedConfirmation).result.then(function() {
				allAgentsService
					.deleteClient(entityId)
					.success(function(data) {
						if (redirection) {
							$state.go(redirection);
						} else {
							// default redirection logic applies if redirection param is not supplied
							_removeActionRedirect(entityListPageState);
						}
						if (callBack) {
							callBack();
						}
						cvToaster.showSuccessMessage({
							message: deviceName + ' ' + cvLoc('info.deleteSuccessful')
						});
					})
					.error(function(e) {
						cvToaster.showErrorMessage({
							ttl: '10000',
							message: e ? e : cvLoc('generic_error')
						});
					});
			});
		};

		var _onRetireSuccess = function(data, clientName, applicationName, redirection, callBack, entityListPageState) {
			let jobId = '';
			let retireMsg;

			if (data && data.jobId) {
				jobId += data.jobId;
				retireMsg = applicationName
					? cvLoc('info.retireAgentJobSubmitted', clientName, applicationName, jobId)
					: cvLoc('info.retireJobSubmitted', clientName, jobId) +
					  (' <br><a href=#/jobs/' + jobId + '>' + cvLoc('notification.jobDetails') + '</a>');
			} else {
				retireMsg = applicationName
					? cvLoc('info.retireAgent.success', clientName, applicationName)
					: cvLoc('info.retire.success', clientName);
			}

			if (redirection) {
				$state.go(redirection);
			} else {
				// default redirection logic applies if redirection function is not supplied
				_removeActionRedirect(entityListPageState);
			}
			if (callBack) {
				callBack();
			}

			cvToaster.showSuccessMessage({
				ttl: '7000',
				message: retireMsg
			});
		};

		var _retireClientV2 = function(entityId, entityName, redirection, callBack, promptMessage, entityListPageState) {
			let modalTitle = cvLoc('label.confirmRetire', entityName);
			let typedConfirmation = cvLoc('action.retire');
			let entityNameMessage = entityName ? '<b>' + entityName + '</b>' : cvLoc('label.entityNamePlaceHolder');
			promptMessage = promptMessage
				? promptMessage
				: cvLoc('prompt.confirmRetireClient', entityNameMessage, entityNameMessage, entityNameMessage, cv.oemName);
			let actionButtonLabel = cvLoc('action.retire');
			dialogFactory
				.deleteConfirmDialog(modalTitle, promptMessage, typedConfirmation, actionButtonLabel)
				.result.then(function() {
					allAgentsService
						.retireClient(entityId, entityListPageState)
						.success(function(data) {
							_onRetireSuccess(data, entityName, undefined, redirection, callBack, entityListPageState);
						})
						.error(function(e) {
							cvToaster.showErrorMessage({
								ttl: '10000',
								message: e ? e : cvLoc('generic_error')
							});
						});
				});
		};

		var _retireClientListV2 = function(entityList, ctrl, entityType) {
			let modalTitle = cvLoc('label.confirmRetire', entityType);
			let typedConfirmation = cvLoc('action.retire');
			let entityNameMessage = cvLoc('label.entityListPlaceHolder', entityType);
			let promptMessage = cvLoc(
				'prompt.confirmRetireClient',
				entityNameMessage,
				entityNameMessage,
				entityNameMessage,
				cv.oemName
			);
			let actionButtonLabel = cvLoc('action.retire');

			let entityIdList = [];
			entityList.forEach(function(entity) {
				entityIdList.push(entity.entityId);
			});
			dialogFactory
				.deleteConfirmDialog(modalTitle, promptMessage, typedConfirmation, actionButtonLabel)
				.result.then(function() {
					allAgentsService
						.retireClients(entityIdList.toString())
						.success(function(data) {
							if (ctrl && ctrl.refresh) {
								ctrl.refresh();
							}
							cvToaster.showInfoMessage({
								ttl: '10000',
								message: entityType + cvLoc('label.successRetire')
							});
						})
						.error(function(e) {
							cvToaster.showErrorMessage({
								ttl: '10000',
								message: e ? e : cvLoc('generic_error')
							});
						});
				});
		};

		let _viewLogs = (clientId, clientName) => {
			var modalInstance = $modal.open({
				templateUrl: appUtil.appRoot + 'machineBrowse/partials/machineBrowse.jsp',
				controller: 'mbController',
				backdrop: 'static',
				resolve: {
					browseParams: function() {
						return {
							clientId: clientId,
							clientName: clientName,
							foldersOnly: false,
							selectMultiple: true,
							viewLogs: true
						};
					}
				}
			});
		};
		//modules/settings/partials/addEditTags.jsp
		let _manageTags = (entityId, entityName, entityType, callBack) => {
			return $modal.open({
				templateUrl: appUtil.appRoot + 'modules/settings/partials/addEditTags.jsp',
				backdrop: 'static',
				windowClass: 'small-size',
				controller: [
					'$scope',
					'$uibModalInstance',
					'cvLoc',
					'tagsService',
					'EntityTypes',
					'cvToaster',
					function($scope, $modalInstance, cvLoc, tagsService, EntityTypes, cvToaster) {
						$scope.entity = {
							entityId: entityId,
							entityName: entityName,
							entityType: EntityTypes[entityType]
						};
						$scope.noTagsToDisplay = cvLoc('info.noTagsToDisplay', $scope.entity.entityName);
						$scope.setErrorMessage = function(errorString) {
							$scope.serverMessage = {
								type: 'error',
								message: errorString
							};
						};

						$scope.setSavingMessage = function() {
							$scope.serverMessage = {
								message: cvLoc('Saving'),
								type: 'loader'
							};
						};

						$scope.entityTagsloadComplete = false;
						$scope.tagsForEntity = [];
						$scope.existingEntityTagNames = [];
						tagsService
							.getTagsForEntity($scope.entity)
							.success(function(data) {
								$scope.serverMessage = null;
								$scope.entityTagsloadComplete = true;
								if (!_.isNil(data) && !_.isNil(data.tags) && !_.isNil(data.tags[0]) && !_.isNil(data.tags[0].tag)) {
									// Loading existing tags for entity in map for edit and remove operation
									for (let k = 0; k < data.tags[0].tag.length; k++) {
										$scope.tagsForEntity.push(data.tags[0].tag[k]);
										$scope.existingEntityTagNames.push(data.tags[0].tag[k].name);
									}
								}
							})
							.error(function(err) {
								$scope.entityTagsloadComplete = true;
								$scope.setErrorMessage(err);
							});

						$scope.removeTagForEntity = tagName => {
							for (let i = 0; i < $scope.tagsForEntity.length; i++) {
								if (!_.isNil($scope.tagsForEntity[i]) && $scope.tagsForEntity[i].name === tagName) {
									//not using ES6 filter operation since this file is loaded during app load and IE loading should not cause problem
									$scope.tagsForEntity.splice(i, 1);
								}
								$scope.existingEntityTagNames.splice($scope.existingEntityTagNames.indexOf(tagName), 1);
							}
						};

						$scope.addTagForEntity = () => {
							if ($scope.newTag.name !== '' && !$scope.existingEntityTagNames.includes($scope.newTag.name)) {
								$scope.tagsForEntity.push(angular.copy($scope.newTag));
								$scope.existingEntityTagNames.push(angular.copy($scope.newTag.name));
								$scope.newTag = {
									name: '',
									value: ''
								};
								$scope.serverMessage = null;
							} else if ($scope.newTag.name == '') {
								$scope.serverMessage = {
									type: 'error',
									message: cvLoc('error.emptyTagName')
								};
							} else if ($scope.existingEntityTagNames.includes($scope.newTag.name)) {
								$scope.serverMessage = {
									type: 'error',
									message: cvLoc('error.duplicateTagError')
								};
							}
						};

						const createPayLoad = function(entity, entityTags) {
							if (!_.isNil(entity) && !_.isNil(entityTags)) {
								return {
									entityTag: [
										{
											entityId: entity.entityId,
											entityType: entity.entityType,
											tag: entityTags
										}
									]
								};
							}
							return null;
						};

						$scope.newTag = {
							name: '',
							value: ''
						};
						$scope.title = cvLoc('label.manageTags');
						$scope.cancelManageTagsModal = function() {
							$modalInstance.close($scope.tagsForEntity);
						};

						$scope.saveManageTagsModal = function() {
							const payLoad = createPayLoad($scope.entity, $scope.tagsForEntity);
							if (!_.isNil(payLoad)) {
								$scope.setSavingMessage();
								tagsService
									.editTagsForEntity(payLoad)
									.success(function(data) {
										if (!data.error || (data.error && data.error.errorCode == 0)) {
											cvToaster.showSuccessMessage({
												message: cvLoc('info.updateEntityTagsSuccess', entityName)
											});
										} else {
											cvToaster.showErrorMessage({
												ttl: '10000',
												message: data.error.errorMessage
													? data.error.errorMessage
													: cvLoc('error.updateEntityTagsFailure', entityName)
											});
										}
										if (callBack) {
											callBack($scope.tagsForEntity);
										}
										$modalInstance.close($scope.tagsForEntity);
									})
									.error(function(err) {
										cvToaster.showErrorMessage({
											ttl: '10000',
											message: err ? err : cvLoc('error.updateEntityTagsFailure', entityName)
										});
									});
							}
						};
					}
				]
			});
		};

		factory.retireClient = _retireClientV2;
		factory._retireClientListV2 = _retireClientListV2;
		factory.deleteClient = _deleteV2;
		factory.removeActionRedirect = _removeActionRedirect;
		factory.onRetireSuccess = _onRetireSuccess;
		factory._viewLogs = _viewLogs;
		factory._manageTags = _manageTags;

		factory.handleCommonAction = function(
			value,
			entity,
			entityType,
			actionObject,
			entityId,
			entityName,
			entityListPageState
		) {
			//call back funtion to refresh cacheId when client has been modified
			var callBack = function() {
				globalCacheFactory.refreshCacheId();
			};
			switch (value) {
				case 'UPDATE_SOFTWARE': {
					updateSoftwareFactory.openUpdateSoftwareDialog(entityId, entityName, callBack);
					break;
				}
				case 'UNINSTALL_SOFTWARE': {
					uninstallSoftwareFactory.openUninstallSoftwareDialog(
						entityId,
						entityName,
						actionObject.osType,
						callBack,
						null,
						true
					);
					break;
				}
				case 'RELEASE_LICENSE': {
					releaseLicenseFactory.openReleaseLicenseDialog(entityId, entityName, callBack);
					break;
				}
				case 'RECONFIGURE': {
					reconfigureClientFactory.reconfigureClient(entityId, entityName, callBack);
					break;
				}
				case 'DELETE': {
					_deleteV2(entityId, entityName, actionObject.redirection, callBack, undefined, entityListPageState);
					break;
				}
				case 'RETIRE': {
					_retireClientV2(entityId, entityName, undefined, undefined, undefined, entityListPageState);
					break;
				}
				case 'VIEW_LOGS': {
					_viewLogs(entityId, entityName);
					break;
				}
				case 'MANAGE_TAGS': {
					_manageTags(entityId, entityName, entityType, actionObject.refreshGrid, entity);
					break;
				}
			}
		};
		/**
		 * @param{number} entityId = this is the id of the entity
		 * @param{string} entityName = this is the name of the entity returns the href for checkReadiness
		 *                actions on list action item and details click items This approach is implemented
		 *                because on click fails when we right click link and open in new tab. In case of
		 *                multicommcell,we check the url , if it has _cn we append that to the url
		 */
		factory.getCheckReadinessHref = function(entityId, entityName, provider = '', applicationId) {
			var queryParamsCheckReadiness = {
				clientName: entityName,
				provider,
				applicationId
			};
			if ($stateParams._cn && angular.isDefined($stateParams._cn)) {
				queryParamsCheckReadiness._cn = $stateParams._cn;
			}
			return '#checkReadiness/' + entityId + '?' + $httpParamSerializer(queryParamsCheckReadiness);
		};
		/**
		 * @param{number} entityId = this is the id of the entity
		 * @param{string} entityName = this is the name of the entity
		 * @param{string} currentStateName = this is passed by action from the state which it is triggered
		 *                from returns the href for sendLogs actions on list action item and details click
		 *                items This approach is implemented because on click fails when we right click link
		 *                and open in new tab. In case of multicommcell,we check the url , if it has _cn we
		 *                append that to the url
		 */
		factory.getSendLogsHref = function(entityId, entityName, currentStateName) {
			var queryParamsSendLogs = {
				sourceName: entityName
			};
			if ($stateParams._cn && angular.isDefined($stateParams._cn)) {
				queryParamsSendLogs._cn = $stateParams._cn;
			}
			return '#sendLogs/' + currentStateName + '/' + entityId + '?' + $httpParamSerializer(queryParamsSendLogs);
		};
		/**
		 * @param{object} queryParams = includes object of queryParams for JOB state returns the href for
		 *                sendLogs actions on list action item and details click items This approach is
		 *                implemented because on click fails when we right click link and open in new tab. In
		 *                case of multicommcell,we check the url , if it has _cn we append that to the url
		 */
		factory.getBackupRestoreJobHref = function(queryParams) {
			if ($stateParams._cn && angular.isDefined($stateParams._cn)) {
				queryParams._cn = $stateParams._cn;
			}
			return '#jobs?' + $httpParamSerializer(queryParams);
		};

		factory.getShowUninstallAndReleaseKey = function() {
			return cvUtil.getAdditionalSettingValue(
				'showUninstallSoftwareAndRelLicense',
				ADDITIONAL_SETTING_CATEGORY.ADMINCONSOLE,
				false
			);
		};

		factory.setShowUninstallAndReleaseKey = function(value) {
			cvUtil.setAdditionalSettingValue(
				'showUninstallSoftwareAndRelLicense',
				ADDITIONAL_SETTING_CATEGORY.ADMINCONSOLE,
				value
			);
		};

		return factory;
	}
]);
