import { cvCommonModule } from 'common/js/modules';

var cvCommon = cvCommonModule;

cvCommon.directive('cvJobStatusTracker', [
	function() {
		var jobStatusController = [
			'$scope',
			'$log',
			'cvLoc',
			'cvUtil',
			function($scope, $log, cvLoc, cvUtil) {
				var self = this;

				var FAILED_STATUS = 'Failed';
				var DANGER = 'danger';
				var SUCCESS = 'success';

				self.filterJobs = function() {
					self.jobList = self.jobList.filter(function(job) {
						return job.status === 'Running' && job.jobAlreadySeen;
					});
					$scope.pushstate.isJobRunning = self.jobList.length > 0;
				};

				self.jobList = [];
				$scope.pushstate.isJobRunning = self.jobList.length > 0;

				$scope.$watch('pushstate', function() {
					if (!$scope.pushstate.isOpen) {
						self.filterJobs();
					} else {
						self.jobList.map(function(job) {
							job.jobAlreadySeen = true;
							return job;
						});
					}
					if (self.jobList.length == 0) {
						$scope.pushstate.isJobRunning = false;
					}
				});

				if (cvConfig.pushEnabled) {
					var subscribeJobs = function(onMessage, onError) {
						var subscribeInfo = {
							msg: 'subscribe',
							type: 'JOB',
							filter: 'PUSH_INSTALL'
						};

						var unsubscribe = pushService.subscribe(subscribeInfo, onMessage, onError);
					};

					subscribeJobs(
						function(jobsResp) {
							if (jobsResp.jobs) {
								var jobs = jobsResp.jobs.map(function(job) {
									if (!job.jobSummary.status) {
										return;
									}
									return {
										name: job.jobSummary.jobId + ' - [' + job.jobSummary.localizedOperationName + ']',
										progress: job.jobSummary.status === FAILED_STATUS ? '100%' : job.jobSummary.percentComplete + '%',
										valueNow: job.jobSummary.status === FAILED_STATUS ? '100' : job.jobSummary.percentComplete,
										status: job.jobSummary.status,
										progressClass: job.jobSummary.status === FAILED_STATUS ? DANGER : SUCCESS,
										id: job.jobSummary.jobId,
										jobAlreadySeen: $scope.pushstate.isOpen
									};
								});
								if (jobs && jobs[0] && jobs.length > 0) {
									for (var newJobIdx in jobs) {
										var isFound = false;
										if (self.jobList.length === 0) {
											self.jobList.push(jobs[newJobIdx]);
										}
										for (var jobIdx in self.jobList) {
											if (self.jobList[jobIdx].id === jobs[newJobIdx].id) {
												self.jobList[jobIdx] = jobs[newJobIdx];
												isFound = true;
												break;
											}
										}
										if (!isFound) {
											self.jobList.unshift(jobs[newJobIdx]);
										}
									}
									$scope.pushstate.isJobRunning = true;
									$scope.$apply();
								}
							}
						},
						function(message) {
							console.debug(message);
						}
					);
				}
			}
		];
		return {
			restrict: 'E',
			templateUrl: appUtil.appRoot + 'modules/settings/partials/jobStatusTracking.jsp',
			scope: {
				pushstate: '='
			},
			controller: jobStatusController,
			controllerAs: 'jobStatusCtrl'
		};
	}
]);

export default cvCommon;
