import { commonAllAgentsModule } from 'common/js/modules';
import 'modules/settings/js/factories/cvPermissions.factory.js'; //cvPermissionFactory
var mod = commonAllAgentsModule;
mod.directive('cvPermittedActions', [
	function() {
		return {
			restrict: 'E',
			templateUrl: appUtil.appRoot + 'modules/settings/partials/cvPermitActions.jsp',
			controller: cvPermittedActionsController,
			controllerAs: 'cvPermitActionCtrl',
			bindToController: true,
			scope: {
				cvPermittedOptions: '='
			},
			link(scope, elem, attrs, ctrl) {
				if (ctrl.cvPermittedOptions.appendToBody) {
					// If we are appending to body, adjust the z-index if inside a modal
					const modalElem = elem.parents('.modal');
					if (modalElem.length) {
						// We are inside a modal, use the same z-index as the modal
						ctrl.dropdownStyles['z-index'] = modalElem.css('z-index');
					}
				}
			}
		};
	}
]);
/*
 * cvPermittedOptions needs five properties
 *
 * entityType : entity type of selected entity. eg: CLIENT_ENTITY, SUBCLIENT_ENTITY.. entity: object which
 * contains entity information, such as clientId,clientName, subclientId, subclientName,
 * applicationType...etc. commcellEntity: needs to pass _commcell_ if this page support multi-commcell
 * permittedActionList : all the actions for selected entity, will filter out permitted actions from this list
 * in the directive onclick : function when click on any actions
 */
var cvPermittedActionsController = [
	'cvLoc',
	'cvUtil',
	'cvMultiCommcell',
	'EntityTypesUtil',
	'settingsService',
	'cvPermissionFactory',
	'cvToaster',
	'$scope',
	'orderByFilter',
	'deepLink',
	'multiCommcellFactory',
	function(
		cvLoc,
		cvUtil,
		cvMultiCommcell,
		EntityTypesUtil,
		settingsService,
		cvPermissionFactory,
		cvToaster,
		$scope,
		orderBy,
		deepLink,
		multiCommcellFactory
	) {
		var self = this;
		this.$onInit = function() {
			//functions to filter out actions based on permissionId and conditions
			var filterPermittedActions = cvPermissionFactory.filterPermittedActions;
			self.showLoader = false;
			self.showRulerLoader = false;

			self.dropdownStyles = {};
			self.isMultiCommcellEnabled =
				cv.sessionContext.isMultiComcellAware &&
				self.cvPermittedOptions.commcellEntity &&
				self.cvPermittedOptions.commcellEntity.commCellName;
			self.cvPermittedOptions.actionListLoaded = false;
			//entity info of selected entity
			self.entity = self.cvPermittedOptions.entity;
			//entity type of selected entity
			self.entityType = self.cvPermittedOptions.entityType;
			//entity id of selected entity
			self.entityId = self.cvPermittedOptions.entityId;
			//entityName for selected entity
			self.entityName = self.cvPermittedOptions.entityName;
			//Source page of the entity : ex: for action on a fileServer entity - fsServersList
			self.entityListPageState = self.cvPermittedOptions.entityListPageState;
			//all the potential actions of selected entity
			self.allActionList = self.cvPermittedOptions.permittedActionList;
			//whether the dropdown should be appended to the body
			self.appendToBody = self.cvPermittedOptions.appendToBody;
			self.commcellName = self.cvPermittedOptions.commcellEntity
				? self.cvPermittedOptions.commcellEntity.commCellName
				: undefined;

			function modifyOnClickForMultiCommcell(permittedActionList = []) {
				_.forEach(permittedActionList, permittedAction => {
					// If permittedAction has overrideGlobal flag set, then its behaviour is not modified
					if (
						cv.isCometApp &&
						!permittedAction.overrideGlobal &&
						(permittedAction.onClick || permittedAction.href) &&
						self.commcellName
					) {
						permittedAction.cometAction = true;
						permittedAction.onClick = (...params) => {
							const redirectUrl = deepLink.getDeepLink({
								permittedOptions: self.cvPermittedOptions,
								params
							});
							multiCommcellFactory.openUrl(redirectUrl, {
								commcellName: self.commcellName
							});
						};
					}
				});
				return permittedActionList;
			}

			self.openActionList = function() {
				if (!self.cvPermittedOptions.actionListLoaded) {
					self.showLoader = true;
					self.showRulerLoader = true;
					if (self.entityId && self.entityType) {
						settingsService
							.getEntityCapabilities(
								self.entityId,
								self.entityType,
								self.isMultiCommcellEnabled || cv.isCometApp ? self.commcellName : undefined
							)
							.success(function(data) {
								self.showRulerLoader = false;
								self.cvPermittedOptions.actionListLoaded = true;
								if (data && data.length > 0) {
									self.permission = data.map(function(permissionEntity) {
										return permissionEntity.permissionId;
									});
								}
								//filter out actions by permission ids
								self.permittedActionList = self.allActionList.filter(function(action) {
									return filterPermittedActions(action, self.permission);
								});
								self.permittedActionList = modifyOnClickForMultiCommcell(self.permittedActionList);

								if (
									self.cvPermittedOptions.enableLexicalSorting &&
									self.cvPermittedOptions.enableLexicalSorting === true
								) {
									self.permittedActionList = orderBy(self.permittedActionList, ['rank', 'label']);
								} else {
									self.permittedActionList = orderBy(self.permittedActionList, ['rank']);
								}

								self.groupedActionList = _.values(_.groupBy(self.permittedActionList, 'groupId'));

								$scope.$applyAsync(() => {
									self.refreshDropdownOffset();
									self.showLoader = false;
								});
							})
							.error(function(e) {
								self.showLoader = false;
								self.showRulerLoader = false;
								cvToaster.showErrorMessage({
									ttl: '10000',
									message: cvLoc('error.loadPermission')
								});
								self.permittedActionList = [];
							});
					} else {
						self.showLoader = false;
						self.showRulerLoader = false;
						self.permittedActionList = self.allActionList.filter(function(action) {
							return filterPermittedActions(action, self.permission);
						});
						self.permittedActionList = modifyOnClickForMultiCommcell(self.permittedActionList);
						self.groupedActionList = _.values(_.groupBy(self.permittedActionList, 'groupId'));
					}
				}
			};

			//function to handle multi commcells
			self.appenCnifMultiCommcell = function() {
				if (self.isMultiCommcellEnabled) {
					cvMultiCommcell.setcommCellNameforLinks(self.cvPermittedOptions.commcellEntity.commCellName);
				}
			};

			self.dropdownId = `cv-permit-actions-dropdown-${$scope.$id}`;
			self.dropdownMenuId = `cv-permit-actions-dropdown-menu-${$scope.$id}`;
			self.rulerMenuId = `cv-permit-actions-ruler-menu-${$scope.$id}`;

			self.calculateDropdownOffset = function() {
				if (!self.appendToBody) {
					// Do not reposition dropdown if not appended to body
					return null;
				}
				self.repositionQueued = false;
				const body = angular.element('body');
				const dropdown = angular.element(`#${self.dropdownId}`);
				// const dropdownMenu = angular.element(`#${self.dropdownMenuId}`);
				const rulerMenu = angular.element(`#${self.rulerMenuId}`);
				// Read height/width/position of body and dropdown:
				const bodyHeight = body.height();
				const bodyWidth = body.width();
				let dropdownMenuHeight = rulerMenu.outerHeight(true) + 1;
				let dropdownMenuWidth = rulerMenu.outerWidth(true) + 1;

				// Cap dropdown dimensions at body dimensions so that we will
				// at most move the dropdown to the top left corner:
				dropdownMenuWidth = bodyWidth < dropdownMenuWidth ? bodyWidth : dropdownMenuWidth;
				dropdownMenuHeight = bodyHeight < dropdownMenuHeight ? bodyHeight : dropdownMenuHeight;

				// Add one to height/width as a hacky fix because the ruler menu is sometimes 1px shorter than the actual dropdown menu
				const dropdownOffset = dropdown.offset();
				const dropdownHeight = dropdown.outerHeight();

				//added this check because actions were not loading on grids.//To do fix placement issue by Noel
				if (
					cvUtil.objectContainsNestedProperty('dropdownOffset.top', dropdownOffset) &&
					cvUtil.objectContainsNestedProperty('dropdownOffset.left', dropdownOffset) &&
					angular.isDefined(dropdownHeight)
				) {
					const dropdownMenuOffset = {
						top: dropdownOffset.top + dropdownHeight,
						left: dropdownOffset.left
					};

					// Move dropdown if it extends past the body:
					const dropdownMenuRight = dropdownMenuOffset.left + dropdownMenuWidth;
					const dropdownMenuBottom = dropdownMenuOffset.top + dropdownMenuHeight;
					const moveLeft = bodyWidth < dropdownMenuRight ? dropdownMenuRight - bodyWidth : 0;
					const moveUp = bodyHeight < dropdownMenuBottom ? dropdownMenuBottom - bodyHeight : 0;
					if (moveLeft > 0 || moveUp > 0) {
						return {
							top: dropdownMenuOffset.top - moveUp,
							left: dropdownMenuOffset.left - moveLeft
						};
					} else {
						return null;
					}
				}

				return null;
			};

			self.clearDropdownOffset = () => {
				delete self.dropdownStyles.top;
				delete self.dropdownStyles.left;
			};

			$scope.hasChildren = action => {
				return action.children && action.children.length > 0;
			};

			self.refreshDropdownOffset = () => {
				const newOffset = self.calculateDropdownOffset();
				if (newOffset) {
					angular.extend(self.dropdownStyles, newOffset);
				} else {
					self.clearDropdownOffset();
				}
			};

			// We pass an object with a getter/setter to uib-dropdown is-open
			// instead of passing a function to on-toggle because there is a bug
			// in uib-dropdown where if 2 uib-dropdowns are appended to the same
			// element and one is opened while the other is already open, the
			// newly opened dropdown will not fire the on-toggle listener.
			self.isOpen = {
				_value: false,
				get value() {
					return self.isOpen._value;
				},
				set value(val) {
					if (self.isOpen._value !== val) {
						self.isOpen._value = val;
						// Calculate the dropdown offset in a requestAnimationFrame
						// so that uib-dropdon can initialize the dropdon position:
						cancelAnimationFrame(self.calcOffsetRafId);
						self.calcOffsetRafId = requestAnimationFrame(() => {
							self.toggledOpen = self.isOpen._value;
							if (self.isOpen._value) {
								self.refreshDropdownOffset();
							} else {
								self.clearDropdownOffset();
							}
						});
					}
				}
			};

			// this is by a UI-grid bug, when using server side pagination or filtering, directives will not be rendered again after applying any filtering.
			$scope.$watch('cvPermitActionCtrl.cvPermittedOptions', function(newValue, oldValue) {
				self.cvPermittedOptions = newValue;
				//entity info of selected entity
				self.entity = self.cvPermittedOptions.entity;
				//entity type of selected entity
				self.entityType = self.cvPermittedOptions.entityType;
				//entity id of selected entity
				self.entityId = self.cvPermittedOptions.entityId;
				//entityName for selected entity
				self.entityName = self.cvPermittedOptions.entityName;
				//Source page of the entity : ex: for action on a fileServer entity - fsServersList
				self.entityListPageState = self.cvPermittedOptions.entityListPageState;
				//all the potential actions of selected entity
				self.allActionList = self.cvPermittedOptions.permittedActionList;
				//whether the dropdown should be appended to the body
				self.appendToBody = self.cvPermittedOptions.appendToBody;
			});

			if (document.documentMode) {
				// There is an issue in Internet Explorer only where the dropdown
				// is sometimes not closed and removed if appendedToBody is true
				// and the page changes when the user clicks a dropdown option.
				// If the browser is IE then when this directive is destroyed,
				// wait for the next digest cycle, and if the menu is still
				// present then remove it
				$scope.$on('$destroy', () => {
					$scope.$applyAsync(() => {
						const dropdownMenu = angular.element(`#${self.dropdownMenuId}`);
						if (dropdownMenu.length) {
							dropdownMenu.remove();
						}
					});
				});
			}
		};
	}
];

export default mod;
