import 'modules/settings/js/factories/cvPermissions.factory.js'; //cvPermissionFactory
import { commonAllAgentsModule } from 'common/js/modules';
var mod = commonAllAgentsModule;
mod.directive('cvCapabilityLinks', [
	function() {
		return {
			restrict: 'E',
			templateUrl: appUtil.appRoot + 'modules/settings/partials/cvCapabilityLinks.jsp',
			controller: cvCapabilityLinksController,
			controllerAs: 'cvCapabilityLinksCtrl',
			bindToController: true,
			scope: {
				cvPermittedOptions: '='
			}
		};
	}
]);
/*
 * cvPermittedOptions needs five properties
 *
 * entitySecurityData : permissions list from response header which contains all the permissions of this
 * entity entity: object which contains entity information, such as clientId,clientName, subclientId,
 * subclientName, applicationType...etc. commcellEntity: needs to pass _commcell_ if this page support
 * multi-commcell permittedActionList : actions will be display in page links, will filter out permitted
 * actions from this list in the directive permittedMoreActionsList : actions will be display in more actions
 * link, will filter out permitted actions from this list in the directive onclick : function when click on
 * any actions
 */
var cvCapabilityLinksController = [
	'cvLoc',
	'cvUtil',
	'cvMultiCommcell',
	'cvPermissionFactory',
	'orderByFilter',
	'$scope',
	function(cvLoc, cvUtil, cvMultiCommcell, cvPermissionFactory, orderBy, $scope) {
		var self = this;
		this.$onInit = function() {
			self.permission = self.cvPermittedOptions.entitySecurityData.permissionIds;
			self.entity = self.cvPermittedOptions.entity;
			self.entityType = self.cvPermittedOptions.entityType;
			self.entityId = self.cvPermittedOptions.entityId;
			self.entityName = self.cvPermittedOptions.entityName;
			self.entityListPageState = self.cvPermittedOptions.entityListPageState;
			self.moreActionsTitle = cvLoc('label.moreActions');
			if (cvUtil.objectContainsNestedProperty('cvPermittedOptions.moreActionsTitle', self.cvPermittedOptions)) {
				self.moreActionsTitle = self.cvPermittedOptions.moreActionsTitle;
			}
			//functions to filter out actions based on permissionId and conditions
			var filterPermittedActions = cvPermissionFactory.filterPermittedActions;

			//actions in page links
			self.permittedActionsList = self.cvPermittedOptions.permittedActionsList.filter(function(action) {
				return filterPermittedActions(action, self.permission);
			});
			self.permittedActionsList = orderBy(self.permittedActionsList, ['rank', 'label']);
			//actions in more actions dropdown
			self.permittedMoreActionsList = self.cvPermittedOptions.permittedMoreActionsList.filter(function(action) {
				return filterPermittedActions(action, self.permission);
			});
			self.permittedMoreActionsList = orderBy(self.permittedMoreActionsList, ['rank', 'label']);

			//function to handle multi commcells
			self.appenCnifMultiCommcell = function() {
				if (cv.sessionContext.isMultiComcellAware && self.cvPermittedOptions.commcellName) {
					cvMultiCommcell.setcommCellNameforLinks(self.cvPermittedOptions.commcellName);
				}
			};
			$scope.$watch('cvCapabilityLinksCtrl.cvPermittedOptions', function(newValue, oldValue) {
				self.cvPermittedOptions = newValue;
				self.permission = self.cvPermittedOptions.entitySecurityData.permissionIds;
				//entity info of selected entity
				self.entity = self.cvPermittedOptions.entity;
				//entity type of selected entity
				self.entityType = self.cvPermittedOptions.entityType;
				//entity id of selected entity
				self.entityId = self.cvPermittedOptions.entityId;
				//entityName for selected entity
				self.entityName = self.cvPermittedOptions.entityName;
				//Source page of the entity : ex: for action on a fileServer entity - fsServersList
				self.entityListPageState = self.cvPermittedOptions.entityListPageState;
				//all the potential actions of selected entity
				self.permittedActionsList = self.cvPermittedOptions.permittedActionsList.filter(function(action) {
					return filterPermittedActions(action, self.permission);
				});
				self.permittedActionsList = orderBy(self.permittedActionsList, ['rank', 'label']);
				//actions in more actions dropdown
				self.permittedMoreActionsList = self.cvPermittedOptions.permittedMoreActionsList.filter(function(action) {
					return filterPermittedActions(action, self.permission);
				});
				self.permittedMoreActionsList = orderBy(self.permittedMoreActionsList, ['rank', 'label']);
			});
		};
	}
];

export default mod;
