import { acAppDirectivesModule } from 'common/js/modules';
import 'modules/settings/js/factories/cvManageIdleClients.factory.js';
import autoRetireDevices from 'modules/settings/js/constants/autoRetireDevices.js';
var acAppDirectives = acAppDirectivesModule;

/**
 * Directive takes in following inpput  params.
 * @level{string} = has one of the following values COMPANY, COMMCELL, PLAN --> indicates manage inactive devices are set at which level
 * @autoRetireDevices{object} = object should be of type {
 * 		forceDeleteDevicesAfterDays = int;
 * 		retireDevicesAfterDays = int;
 * }
 * @entityId{integer} = id of company/Commcell/plan where this is set.
 * @entityName{string} = name of company/Commcell/plan where this is set.
 */

acAppDirectives.directive('cvManageIdleClients', [
	function() {
		return {
			restrict: 'E',
			templateUrl: appUtil.appRoot + 'modules/settings/partials/cvManageIdleClients.jsp',
			bindToController: {
				level: '@?',
				autoRetireDevices: '=',
				entityId: '=',
				entityName: '='
			},
			controllerAs: 'manageIdleClientsCtrl',
			controller: [
				'$log',
				'cvLoc',
				'cvManageIdleClientsFactory',
				'cvToaster',
				function($log, cvLoc, cvManageIdleClientsFactory, cvToaster) {
					const self = this;
					const DEFAULT_RETIRE_DEVICES_AFTER_DAYS = 183;
					const DEFAULT_FORCE_DELETE_DEVICES_AFTER_DAYS = 365;
					const PROPERTIES = {
						RETIRE_AFTER_DAYS: 0,
						DELETE_AFTER_DAYS: 1
					};

					self.dataLoaded = false;

					self.unitTypes = [
						{
							type: 'DAYS',
							label: cvLoc('label.retentionUnit.daysWithBracket'),
							value: 1
						},
						{
							type: 'MONTHS',
							label: cvLoc('label.retentionUnit.monthsWithBracket'),
							value: 30.41
						},
						{
							type: 'YEARS',
							label: cvLoc('label.retentionUnit.yearsWithBracket'),
							value: 365
						},
						{
							type: 'INDEFINITE',
							label: cvLoc('label.never'),
							value: -1
						}
					];

					self.selectedUnit = {
						retireDevicesAfterDays: '',
						forceDeleteDevicesAfterDays: ''
					};

					self.label = {
						retireDevicesAfterDays: '',
						forceDeleteDevicesAfterDays: ''
					};

					self.titleLabel = {
						retireDevicesAfterDays: cvLoc('label.retireDevicesAfter'),
						forceDeleteDevicesAfterDays: cvLoc('label.deleteDevicesAfter')
					};

					let _convertDaysToXAndUpdateLabel = (days, propertyValue) => {
						if (days < 0) {
							if (propertyValue === PROPERTIES.DELETE_AFTER_DAYS) {
								self.selectedUnit.forceDeleteDevicesAfterDays = -1;
								self.autoRetireDevicesModel.forceDeleteDevicesAfterDays = DEFAULT_FORCE_DELETE_DEVICES_AFTER_DAYS;
								self.label.forceDeleteDevicesAfterDays = cvLoc('label.never');
								self.titleLabel.forceDeleteDevicesAfterDays = cvLoc('label.deleteDevicesWhenIndefinite');
							} else if (propertyValue === PROPERTIES.RETIRE_AFTER_DAYS) {
								self.selectedUnit.retireDevicesAfterDays = -1;
								self.autoRetireDevicesModel.retireDevicesAfterDays = DEFAULT_RETIRE_DEVICES_AFTER_DAYS;
								self.label.retireDevicesAfterDays = cvLoc('label.never');
								self.titleLabel.retireDevicesAfterDays = cvLoc('label.retireDevicesWhenIdefinite');
							}
						} else if (days % 365 === 0) {
							//this is years
							if (propertyValue === PROPERTIES.DELETE_AFTER_DAYS) {
								self.selectedUnit.forceDeleteDevicesAfterDays = 365;
								self.autoRetireDevicesModel.forceDeleteDevicesAfterDays = days / 365;
								self.label.forceDeleteDevicesAfterDays =
									self.autoRetireDevicesModel.forceDeleteDevicesAfterDays +
									' ' +
									cvLoc('label.retentionUnit.yearsWithBracket');
								self.titleLabel.forceDeleteDevicesAfterDays = cvLoc('label.deleteDevicesAfter');
							} else if (propertyValue === PROPERTIES.RETIRE_AFTER_DAYS) {
								self.selectedUnit.retireDevicesAfterDays = 365;
								self.autoRetireDevicesModel.retireDevicesAfterDays = days / 365;
								self.label.retireDevicesAfterDays =
									self.autoRetireDevicesModel.retireDevicesAfterDays +
									' ' +
									cvLoc('label.retentionUnit.yearsWithBracket');
								self.titleLabel.retireDevicesAfterDays = cvLoc('label.retireDevicesAfter');
							}
						} else if (Math.floor(days % 30.41) === 0) {
							if (propertyValue === PROPERTIES.DELETE_AFTER_DAYS) {
								self.selectedUnit.forceDeleteDevicesAfterDays = 30.41;
								self.autoRetireDevicesModel.forceDeleteDevicesAfterDays = Math.floor(days / 30.41);
								self.label.forceDeleteDevicesAfterDays =
									self.autoRetireDevicesModel.forceDeleteDevicesAfterDays +
									' ' +
									cvLoc('label.retentionUnit.monthsWithBracket');
								self.titleLabel.forceDeleteDevicesAfterDays = cvLoc('label.deleteDevicesAfter');
							} else if (propertyValue === PROPERTIES.RETIRE_AFTER_DAYS) {
								self.selectedUnit.retireDevicesAfterDays = 30.41;
								self.autoRetireDevicesModel.retireDevicesAfterDays = Math.floor(days / 30.41);
								self.label.retireDevicesAfterDays =
									self.autoRetireDevicesModel.retireDevicesAfterDays +
									' ' +
									cvLoc('label.retentionUnit.monthsWithBracket');
								self.titleLabel.retireDevicesAfterDays = cvLoc('label.retireDevicesAfter');
							}
						} else {
							if (propertyValue === PROPERTIES.DELETE_AFTER_DAYS) {
								self.selectedUnit.forceDeleteDevicesAfterDays = 1;
								self.autoRetireDevicesModel.forceDeleteDevicesAfterDays = days;
								self.label.forceDeleteDevicesAfterDays =
									self.autoRetireDevicesModel.forceDeleteDevicesAfterDays +
									' ' +
									cvLoc('label.retentionUnit.daysWithBracket');
								self.titleLabel.forceDeleteDevicesAfterDays = cvLoc('label.deleteDevicesAfter');
							} else if (propertyValue === PROPERTIES.RETIRE_AFTER_DAYS) {
								self.selectedUnit.retireDevicesAfterDays = 1;
								self.autoRetireDevicesModel.retireDevicesAfterDays = days;
								self.label.retireDevicesAfterDays =
									self.autoRetireDevicesModel.retireDevicesAfterDays +
									' ' +
									cvLoc('label.retentionUnit.daysWithBracket');
								self.titleLabel.retireDevicesAfterDays = cvLoc('label.retireDevicesAfter');
							}
						}
					};

					let _computeActualDays = (val, selectedUnit) => {
						switch (selectedUnit) {
							case -1:
								return -1;
							case 30.41:
								return Math.ceil(val * 30.41);
							case 365:
								return val * 365;
							case 1:
							default:
								return val;
						}
					};

					const _isValidInput = (retireDays, deleteDays) => {
						if (
							!_.isNull(retireDays) &&
							!_.isUndefined(retireDays) &&
							!_.isNull(deleteDays) &&
							!_.isUndefined(deleteDays)
						) {
							if (deleteDays >= 0 && retireDays >= 0) {
								return retireDays <= deleteDays;
							} else if (retireDays < 0) {
								return deleteDays < 0;
							}
						}
						return true;
					};

					/**
					 * sets the number of days the device can stay idle for if the edited value is different from the input to the directive.
					 */

					self.saveNumberOfDays = saveProperty => {
						let autoRetireDevicesObjectToSendToBackend = new autoRetireDevices(
							_computeActualDays(
								self.autoRetireDevicesModel.forceDeleteDevicesAfterDays,
								self.selectedUnit.forceDeleteDevicesAfterDays
							),
							_computeActualDays(
								self.autoRetireDevicesModel.retireDevicesAfterDays,
								self.selectedUnit.retireDevicesAfterDays
							)
						);
						if (
							!_isValidInput(
								autoRetireDevicesObjectToSendToBackend.retireDevicesAfterDays,
								autoRetireDevicesObjectToSendToBackend.forceDeleteDevicesAfterDays
							)
						) {
							self.showInvalidInputError = true;
							return;
						} else {
							self.showInvalidInputError = false;
						}
						if (
							autoRetireDevicesObjectToSendToBackend.forceDeleteDevicesAfterDays !=
								self.autoRetireDevicesCopy.forceDeleteDevicesAfterDays ||
							autoRetireDevicesObjectToSendToBackend.retireDevicesAfterDays !=
								self.autoRetireDevicesCopy.retireDevicesAfterDays
						) {
							self.disableSubmitAndCancelButton = true;
							cvManageIdleClientsFactory
								.setManageInactiveDevices(autoRetireDevicesObjectToSendToBackend, self.entityId, self.level)
								.success(function(data) {
									self.disableSubmitAndCancelButton = false;
									if (saveProperty === PROPERTIES.RETIRE_AFTER_DAYS) {
										self.bRetireDevicesAfter = false;
									} else if (saveProperty === PROPERTIES.DELETE_AFTER_DAYS) {
										self.bDeleteDevicesAfter = false;
									}
									self.autoRetireDevices = _.cloneDeep(autoRetireDevicesObjectToSendToBackend); // need to update the directive caller to update the value as well
									self.autoRetireDevicesModel = _.cloneDeep(autoRetireDevicesObjectToSendToBackend); // need to update this to recompute the label
									self.autoRetireDevicesCopy = _.cloneDeep(autoRetireDevicesObjectToSendToBackend); // required if in same occurence they tend to save the previous value
									_convertDaysToXAndUpdateLabel(
										self.autoRetireDevicesModel.retireDevicesAfterDays,
										PROPERTIES.RETIRE_AFTER_DAYS
									);
									_convertDaysToXAndUpdateLabel(
										self.autoRetireDevicesModel.forceDeleteDevicesAfterDays,
										PROPERTIES.DELETE_AFTER_DAYS
									);
									cvToaster.showSuccessMessage({
										message: cvLoc('info.saveAutoRetireDeviceProperty', '<b>' + self.entityName + '</b>')
									});
								})
								.error(function(err) {
									$log.error('Failed to set auto retire devices property at ' + self.level + 'level');
									cvToaster.showErrorMessage({
										message: cvLoc('error.saveAutoRetireDeviceProperty', '<b>' + self.entityName + '</b>')
									});
								});
						} else {
							if (saveProperty === PROPERTIES.RETIRE_AFTER_DAYS) {
								self.bRetireDevicesAfter = false;
							} else if (saveProperty === PROPERTIES.DELETE_AFTER_DAYS) {
								self.bDeleteDevicesAfter = false;
							}
						}
					};
					self.cancelNumberOfDays = cancelProperty => {
						if (cancelProperty === PROPERTIES.RETIRE_AFTER_DAYS) {
							self.bRetireDevicesAfter = false;
						} else if (cancelProperty === PROPERTIES.DELETE_AFTER_DAYS) {
							self.bDeleteDevicesAfter = false;
						}
						if (self.showInvalidInputError) {
							self.showInvalidInputError = false;
						}
					};
					self.editNumberOfDays = editProperty => {
						if (editProperty === PROPERTIES.RETIRE_AFTER_DAYS) {
							self.bRetireDevicesAfter = true;
						} else if (editProperty === PROPERTIES.DELETE_AFTER_DAYS) {
							self.bDeleteDevicesAfter = true;
						}
					};

					this.$onInit = function() {
						self.showManageIdleClientsFeature = cvConfig.showRetireOfflineDevices;
						self.bRetireDevicesAfter = false;
						self.bDeleteDevicesAfter = false;
						self.sIdleDaysLabel = cvLoc('info.noConfigured');
						self.showInvalidInputError = false;

						self.init = () => {
							self.dataLoaded = true;
							if (_.isNull(self.autoRetireDevices) || _.isUndefined(self.autoRetireDevices)) {
								//setting defaults
								self.autoRetireDevices = new autoRetireDevices(365, 183);
							}
							self.autoRetireDevicesModel = _.cloneDeep(self.autoRetireDevices); // For UI
							self.autoRetireDevicesCopy = _.cloneDeep(self.autoRetireDevices); // For comparison if the edited value is different from existing value
							_convertDaysToXAndUpdateLabel(
								self.autoRetireDevicesModel.retireDevicesAfterDays,
								PROPERTIES.RETIRE_AFTER_DAYS
							);
							_convertDaysToXAndUpdateLabel(
								self.autoRetireDevicesModel.forceDeleteDevicesAfterDays,
								PROPERTIES.DELETE_AFTER_DAYS
							);
						};
						self.init();
					};
				}
			]
		};
	}
]);

export default acAppDirectives;
