import { cvModuleSettingsModule } from 'common/js/modules';
import 'modules/settings/js/services/settings.svc.js';
import 'modules/settings/js/constants/syslogs.constant.js';

let app = cvModuleSettingsModule;

class sysLogServerController {
	constructor($scope, cvBreadcrumbsTabsFactory, cvLoc, settingsService, cvToaster, cvUtil, syslogConstants) {
		this.$scope = $scope;
		this.cvBreadcrumbsFactory = cvBreadcrumbsTabsFactory;
		this.cvLoc = cvLoc;
		this.settingsService = settingsService;
		this.cvToaster = cvToaster;
		this.cvUtil = cvUtil;
		this.syslogConstants = syslogConstants;
		this.syslogMessage = this.cvUtil.infoMsgLoc('Loading');
		this.caFileName = null;
		this.caFileContent = null;
		this.hostname = '';
		this.isEnabled = null;
		this.isSecureEnabled = null;
		this.port = null;
		this.protocolType = null;
		this.showPortErrorMessage = false;
		this.beforeEditValues = {};
		this.isSubmitButtonEnabled = false;
		this.selectedLogTypes = [];
		this.checkboxChanged = false;
		this.showLogtypeErrorMessage = false;
		this.checkboxDirty = false;
		this.LOG_TYPES = {
			Alerts: {
				label: this.cvLoc('label.logType.alerts'),
				value: 'Alerts'
			},
			Events: {
				label: this.cvLoc('label.logType.events'),
				value: 'Events'
			},
			Audit: {
				label: this.cvLoc('label.logType.auditTrail'),
				value: 'Audit'
			}
		};

		this._initializeBreadCrumbs();
		this._fetchStatus();
	}

	updateChange(checkPort) {
		this.isSubmitButtonEnabled = this._isFieldChanged() && this.isValidInputs();
		if (checkPort) {
			this.showPortErrorMessage =
				this.port <= this.syslogConstants.PORT_LOWERLIMIT ||
				this.port > this.syslogConstants.PORT_UPPERLIMIT ||
				!Number.isInteger(this.port);
		}
	}
	toggleSecureChange(data) {
		this.protocolType = data ? this.syslogConstants.TLS_PROTOCOLTYPE : this.syslogConstants.UDP_PROTOCOLTYPE;
		this.isSubmitButtonEnabled = this.isValidInputs();
	}
	toggleChange(data) {
		this.updateCheckboxErrorMessageStatus(data);
		this.isSubmitButtonEnabled = this._isFieldChanged(data) && this.isValidInputs();
	}

	checkboxChange() {
		this.checkboxDirty = true;
		this.checkboxChanged = true;
		this.updateCheckboxErrorMessageStatus(this.isEnabled);
		this.isSubmitButtonEnabled = this._isFieldChanged(this.isEnabled) && this.isValidInputs();
	}

	updateCheckboxErrorMessageStatus(toggleValue) {
		this.showLogtypeErrorMessage = this.selectedLogTypes.length === 0 && toggleValue;
	}

	_isFieldChanged(toggleValue) {
		let toggleState = _.isUndefined(toggleValue) ? this.isEnabled : toggleValue;
		if (toggleState && this.checkboxChanged) {
			this.checkboxChanged = false;
			let checkboxDict = {};
			this.beforeEditValues.syslogPolicy.forEach(checkbox => {
				checkboxDict[checkbox.name] = checkbox.enabled;
			});
			for (var i = 0; i < this.selectedLogTypes.length; i++) {
				if (checkboxDict[this.selectedLogTypes[i].name] !== this.selectedLogTypes[i].enabled) {
					return true;
				}
			}
		}
		return (
			this.beforeEditValues.hostname !== this.hostname ||
			this.beforeEditValues.port !== this.port ||
			this.beforeEditValues.enabled !== toggleState
		);
	}

	_initializeBreadCrumbs() {
		let breadCrumbs = [];
		breadCrumbs.push({
			title: this.cvLoc('label.nav.system'),
			link: '#nav/settings'
		});

		this.cvBreadcrumbsFactory.addBreadCrumbs(breadCrumbs);
	}

	_fetchStatus() {
		let self = this;
		this.settingsService
			.getSyslogStatus()
			.success(response => {
				self.syslogMessage = self.cvUtil.emptyMsg();
				self._setPageState(response);
			})
			.error(err => {
				self._showErrorResponse(err);
			});
	}

	_attachFileUploadEvents() {
		let self = this;
		var $browse = angular.element('#browse');
		$browse.change(function onBrowseFileChange(event) {
			self._fileUpload($browse[0]);
		});
	}

	browseLocalPath(inputName, pathName, browse) {
		this._attachFileUploadEvents();
		var showPath = document.getElementById(pathName),
			element = document.getElementById(inputName);
		element.click();
	}

	_fileUpload(element) {
		if (!element.files || !element.files[0]) {
			return;
		} else {
			if (
				angular.isDefined(element.files[0].type) &&
				element.files[0].type.length > 0 &&
				!(
					element.files[0].name.includes('.pem') ||
					element.files[0].name.includes('.crt') ||
					element.files[0].name.includes('.key')
				)
			) {
				this.syslogMessage = {
					type: 'error',
					message: this.cvLoc('error.invalidFile')
				};
				this.isSubmitButtonEnabled = false;
				this.$scope.$apply();

				return;
			}
			var reader = new FileReader();
			var file = element.files[0];
			if (file) {
				this.isSubmitButtonEnabled = true;
				let self = this;
				reader.onload = evt => {
					self.caFileContent = Base64.encode(evt.target.result);
					this.$scope.$apply();
				};
				reader.filename = file.name;
				reader.readAsText(file);
			}
			this.caFileName = element.files[0].name;
			this.syslogMessage = this.cvUtil.emptyMsg();
		}
	}
	_showErrorResponse(error) {
		this.syslogMessage = {
			type: 'error',
			message: error.errorMessage
		};
	}

	_setPageState(response) {
		let self = this;
		this.caFileName = response.caFileName;
		this.protocolType = response.protocolType;
		this.isSecureEnabled = this.protocolType == this.syslogConstants.TLS_PROTOCOLTYPE ? true : false;

		this.hostname = response.hostname;
		this.port = response.port || this.syslogConstants.DEFAULT_PORT;
		this.isEnabled = response.enabled;

		if (!this.checkboxOptions) {
			this.checkboxOptions = response.syslogPolicy.map(logType => ({
				label: self.LOG_TYPES[logType.name].label,
				value: self.LOG_TYPES[logType.name].value,
				model: angular.copy(logType.enabled),
				name: logType.name
			}));
		}

		this.isSubmitButtonEnabled = false;

		this.beforeEditValues = angular.copy(response);
	}

	isValidInputs() {
		return (
			!_.isEmpty(this.hostname) && // hostname not empty
			this.port > this.syslogConstants.PORT_LOWERLIMIT && // port within limits
			this.port <= this.syslogConstants.PORT_UPPERLIMIT &&
			Number.isInteger(this.port) && // port number is an integer
			(!this.isEnabled || this.selectedLogTypes.length > 0) && // atleast one log type is selected when syslog is enabled
			(this.protocolType === this.syslogConstants.TLS_PROTOCOLTYPE ? angular.isDefined(this.caFileName) : true) // In case of TLS_PROTOCOLTYPE, CA file shall be present
		);
	}

	setSyslogServerStatus() {
		let self = this;

		if (!this.isValidInputs()) {
			this.checkboxDirty = true;
			this.updateCheckboxErrorMessageStatus(this.isEnabled);
			return;
		}

		this.isSubmitButtonEnabled = false;

		let requestBody = {
			hostname: this.hostname,
			enabled: this.isEnabled,
			port: this.port,
			protocolType: this.protocolType,
			caFileName: this.protocolType === this.syslogConstants.TLS_PROTOCOLTYPE ? this.caFileName : undefined,
			caFileContent: this.protocolType === this.syslogConstants.TLS_PROTOCOLTYPE ? this.caFileContent : undefined,
			syslogPolicy: this.checkboxOptions.map(checkbox => ({
				name: checkbox.value,
				enabled: self.isEnabled ? checkbox.model : false
			}))
		};

		this.settingsService
			.setSyslog(requestBody)
			.success(response => {
				self.cvToaster.showSuccessMessage({
					message: self.cvLoc('label.successSyslogMessage'),
					ttl: '5000'
				});
				self.syslogMessage = self.cvUtil.emptyMsg();
				self._setPageState(requestBody);
			})
			.error(err => {
				self._showErrorResponse(err);
				self.isSubmitButtonEnabled = true;
			});
	}
}

sysLogServerController.$inject = [
	'$scope',
	'cvBreadcrumbsTabsFactory',
	'cvLoc',
	'settingsService',
	'cvToaster',
	'cvUtil',
	'syslogConstants'
];

app.controller('syslogServerController', sysLogServerController);

export default app;
