import 'modules/settings/js/constants/privacyAlgorithm.constant.js';
import 'modules/settings/js/constants/allowedAlgorithms.constant.js';
import 'modules/settings/js/controllers/snmpv3Configuration.ctrl.js';
import * as snmpv3ConfigurationTemplate from 'modules/settings/js/controllers/snmpv3Configuration.template.js';
import 'modules/settings/js/services/settings.svc.js';
import { cvModuleSettingsModule } from 'common/js/modules';
import { nmcall } from 'q';
var app = cvModuleSettingsModule;
export class Snmpv3ConfigurationListController {
	constructor(
		ENTITY_TYPES,
		cvPermissionFactory,
		$compile,
		$scope,
		$modal,
		$state,
		cvUtil,
		cvLoc,
		snmpv3Service,
		$filter,
		$dialogs,
		OperationType,
		privacyAlgorithm,
		cvBreadcrumbsTabsFactory,
		cvToaster
	) {
		this.$scope = $scope;
		this.ENTITY_TYPES = ENTITY_TYPES;
		this.cvPermissionFactory = cvPermissionFactory;
		this.$modal = $modal;
		this.$compile = $compile;
		this.$state = $state;
		this.cvUtil = cvUtil;
		this.cvLoc = cvLoc;
		this.snmpv3Service = snmpv3Service;
		this.$filter = $filter;
		this.$dialogs = $dialogs;
		this.OperationType = OperationType;
		this.privacyAlgorithm = privacyAlgorithm;
		this.cvBreadcrumbsTabsFactory = cvBreadcrumbsTabsFactory;
		this.cvToaster = cvToaster;
		this.initbreadCrums();
		this._setupGridOptions();
	}
	initbreadCrums() {
		let breadCrumbs = [];
		breadCrumbs.push({
			title: this.cvLoc('label.nav.system'),
			link: '#nav/settings'
		});
		this.cvBreadcrumbsTabsFactory.addBreadCrumbs(breadCrumbs);
	}
	_initColumns() {
		return snmpv3ConfigurationTemplate.getColumnTemplate({
			cvLoc: this.cvLoc
		});
	}
	_setupGridOptions() {
		const self = this;
		this.kendoGridOptions = {};
		this.$scope.kendoGridOptions = this.kendoGridOptions;
		this.kendoGridOptions.gridTitle = this.cvLoc('label.snmpv3Configuration');
		this.kendoGridOptions.tableName = 'snmpv3ConfigurationTable';
		this.kendoGridOptions.columns = this._initColumns();
		this.kendoGridOptions.url = this._fetchData.bind(this);
		this.kendoGridOptions.usePageToolbar = true;
		this.kendoGridOptions.onGridDataBound = this._onGridDataBound.bind(this);
		this.kendoGridOptions.gridToolbarMenu = [
			{
				id: 'Add',
				disableOnDeselect: false,
				label: this.cvLoc('label.addConfiguration'),
				onSelect: event => {
					this.addConfiguration();
				},
				contextMenuOnly: true
			}
		];

		this.kendoGridOptions.gridEmptyMenu = [
			{
				id: 'Add',
				label: this.cvLoc('error.noSNMPConfiguration'),
				onSelect: event => {
					this.addConfiguration();
				}
			}
		];
		this.kendoGridOptions.beforeGridInitialize = ({ grid }) => {
			self.grid = grid;
		};
	}
	deleteConfiguration(value, entity, entityType, actionObject, entityId, entityName) {
		const self = this;
		let snmpInfoRow = entity;
		let callBackFunctions = {
			noFunction: () => {},
			yesFunction: () => {
				self.snmpv3Service
					.updateConfiguration({
						snmv3Info: snmpInfoRow,
						snmv3ConfigOperationType: self.OperationType.DELETE
					})
					.then(
						() => {
							self.$state.forceReload();
							self.cvToaster.showSuccessMessage({
								message: self.cvLoc('info.snmpDeleteSuccessful')
							});
						},
						errorMessage => {
							self.$scope.snmpConfigurationData = snmpConfigurationCopy;
							self.$scope.serverMessage = {
								message: typeof errorMessage.data == 'string' ? errorMessage.data : self.cvLoc('generic_error'),
								type: 'error'
							};
						}
					);
			}
		};
		self.$dialogs.confirm(
			self.cvLoc('label.confirmDelete'),
			self.cvLoc('label.confirmDeleteSnmpConfiguration'),
			callBackFunctions
		);
	}
	_onGridDataBound(dataItem, row) {
		let self = this;

		const permittedOptions = dataItem.permittedOptions;
		const id = permittedOptions.entityId;
		const template = `<cv-permitted-actions cv-permitted-options="permittedOptions${id}"></cv-permitted-actions>`;
		this.$scope[`permittedOptions${id}`] = permittedOptions;
		row.find('.permittedActions').append(this.$compile(template)(this.$scope));

		const detailLink = row.find('.k-grid-keyDetail');

		let customObject = {
			encryptAlgorithm: dataItem.encryptAlgorithm,
			hostName: dataItem.hostName,
			id: dataItem.id,
			privacyAlgorithm: dataItem.privacyAlgorithm,
			userAccount: {
				userName: dataItem.userAccount.userName
			}
		};
		detailLink.click(() => {
			self.addConfiguration(customObject);
		});
	}
	getExistingConfiguration(editMode, snmpInfo) {
		if (editMode) {
			/**
			 * Remove the element that is being edited from configuration list. List with remaining elements
			 * are used to check for duplicate hostnames.
			 */
			const snmpHostNames = this.$scope.snmpConfigurationData.map(snmp => {
				return snmp.hostName;
			});
			var index = snmpHostNames.indexOf(snmpInfo.hostName);
			if (index > -1) {
				var snmpConfigurationCopy = angular.copy(this.$scope.snmpConfigurationData);
				snmpConfigurationCopy.splice(index, 1);
				return snmpConfigurationCopy;
			}
		}
		return angular.copy(this.$scope.snmpConfigurationData);
	}

	addConfiguration(snmpInfo) {
		let editMode = snmpInfo ? true : false;
		if (!editMode) {
			snmpInfo = {
				hostName: '',
				userAccount: {
					userName: '',
					password: ''
				},
				encryptAlgorithm: 'HMAC_MD5',
				privacyCredentials: false,
				privacyAlgorithm: 'None',
				privacyPassword: ''
			};
		}
		let modalInstance = this.$modal.open({
			templateUrl: appUtil.appRoot + 'modules/settings/partials/addEditSNMPV3Configuration.jsp',
			backdrop: 'static',
			controller: 'addEditSNMPV3Configuration',
			resolve: {
				inputParams: () => {
					return {
						editMode: editMode,
						snmpInfo: snmpInfo,
						snmpConfigList: this.getExistingConfiguration(editMode, snmpInfo)
					};
				}
			}
		});
		modalInstance.result.then(() => {
			this.$scope.serverMessage = this.cvUtil.emptyMsg();
			this.snmpv3Service
				.updateConfiguration({
					snmv3Info: snmpInfo,
					snmv3ConfigOperationType: editMode ? this.OperationType.MODIFY : this.OperationType.ADD
				})
				.then(
					result => {
						this.$state.forceReload();
					},
					errorMessage => {
						var errorString = typeof errorMessage.data == 'string' ? errorMessage.data : this.cvLoc('generic_error');
						this.$scope.serverMessage = this.cvUtil.errMsg(errorString);
					}
				);
		});
	}
	_fetchData(options) {
		const self = this;
		self.$scope.serverMessage = self.cvUtil.infoMsg(this.cvLoc('Loading'));
		let cvLoc = this.cvLoc;
		let _computePermittedActionsForRole = function(entity) {
			let arrayOfActionsToOverrideRole = [
				{
					DELETE: {
						permissionIds: [],
						show: true,
						label: cvLoc('action.delete'),
						onClick: self.deleteConfiguration.bind(self),
						groupId: 1
					}
				}
			];
			return self.cvPermissionFactory.updateAndGetCommonActionsList(
				arrayOfActionsToOverrideRole,
				false,
				self.cvPermissionFactory.commonPermittedList
			);
		};
		self.snmpv3Service.getConfiguration().then(data => {
			if (data) {
				if (data.data) {
					self.$scope.snmpConfigurationData = data.data.snmv3InfoList ? data.data.snmv3InfoList : [];
					for (let i = 0; i < self.$scope.snmpConfigurationData.length; ++i) {
						self.$scope.snmpConfigurationData[i].privacyAlgorithm = self.cleanPrivacy(
							self.$scope.snmpConfigurationData[i].privacyAlgorithm
						);

						self.$scope.snmpConfigurationData[i].permittedOptions = {
							entity: angular.copy(self.$scope.snmpConfigurationData[i]),
							entityId: self.$scope.snmpConfigurationData[i].id,
							entityName: self.$scope.snmpConfigurationData[i].hostName,
							commcellEntity: {
								commcellName: self.$scope.snmpConfigurationData[i]._commcellName_
							},
							appendToBody: true,
							permittedActionList: _computePermittedActionsForRole(self.$scope.snmpConfigurationData[i])
						};
					}
					options.success(self.$scope.snmpConfigurationData);
				}
				self.$scope.serverMessage = self.cvUtil.emptyMsg();
			}
		});
	}
	cleanPrivacy(privacyAlg) {
		return this.privacyAlgorithm[privacyAlg] || privacyAlg;
	}
}
Snmpv3ConfigurationListController.$inject = [
	'ENTITY_TYPES',
	'cvPermissionFactory',
	'$compile',
	'$scope',
	'$uibModal',
	'$state',
	'cvUtil',
	'cvLoc',
	'snmpv3Service',
	'$filter',
	'$dialogs',
	'OperationType',
	'privacyAlgorithm',
	'cvBreadcrumbsTabsFactory',
	'cvToaster'
];
app.controller('snmpv3ConfigurationListController', Snmpv3ConfigurationListController);
app.constant('OperationType', {
	NONE: 0,
	ADD: 1,
	DELETE: 2,
	MODIFY: 3,
	DISABLE: 4,
	ENABLE: 5,
	CLONE: 6,
	TEST: 7,
	UPDATE_ALL: 8,
	HIDE_ITEMS: 9,
	SHOW_ITEMS: 10,
	DETECT: 11,
	REGISTER: 12
});
export default app;
