import 'modules/settings/js/constants/privacyAlgorithm.constant.js';
import 'modules/settings/js/constants/allowedAlgorithms.constant.js';

import { cvModuleSettingsModule } from 'common/js/modules';

var app = cvModuleSettingsModule;

app.constant('OperationType', {
	NONE: 0,
	ADD: 1,
	DELETE: 2,
	MODIFY: 3,
	DISABLE: 4,
	ENABLE: 5,
	CLONE: 6,
	TEST: 7,
	UPDATE_ALL: 8,
	HIDE_ITEMS: 9,
	SHOW_ITEMS: 10,
	DETECT: 11,
	REGISTER: 12
});

app.controller('snmpv3Controller', [
	'$scope',
	'$uibModal',
	'$state',
	'cvUtil',
	'cvLoc',
	'cvToaster',
	'cvTableOptions',
	'snmpv3Service',
	'$filter',
	'$dialogs',
	'OperationType',
	'privacyAlgorithm',
	'cvBreadcrumbsTabsFactory',
	function(
		$scope,
		$modal,
		$state,
		cvUtil,
		cvLoc,
		cvToaster,
		cvTableOptions,
		snmpv3Service,
		$filter,
		$dialogs,
		OperationType,
		privacyAlgorithm,
		cvBreadcrumbsTabsFactory
	) {
		$scope.serverMessage = cvUtil.infoMsg(cvLoc('Loading'));
		snmpv3Service.getConfiguration().then(function(data) {
			if (data) {
				if (data.data) {
					$scope.snmpConfigurationData = data.data.snmv3InfoList ? data.data.snmv3InfoList : [];
					for (var i = 0; i < $scope.snmpConfigurationData.length; ++i)
						$scope.snmpConfigurationData[i].privacyAlgorithm = cleanPrivacy(
							$scope.snmpConfigurationData[i].privacyAlgorithm
						);
				}
				$scope.serverMessage = cvUtil.emptyMsg();
			}
		});

		/* GRID CONTSTRUCTION */
		var globalGridOptions = angular.copy(cvTableOptions.commonNgGridOptions);

		angular.extend(globalGridOptions, {
			data: 'snmpConfigurationData',
			columnDefs: [
				{
					field: 'hostName',
					sort: {
						direction: 'asc',
						priority: 0
					},
					displayName: cvLoc('header.hostname'),
					width: '20%',
					cellTemplate:
						'<a class="crop" href="" data-ng-click="grid.appScope.addConfiguration(row.entity)" title="{{row.entity.hostName}}" data-ng-bind="row.entity.hostName"></a>',
					enableHiding: false
				},
				{
					field: 'userName',
					displayName: cvLoc('label.userName'),
					cellTemplate:
						'<span class="crop" title="{{row.entity.userAccount.userName}}" data-ng-bind="row.entity.userAccount.userName"></span>',
					width: '20%'
				},
				{
					field: 'encryptAlgorithm',
					displayName: cvLoc('label.authenticationAlgorithm'),
					cellTemplate:
						'<span class="crop" title="{{row.entity.encryptAlgorithm}}" data-ng-bind="row.entity.encryptAlgorithm"></span>',
					width: '20%'
				},
				{
					field: 'privacyAlgorithm',
					displayName: cvLoc('label.privacyAlgorithm'),
					cellTemplate:
						'<span class="crop" title="{{row.entity.privacyAlgorithm}}" data-ng-bind="row.entity.privacyAlgorithm"></span>',
					width: '15%'
				},
				{
					name: 'action',
					displayName: cvLoc('label.actions'),
					enableFiltering: false,
					enableSorting: false,
					enableHiding: false,
					cellTemplate:
						'<div class="btn-group" uib-dropdown><a href class="uib-dropdown-toggle" uib-dropdown-toggle ng-disabled="disabled"><span class="grid-action-icon"></span></a><ul uib-dropdown-menu class="dropdown-menu" role="menu"><li><a href="" class="ui-grid-action-items" ng-click="grid.appScope.deleteConfiguration(row.entity)">' +
						cvLoc('action.delete') +
						'</a></li><li><a href="" data-ng-click="grid.appScope.addConfiguration(row.entity)">' +
						cvLoc('action.modify') +
						'</a></li></ul></div>'
				}
			]
		});

		$scope.addConfiguration = function(snmpInfo) {
			var editMode = snmpInfo ? true : false;
			if (!editMode) {
				snmpInfo = {
					hostName: '',
					userAccount: {
						userName: '',
						password: ''
					},
					encryptAlgorithm: 'HMAC_MD5',
					privacyCredentials: false,
					privacyAlgorithm: 'None',
					privacyPassword: ''
				};
			}
			delete snmpInfo.userAccount.password;
			delete snmpInfo.privacyPassword;

			var getExistingConfiguration = function() {
				if (editMode) {
					/**
					 * Remove the element that is being edited from configuration list. List with remaining
					 * elements are used to check for duplicate hostnames.
					 */
					var index = $scope.snmpConfigurationData.indexOf(snmpInfo);
					if (index > -1) {
						var snmpConfigurationCopy = angular.copy($scope.snmpConfigurationData);
						snmpConfigurationCopy.splice(index, 1);
						return snmpConfigurationCopy;
					}
				}
				return angular.copy($scope.snmpConfigurationData);
			};

			var modalInstance = $modal.open({
				templateUrl: appUtil.appRoot + 'modules/settings/partials/addEditSNMPV3Configuration.jsp',
				backdrop: 'static',
				controller: 'addEditSNMPV3Configuration',
				resolve: {
					inputParams: function() {
						return {
							editMode: editMode,
							snmpInfo: snmpInfo,
							snmpConfigList: getExistingConfiguration()
						};
					}
				}
			});

			modalInstance.result.then(function() {
				$scope.serverMessage = cvUtil.emptyMsg();
				snmpv3Service
					.updateConfiguration({
						snmv3Info: snmpInfo,
						snmv3ConfigOperationType: editMode ? OperationType.MODIFY : OperationType.ADD
					})
					.then(
						function(result) {
							$state.forceReload();
						},
						function(errorMessage) {
							var errorString = typeof errorMessage.data == 'string' ? errorMessage.data : cvLoc('generic_error');
							$scope.serverMessage = cvUtil.errMsg(errorString);
						}
					);
			});
		};

		var cleanPrivacy = function(privacyAlg) {
			return privacyAlgorithm[privacyAlg] || privacyAlg;
		};

		$scope.deleteConfiguration = function(snmpInfo) {
			var callBackFunctions = {
				noFunction: function() {},
				yesFunction: function() {
					var index = $scope.snmpConfigurationData.indexOf(snmpInfo);
					if (index > -1) {
						var snmpConfigurationCopy = angular.copy($scope.snmpConfigurationData);
						$scope.snmpConfigurationData.splice(index, 1);
						snmpv3Service
							.updateConfiguration({
								snmv3Info: snmpInfo,
								snmv3ConfigOperationType: OperationType.DELETE
							})
							.then(
								function() {
									cvToaster.showSuccessMessage({
										message: cvLoc('info.snmpDeleteSuccessful')
									});
								},
								function(errorMessage) {
									$scope.snmpConfigurationData = snmpConfigurationCopy;
									$scope.serverMessage = {
										message: typeof errorMessage.data == 'string' ? errorMessage.data : cvLoc('generic_error'),
										type: 'error'
									};
								}
							);
					}
				}
			};

			$dialogs.confirm(cvLoc('label.confirmDelete'), cvLoc('label.confirmDeleteSnmpConfiguration'), callBackFunctions);
		};

		$scope.gridOptions = {
			cvPageLinks: [
				{
					label: cvLoc('label.addConfiguration'),
					onclick: $scope.addConfiguration
				}
			],
			cvGridTitle: cvLoc('label.snmpv3Configuration'),
			cvTableName: 'snmpv3ConfigurationTable',
			cvServerMessage: 'serverMessage',
			cvSearchFields: ['hostName', 'userName', 'encryptAlgorithm', 'privacyAlgorithm'],
			cvOnGridEmpty: {
				message: cvLoc('error.noSNMPConfiguration'),
				links: [
					{
						label: cvLoc('label.addConfiguration'),
						onclick: $scope.addConfiguration
					}
				]
			},
			gridOptions: globalGridOptions
		};

		var breadCrumbs = [];

		breadCrumbs.push({
			title: cvLoc('label.nav.operations'),
			link: '#nav/operation'
		});

		cvBreadcrumbsTabsFactory.addBreadCrumbs(breadCrumbs);
	}
]);

app.controller('addEditSNMPV3Configuration', [
	'$scope',
	'$uibModalInstance',
	'cvUtil',
	'inputParams',
	'snmpv3Service',
	'$filter',
	'privacyAlgorithm',
	'allowedAlgorithms',
	function($scope, $modalInstance, cvUtil, inputParams, snmpv3Service, $filter, privacyAlgorithm, allowedAlgorithms) {
		$scope.model = {
			editMode: inputParams.editMode,
			snmpInfo: angular.copy(inputParams.snmpInfo),
			encryptionAlgorithms: [],
			privacyAlgorithms: [],
			password: '',
			privacyPassword: '',
			confirmPassword: '',
			confirmPrivacyPassword: '',
			duplicateHostName: false,
			dummyPassword: 'cvAc123@duMmyPaSsw0rD$%^#',
			formSubmitted: false
		};

		$scope.userNameChanged = function() {
			if ($scope.model.password == $scope.model.dummyPassword) {
				$scope.model.password = '';
				$scope.model.confirmPassword = '';
			}
		};

		if ($scope.model.editMode) {
			/**
			 * For existing configurations, passwords will not be sent from server. So to show black dots in
			 * UI, dummyPassword is used.
			 */
			$scope.model.password = $scope.model.dummyPassword;
			$scope.model.confirmPassword = $scope.model.dummyPassword;
			if ($scope.model.snmpInfo.privacyAlgorithm.toLowerCase() != 'none') {
				$scope.model.privacyPassword = $scope.model.dummyPassword;
				$scope.model.confirmPrivacyPassword = $scope.model.dummyPassword;
			}
		}

		var checkForDuplicateHostNames = function() {
			if (inputParams.snmpConfigList) {
				for (var i = 0; i < inputParams.snmpConfigList.length; i++) {
					var snmpConfig = inputParams.snmpConfigList[i];
					if (snmpConfig.hostName == $scope.model.snmpInfo.hostName) {
						$scope.model.duplicateHostName = true;
						return true;
					}
				}
			}
			return false;
		};

		$scope.saveConfiguration = function() {
			$scope.model.formSubmitted = true;

			if (!$scope.isFormValid()) {
				return;
			}

			inputParams.snmpInfo.hostName = $scope.model.snmpInfo.hostName;
			inputParams.snmpInfo.encryptAlgorithm = $scope.model.snmpInfo.encryptAlgorithm;
			if (privacyAlgorithm[$scope.model.snmpInfo.privacyAlgorithm]) {
				$scope.model.snmpInfo.privacyAlgorithm = privacyAlgorithm[$scope.model.snmpInfo.privacyAlgorithm];
			}
			inputParams.snmpInfo.userAccount.userName = $scope.model.snmpInfo.userAccount.userName;
			inputParams.snmpInfo.privacyCredentials =
				$scope.model.snmpInfo.privacyAlgorithm != $scope.model.privacyAlgorithms[0];
			inputParams.snmpInfo.privacyAlgorithm = $scope.model.snmpInfo.privacyAlgorithm;
			if ($scope.model.password !== $scope.model.dummyPassword) {
				inputParams.snmpInfo.userAccount.password = cvUtil.getBytes($scope.model.password);
			} else if ($scope.model.editMode) {
				delete inputParams.snmpInfo.userAccount;
			}

			if (
				$scope.model.privacyPassword !== $scope.model.dummyPassword &&
				$scope.model.snmpInfo.privacyAlgorithm != $scope.model.privacyAlgorithms[0]
			) {
				inputParams.snmpInfo.privacyPassword = cvUtil.getBytes($scope.model.privacyPassword);
			} else {
				delete inputParams.snmpInfo.privacyPassword;
			}

			$modalInstance.close();
		};

		$scope.needsAttention = function(inputElement) {
			return $scope.model.formSubmitted && inputElement.$invalid && !inputElement.pristine;
		};

		$scope.hasPasswordsMatched = function() {
			return $scope.model.password === $scope.model.confirmPassword;
		};

		$scope.hasPrivacyPasswordsMatched = function() {
			return $scope.model.privacyPassword === $scope.model.confirmPrivacyPassword;
		};

		$scope.isFormValid = function() {
			return (
				$scope.snmpConfigurationForm.$valid &&
				!checkForDuplicateHostNames() &&
				$scope.hasPasswordsMatched() &&
				(!$scope.model.snmpInfo.privacyCredentials ||
					($scope.model.snmpInfo.privacyCredentials && $scope.hasPrivacyPasswordsMatched()))
			);
		};

		$scope.close = function() {
			$modalInstance.dismiss();
		};

		var intersect = function(a, b) {
			var t;
			if (b.length > a.length) (t = b), (b = a), (a = t); // indexOf to loop over shorter
			return a.filter(function(e) {
				return b.indexOf(e) > -1;
			});
		};

		$scope.encryptionChanged = function() {
			if (allowedAlgorithms[$scope.model.snmpInfo.encryptAlgorithm]) {
				$scope.model.privacyAlgorithms = intersect(
					$scope.model.privacyAlgorithmsFull,
					allowedAlgorithms[$scope.model.snmpInfo.encryptAlgorithm]
				);
			} else {
				$scope.model.privacyAlgorithms = ['None'];
			}
		};

		snmpv3Service
			.getPrivacyAlgorithms()
			.success(function(privacyAlgorithms) {
				if (privacyAlgorithms && privacyAlgorithms.length > 0) {
					for (var i = 0; i < privacyAlgorithms.length; ++i)
						if (privacyAlgorithm[privacyAlgorithms[i]]) privacyAlgorithms[i] = privacyAlgorithm[privacyAlgorithms[i]];
					$scope.model.privacyAlgorithms = privacyAlgorithms;
					$scope.model.privacyAlgorithmsFull = privacyAlgorithms;
					$scope.encryptionChanged();
				}
			})
			.error(function(errorMessage) {
				$scope.serverMessage = {
					message: errorMessage ? errorMessage : cvLoc('generic_error'),
					type: 'error'
				};
			});

		snmpv3Service
			.getEncryptionAlgorithms()
			.success(function(encryptionAlgorithms) {
				if (encryptionAlgorithms && encryptionAlgorithms.length > 0) {
					$scope.model.encryptionAlgorithms = encryptionAlgorithms;
				}
			})
			.error(function(errorMessage) {
				$scope.serverMessage = {
					message: errorMessage ? errorMessage : cvLoc('generic_error'),
					type: 'error'
				};
			});
	}
]);

export default app;
