import 'modules/servers/js/services/servers.svc.js';
import 'vsa/js/controllers/addServerContent.ctrl.js';

import { cvModuleSettingsModule } from 'common/js/modules';

var settingsMod = cvModuleSettingsModule;

var controllers = {};

controllers.pluginController = [
	'$scope',
	'$log',
	'$state',
	'cvLoc',
	'cvToaster',
	'cvUtil',
	'serverService',
	'tabsFactory',
	'$uibModal',
	'$dialogs',
	'cvBreadcrumbsTabsFactory',
	function(
		$scope,
		$log,
		$state,
		cvLoc,
		cvToaster,
		cvUtil,
		serverService,
		tabsFactory,
		$modal,
		$dialogs,
		cvBreadcrumbsTabsFactory
	) {
		$scope.addServerLabel = cvLoc('label.addHost');

		$scope.showAddServerDialog = function() {
			if (cvConfig.AmazonHostedCS) {
				//Use add server wizard for AmazonHostedCS
				$state.go('addServerWizard', {
					vendor: 'amazon'
				});
				return;
			}
			$modal.open({
				templateUrl: appUtil.appRoot + 'vsa/partials/addServerContent.jsp',
				windowClass: 'addServerModal',
				backdrop: 'static',
				controller: 'addServerContent',
				resolve: {
					model: function() {
						return $scope.model;
					},
					loadServerList: function() {
						return $scope.loadServerList;
					}
				}
			});
		};

		// to validate webconsole host ip input
		$scope.ipPattern = '^(?:[0-9]{1,3}.){3}[0-9]{1,3}';

		tabsFactory.createPluginTabs('#plugin');

		var breadCrumbs = [];

		breadCrumbs.push({
			title: cvLoc('label.nav.system'),
			link: '#nav/settings'
		});

		cvBreadcrumbsTabsFactory.addBreadCrumbs(breadCrumbs);

		$scope.actions = [
			{
				label: cvLoc('label.plugin.action.add'),
				value: 'ADD'
				/*
				 * }, { 'label' : cvLoc('label.plugin.action.edit'), 'value' : 'EDIT'
				 */
			},
			{
				label: cvLoc('label.plugin.action.delete'),
				value: 'DELETE'
				//		}, {
				//			'label': cvLoc('label.plugin.action.find'),
				//			'value': 'FIND'
			}
		];

		$scope.versions = [
			{
				label: cvLoc('label.plugin.version.1.0'),
				value: 1
			},
			{
				label: cvLoc('label.plugin.version.2.0'),
				value: 2
			}
		];

		$scope.model = {
			clientId: '',
			userName: '',
			password: '',
			action: 'ADD',
			webConsoleHost: undefined,
			useSAML: false,
			version: 2
		};

		serverService
			.getServers()
			.success(function(data) {
				// remove everything except vmware
				$scope.servers = data;
				for (var i = 0; i < data.length; ) {
					if (data[i].type != 'VMW') {
						data.splice(i, 1);
					} else {
						i++;
					}
				}
				$scope.serverMessage = cvUtil.emptyMsg();
				$scope.model.clientId = null;
				if ($scope.servers.length >= 1) {
					$scope.model.clientId = $scope.servers[0].clientId;
				}

				// $scope.callFinished = true;
			})
			.error(function(e) {
				$scope.serverMessage = cvUtil.errMsgLoc('error.getServers');
			});

		$scope.manageVMPlugin = function(trustAll) {
			$scope.serverMessage = cvUtil.emptyMsg();

			serverService
				.manageVMPlugin($scope.model)
				.success(function(wr) {
					wr = wr.trim();
					if (wr) {
						$scope.serverMessage = cvUtil.infoMsg(wr);
						if (
							$scope.model.version == 1 &&
							((wr === cvLoc('info.add.plugin') && $scope.model.useSAML) || wr === cvLoc('info.find.plugin'))
						) {
							$scope.isDownloadAvailable = true;
							$scope.serverMessage = cvUtil.infoMsg(wr + ' ' + cvLoc('info.download.metaData'));
						}
					}
				})
				.error(function(e) {
					if (e === 'HTTPS hostname wrong') {
						e = cvLoc('error.invalid.pluginhost');
					}
					var errMsg = cvUtil.errMsg(e == undefined ? cvLoc('error.manage.plugin') : new String(e).trim());
					// provide a way to bypass the certificate
					if (e === 'Invalid SSL certificate') {
						var callBackFunctions = {
							noFunction: function() {
								// dont do anything
								//$scope.serverMessage = errMsg;
							},
							yesFunction: function() {
								$scope.model.trustAll = true;
								$scope.manageVMPlugin();
							}
						};
						$dialogs.confirm(cvLoc('header.security.alert'), cvLoc('label.invalid.certificate'), callBackFunctions);
					} else {
						$scope.serverMessage = errMsg;
					}
				});
		};

		$scope.clearState = function() {
			$scope.model = {
				//clientId: '',
				userName: '',
				password: '',
				action: 'ADD',
				webConsoleHost: undefined,
				useSAML: false
			};

			$scope.serverMessage = cvUtil.emptyMsg();
			$scope.isDownloadAvailable = false;
		};

		$scope.pluginActionChanged = function() {
			$scope.serverMessage = cvUtil.emptyMsg();
		};
	}
];

controllers.scvmmController = [
	'tabsFactory',
	'$scope',
	'cvLoc',
	'cvUtil',
	'serverService',
	'cvBreadcrumbsTabsFactory',
	function(tabsFactory, $scope, cvLoc, cvUtil, serverService, cvBreadcrumbsTabsFactory) {
		$scope.loading = true;
		tabsFactory.createPluginTabs('#scvmm');

		var breadCrumbs = [];

		breadCrumbs.push({
			title: cvLoc('label.nav.operations'),
			link: '#nav/operation'
		});

		cvBreadcrumbsTabsFactory.addBreadCrumbs(breadCrumbs);
	}
];

settingsMod.controller(controllers);

export default settingsMod;
