import { commonAllAgentsModule } from 'common/js/modules';
import { inherit } from 'angular-ui-router';

(function() {
	'use strict';

	commonAllAgentsModule.controller('selectNlpEntityController', [
		'$scope',
		'$uibModalInstance',
		'cvLoc',
		'entities',
		'intent',
		'entityMap',
		function($scope, $modalInst, cvLoc, entities, intent, entityMap) {
			$scope.intentText = cvLoc('label.selectEntityForIntent', intent);
			const _selectEntity = (entity, searchType) => {
				entity.searchType = searchType;
				$modalInst.close(entity);
			};

			const _init = () => {
				_.each(entities, entityType => {
					entityType.typeDisplayName = _.find(entityMap, { name: '' + entityType.searchType }).displayName;
				});

				$scope.entities = entities;
			};

			_init();
			$scope.selectEntity = _selectEntity;
		}
	]);
})();
