(function() {
	'use strict';

	var settingsMod = angular.module('cvModule.settings');

	var controllers = {};
	controllers.globalSearchController = [
		'$scope',
		'$q',
		'cvLoc',
		'globalSearchService',
		'$location',
		'$state',
		'cvNavigationFactory',
		'hotkeys',
		'vendorTypes',
		'downloadsFactory',
		'globalActionsFactory',
		'globalAddActionsFactory',
		'globalNLPActionFactory',
		'searchEntitiesFactory',
		'$log',
		'globalSearchFactory',
		'additionalSettingsFactory',
		'cvToaster',
		'BrowseTypes',
		'browseForAgentsService',
		'browseService',
		'restoreFactory',
		'selectionService',
		function(
			$scope,
			$q,
			cvLoc,
			globalSearchService,
			$location,
			$state,
			cvNavigationFactory,
			hotkeys,
			vendorTypes,
			downloadsFactory,
			globalActionsFactory,
			globalAddActionsFactory,
			globalNLPActionFactory,
			searchEntitiesFactory,
			$log,
			globalSearchFactory,
			additionalSettingsFactory,
			cvToaster,
			BrowseTypes,
			browseForAgentsService,
			browseService,
			restoreFactory,
			selectionService
		) {
			$scope.showSearch =
				cv.additionalSettings &&
				cv.additionalSettings.AdminConsole &&
				angular.isDefined(cv.additionalSettings.AdminConsole.bEnableEntitySearch)
					? cv.additionalSettings.AdminConsole.bEnableEntitySearch
					: true;

			var COMMANDS = [];
			var commcellGUIDMap = {};
			var initPlaceHolder = cvLoc('label.globalSearch.placeHolder');
			var isCometApp = cv.isCometApp;
			var arrowKeyCodes = [9, 32, 37, 38, 39, 40];

			COMMANDS.push(getGotoCommand());
			COMMANDS.push(getHelpCommand());
			COMMANDS.push(getAddCommand());

			if (cvConfig.enableAdditionalSettings && (cv.isMspAdmin || cv.isTenantAdmin) && !cv.isCometApp) {
				COMMANDS.push(getAdditionalSettingsCommand());
			}

			if (cvConfig.showBackupRestoreCommand) {
				COMMANDS.push(getBackupCommand());
				COMMANDS.push(getRestoreCommand());
			}

			if (cvConfig.showGlobalFileSearch && !angular.isDefined(cv.sessionContext.operatorCompanyId)) {
				COMMANDS.push(getFilesCommand());
			}

			//				if (!cvConfig.showGlobalFileSearch) {
			//					initPlaceHolder = cvLoc('label.globalSearch.placeHolder2');
			//				}

			function getGotoCommand() {
				return {
					commandName: '/' + cvLoc('label.globalSearch.goto'),
					commandId: 2,
					commandDescription: cvLoc('label.globalSearch.gotoCommandDescription'),
					placeHolder: cvLoc('label.globalSearch.gotoPlaceholder')
				};
			}

			function getFilesCommand() {
				return {
					commandName: '/' + cvLoc('label.globalSearch.files'),
					commandId: 1,
					commandDescription: cvLoc('label.globalSearch.filesCommandDescription'),
					placeHolder: cvLoc('label.globalSearch.filesCommandDescription')
				};
			}

			function getKeysCommand() {
				return {
					commandName: '/' + cvLoc('label.globalSearch.keys'),
					commandId: 4,
					commandDescription: cvLoc('label.globalSearch.keysCommandDescription'),
					placeHolder: cvLoc('label.globalSearch.keysCommandDescription')
				};
			}

			function getHelpCommand() {
				return {
					commandName: '/' + cvLoc('label.globalSearch.help'),
					commandId: 3,
					commandDescription: cvLoc('label.globalSearch.helpCommandDescription'),
					placeHolder: cvLoc('label.globalSearch.helpPlaceholder')
				};
			}

			function getAddCommand() {
				return {
					commandName: '/' + cvLoc('label.globalSearch.add'),
					commandId: 5,
					commandDescription: cvLoc('label.globalSearch.addCommandDescription'),
					placeHolder: cvLoc('label.globalSearch.addPlaceholder')
				};
			}

			function getBackupCommand() {
				return {
					commandName: '/' + cvLoc('label.globalSearch.backup'),
					commandId: 6,
					commandDescription: cvLoc('label.globalSearch.backupCommandDescription'),
					placeHolder: cvLoc('label.globalSearch.backupPlaceholder')
				};
			}

			function getRestoreCommand() {
				return {
					commandName: '/' + cvLoc('label.globalSearch.restore'),
					commandId: 7,
					commandDescription: cvLoc('label.globalSearch.restoreCommandDescription'),
					placeHolder: cvLoc('label.globalSearch.restorePlaceholder')
				};
			}

			function getAdditionalSettingsCommand() {
				return {
					commandName: '/' + cvLoc('label.globalSearch.additionalSettings'),
					commandId: 8,
					commandDescription: cvLoc('label.globalSearch.additionalSettingsCommandDescription'),
					placeHolder: cvLoc('label.globalSearch.additionalSettingsPlaceholder')
				};
			}
			//COMMANDS.push(getKeysCommand());

			const entitySearchPlaceHolder = cvLoc('label.globalSearch.pressTabToSearch') + ' ';
			const entityActionPlaceHolder = cvLoc('label.globalSearch.pressTabToAction');

			$scope.placeHolder = initPlaceHolder;
			$scope.commandMode = {
				enable: false,
				commandId: null
			};

			const ENTITIES = Object.assign(searchEntitiesFactory.ENTITIES, searchEntitiesFactory.COMMCELL_ENTITIES);

			var checkStateAvailable = function(name) {
				for (var property in ENTITIES) {
					if (ENTITIES[property].stateName === name) {
						return true;
					}
				}
				return false;
			};

			var getEntityIdFromState = function(name) {
				for (var property in ENTITIES) {
					if (ENTITIES[property].stateName === name) {
						return parseInt(ENTITIES[property].name);
					}
				}
				return null;
			};

			$scope.dataFromServer = [];
			$scope.entityActionList = [];

			// Once user has clicked any result navigate to particular state
			var getLinkAndRedirect = function(item, evt, scope) {
				// If its a nav item then go to that state
				if (item.type == 0) {
					scope.entitySearchTitle = '';
					$state.go(ENTITIES[item.type].redirectURL(item));
				} else if (item.type === 'nlp') {
					performNlpAction(item, item.isCommCellIntent ? false : !$scope.commandModeObj);
				} else {
					// If action clicked then
					if (item.entityActionName) {
						if (item.href) {
							var linkName;
							if (item.href.charAt(0) === '#') {
								linkName = item.href.substring(1, item.href.length);
							} else {
								linkName = item.href;
							}
							$scope.resetSearch();
							$location.url(linkName);
						} else {
							setTimeout(function() {
								$scope.resetSearch();
								globalActionsFactory.doAction(scope.entityAction.obj.type, item, scope.entityAction.obj);
							}, 500);
						}

						setTimeout(function() {
							angular.element('#globalSearch .dropdown-menu').hide();
						}, 500);

						return;
					} else if (item.type === 'browse') {
						// if its a file browse then do browse otherwise to href state
						if (item.browseurl.indexOf('globalFileSearch') > -1) {
							$location.url(item.browseurl.substr(2));
						}
					} else if (item.url) {
						// If its restore or backup command command perform that otherwise redirect
						if ($scope.commandMode && ($scope.commandMode.commandId === 6 || $scope.commandMode.commandId === 7)) {
							doBackupRestoreOperation(item);
							return;
						}

						if (isCometApp) {
							window.open(item.url, '_blank');
						} else {
							$location.url(ENTITIES[item.type].redirectURL(item));
						}
					}
				}
			};

			function doBackupRestoreOperation(item) {
				let commandId = $scope.commandMode.commandId;
				$scope.resetSearch();
				globalSearchFactory.performBackupRestoreOperation(item, commandId);
			}

			$scope.performSupportedAction = function(obj, evt) {
				if ($scope.commandMode && ($scope.commandMode.commandId === 6 || $scope.commandMode.commandId === 7)) {
					evt.preventDefault();
					evt.stopPropagation();
					$scope.typeEntity = '';
					doBackupRestoreOperation(obj);
				}
			};

			// This will remove results for which the route is not accessible to the user
			// This can happen when Customization rules are applied or setup is not complete for that app
			var filterRoutes = function(val, searchText) {
				// used to show info in first entity
				var showDisplay = {};
				for (var property in ENTITIES) {
					showDisplay[property] = false;
				}
				for (var i = 0; i < val.length; i++) {
					let _entity = ENTITIES[val[i].type];
					// If user does not have access to that page ignore
					if (_entity.stateName != null && $state.href(_entity.stateName) == null && !isCometApp) {
						val.splice(i, 1);
						i--;
					} else {
						// Display type of entity in first item only
						if (!showDisplay[_entity.name]) {
							val[i].displayType = _entity.displayName;
							showDisplay[_entity.name] = true;
						}
						if (_entity.name !== 'nlp' && $scope.commandMode && $scope.commandMode.commandId !== 'nlp') {
							// Append URL based on type of action
							if (_entity.name == 0) {
								val[i].state = _entity.redirectURL(val[i]);
								val[i].searchPlaceHolder = checkStateAvailable(val[i].state)
									? entitySearchPlaceHolder + val[i].lastName
									: '';
							} else {
								val[i].url = '#/' + _entity.redirectURL(val[i]);
								val[i].urlTarget = '_self';

								if (isCometApp) {
									val[i].url = val[i].multicommcellURL + val[i].url;
									val[i].urlTarget = '_blank';
								}
							}
						}
					}
				}
			};

			var setAdditionalSettingsAutocomplete = function(settings) {
				$scope.dataFromServer = [];
				for (var i = 0; i < settings.length; i++) {
					var setting = settings[i];
					var dataObj = {
						actionPlaceHolder: '',
						actionSupport: false,
						count: 0,
						displayType:
							cvLoc('label.globalSearch.default') +
							': ' +
							setting.defaultValue +
							', ' +
							cvLoc('label.globalSearch.current') +
							': ' +
							setting.currentValue,
						id: setting.keyName,
						lastName: setting.keyName,
						name: setting.keyName,
						searchPlaceHolder: cvLoc('label.globalSearch.pressTabToAction'),
						state: setting.keyName,
						addSetting: setting,
						type: 2
					};
					$scope.dataFromServer.push(dataObj);
				}
				return $scope.dataFromServer;
			};

			var setAdditionalSettingsValues = function(values) {
				$scope.dataFromServer = [];
				for (var i = 0; i < values.length; i++) {
					var value = values[i];
					var dataObj = {
						addEntityName: value,
						addStateName: value
					};
					$scope.dataFromServer.push(dataObj);
				}
				return $scope.dataFromServer;
			};

			var checkIfTabActionSupported = function(actionSupport) {
				if (
					cvConfig.showSearchEntityActions &&
					actionSupport &&
					$scope.commandMode &&
					$scope.commandMode.commandId != 6 &&
					$scope.commandMode.commandId != 7
				) {
					return true;
				}
				//$scope.commandMode && $scope.commandMode.commandId != 6
				return false;
			};

			function getNlpActionPlaceHolder(item) {
				const acMap = _.get(
					searchEntitiesFactory.INTENT_ACTION_MAP,
					_.toUpper($scope.commandModeObj ? $scope.commandModeObj.action : item.action)
				);
				item.placholderAction = acMap.intent;
				return cvLoc('label.pressTabOrEnter', _.toLower(item.placholderAction));
			}

			// Function to filter data by type of response from server
			var addDataInArray = function(list, entityType, totalCount) {
				const isNlpCommandMode = entityType === 'nlp' || ($scope.commandMode && $scope.commandMode.commandId === 'nlp');
				for (var j = 0; j < list.length; j++) {
					var displayName = list[j].displayName ? list[j].displayName : list[j].name;
					var obj = {
						id: list[j].id,
						type: entityType,
						name: displayName,
						searchEntity: isNlpCommandMode ? list[j] : undefined,
						count: totalCount,
						actionPlaceHolder: !isNlpCommandMode
							? checkIfTabActionSupported(ENTITIES[entityType].actionSupport)
								? entityActionPlaceHolder
								: ''
							: getNlpActionPlaceHolder(list[j]),
						actionSupport:
							checkIfTabActionSupported(ENTITIES[entityType].actionSupport) && !isNlpCommandMode
								? ENTITIES[entityType].actionSupport
								: false
					};

					// Some entities required more information apart from name and id to form URL.
					switch (entityType) {
						case 1:
							obj['osSubType'] = _.get(
								list[j],
								'detailedProperty.serverProperty.clientProperties.client.osInfo.SubType'
							);
							break;
						case 4:
							obj['serverId'] = _.get(
								list[j],
								'detailedProperty.vmGroupProperty.subClientProperties.subClientEntity.clientId'
							);
							break;
						case 15:
							obj['appId'] = _.get(
								list[j],
								'detailedProperty.sharePointProperty.clientProperties.client.idaList[0].idaEntity.applicationId'
							);
							break;
						case 22:
							obj['clientId'] = _.get(list[j], 'detailedProperty.sqlInstanceProperty.SqlInstance.cId');
							break;
						case 23:
							obj['insId'] = _.get(list[j], 'detailedProperty.sqlDBProperty.SqlDatabase.insId');
							obj['dbId'] = _.get(list[j], 'detailedProperty.sqlDBProperty.SqlDatabase.dbId');
							break;
						case 25:
							obj['osSubType'] = _.get(
								list[j],
								'detailedProperty.fileServerProperty.clientProperties.client.osInfo.SubType'
							);
							obj['appId'] = _.get(
								list[j],
								'detailedProperty.fileServerProperty.clientProperties.client.idaList[0].idaEntity.applicationId'
							);
							break;
						case 28:
							obj['clientType'] = _.get(list[j], 'detailedProperty.dbInstanceProperty.dbInstance.clientType');
							obj['instance'] = _.get(list[j], 'detailedProperty.dbInstanceProperty.dbInstance.instance') || {};
							obj['backupset'] = _.get(list[j], 'detailedProperty.dbInstanceProperty.dbInstance.backupset') || {};
							break;
						case 29:
							obj['srcInstId'] = _.get(
								list[j],
								'detailedProperty.dbInstanceCloneProperty.clones.sourceInstance.instanceId'
							);
							obj['cloneJobId'] = _.get(list[j], 'detailedProperty.dbInstanceCloneProperty.clones.cloneJobId');
							break;
						case 31:
							obj['osSubType'] = _.get(
								list[j],
								'detailedProperty.archiveServerProperty.clientProperties.client.osInfo.SubType'
							);
							obj['appId'] = _.get(
								list[j],
								'detailedProperty.archiveServerProperty.clientProperties.client..idaList[0].idaEntity.applicationId'
							);
							break;
						case 34:
							obj['serverId'] = _.get(
								list[j],
								'detailedProperty.vmGroupProperty.subClientProperties.subClientEntity.clientId'
							);
							break;
						case 0:
							obj['name'] = _.get(list[j], 'name');
							obj['lastName'] = _.get(list[j], 'lastName');
							obj['inCompleteSetup'] = _.get(list[j], 'inCompleteSetup');
							break;
						case 'nlp':
							obj.entity = _.get(list[j], 'entity');
							obj.entityType = _.get(list[j], 'entityType');
							obj.action = _.get(list[j], 'action');
							obj.urlLink = _.get(list[j], 'urlLink');
							obj.stateName = _.get(list[j], 'state');
							obj.view = _.get(list[j], 'view');
							obj.entityName = _.get(list[j], 'entityName');
							obj.isCommCellAction = _.get(list[j], 'isCommCellAction');
							obj.isCommCellIntent = _.get(list[j], 'isCommCellIntent');
							obj.localizedEntityName = _.get(list[j], 'localizedEntityName');
							obj.searchType = _.get(list[j], 'searchType');
							obj.placeholderAction = _.get(list[j], 'placholderAction');
							break;
					}

					if (list[j].detailedProperty) {
						obj['detailedProperty'] = list[j].detailedProperty;
					}

					// For multicommcell check URL and update paths as needed
					if (list[j].commcellGuid && cv.commcellUrls && !cv.commcellUrls['undefined']) {
						obj['isMaterCommcell'] = commcellGUIDMap[list[j].commcellGuid].isMaster;
						obj['multicommcellURL'] = commcellGUIDMap[list[j].commcellGuid].url;
						obj['commcellName'] = commcellGUIDMap[list[j].commcellGuid].commcellName;

						if (isCometApp) {
							obj.actionPlaceHolder = '';
							obj.actionSupport = false;
						}
					}

					$scope.dataFromServer.push(obj);
				}
			};

			var allURLRoutes = [];
			// Adds all the valid incomplete solutions to all Routes ( Valid meaning- Those which are not completed and the corresponding states are not available on left navigation)
			var addValidIncompleteSolutions = function(incompleteSolutionRoutes) {
				incompleteSolutionRoutes.forEach(function(incompleteSolutionRoute) {
					allURLRoutes.push({
						id: incompleteSolutionRoute.state,
						name: incompleteSolutionRoute.cvTitle,
						lastName: incompleteSolutionRoute.cvTitle,
						inCompleteSetup: incompleteSolutionRoute.inCompleteSetup ? incompleteSolutionRoute.inCompleteSetup : false
					});
				});
			};
			var extractURLRoutes = function(routes, parentName) {
				for (var i = 0; i < routes.length; i++) {
					if (!_.isNull(routes[i].url) && !_.isUndefined(routes[i].url)) {
						allURLRoutes.push({
							id: routes[i].state,
							name: parentName + routes[i].cvTitle,
							lastName: routes[i].cvTitle
						});
					}
					if (routes[i].children) {
						// Hiding webconsole apps from global search
						if (!routes[i].cvTitle.includes('Web console')) {
							extractURLRoutes(routes[i].children, parentName + routes[i].cvTitle + ' > ');
						}
					}
				}
			};

			$scope.getSearchResults = function(val) {
				$scope.nlpNoResults = false;
				const resultPromise = _getSearchResults(val);
				if (resultPromise) {
					return resultPromise.then(function(results) {
						$scope.nlpNoResults = val && val !== '' && (!results || (results && !results.length));
						$scope.userTyping = false;
						if (_.get($scope, 'entityAction.enable') && val) {
							//To filter actions based on keywords
							results = results.filter(function(action) {
								return action.label.toLowerCase().includes(val.toLowerCase());
							});
						}
						return results;
					});
				} else {
					return resultPromise;
				}
			};

			const _getSearchResults = function(val) {
				// Create Map of base commcell GUID to URL for multicommcell scenario
				if (Object.keys(commcellGUIDMap).length === 0 && cv.commcellUrls && !cv.commcellUrls['undefined']) {
					for (let value in cv.commcellUrls) {
						if (_.get(cv.commcellUrls[value], 'commcell.csGUID')) {
							commcellGUIDMap[cv.commcellUrls[value].commcell.csGUID] = {
								url: cv.commcellUrls[value].webUrl,
								isMaster: cv.commcellUrls[value].isIdp || false,
								commcellName: cv.commcellUrls[value].commcell.commCellName
							};
						}
					}
				}

				angular.element('#globalSearch .dropdown-menu').show();
				$scope.dataFromServer = [];

				// When entity action is enabled. Get results directly
				if ($scope.entityAction && $scope.entityAction.enable) {
					// Do actions things here
					let entityActionProm = new Promise(function(resolve, reject) {
						// When actions are already available
						if ($scope.entityActionList && $scope.entityActionList.length !== 0) {
							resolve($scope.entityActionList);
						} else {
							// get actions for the first time for a given entity
							let actionList = globalActionsFactory.getActionsList(
								$scope.entityAction.obj.type,
								$scope.entityAction.obj
							);
							resolve(actionList);
						}
					});

					entityActionProm.then(function(results) {
						$scope.dataFromServer = results;
						$scope.entityActionList = $scope.dataFromServer;
						return $scope.dataFromServer;
					});

					return entityActionProm;
				}

				if ((typeof val === 'undefined' || val.length === 0) && $scope.commandMode.commandId != 9) {
					return;
				}

				if ($scope.commandMode.enable) {
					switch ($scope.commandMode.commandId) {
						case 0:
							return globalSearchService.getSearchData(val, $scope.commandMode.entityId).then(function(results) {
								let dRes = processSearchResult(results, val, false);
								return results;
							});
							break;
						case 1:
							let fileSearchTerm = val.replace('*', '');
							return globalSearchService
								.getFileSearchData(fileSearchTerm)
								.then(function(results) {
									if (results.data && results.data.response && results.data.response.docs) {
										$scope.dataFromServer = results.data.response.docs;
									}

									$scope.dataFromServer.forEach(function(item) {
										item.FilePath = item.FilePath ? item.FilePath : item.Url;

										// FS browse
										if (item.AppType === 33 || item.AppType === 29) {
											item.type = 'browse';
											item.browseurl =
												'#/browseForAgents/' +
												item.AppType +
												'//?clientGroupName=&subclientId=' +
												item.ApplicationId +
												'&path=' +
												item.FilePath +
												'&globalSearch=true';

											item.path = item.FilePath;
											item.browseType = BrowseTypes.FS_FILE_BROWSE;
										}

										// Temp way to check VSA agent type. Replace the VMname to APPType once API is changed
										else if (item.AppType === 106) {
											if (item.FilePath[0] === '/') {
												item.FilePath = item.FilePath.replace(/\//g, '\\');
											}
											let vendorName = vendorTypes.getVendorName(item.VMHypervisor);
											let path = escape('/' + item.VMUniqueIdentifier + '/' + item.FilePath);

											item.vendor = vendorName;
											item.browseType = BrowseTypes.VS_FILE_BROWSE;

											item.type = 'browse';
											item.browseurl =
												'#/browse/vsFileBrowse/' +
												item.ApplicationId +
												'/' +
												'%5C' +
												item.VMUniqueIdentifier +
												'%5C' +
												escape(item.FilePath) +
												'?vendor=' +
												vendorName +
												'&vmname=' +
												item.VMName +
												'&globalSearch=true';

											item.path = item.VMUniqueIdentifier + '\\' + item.FilePath;
										}

										item.downloadLocale = cvLoc('label.globalSearch.download');
										item.serverNameLocale = cvLoc('label.header.serverName');
										item.pathNameLocale = cvLoc('label.header.path');
									});

									// If more results then show option to go to full page
									if ($scope.dataFromServer.length === 20) {
										$scope.dataFromServer.unshift({
											type: 'browse',
											hideOption: true,
											FileName: cvLoc('label.globalSearch.showAllFiles'),
											browseurl: '#/globalFileSearch?fileName=' + val
										});
									}
									return $scope.dataFromServer;
								})
								.catch(function(err) {
									cvToaster.showErrorMessage({
										ttl: '5000', //5 sec
										message: cvLoc('error.fileSearchFailed')
									});
								});
							break;
						case 2:
							let navPromise = new Promise(function(resolve, reject) {
								allURLRoutes = [];

								// Add nav items
								var navItems = cvNavigationFactory.filterRoutes(angular.copy(cv.nav.routes), val);
								extractURLRoutes(navItems, '');
								addInCompleteSolutions(val);
								addDataInArray(allURLRoutes, 0, 0);

								filterRoutes($scope.dataFromServer, val);
								resolve($scope.dataFromServer);
							});

							navPromise.then(function(dataFromServer) {
								return dataFromServer;
							});

							return navPromise;
							break;
						case 5:
							$scope.addActionList = globalAddActionsFactory.getSupportedAddAction(val);

							let entityAddActionProm = new Promise(function(resolve, reject) {
								// When actions are already available
								if ($scope.addActionList) {
									resolve($scope.addActionList);
								}
							});

							entityAddActionProm.then(function(results) {
								$scope.dataFromServer = results;
								return $scope.dataFromServer;
							});

							return entityAddActionProm;

							break;
						case 6:
							return globalSearchService.getSearchData(val, '3,4,5,14,25').then(function(results) {
								let dRes = processSearchResult(results, val, false);
								return dRes;
							});
							break;
						case 7:
							return globalSearchService.getSearchData(val, '3,4,5,14,25').then(function(results) {
								let dRes = processSearchResult(results, val, false);
								return dRes;
							});
							break;
						case 'nlp':
							return globalSearchService.getSearchData(val, $scope.nlpSearchType).then(function(results) {
								let dRes = processSearchResult(results, val, false);
								return dRes;
							});
							break;
						case 8:
							if (cv.isMspAdmin) {
								let settingsPromise = new Promise(function(resolve, reject) {
									additionalSettingsFactory.filterAdditionalSettings(val).then(function(filteredSettings) {
										resolve(setAdditionalSettingsAutocomplete(filteredSettings));
									});
								});
								settingsPromise.then(function(dataFromServer) {
									return dataFromServer;
								});
								return settingsPromise;
							} else {
								let valuesPromise = new Promise(function(resolve, reject) {
									resolve([]);
								});
								valuesPromise.then(function(dataFromServer) {
									return dataFromServer;
								});
								return valuesPromise;
							}
							break;
						case 9:
							if (cv.isMspAdmin) {
								let valuesPromise = new Promise(function(resolve, reject) {
									resolve(
										setAdditionalSettingsValues(
											additionalSettingsFactory.getAvailableOptions($scope.selectedAdditionalSetting, val)
										)
									);
								});
								valuesPromise.then(function(dataFromServer) {
									return dataFromServer;
								});
								return valuesPromise;
							} else {
								let valuesPromise = new Promise(function(resolve, reject) {
									resolve([]);
								});
								valuesPromise.then(function(dataFromServer) {
									return dataFromServer;
								});
								return valuesPromise;
							}
							break;
					}
				} else {
					if (val.charAt(0) == '/') {
						let p1 = new Promise(function(resolve, reject) {
							var eligible = COMMANDS.filter(function(curr) {
								return curr.commandName.toLowerCase().indexOf(val.toLowerCase()) > -1;
							});
							resolve(eligible);
						});

						p1.then(function(results) {
							$scope.dataFromServer = results;
							return $scope.dataFromServer;
						});

						return p1;
					} else {
						return $q
							.all([globalSearchService.getSearchData(val), globalSearchService.processNLP(val)])
							.then(function(results) {
								$scope.dataFromServer = [];
								let NLP_RESULTS = processNlpResults(val, results[1]);
								if (NLP_RESULTS.length) {
									addDataInArray(NLP_RESULTS, 'nlp', 0);
								}
								processSearchResult(results[0], val, true);
								return $scope.dataFromServer;
							});
					}
				}
			};

			function processNlpResults(command, results) {
				let INTENT = _.get(results, 'data.action');
				let ENTITY = _.get(results, 'data.entity');
				let ENTITY_NAME = _.get(results, 'data.entityName');
				let VIEW = _.get(results, 'data.view');
				const NO_INTENT = _.get(results, 'data.noIntent');
				let LOC_ENTITY_NAME = _.get(results, 'data.localizedEntityName', NO_INTENT ? command : undefined);
				if (INTENT) {
					const ACTION_MAP = _.get(searchEntitiesFactory.INTENT_ACTION_MAP, _.toUpper(INTENT));
					const CC_ENTITY_MAP = _.get(searchEntitiesFactory.COMMCELL_ENTITIES, _.toUpper(ENTITY));
					const HISTORY = _.get(results, 'data.history', []);
					let suggestions = ACTION_MAP ? _.get(ACTION_MAP, 'suggestions') : [];
					let commCellSuggestion = [];
					let historySuggestions = [];
					if (HISTORY && HISTORY.length) {
						_.forEach(HISTORY, function(history) {
							const hisRes = processNlpResults(history.correctedCommand, { data: history });
							if (hisRes && hisRes.length && !_.find(historySuggestions, { id: hisRes[0].id })) {
								historySuggestions.push(hisRes[0]);
							}
						});
					}
					if (CC_ENTITY_MAP) {
						commCellSuggestion = searchEntitiesFactory.getCommcellEntitySuggestions(
							_.toUpper(INTENT),
							CC_ENTITY_MAP,
							ENTITY,
							LOC_ENTITY_NAME
						);

						return commCellSuggestion;
					}

					if (!suggestions) {
						suggestions = searchEntitiesFactory.getSupportedSuggestions;
					}

					if (typeof suggestions === 'function') {
						suggestions = suggestions.call(null, INTENT, ENTITY, VIEW, ENTITY_NAME, LOC_ENTITY_NAME, ACTION_MAP);
					}

					Array.prototype.push.apply(historySuggestions, commCellSuggestion);
					Array.prototype.push.apply(historySuggestions, suggestions);
					suggestions = _.uniqBy(historySuggestions, 'id');

					return suggestions.splice(0, 3) || [];
				}

				return [];
			}

			var keyWordContainsSearchedTerm = function(keyWords, searchTerm) {
				let res = false;
				if (!_.isUndefined(keyWords) && !_.isNull(keyWords) && _.isArray(keyWords) && keyWords.length > 0) {
					for (let l = 0; l < keyWords.length; l++) {
						if (keyWords[l].toLowerCase().includes(searchTerm.toLowerCase())) {
							res = true;
							break;
						}
					}
				}
				return res;
			};

			// checks if the landing state is available in deniedNavstates or not.
			var landingStateIsNotAvailable = function(landingState) {
				if (
					!_.isNull(landingState) &&
					!_.isUndefined(landingState) &&
					landingState !== '' &&
					_.has(cv, 'sessionContext.deniedNavStates')
				) {
					return cv.sessionContext.deniedNavStates && cv.sessionContext.deniedNavStates.includes(landingState);
				}
				return true;
			};

			var addInCompleteSolutions = function(val) {
				if (cv.isMspAdmin) {
					var incompleteSolutions = cvNavigationFactory.getIncompletedSetups();
					var validIncompleteSolutions = [];
					for (let k = 0; k < incompleteSolutions.length; k++) {
						if (
							landingStateIsNotAvailable(incompleteSolutions[k].appDashboardState) &&
							(incompleteSolutions[k].cvTitle.toLowerCase().includes(val.toLowerCase()) ||
								keyWordContainsSearchedTerm(incompleteSolutions[k].keyWords, val))
						) {
							incompleteSolutions[k].inCompleteSetup = true;
							validIncompleteSolutions.push(incompleteSolutions[k]);
						}
					}
					addValidIncompleteSolutions(validIncompleteSolutions);
				}
			};

			var processSearchResult = function(results, val, showURLRoutes) {
				$scope.dataFromServer = $scope.dataFromServer || [];
				allURLRoutes = [];
				if (showURLRoutes) {
					// Add nav items
					var navItems = cvNavigationFactory.filterRoutes(angular.copy(cv.nav.routes), val);
					extractURLRoutes(navItems, '');
					addInCompleteSolutions(val);
				}

				addDataInArray(allURLRoutes, 0, 0);

				results = results.data;
				// There is some data
				if (results && results.entitySearchResultInfo) {
					if (results.entitySearchResultInfo.length > 0) {
						// Loop through all the type of entity sent from server
						for (var i = 0; i < results.entitySearchResultInfo.length; i++) {
							if (ENTITIES[results.entitySearchResultInfo[i].searchType]) {
								addDataInArray(
									results.entitySearchResultInfo[i].entityInfo,
									results.entitySearchResultInfo[i].searchType,
									results.entitySearchResultInfo[i].totalMatchingEntityCount
								);
							}
						}
						// Before returning results filter data depending upon if user has route enabled or not
					}
				}

				filterRoutes($scope.dataFromServer, val);

				return $scope.dataFromServer;
			};

			// Used when entity which has action supported is clicked
			var entityActionMode = function(item) {
				$scope.entityAction = {
					enable: true,
					obj: item
				};

				$scope.entityActionName = item.name;
				$scope.placeHolder = cvLoc('label.globalActions.selectAnAction');
				focusOnServer();
			};

			var entityAddActionMode = function(item) {
				globalAddActionsFactory.performAction(item.entityType);
				$scope.resetSearch();
			};

			// Event when user presses enter on any result as href is used on click event
			$scope.selectedEntity = function(item, model, label, event) {
				$scope.selectedNewEntity = true;
				if ($scope.commandMode && $scope.commandMode.commandId === 'nlp') {
					item.url = undefined;
					$scope.commandModeObj.entityName = item.name;
					$scope.commandModeObj.searchEntity = item.searchEntity;
					$scope.commandModeObj.name = undefined;
					item = _.extend(item, $scope.commandModeObj);
					item.type === 'nlp';
					$scope.commandMode = {
						enable: false,
						commandId: undefined
					};
				}

				if (
					event &&
					(event.keyCode === 9 || event.keyCode === 13) &&
					item.commandId === 8 &&
					cv.isTenantAdmin &&
					!cv.isMspAdmin
				) {
					$location.url('/additionalSettings');
					return;
				}

				if (event && event.keyCode === 9 && item.actionSupport) {
					entityActionMode(item);
					return;
				}

				// When add is clicked
				if (item.type !== 'nlp' && item.entityType) {
					entityAddActionMode(item);
					return;
				}

				if (
					event &&
					(event.keyCode === 13 || event.keyCode === 9) &&
					$scope.selectedAdditionalSetting &&
					$scope.commandMode.commandId == 9
				) {
					additionalSettingsFactory.changeAdditionalSettingFromSearch(
						$scope.selectedAdditionalSetting.keyName,
						$scope.selectedAdditionalSetting.type,
						item.addEntityName
					);

					$scope.typeEntity = '';
					$scope.resetSearch();
					return;
				}

				if (event && (event.keyCode === 13 || event.keyCode === 9) && item.type === 2) {
					$scope.selectedAdditionalSetting = item.addSetting;
					var obj = {
						commandName: item.lastName,
						placeHolder: cvLoc('label.globalSearch.enterValueForAdditionalSetting') + ' ' + item.lastName,
						commandId: 9,
						stateName: item.state
					};
					_inCommandMode(obj);
					return;
				}

				// When tab is pressed on a nav item then do entity search for that entity if entity search is allowed for that entity
				if (event && event.keyCode === 9 && item.type === 0 && checkStateAvailable(item.state)) {
					var obj = {
						commandName: item.lastName,
						placeHolder: cvLoc('label.globalSearch.search') + ' ' + item.lastName,
						commandId: 0,
						stateName: item.state
					};
					_inCommandMode(obj);
					return;
				}

				if (item.commandId) {
					_inCommandMode(item);
				} else {
					var link = getLinkAndRedirect(item, event, $scope);

					// clear the search result
					$scope.dataFromServer = [];
				}
			};

			// activate command mode and do DOM changes
			var _inCommandMode = function(item) {
				if (item.commandId === 4) {
					openKeyboardHelpModal();
					return;
				}

				if (item.commandId === 0) {
					var entityId = getEntityIdFromState(item.stateName);
					if (entityId !== null) {
						$scope.commandMode.entityId = entityId;
					}
				}

				$scope.commandName = item.commandName;
				$scope.placeHolder = item.placeHolder;
				$scope.commandMode.enable = true;
				$scope.commandMode.commandId = item.commandId;
			};

			$scope.goToEntityPage = function(val, event) {
				event.preventDefault();
				event.stopPropagation();
				$location.url(val);
				$scope.typeEntity = '';
				$scope.dataFromServer = [];
			};

			function performNlpAction(res, suggestionMode) {
				if (
					!res.isCommCellAction &&
					suggestionMode &&
					res.action &&
					res.action !== 'Navigate' &&
					res.action !== 'Add' &&
					res.entity &&
					!res.entityName
				) {
					let obj = {
						commandName: res.placeholderAction,
						placeHolder:
							cvLoc('label.globalSearch.search') +
							' ' +
							_.toLower(res.localizedEntityName) +
							' to ' +
							_.toLower(res.placeholderAction),
						commandId: 'nlp'
					};
					$scope.nlpSearchType = res.searchType;
					$scope.commandModeObj = res;
					_inCommandMode(obj);
					return;
				} else {
					if (res.searchEntity) {
						_.set(res, 'searchEntity.searchType', parseInt($scope.nlpSearchType || 0));
					}
					$scope.commandModeObj = undefined;
					let intent = {
						action: res.action,
						entity: res.entity,
						entityType: res.entityType,
						entityName: res.entityName,
						searchEntity: res.searchEntity,
						urlLink: res.urlLink,
						stateName: res.stateName,
						locEntityName: res.localizedEntityName,
						isCommCellAction: res.isCommCellAction,
						isCommCellIntent: res.isCommCellIntent,
						view: res.view
					};
					$scope.nlpSearchType = undefined;
					globalNLPActionFactory.performAction(intent, function nlpCallBack(flags) {
						if (flags && flags.noResultsFound) {
							$scope.nlpNoResults = true;
						} else {
							//clear search entity
							$scope.nlpNoResults = false;
							$scope.typeEntity = '';
							$scope.resetSearch();
						}
					});
				}
			}

			function isArrowKeyStroke(event) {
				return event && _.includes(arrowKeyCodes, event.keyCode);
			}

			$scope.setUserTyping = function(event) {
				$scope.userTyping = !isArrowKeyStroke(event);
			};

			// Revert back to non command mode and do DOM changes. Like initial state
			$scope.removeTagOnBackspace = function(model, event, inCommandMode, entityAction) {
				$scope.nlpNoResults = false;
				$scope.userTyping = !isArrowKeyStroke(event);
				// When enter is pressed and the use is in help command mode
				if (model !== '' && event && event.keyCode == 13 && inCommandMode && inCommandMode.commandId === 3) {
					//assuming custom link won't have article keyword in it.
					//this replace is done because search has a link as http://documentation.commvault.com/commvault/v11_sp20/search.jsp
					//but documentation link returns base link as http://documentation.commvault.com/commvault/v11_sp20/article
					let url = cvConfig.helpLink.replace('article', '') + '/search.jsp?q=' + model;
					let win = window.open(url, '_blank');
					win.focus();
					$scope.typeEntity = '';
					$scope.resetSearch();
					return;
				}

				// When enter is pressed and the user is in Additional Settings command mode
				if (
					model == '' &&
					event &&
					event.keyCode == 13 &&
					inCommandMode &&
					inCommandMode.commandId === 8 &&
					!$scope.selectedNewEntity
				) {
					$location.url('/additionalSettings');
					return;
				}

				if (
					model != '' &&
					event &&
					event.keyCode == 13 &&
					inCommandMode &&
					inCommandMode.commandId === 9 &&
					!$scope.selectedNewEntity &&
					$scope.selectedAdditionalSetting
				) {
					additionalSettingsFactory.changeAdditionalSettingFromSearch(
						$scope.selectedAdditionalSetting.keyName,
						$scope.selectedAdditionalSetting.type,
						model
					);

					$scope.typeEntity = '';
					$scope.resetSearch();
					return;
				}

				if ($scope.selectedNewEntity) {
					$scope.selectedNewEntity = false;
				}

				//When enter is pressed before the search results are loaded
				if (_.get(event, 'keyCode') == 13 && $scope.userTyping) {
					return;
				}

				if (model != '' && event && event.keyCode == 13) {
					globalSearchService.processNLP(model).then(function(res) {
						if (res && res.data) {
							if (res.data.action && res.data.entity) {
								const entity = searchEntitiesFactory.COMMCELL_ENTITIES[res.data.entity];
								if (entity && _.includes(entity.intents, _.toUpper(res.data.action))) {
									res.data.isCommCellAction = true;
								}
							}
							performNlpAction(res.data);
						}
					});
					return;
				}

				// Revert back the entity action command mode
				if (model == '' && entityAction && entityAction.enable && event.keyCode === 8) {
					entityAction.enable = false;

					// If already in entity mode then change to entity place holder if not revert to initial
					if (inCommandMode.enable) {
						$scope.placeHolder =
							cvLoc('label.globalSearch.search') + ' ' + ENTITIES[inCommandMode.entityId].displayName;
					} else {
						$scope.placeHolder = initPlaceHolder;
					}

					$scope.entityActionList.length = 0;
					focusOnServer();

					return;
				}

				// Revert back the regular command mode
				if (model == '' && inCommandMode.enable && event.keyCode === 8) {
					$scope.placeHolder = initPlaceHolder;
					inCommandMode.enable = false;
					inCommandMode.commandId = null;
					$scope.commandModeObj = undefined;
				}
			};

			// Used to initiate the download for file search
			$scope.downloadFile = function(obj, evt) {
				evt.preventDefault();
				evt.stopPropagation();
				this.$parent.typeEntity = '';
				$('#globalSearch .dropdown-menu').css({
					display: 'none'
				});

				$('#globalSearchInput').removeClass('extend-width');
				this.$parent.dataFromServer.length = 0;

				if (obj.FilePath[0] === '\\') {
					obj.FilePath = obj.FilePath.replace('\\', '');
				}

				downloadsFactory.processDownloadRequest(obj);
			};

			// Key board shortcuts
			hotkeys
				.bindTo($scope)
				.add({
					combo: 'mod+s',
					callback: function(e) {
						initKeyBoardOnInput(e);
					}
				})
				.add({
					combo: 'mod+g',
					callback: function(e) {
						initKeyBoardOnInput(e);
						_inCommandMode(getGotoCommand());
						$scope.typeEntity = '';
					}
				})
				.add({
					combo: 'mod+a',
					callback: function(e) {
						initKeyBoardOnInput(e);
						_inCommandMode(getAddCommand());
						$scope.typeEntity = '';
					}
				});

			// Used to provide focus on the search input

			function initKeyBoardOnInput(e) {
				e.preventDefault();
				setTimeout(function() {
					document.getElementById('globalSearchInput').trigger('focus');
				}, 10);
			}

			// Need to use jquery as the custom template used to remove class does not have access to controller
			$scope.focusEvt = function(evt) {
				$('#globalSearchInput').addClass('extend-width');
			};

			$scope.focusOut = function(evt) {
				$('#globalSearchInput').removeClass('extend-width');
			};

			var focusOnServer = function() {
				setTimeout(function() {
					// Think of a better way to do this
					$('#globalSearchInput').trigger('focus');
					$scope.$apply();
				}, 10);
			};

			$scope.resetSearch = function() {
				$scope.placeHolder = initPlaceHolder;
				$scope.commandMode.enable = false;
				$scope.commandMode.commandId = null;

				if ($scope.entityAction && $scope.entityAction.enable) {
					$scope.entityAction.enable = false;
					$scope.entityActionList.length = 0;
				}
			};

			$scope.processNLPData = function(val) {
				globalNLPActionFactory.performAction(val).then(function(results) {
					$log.info(results);
					$scope.typeEntity = '';
					$scope.resetSearch();
				});
			};

			let setBrowseServiceEntity = function(clientId, clientName, subclientId, applicationId, browseType) {
				let entity = {
					clientId: clientId,
					clientName: clientName,
					subclientId: subclientId,
					applicationId: applicationId
				};
				entity.appTypeId = applicationId;
				switch (browseType) {
					case BrowseTypes.FS_FILE_BROWSE:
						browseForAgentsService.entity = entity;
						break;
					case BrowseTypes.VS_FILE_BROWSE:
						browseService.entity = entity;
						break;
					default:
						$log.error('Browse Type is not supported', browseType);
						break;
				}
			};

			$scope.doShowRestoreDialog = function(selectedRow) {
				if (!selectedRow.hideOption) {
					selectionService.clearSelection();
					selectionService.selectionArray = [selectedRow];
					setBrowseServiceEntity(
						selectedRow.ClientId,
						selectedRow.ClientName,
						selectedRow.ApplicationId,
						selectedRow.AppType,
						selectedRow.browseType
					);
					restoreFactory.doShowRestoreDialogSub(
						selectedRow.browseType,
						selectedRow.vendor,
						selectedRow,
						selectedRow.VMUniqueIdentifier,
						selectedRow.vendor
					);
				}
			};
		}
	];

	settingsMod.controller(controllers);
})();
