import { cvModuleSettingsModule } from 'common/js/modules';

var mod = cvModuleSettingsModule;

mod.controller('feedbackController', [
	'$scope',
	'$location',
	'$window',
	'cvLoc',
	'cvToaster',
	'cvUtil',
	'submitFeedbackService',
	function($scope, $location, $window, cvLoc, cvToaster, cvUtil, submitFeedbackService) {
		if ($location.search().ref) {
			// If search has the reference url parameter, use it for the cancel
			// button and for redirecting the user after submit.
			$scope.returnUrl = $location.search().ref;
			// The reference url string is the string that will be inserted
			// into the message box when the user selects the localization
			// subject.
			$scope.referenceUrlString = cvLoc('string.referenceUrl', $location.search().ref);
		} else {
			$scope.returnUrl = '#' + cvUtil.getAppDashboard();
		}

		$scope.isCoreSetupComplete = cvUtil.objectContainsNestedProperty('cv.sessionContext.completedSetups.CORE_SETUP', cv)
			? cv.sessionContext.completedSetups.CORE_SETUP
			: false;

		// List is used to populate the select via ngOptions
		$scope.subjectsList = [
			{
				value: '',
				label: cvLoc('label.subjects.placeholder')
			},
			{
				value: 'like',
				label: cvLoc('label.subjects.like')
			},
			{
				value: 'dislike',
				label: cvLoc('label.subjects.dislike')
			},
			{
				value: 'request',
				label: cvLoc('label.subjects.request')
			},
			{
				value: 'general',
				label: cvLoc('label.subjects.general')
			},
			{
				value: 'localization',
				label: cvLoc('label.subjects.localization')
			}
		];
		// Dictionary is used to look up subject objects by string/value
		$scope.subjects = {};
		$scope.subjectsList.forEach(function(subject) {
			$scope.subjects[subject.value] = subject;
		});
		$scope.selectedSubject = '';
		$scope.documentationPageLink = cvConfig.helpLink;
		$scope.onSubjectChange = function() {
			// Force $scope.message to be a string if null/undefined so that
			// we may concatenate it with other strings without
			// concatenating 'null' or 'undefined'
			if (typeof $scope.message !== 'string') {
				$scope.message = '';
			}
			// If user selects localization subject and there is a reference
			// url and the user's message does not contain the reference url,
			// then insert the reference url at the beginning of the user's
			// message
			if (
				$scope.selectedSubject === 'localization' &&
				$location.search().ref &&
				!$scope.message.includes($scope.referenceUrlString)
			) {
				$scope.message = $scope.referenceUrlString + '\n' + $scope.message;
			}
		};

		$scope.message = '';

		$scope.submitFeedback = function() {
			submitFeedbackService
				.submitFeedback({
					subject: $scope.subjects[$scope.selectedSubject].label,
					body: $scope.message
				})
				.then(
					function() {
						$window.location.assign($scope.returnUrl);
						cvToaster.showSuccessMessage({
							message: cvLoc('label.feedbackSuccess'),
							ttl: 12000
						});
					},
					function(data) {
						cvToaster.showErrorMessage({
							message: data.data,
							ttl: 12000
						});
					}
				);
		};
	}
]);

export default mod;
