import 'adminConsole/js/directives/acDirectives.js';
import 'adminConsole/js/services/clientGroups.svc.js';
import 'adminConsole/js/services/clients.svc.js';
import 'modules/settings/js/controllers/dataInterfacePairs.ctrl.js';

import { cvModuleSettingsModule } from 'common/js/modules';

var app = cvModuleSettingsModule;

app.filter('pipeLineStatus', [
	'cvLoc',
	function(cvLoc) {
		return function(boolValue) {
			if (boolValue) {
				return cvLoc('enabled.true');
			} else {
				return cvLoc('enabled.false');
			}
		};
	}
]);

app.filter('readablePipeLineInfo', [
	function() {
		return function(pipeLineInfo) {
			var readablePipelineInfo = '';
			if (pipeLineInfo) {
				if (pipeLineInfo.isSourceClientGroup) {
					readablePipelineInfo = pipeLineInfo.clientGroup1.name;
				} else {
					readablePipelineInfo = pipeLineInfo.client1.name;
				}
				if (pipeLineInfo.isDestClientGroup) {
					readablePipelineInfo += ' & ' + pipeLineInfo.clientGroup2.name;
				} else {
					readablePipelineInfo += ' & ' + pipeLineInfo.client2.name;
				}
			}
			return readablePipelineInfo;
		};
	}
]);

app.filter('readableInterfacePair', [
	'cvLoc',
	function(cvLoc) {
		return function(interfacePair, isClientGroup) {
			var readableinterfacePair = '';
			if (interfacePair) {
				readableinterfacePair = interfacePair.hostNameA;
				readableinterfacePair += ' & ' + interfacePair.hostNameB;
			}
			return readableinterfacePair;
		};
	}
]);

app.directive('cvDataInterfacePairs', [
	function() {
		return {
			restrict: 'E',
			templateUrl: appUtil.appRoot + 'modules/settings/partials/dataInterfacePairsTemplate.jsp',
			controller: [
				'$scope',
				'$uibModal',
				'cvUtil',
				'cvLoc',
				'cvToaster',
				'dataInterfacePairsFactory',
				function($scope, $modal, cvUtil, cvLoc, cvToaster, dataInterfacePairsFactory) {
					dataInterfacePairsFactory.getDataInterfacePairsForAllComputers().then(
						function() {
							$scope.dataInterfacePairs = dataInterfacePairsFactory.dataInterfacePairsOfAllComputers;
						},
						function(errorMessage) {
							$scope.dataInterfacePairs = {};
							showErrorMessage(errorMessage);
						}
					);

					$scope.configureDataInterfacePairs = function() {
						var modalInstance = $modal.open({
							templateUrl: appUtil.appRoot + 'modules/settings/partials/configureDataInterfacePairs.jsp',
							backdrop: 'static',
							controller: 'configureDataInterfacePairsController'
						});

						modalInstance.result.then(function() {
							cvToaster.showSuccessMessage({
								message: cvLoc('label.dataInterfacePairsUpdateSuccess'),
								ttl: 5000
							});
						});
					};

					function showErrorMessage(errorMessage) {
						if (errorMessage) {
							if (angular.isString(errorMessage)) {
								$scope.serverMessage = cvUtil.errMsg(errorMessage);
							} else if (angular.isString(errorMessage.data)) {
								$scope.serverMessage = cvUtil.errMsg(errorMessage.data);
							} else {
								$scope.serverMessage = cvLoc('generic_error');
							}
						}
					}
				}
			]
		};
	}
]);

app.factory('dataInterfacePairsFactory', [
	'$q',
	'$uibModal',
	'$log',
	'$filter',
	'cvLoc',
	'cvUtil',
	'cvTableOptions',
	'clientService',
	'clientGroupService',
	'dataInterfacePairsService',
	'orderByFilter',
	function dataInterfacePairsFactory(
		$q,
		$modal,
		$log,
		$filter,
		cvLoc,
		cvUtil,
		cvTableOptions,
		clientService,
		clientGroupService,
		dataInterfacePairsService,
		sortBy
	) {
		dataInterfacePairsFactory.dataInterfacePairsOfAllComputers = [];
		dataInterfacePairsFactory.gridOptionsData = {
			client1: {},
			client2: {},
			pipeLineData: []
		};
		dataInterfacePairsFactory.interfacesForClients = {
			client1: [],
			client2: []
		};

		var pipeLineDataCopy = {};

		dataInterfacePairsFactory.getDataInterfacePairsForAllComputers = function() {
			return dataInterfacePairsService
				.getDataInterfacePairsForAllClients()
				.success(function(response) {
					if (response && angular.isArray(response)) {
						dataInterfacePairsFactory.dataInterfacePairsOfAllComputers = response;
					}
				})
				.error(function(errorMessage) {
					$log.error('Unable to fetch data interface pairs ' + errorMessage);
					dataInterfacePairsFactory.dataInterfacePairsOfAllComputers = {};
				});
		};

		dataInterfacePairsFactory.getComputers = function() {
			dataInterfacePairsFactory.computers = {
				firstComputer: [],
				secondComputer: []
			};
			var requests = {
				clientsResp: clientService.getClientNames(),
				clientGroupsResp: clientGroupService.getClientGroups()
			};
			return $q.all(requests).then(
				function(response) {
					if (angular.isArray(response.clientsResp.data)) {
						var clients = sortBy(
							response.clientsResp.data.map(function(clientObj) {
								return {
									entityId: clientObj.client.clientEntity.clientId,
									entityName: _.get(
										clientObj,
										'client.clientEntity.displayName',
										clientObj.client.clientEntity.clientName
									),
									entityTypeName: 'CLIENT_ENTITY'
								};
							}),
							'entityName'
						);
						var _clients = getGroupedClients(clients);
						dataInterfacePairsFactory.computers.firstComputer = _clients;
						dataInterfacePairsFactory.computers.secondComputer = _.cloneDeep(_clients);
					}
					if (angular.isArray(response.clientGroupsResp.data)) {
						var clientGroups = sortBy(
							response.clientGroupsResp.data.map(function(cg) {
								return {
									entityId: cg.Id,
									entityName: cg.name,
									entityTypeName: 'CLIENT_GROUP_ENTITY'
								};
							}),
							'entityName'
						);

						var groups = getGroupedClientGroups(clientGroups);
						Array.prototype.push.apply(dataInterfacePairsFactory.computers.firstComputer, groups);
						Array.prototype.push.apply(dataInterfacePairsFactory.computers.secondComputer, _.cloneDeep(groups));
					}
				},
				function(errorMessage) {
					$log.error('Unable to fetch computers ' + errorMessage);
				}
			);
		};

		/*
		 * Two methods "getGroupedClients" and "getGroupedClientGroups" are used for the dropdown.
		 * To show the label "Clients" followed by a list of clients and another label "ClientGroups" which
		 * followed by a list of clientgroups in dropdown popup menu
		 */
		function getGroupedClients(clients) {
			var groupedClients = [];
			if (clients.length > 0) {
				groupedClients.push({
					entityName: cvLoc('heading.Clients'),
					group: true
				});
				Array.prototype.push.apply(groupedClients, angular.copy(clients));
				groupedClients.push({
					group: false
				});
			}
			return groupedClients;
		}

		function getGroupedClientGroups(clientgroups) {
			var groupedClientGroups = [];
			if (clientgroups.length > 0) {
				groupedClientGroups.push({
					entityName: cvLoc('heading.ClientGroups'),
					group: true
				});
				Array.prototype.push.apply(groupedClientGroups, clientgroups);
				groupedClientGroups.push({
					group: false
				});
			}
			return groupedClientGroups;
		}

		dataInterfacePairsFactory.getCommonDataInterfacePairs = function(pipeLineInfo) {
			return dataInterfacePairsService
				.getCommonDataInterfacePairs(
					pipeLineInfo.client1.id,
					pipeLineInfo.client2.id,
					pipeLineInfo.isSourceClientGroup,
					pipeLineInfo.isDestClientGroup
				)
				.success(function(response) {
					dataInterfacePairsFactory.gridOptionsData.pipeLineData.length = 0;
					if (response && angular.isArray(response)) {
						Array.prototype.push.apply(dataInterfacePairsFactory.gridOptionsData.pipeLineData, response);
						pipeLineDataCopy = angular.copy(response);
					}
				})
				.error(function(errorMessage) {
					$log.error('Unable to fetch data interface pairs' + errorMessage);
				});
		};

		dataInterfacePairsFactory.updateDataInterfaceGridOptions = function(pipeLineInfo) {
			dataInterfacePairsFactory.gridOptionsData['client1'] = pipeLineInfo.client1;
			dataInterfacePairsFactory.gridOptionsData['client2'] = pipeLineInfo.client2;
			dataInterfacePairsFactory.gridOptionsData.isSourceClientGroup = pipeLineInfo.isSourceClientGroup;
			dataInterfacePairsFactory.gridOptionsData.isDestClientGroup = pipeLineInfo.isDestClientGroup;
			updateColumnNames();
		};

		dataInterfacePairsFactory.getInterfaceForClient1 = function(client1) {
			return dataInterfacePairsService
				.getInterfacesForClient(client1.id)
				.success(function(interfaces) {
					if (angular.isArray(interfaces)) {
						dataInterfacePairsFactory.interfacesForClients['client1'] = interfaces;
					}
				})
				.error(function(errorMessage) {
					$log.error('Unable to fetch interfaces for client id' + client1.id);
				});
		};

		dataInterfacePairsFactory.getInterfaceForClient2 = function(client2) {
			return dataInterfacePairsService
				.getInterfacesForClient(client2.id)
				.success(function(interfaces) {
					if (angular.isArray(interfaces)) {
						dataInterfacePairsFactory.interfacesForClients['client2'] = interfaces;
					}
				})
				.error(function(errorMessage) {
					$log.error('Unable to fetch interfaces for client id' + client2.id);
				});
		};

		dataInterfacePairsFactory.updateDataInterfacePairs = function() {
			if (dataInterfacePairsFactory.gridOptionsData.pipeLineData.length == 0) {
				return dataInterfacePairsService.updateDataInterfacePairs({
					pipeLineInfoList: angular.toJson(pipeLineDataCopy),
					operationType: 'DELETE'
				});
			}

			return dataInterfacePairsService.updateDataInterfacePairs({
				pipeLineInfoList: angular.toJson(dataInterfacePairsFactory.gridOptionsData.pipeLineData),
				operationType: 'MODIFY'
			});
		};

		function createNewPipeLineInfo() {
			return {
				isActive: true,
				client1: {
					id: dataInterfacePairsFactory.gridOptionsData['client1'].id,
					name: ''
				},
				client2: {
					id: dataInterfacePairsFactory.gridOptionsData['client2'].id,
					name: ''
				}
			};
		}

		dataInterfacePairsFactory.addInterfacePairs = function(pipeLineInfo) {
			var editMode = !!pipeLineInfo;
			if (!editMode) {
				pipeLineInfo = createNewPipeLineInfo();
			}

			var modalInstance = $modal.open({
				templateUrl: appUtil.appRoot + 'modules/settings/partials/addInterfaces.jsp',
				backdrop: 'static',
				controller: 'addInterfacesController',
				resolve: {
					inputParams: function() {
						return {
							editMode: editMode,
							pipeLineInfo: pipeLineInfo,
							client1: dataInterfacePairsFactory.gridOptionsData['client1'],
							client2: dataInterfacePairsFactory.gridOptionsData['client2'],
							isSourceClientGroup: dataInterfacePairsFactory.gridOptionsData['isSourceClientGroup'],
							isDestClientGroup: dataInterfacePairsFactory.gridOptionsData['isDestClientGroup']
						};
					}
				}
			});

			modalInstance.result.then(function() {
				if (!editMode) {
					dataInterfacePairsFactory.gridOptionsData.pipeLineData.push(pipeLineInfo);
				}
			});
		};

		dataInterfacePairsFactory.removeInterfacePairs = function(pipeLineInfo) {
			var index = dataInterfacePairsFactory.gridOptionsData.pipeLineData.indexOf(pipeLineInfo);
			if (index > -1) {
				dataInterfacePairsFactory.gridOptionsData.pipeLineData.splice(index, 1);
			}
		};

		dataInterfacePairsFactory.initializeGrid = function() {
			var globalGridOptions = angular.copy(cvTableOptions.commonNgGridOptions);
			angular.extend(globalGridOptions, {
				data: dataInterfacePairsFactory.gridOptionsData.pipeLineData,
				enableGridMenu: false,
				columnDefs: []
			});

			dataInterfacePairsFactory.dataInterfaceGridOptions = {
				cvTableName: 'dataInterfacePairsTable',
				cvPageLinks: [
					{
						label: cvLoc('label.addInterfacePairs'),
						onclick: dataInterfacePairsFactory.addInterfacePairs
					}
				],
				cvServerMessage: 'scgRuleMessage',
				cvIsSearchable: false,
				cvInstantSearch: false,
				cvIsPageTitle: false,
				cvOnGridEmpty: cvUtil.errMsg(cvLoc('error.dataInterfacesConfigured')),
				cvGridDirectives: {
					cvPageHeight: false,
					uiGridSelection: false,
					uiGridPagination: true
				},
				cvGridCssClass: {
					'bottom-border-last-child': true,
					'top-bottom-border': true,
					'responsive-height-grid': true
				},
				gridOptions: globalGridOptions
			};

			return dataInterfacePairsFactory.dataInterfaceGridOptions;
		};

		dataInterfacePairsFactory.getReadablePipelineInfo = function(pipeLineInfo) {
			var readablePipelineInfo = {};
			if (pipeLineInfo) {
				if (pipeLineInfo.client1 && pipeLineInfo.client1.name) {
					readablePipelineInfo.label = pipeLineInfo.client1.name;
				}
				if (pipeLineInfo.client2 && pipeLineInfo.client2.name) {
					readablePipelineInfo.label += ' & ' + pipeLineInfo.client2.name;
				}
				readablePipelineInfo.status = $filter('pipeLineStatus')(pipeLineInfo.isActive);
			}
			return readablePipelineInfo;
		};

		dataInterfacePairsFactory.validateInterfacePairs = function(uiModel) {
			var existingPairs = dataInterfacePairsFactory.gridOptionsData.pipeLineData;
			if (angular.isArray(existingPairs)) {
				for (var i = 0, length = existingPairs.length; i < length; i++) {
					if (
						uiModel.pipeLineInfo.client1.name == existingPairs[i].client1.name &&
						uiModel.pipeLineInfo.client2.name == existingPairs[i].client2.name
					) {
						uiModel.serverMessage = cvUtil.errMsg(cvLoc('error.interfacePairExists'));
						return false;
					}
				}
				return true;
			}
		};

		dataInterfacePairsFactory.hasInterfacesModified = function() {
			return !angular.equals(pipeLineDataCopy, dataInterfacePairsFactory.gridOptionsData.pipeLineData);
		};

		function updateColumnNames() {
			var globalGridOptions = dataInterfacePairsFactory.dataInterfaceGridOptions.gridOptions;
			globalGridOptions.columnDefs.length = 0;
			globalGridOptions.columnDefs.push.apply(globalGridOptions.columnDefs, getGridColumns());
		}

		function getGridColumns() {
			var clientOneName = dataInterfacePairsFactory.gridOptionsData['client1'].name;
			var clientTwoName = dataInterfacePairsFactory.gridOptionsData['client2'].name;
			return [
				{
					field: 'client1',
					displayName: cvLoc('label.clientInterfacesFor', clientOneName),
					enableFiltering: false,
					enableSorting: false,
					cellTemplate:
						'<span data-ng-if="row.entity.srcGroupId && row.entity.client1.name === \'\'">' +
						cvLoc('label.noDefaultInterfaces') +
						'</span>' +
						'<span data-ng-if="row.entity.client1.name" data-ng-bind="row.entity.client1.name"></span>',
					width: '35%'
				},
				{
					field: 'client2',
					displayName: cvLoc('label.clientInterfacesFor', clientTwoName),
					enableFiltering: false,
					enableSorting: false,
					cellTemplate:
						'<span data-ng-if="row.entity.destGroupId && row.entity.client2.name === \'\'">' +
						cvLoc('label.noDefaultInterfaces') +
						'</span>' +
						'<span data-ng-if="row.entity.client2.name" data-ng-bind="row.entity.client2.name"></span>',
					width: '35%'
				},
				{
					field: 'isActive',
					displayName: cvLoc('label.status'),
					enableFiltering: false,
					enableSorting: false,
					cellTemplate: '<span data-ng-bind="row.entity.isActive | pipeLineStatus"></span>',
					width: '15%'
				},
				{
					field: 'client2',
					displayName: cvLoc('label.actions'),
					cellTemplate:
						'<div class="btn-group" uib-dropdown><a href class="uib-dropdown-toggle" uib-dropdown-toggle ng-disabled="disabled"><span class="grid-action-icon"></span></a><ul uib-dropdown-menu class="dropdown-menu" role="menu"><li><a class="crop" href="" data-ng-click="grid.appScope.addInterfacePairs(row.entity)">' +
						cvLoc('label.edit') +
						'</a></li><li><a class="crop" href="" data-ng-click="grid.appScope.removeInterfacePairs(row.entity)">' +
						cvLoc('label.remove') +
						'</a></li></ul></div>',
					enableFiltering: false,
					enableSorting: false,
					enableHiding: false
				}
			];
		}

		return dataInterfacePairsFactory;
	}
]);

app.controller('dataOptionsController', [
	'cvLoc',
	'cvBreadcrumbsTabsFactory',
	function(cvLoc, cvBreadcrumbsTabsFactory) {
		// Add breadcumbs
		var breadCrumbs = [];
		breadCrumbs.push({
			title: cvLoc('label.nav.network'),
			link: '#nav/network'
		});
		cvBreadcrumbsTabsFactory.addBreadCrumbs(breadCrumbs);
	}
]);

app.controller('configureDataInterfacePairsController', [
	'$scope',
	'$state',
	'$uibModalInstance',
	'cvUtil',
	'cvLoc',
	'dataInterfacePairsFactory',
	'cvBreadcrumbsTabsFactory',
	function($scope, $state, $modalInstance, cvUtil, cvLoc, dataInterfacePairsFactory, cvBreadcrumbsTabsFactory) {
		$scope.uiModel = {
			accordionStatus: {
				selectComputersTab: true,
				selectInterfacesTab: false
			},
			serverMessage: cvUtil.infoMsg(cvLoc('Loading')),
			computers: {
				firstComputer: [],
				secondComputer: []
			},
			firstComputer: undefined,
			secondComputer: undefined,
			gridOptions: dataInterfacePairsFactory.initializeGrid(),
			translation: cvUtil.getIStevenLocLabels()
		};

		$scope.close = function() {
			$modalInstance.dismiss();
		};

		$scope.saveConfiguration = function() {
			if (!dataInterfacePairsFactory.hasInterfacesModified()) {
				$scope.close();
				return;
			}

			dataInterfacePairsFactory.updateDataInterfacePairs().then(function() {
				$modalInstance.close();
				$state.forceReload();
			}, showErrorMessage);
		};

		$scope.validateSelectedComputers = function() {
			if (
				$scope.uiModel.firstComputer &&
				$scope.uiModel.firstComputer.length != 0 &&
				$scope.uiModel.secondComputer &&
				$scope.uiModel.secondComputer.length != 0
			) {
				if (
					($scope.uiModel.firstComputer[0].entityTypeName === 'CLIENT_GROUP_ENTITY' &&
						$scope.uiModel.secondComputer[0].entityTypeName === 'CLIENT_GROUP_ENTITY') ||
					($scope.uiModel.firstComputer[0].entityTypeName === 'CLIENT_ENTITY' &&
						$scope.uiModel.secondComputer[0].entityTypeName === 'CLIENT_ENTITY')
				) {
					return $scope.uiModel.firstComputer[0].entityId !== $scope.uiModel.secondComputer[0].entityId; //if both are of same entity type then only compare id and return false if same.
				} else {
					return true;
				}
			}
			return false;
		};

		dataInterfacePairsFactory.getComputers().then(initializeComputers, showErrorMessage);

		$scope.addInterfacePairs = dataInterfacePairsFactory.addInterfacePairs;
		$scope.removeInterfacePairs = dataInterfacePairsFactory.removeInterfacePairs;

		function initializeComputers() {
			$scope.uiModel.computers = dataInterfacePairsFactory.computers;
			$scope.uiModel.firstComputer = [];
			$scope.uiModel.secondComputer = [];
			$scope.uiModel.serverMessage = cvUtil.emptyMsg();
		}

		function showErrorMessage(errorMessage) {
			if (errorMessage) {
				if (angular.isString(errorMessage)) {
					$scope.uiModel.serverMessage = cvUtil.errMsg(errorMessage);
				} else if (angular.isString(errorMessage.data)) {
					$scope.uiModel.serverMessage = cvUtil.errMsg(errorMessage.data);
				} else {
					$scope.uiModel.serverMessage = cvLoc('generic_error');
				}
			}
		}

		$scope.updateAvailableInterfaces = function() {
			if (!$scope.validateSelectedComputers()) {
				return;
			}

			var pipeLineInfo = {
				client1: {
					id: $scope.uiModel.firstComputer[0].entityId,
					name: $scope.uiModel.firstComputer[0].entityName
				},
				client2: {
					id: $scope.uiModel.secondComputer[0].entityId,
					name: $scope.uiModel.secondComputer[0].entityName
				},
				isSourceClientGroup: $scope.uiModel.firstComputer[0].entityTypeName === 'CLIENT_GROUP_ENTITY',
				isDestClientGroup: $scope.uiModel.secondComputer[0].entityTypeName === 'CLIENT_GROUP_ENTITY'
			};

			dataInterfacePairsFactory.updateDataInterfaceGridOptions(pipeLineInfo);
			$scope.uiModel.serverMessage = cvUtil.infoMsg(cvLoc('Loading'));
			dataInterfacePairsFactory.getCommonDataInterfacePairs(pipeLineInfo).then(function() {
				$scope.uiModel.serverMessage = cvUtil.emptyMsg();
			}, showErrorMessage);
		};
	}
]);

app.controller('addInterfacesController', [
	'$scope',
	'$uibModalInstance',
	'$log',
	'cvUtil',
	'cvLoc',
	'inputParams',
	'dataInterfacePairsFactory',
	function($scope, $modalInstance, $log, cvUtil, cvLoc, inputParams, dataInterfacePairsFactory) {
		$scope.uiModel = {
			editMode: inputParams.editMode,
			pipeLineInfo: angular.copy(inputParams.pipeLineInfo),
			pipeLineStatus: inputParams.pipeLineInfo.isActive == 1,
			clientEntityOne: inputParams.client1,
			clientEntityTwo: inputParams.client2,
			isSourceClientGroup: inputParams.isSourceClientGroup,
			isDestClientGroup: inputParams.isDestClientGroup,
			interfacesOnClient1: [],
			interfacesOnClient2: [],
			serverMessage: cvUtil.infoMsg(cvLoc('Loading'))
		};

		$scope.close = function() {
			$modalInstance.dismiss();
		};

		$scope.saveInterfaces = function() {
			if (
				(inputParams.pipeLineInfo.client1.name != $scope.uiModel.pipeLineInfo.client1.name ||
					inputParams.pipeLineInfo.client2.name != $scope.uiModel.pipeLineInfo.client2.name) &&
				!dataInterfacePairsFactory.validateInterfacePairs($scope.uiModel)
			) {
				return;
			}
			if (
				$scope.uiModel.pipeLineInfo.client1.name.length == 0 &&
				$scope.uiModel.pipeLineInfo.client2.name.length == 0
			) {
				$scope.uiModel.serverMessage = cvUtil.errMsg(cvLoc('error.selectAtleastInterface'));
				return;
			}
			if ($scope.uiModel.pipeLineInfo.client1.name.length == 0) {
				$scope.uiModel.pipeLineInfo.client1.name = cvLoc('label.noDefaultInterfaces');
			} else if ($scope.uiModel.pipeLineInfo.client2.name.length == 0) {
				$scope.uiModel.pipeLineInfo.client2.name = cvLoc('label.noDefaultInterfaces');
			}

			inputParams.pipeLineInfo.client1.name = $scope.uiModel.pipeLineInfo.client1.name;
			inputParams.pipeLineInfo.client2.name = $scope.uiModel.pipeLineInfo.client2.name;
			inputParams.pipeLineInfo.isActive = $scope.uiModel.pipeLineStatus ? 1 : 0;
			if ($scope.uiModel.isSourceClientGroup && !$scope.uiModel.isDestClientGroup) {
				//1st one is group and 2nd one is client
				inputParams.pipeLineInfo.client1.id = 0;
				inputParams.pipeLineInfo.client2.id = $scope.uiModel.clientEntityTwo.id;
				inputParams.pipeLineInfo.srcGroupId = $scope.uiModel.clientEntityOne.id;
				inputParams.pipeLineInfo.destGroupId = 0;
			} else if ($scope.uiModel.isDestClientGroup && !$scope.uiModel.isSourceClientGroup) {
				//1st one is client and 2nd one is group
				inputParams.pipeLineInfo.client1.id = $scope.uiModel.clientEntityOne.id;
				inputParams.pipeLineInfo.client2.id = 0;
				inputParams.pipeLineInfo.srcGroupId = 0;
				inputParams.pipeLineInfo.destGroupId = $scope.uiModel.clientEntityTwo.id;
			} else if ($scope.uiModel.isSourceClientGroup && $scope.uiModel.isDestClientGroup) {
				//both are groups
				inputParams.pipeLineInfo.client1.id = 0;
				inputParams.pipeLineInfo.client2.id = 0;
				inputParams.pipeLineInfo.srcGroupId = $scope.uiModel.clientEntityOne.id;
				inputParams.pipeLineInfo.destGroupId = $scope.uiModel.clientEntityTwo.id;
			} else {
				//both are clients
				inputParams.pipeLineInfo.client1.id = $scope.uiModel.clientEntityOne.id;
				inputParams.pipeLineInfo.client2.id = $scope.uiModel.clientEntityTwo.id;
				inputParams.pipeLineInfo.srcGroupId = 0;
				inputParams.pipeLineInfo.destGroupId = 0;
			}
			$modalInstance.close();
		};

		$scope.clearErrorMessage = function() {
			$scope.uiModel.serverMessage = cvUtil.emptyMsg();
		};

		if ($scope.uiModel.editMode) {
			if ($scope.uiModel.pipeLineInfo.client1.name === cvLoc('label.noDefaultInterfaces')) {
				$scope.uiModel.pipeLineInfo.client1.name = '';
			} else if ($scope.uiModel.pipeLineInfo.client2.name === cvLoc('label.noDefaultInterfaces')) {
				$scope.uiModel.pipeLineInfo.client2.name = '';
			}
		}

		if ($scope.uiModel.isSourceClientGroup && !$scope.uiModel.isDestClientGroup) {
			//1st one is group and 2nd one is client
			dataInterfacePairsFactory.getInterfaceForClient2(inputParams.pipeLineInfo.client2).then(
				function() {
					$scope.clearErrorMessage();
					$scope.uiModel.interfacesOnClient2 = dataInterfacePairsFactory.interfacesForClients.client2;
					if (!$scope.uiModel.editMode && $scope.uiModel.interfacesOnClient2.length > 0) {
						$scope.uiModel.pipeLineInfo.client2.name = $scope.uiModel.interfacesOnClient2[0];
					}
				},
				function(errorMessage) {
					$scope.clearErrorMessage();
					$log.error(errorMessage);
				}
			);
		} else if ($scope.uiModel.isDestClientGroup && !$scope.uiModel.isSourceClientGroup) {
			//1st one is client and 2nd one is group
			dataInterfacePairsFactory.getInterfaceForClient1(inputParams.pipeLineInfo.client1).then(
				function() {
					$scope.clearErrorMessage();
					$scope.uiModel.interfacesOnClient1 = dataInterfacePairsFactory.interfacesForClients.client1;
					if (!$scope.uiModel.editMode && $scope.uiModel.interfacesOnClient1.length > 0) {
						$scope.uiModel.pipeLineInfo.client1.name = $scope.uiModel.interfacesOnClient1[0];
					}
				},
				function(errorMessage) {
					$scope.clearErrorMessage();
					$log.error(errorMessage);
				}
			);
		} else if (!$scope.uiModel.isSourceClientGroup && !$scope.uiModel.isDestClientGroup) {
			//both are clients
			dataInterfacePairsFactory.getInterfaceForClient1(inputParams.pipeLineInfo.client1).then(
				function() {
					$scope.uiModel.interfacesOnClient1 = dataInterfacePairsFactory.interfacesForClients.client1;
					if (!$scope.uiModel.editMode && $scope.uiModel.interfacesOnClient1.length > 0) {
						$scope.uiModel.pipeLineInfo.client1.name = $scope.uiModel.interfacesOnClient1[0];
					}
				},
				function(errorMessage) {
					$scope.clearErrorMessage();
					$log.error(errorMessage);
				}
			);
			dataInterfacePairsFactory.getInterfaceForClient2(inputParams.pipeLineInfo.client2).then(
				function() {
					$scope.clearErrorMessage();
					$scope.uiModel.interfacesOnClient2 = dataInterfacePairsFactory.interfacesForClients.client2;
					if (!$scope.uiModel.editMode && $scope.uiModel.interfacesOnClient2.length > 0) {
						$scope.uiModel.pipeLineInfo.client2.name = $scope.uiModel.interfacesOnClient2[0];
					}
				},
				function(errorMessage) {
					$scope.clearErrorMessage();
					$log.error(errorMessage);
				}
			);
		} else {
			//both are groups
			$scope.clearErrorMessage();
		}
		function showErrorMessage(errorMessage) {
			if (errorMessage) {
				if (angular.isString(errorMessage)) {
					$scope.uiModel.serverMessage = cvUtil.errMsg(errorMessage);
				} else if (angular.isString(errorMessage.data)) {
					$scope.uiModel.serverMessage = cvUtil.errMsg(errorMessage.data);
				} else {
					$scope.uiModel.serverMessage = cvLoc('generic_error');
				}
			}
		}
	}
]);

export default app;
