import { cvModuleSettingsModule } from 'common/js/modules';
import 'modules/settings/js/services/cvlivesync.svc.js';

//Grid related imports
import 'common/js/newGrid/cv-kendo-grid.js';
import { getMonitoringNodesGridColumns } from './monitoringNodes.columns.template.js';
import { getNodesGridColumns } from './monitoringNodes.columns.template.js';
import { getAvailableNodesGridColumns } from './monitoringNodes.columns.template.js';

var liveSyncMod = cvModuleSettingsModule;

var liveSyncControllers = {};

liveSyncMod.constant('LiveSyncConstants', {
	DEFAULT_CLIENT_GROUP: { clientGroupId: 0, clientGroupName: '' },
	DEFAULT_LIVE_SYNC_INTERVAL: { liveSyncRPO: 15, defaultRecoveryMode: 0 },
	DEFAULT_ALERT_TYPE: 74,
	DEFAULT_ALERT_CRITERIA: 97,
	DEFAULT_ALERT: { alertName: '', alertId: 0 },
	DEFAULT_PROXY_CONNECTIVITY: { proxyConnectivityOption: 1 },
	DEFAULT_MIN_MONITORING_NODE: 3,
	DEFAULT_MAX_MONITORING_NODE: 7,
	//modal params mapping
	TILE_OBJECT_MAPPING: {
		replication: ['liveSyncRPO', 'backupStoragePolicy']
	},
	//Key to compare for objects
	OBJECT_KEY_MAPPING: {
		backupStoragePolicy: 'storagePolicyId',
		proxyClientGroup: 'clientGroupId',
		testFailoverProxyGroup: 'clientGroupId',
		testFailoverClientGroup: 'clientGroupId'
	}
});

liveSyncControllers.liveSyncController = [
	'liveSyncService',
	'$scope',
	'$compile',
	'$dialogs',
	'cvLoc',
	'$state',
	'$log',
	'$uibModal',
	'LiveSyncConstants',
	'cvTableOptions',
	'cvPermissionFactory',
	'cvBreadcrumbsTabsFactory',
	'dialogFactory',
	'cvToaster',
	'$filter',
	function(
		liveSyncService,
		$scope,
		$compile,
		$dialogs,
		cvLoc,
		$state,
		$log,
		$modal,
		LiveSyncConstants,
		cvTableOptions,
		cvPermissionFactory,
		cvBreadcrumbsTabsFactory,
		dialogFactory,
		cvToaster,
		$filter
	) {
		$scope.pageLoaded = false;
		$scope.local = {};
		$scope.modal = {};

		var breadCrumbs = [];
		breadCrumbs.push({
			title: cvLoc('label.nav.system'),
			link: '#nav/settings'
		});
		cvBreadcrumbsTabsFactory.addBreadCrumbs(breadCrumbs);

		function getAsArray(value) {
			return angular.isArray(value) ? value : new Array(value);
		}

		$scope.getAsObject = value => {
			return angular.isArray(value) ? value[0] : value;
		};

		function populateTileNodes() {
			$scope.nodeInfoAvailable = true;
			if (!$scope.configDetails.failoverNodes) {
				$log.error('Node information is not available.');
				$scope.nodeInfoAvailable = false;
				return;
			}

			const nodeVersions = getAsArray($scope.configDetails.failoverNodeVersion);
			const nodes = getAsArray($scope.configDetails.failoverNodes);
			const clientId = $scope.configDetails.failoverNodes[0].sourceEntity.clientId;
			var nodeVersionInfo = {};

			if (nodeVersions) {
				for (var i = 0; i < nodeVersions.length; ++i) {
					nodeVersionInfo[nodeVersions[i].clientId] = nodeVersions[i].versionInfo;
				}
			}

			const getNodeObject = (clientId, clientName, status, lastSyncTime, version) => {
				return {
					clientId: clientId,
					clientName: clientName,
					status: status,
					lastSyncTime: lastSyncTime,
					version: version
				};
			};

			$scope.nodes = getAsArray(
				getNodeObject(
					clientId,
					nodes[0].sourceEntity.clientName,
					cvLoc('label.active'),
					cvLoc('label.notApplicable'),
					nodeVersionInfo.hasOwnProperty(clientId) ? getVersion(nodeVersionInfo[clientId]) : cvLoc('label.notAvailable')
				)
			);

			$scope.nodes = $scope.nodes.concat(
				nodes.map(function(node) {
					const clientId = node.destinationEntity.clientId;
					return getNodeObject(
						clientId,
						node.destinationEntity.clientName,
						cvLoc('label.passive'),
						node.lastSyncTime ? $filter('customDateTime')(node.lastSyncTime) : cvLoc('label.never'),
						nodeVersionInfo.hasOwnProperty(clientId)
							? getVersion(nodeVersionInfo[clientId])
							: cvLoc('label.notAvailable')
					);
				})
			);

			setupNodeGrid();
		}

		function populateTileMonitoringNodes() {
			$scope.monitoringNodeInfoAvailable = true;
			if (!$scope.configDetails.monitoringNodes) {
				$log.error('Monitoring Nodes information is not available.');
				$scope.monitoringNodeInfoAvailable = false;
				return;
			}
			var availableClients = [];
			var selectedClients = [];
			if ($scope.configDetails.monitoringNodes.availableClients) {
				availableClients = getAsArray($scope.configDetails.monitoringNodes.availableClients);
			}
			if ($scope.configDetails.monitoringNodes.selectedClients) {
				selectedClients = getAsArray($scope.configDetails.monitoringNodes.selectedClients);
			}

			const getMonitoringNodeObject = (clientId, clientName, status, lastSyncTime) => {
				return {
					clientId: clientId,
					clientName: clientName,
					status: status,
					lastSyncTime: lastSyncTime
				};
			};
			const getClients = clientList => {
				return clientList.map(function(client) {
					const clientId = client.node.clientId;
					return getMonitoringNodeObject(
						clientId,
						client.node.clientName,
						1 === client.status ? cvLoc('label.active') : cvLoc('label.offline'),
						client.lastSyncTime ? $filter('customDateTime')(client.lastSyncTime) : cvLoc('label.never')
					);
				});
			};
			$scope.availableMonitoringNodes = [];
			$scope.MonitoringNodes = [];
			if (availableClients.length > 0) {
				$scope.availableMonitoringNodes = getClients(availableClients);
			}

			if (selectedClients.length > 0) {
				$scope.MonitoringNodes = getClients(selectedClients);
			}
			setPermittedOptions($scope.MonitoringNodes);
			setupMonitoringNodeGrid();

			if (
				$scope.values.configStatus &&
				$scope.values.enableAutomaticFailover &&
				typeof $scope.MonitoringNodes !== 'undefined' &&
				$scope.MonitoringNodes.length < LiveSyncConstants.DEFAULT_MIN_MONITORING_NODE
			) {
				cvToaster.showErrorMessage({
					ttl: '10000',
					message: cvLoc('error.monitoringNodesLowCount')
				});
			}
		}

		function populateTileReplication() {
			$scope.values['configStatus'] = 1 === $scope.configDetails.configStatus;
			$scope.values['enableAutomaticFailover'] = $scope.configDetails.isAutomaticFailoverEnabled;
			$scope.modal.showMonitoringNodeTile = $scope.values.configStatus && $scope.values.enableAutomaticFailover;

			if (!$scope.configDetails.failoverScheduleDetails) {
				$scope.configDetails.failoverScheduleDetails = LiveSyncConstants.DEFAULT_LIVE_SYNC_INTERVAL;
			}

			$scope.values['liveSyncRPO'] = $scope.configDetails.failoverScheduleDetails.liveSyncRPO;
			$scope.values['backupStoragePolicy'] = Object.assign({}, $scope.configDetails.backupStoragePolicy);
			$scope.values['tlSchedule'] = $scope.configDetails.tlSchedule;
		}

		function populateTileConnectivity() {
			if (!$scope.configDetails.networkInfo) {
				$scope.configDetails.networkInfo = LiveSyncConstants.DEFAULT_PROXY_CONNECTIVITY;
			} else if (typeof $scope.configDetails.networkInfo.proxyConnectivityOption === undefined) {
				$scope.configDetails.networkInfo['proxyConnectivityOption'] = 1;
			}

			if (!$scope.configDetails.networkInfo.proxyEntity) {
				$scope.configDetails.networkInfo.proxyEntity = LiveSyncConstants.DEFAULT_CLIENT_GROUP;
			}

			$scope.values['useExternalGateway'] = 0 === $scope.configDetails.networkInfo.proxyConnectivityOption;
			$scope.values['proxyClientGroup'] = Object.assign({}, $scope.configDetails.networkInfo.proxyEntity);
		}

		function populateTileAlert() {
			$scope.alertExists = $scope.configDetails.alertEntity && $scope.configDetails.alertEntity.alertId;
			if ($scope.alertExists) {
				$scope.values['alertEntity'] = $scope.configDetails.alertEntity;
			}
		}

		function populateTileTestFailover() {
			if (!$scope.configDetails.miscSettings) {
				$scope.configDetails.miscSettings = LiveSyncConstants.DEFAULT_MONITORING_INTERVAL;
			}
			if (!$scope.configDetails.miscSettings.testFailoverClientGroup) {
				$scope.configDetails.miscSettings.testFailoverClientGroup = LiveSyncConstants.DEFAULT_CLIENT_GROUP;
			}
			if (!$scope.configDetails.miscSettings.testFailoverProxyGroup) {
				$scope.configDetails.miscSettings.testFailoverProxyGroup = LiveSyncConstants.DEFAULT_CLIENT_GROUP;
			}

			$scope.values['testFailoverClientGroup'] = Object.assign(
				{},
				$scope.configDetails.miscSettings.testFailoverClientGroup
			);
			$scope.values['testFailoverProxyGroup'] = Object.assign(
				{},
				$scope.configDetails.miscSettings.testFailoverProxyGroup
			);
		}

		const setupNodeGrid = function() {
			let gridOptions = {};
			gridOptions.data = $scope.nodes;
			gridOptions.columns = getNodesGridColumns({ cvLoc });
			gridOptions.gridTitle = cvLoc('header.label.nodes');
			gridOptions.tableName = 'nodeTable';
			gridOptions.hasViews = true;
			gridOptions.pageSize = 10;
			gridOptions.idField = 'clientName';
			gridOptions.searchable = true;
			gridOptions.sortDirection = {
				field: 'clientName',
				dir: 'asc'
			};
			gridOptions.gridEmptyMessage = '<div class="text-align-center">' + cvLoc('info.noNodeInfoAvailable') + '</div>';
			gridOptions.onGridDataBound = (dataItem, row) => {
				const permittedOptions = dataItem.permittedOptions;
				const id = permittedOptions.entityId;
				const template = `<cv-permitted-actions cv-permitted-options="permittedOptions${id}"></cv-permitted-actions>`;
				$scope[`permittedOptions${id}`] = permittedOptions;
				row.find('.permittedActions').append($compile(template)($scope));
			};
			$scope.nodeGridOptions = gridOptions;
		};

		function getVersion(versionInfo) {
			if (versionInfo && versionInfo.GalaxyRelease) {
				var str = versionInfo.GalaxyRelease.ReleaseString;
				if (versionInfo.version) {
					var str1 = versionInfo.version;
					var array1 = str1.split(',');
					var featureRelease = array1[0].split(':').length > 1 ? array1[0].split(':')[1] : '0';
					str = str.concat('.', featureRelease);
					if (array1.length > 1) {
						var maintainenceRelease =
							array1[1].split(':').length > 1 && array1[1].split(':')[1] != '' ? array1[1].split(':')[1] : '0';
						str = str.concat('.', maintainenceRelease);
					}
				}
				return str;
			}
		}

		const setupMonitoringNodeGrid = function() {
			let gridOptions = {};
			gridOptions.data = $scope.MonitoringNodes;
			gridOptions.columns = getMonitoringNodesGridColumns({ cvLoc });
			gridOptions.gridTitle = cvLoc('header.label.MonitoringNodes');
			gridOptions.tableName = 'monitoringNodeTable';
			gridOptions.hasViews = true;
			gridOptions.pageSize = 10;
			gridOptions.idField = 'clientName';
			gridOptions.searchable = true;
			gridOptions.sortDirection = {
				field: 'clientName',
				dir: 'asc'
			};
			gridOptions.gridEmptyMessage = '<div class="text-align-center">' + cvLoc('info.noNodeInfoAvailable') + '</div>';
			gridOptions.onGridDataBound = (dataItem, row) => {
				const permittedOptions = dataItem.permittedOptions;
				const id = permittedOptions.entityId;
				const template = `<cv-permitted-actions cv-permitted-options="permittedOptions${id}"></cv-permitted-actions>`;
				$scope[`permittedOptions${id}`] = permittedOptions;
				row.find('.permittedActions').append($compile(template)($scope));
			};
			gridOptions.gridToolbarMenu = [
				{
					id: 'AddStorage',
					disableOnDeselect: false,
					label: cvLoc('label.add'),
					onSelect: () => {
						$scope.openModalMonitoringClients();
					}
				}
			];
			gridOptions.beforeGridInitialize = ({ grid }) => {
				$scope.monitoringNodeGrid = grid;
			};

			$scope.modal.monitoringNodeGridOptions = gridOptions;
		};
		var setPermittedOptions = function(data) {
			data.forEach(function(node) {
				node.permittedOptions = {
					entityId: node.clientId,
					entityName: node.clientName,
					appendToBody: true,
					permittedActionList: getPermittedActions(node)
				};
			});
		};

		var getPermittedActions = function(rowEntity) {
			let actionsList = [
				{
					delete: {
						show: true,
						label: cvLoc('label.delete'),
						onClick: () => $scope.deleteNode(rowEntity)
					}
				}
			];
			return cvPermissionFactory.updateAndGetCommonActionsList(actionsList, false, {
				delete: {}
			});
		};

		$scope.getFailOverConfig = () => {
			liveSyncService
				.getFailOverConfig()
				.success(function(configDetails) {
					$scope.pageLoaded = true;

					if ((!configDetails.error || configDetails.error.errorCode === 0) && configDetails.csFailoverConfigInfo) {
						$scope.configDetails = configDetails.csFailoverConfigInfo;

						if ($scope.configDetails.isFailoverPackageConfigured) {
							//Show test failover tile only if additional settings is present
							$scope.bShowCommServeLiveSyncTestFailover =
								cv &&
								cv.additionalSettings &&
								cv.additionalSettings.AdminConsole &&
								cv.additionalSettings.AdminConsole.bShowCommServeLiveSyncTestFailover;

							$scope.isActiveConfigPending = $scope.configDetails.isActiveInstanceConfigurationPending;
							$scope.isDrConfigPending = $scope.configDetails.isDRInstanceConfigurationPending;
							$scope.failoverPackageInstalled = $scope.configDetails.isFailoverPackageConfigured;

							$scope.isConfigError =
								$scope.isActiveConfigPending || $scope.isDrConfigPending || !$scope.failoverPackageInstalled;

							if (!$scope.isConfigError) {
								$scope.values = {};
								$scope.locals = {};
								$scope.lists = {};
								$scope.edit = {};

								populateTileNodes();
								populateTileReplication();
								populateTileConnectivity();
								populateTileAlert();

								if ($scope.bShowCommServeLiveSyncTestFailover) {
									populateTileTestFailover();
								}
								if ($scope.values.enableAutomaticFailover) {
									populateTileMonitoringNodes();
								}
								getStoragePolicies();
								getClientGroups();
							}
						}
					} else {
						$scope.isConfigError = true;
						$scope.failoverPackageInstalled = false;
						$log.error('Unable to get CommServe LiveSync settings');
						cvToaster.showErrorMessage({
							ttl: '10000',
							message: configDetails.error ? configDetails.error.errorMessage : cvLoc('generic_error')
						});
					}
				})
				.error(function(data) {
					$scope.pageLoaded = true;
					$scope.isConfigError = true;
					$scope.failoverPackageInstalled = false;
					$log.error('Failed to fetch CommServe LiveSync settings');
					cvToaster.showErrorMessage({
						ttl: '10000',
						message: data.message ? data.message : cvLoc('generic_error')
					});
				});
		};
		$scope.getFailOverConfig();

		function getClientGroups() {
			liveSyncService
				.getClientGroups()
				.success(function(clientGroups) {
					if (clientGroups && clientGroups.groups) {
						$scope.lists['proxyClientGroup'] = getAsArray(clientGroups.groups).map(val => {
							return {
								clientGroupId: val.Id,
								clientGroupName: val.name,
								ticked: false
							};
						});

						$scope.lists['testFailoverProxyGroup'] = JSON.parse(JSON.stringify($scope.lists.proxyClientGroup));
						$scope.lists.testFailoverProxyGroup.push(LiveSyncConstants.DEFAULT_CLIENT_GROUP);

						$scope.lists['testFailoverClientGroup'] = JSON.parse(JSON.stringify($scope.lists.testFailoverProxyGroup));
					} else {
						$log.error('Unable to get Client Groups');
						cvToaster.showErrorMessage({
							ttl: '10000',
							message: data ? data : cvLoc('generic_error')
						});
					}
				})
				.error(function(data) {
					$log.error('Failed to fetch list of Client Groups');
					cvToaster.showErrorMessage({
						ttl: '10000',
						message: data.errorMessage ? data.errorMessage : cvLoc('generic_error')
					});
				});
		}

		function getStoragePolicies() {
			liveSyncService
				.getStoragePolicies()
				.success(function(storagePolicies) {
					if (!storagePolicies || (storagePolicies.error && storagePolicies.error.errorCode !== 0)) {
						$log.error('Unable to get Storage Policies');
						cvToaster.showErrorMessage({
							ttl: '10000',
							message: storagePolicies.error.errorMessage ? storagePolicies.error.errorMessage : cvLoc('generic_error')
						});
					} else {
						$scope.lists.backupStoragePolicy = getAsArray(storagePolicies.policies).map(val => {
							return {
								...val.storagePolicy,
								ticked: val.storagePolicy.storagePolicyId === $scope.values.backupStoragePolicy.storagePolicyId
							};
						});
					}
				})
				.error(function(data) {
					$log.error('Failed to fetch list of Storage Policies');
					cvToaster.showErrorMessage({
						ttl: '10000',
						message: data.errorMessage ? data.errorMessage : cvLoc('generic_error')
					});
				});
		}

		$scope.openModal = fullSizeWindow => {
			var modalSetting = {
				templateUrl: 'modules/settings/partials/CvLiveSyncModal.jsp',
				scope: $scope,
				backdrop: 'static',
				controller: 'configureCvLiveSyncModalController',
				windowClass: fullSizeWindow ? '' : 'small-size'
			};

			var modal = $modal.open(modalSetting);

			$scope.dismissModal = () => {
				modal.dismiss();
			};
		};

		$scope.toggleValue = param => {
			$scope.values[param] = !$scope.values[param];
		};

		$scope.toggleLocal = param => {
			$scope.locals[param] = !$scope.locals[param];
		};

		$scope.onCancelModal = () => {
			switch ($scope.editing) {
				case 'replication':
					$scope.toggleValue('configStatus');
					$scope.updateLocals('liveSyncRPO', 'backupStoragePolicy', 'enableAutomaticFailover');
					break;
				case 'connectivity':
					$scope.toggleValue('useExternalGateway');
					$scope.updateLocals('proxyClientGroup');
					break;
				case 'MonitoringClients':
					$scope.availableMonitoringNodes.forEach(function(entity) {
						entity.selected = false;
					});
					break;
				default:
					$log.error('Tile is not recognized');
			}
			$scope.editing = '';
			$scope.dismissModal();
		};

		$scope.openModalAlert = () => {
			$scope.editing = 'alert';
			$scope.locals['alertName'] = cvLoc('label.commServeLiveSyncAlert');
			$scope.openModal(true);
		};

		$scope.deleteNode = function(node) {
			if (
				$scope.values.enableAutomaticFailover &&
				typeof $scope.MonitoringNodes !== 'undefined' &&
				$scope.MonitoringNodes.length <= LiveSyncConstants.DEFAULT_MIN_MONITORING_NODE
			) {
				cvToaster.showErrorMessage({
					ttl: '10000',
					message: cvLoc('error.monitoringNodesDeletionNotAllowed')
				});
			} else {
				$dialogs.confirm(
					cvLoc('label.confirmDelete'),
					cvLoc('label.deleteMonitoringNode', '<b>' + node.clientName + '</b>'),
					{
						noFunction: function() {},
						yesFunction: function() {
							$scope.monitoringNodedelete(node);
						}
					}
				);
			}
		};
		$scope.monitoringNodedelete = function(node) {
			$scope.action = 'delete';
			$scope.populateLocalMonitoringNodes();
			$scope.local.selectedMonitoringNodes = getAsArray({
				clientId: node.clientId,
				clientName: node.clientName,
				status: node.status,
				lastSyncTime: node.lastSyncTime
			});
			$scope.setFailOverConfig($scope.getModalObjectMonitoringClients($scope.action)).then(err => {
				if (err) {
					$scope.local.monitoringNodes = [];
					$scope.local.availableMonitoringNodes = [];
					cvToaster.showErrorMessage({
						ttl: '10000',
						message: err ? err : cvLoc('generic_error')
					});
				} else {
					$scope.updateMonitoringClients();
				}
				$scope.action = '';
			});
		};
		$scope.populateLocalMonitoringNodes = () => {
			$scope.local.monitoringNodes = $scope.MonitoringNodes.map(function(node) {
				return {
					clientId: node.clientId,
					clientName: node.clientName,
					status: node.status,
					lastSyncTime: node.lastSyncTime
				};
			});
			$scope.local.availableMonitoringNodes = $scope.availableMonitoringNodes.map(function(node) {
				return {
					clientId: node.clientId,
					clientName: node.clientName,
					status: node.status,
					lastSyncTime: node.lastSyncTime
				};
			});
		};
		$scope.openModalMonitoringClients = () => {
			$scope.editing = 'MonitoringClients';
			$scope.local.selectedMonitoringNodes = [];
			$scope.populateLocalMonitoringNodes();
			if (
				typeof $scope.MonitoringNodes !== 'undefined' &&
				$scope.MonitoringNodes.length < LiveSyncConstants.DEFAULT_MAX_MONITORING_NODE
			) {
				$scope.openModal(true);
			} else {
				cvToaster.showErrorMessage({
					ttl: '10000',
					message: cvLoc('error.monitoringNodesAdditionNotAllowed')
				});
			}
		};

		$scope.onDeleteAlert = () => {
			dialogFactory
				.deleteConfirmDialog(cvLoc('label.confirmDelete'), cvLoc('label.deleteAlert'))
				.result.then(function() {
					liveSyncService
						.deleteAlert($scope.values.alertEntity.alertId)
						.success(function() {
							cvToaster.showSuccessMessage({
								ttl: '5000',
								message: cvLoc('label.deleteAlertSuccess')
							});
							$log.debug('Successfully deleted Alert for CommServe LiveSync');
							$scope.values['alertEntity'] = LiveSyncConstants.DEFAULT_ALERT;
							$scope.alertExists = false;
						})
						.error(function(data) {
							$log.error('Failed to delete Alert for CommServe LiveSync');
							cvToaster.showErrorMessage({
								ttl: '10000',
								message: data ? data : cvLoc('generic_error')
							});
						});
				});
		};

		$scope.updateValues = (...params) => {
			for (var i = 0; i < params.length; ++i) {
				const param = params[i];
				//if it is a list (ie dropdown), copy all keys except 'ticked'. Else just copy over
				if ($scope.lists.hasOwnProperty(param)) {
					$scope.locals[param] = $scope.getAsObject($scope.locals[param]);
					for (var key in $scope.values[param]) {
						if ($scope.values[param].hasOwnProperty(key)) {
							$scope.values[param][key] = $scope.locals[param][key];
						}
					}
				} else {
					$scope.values[param] = $scope.locals[param];
				}
			}
		};

		$scope.updateLocals = (...params) => {
			for (var i = 0; i < params.length; ++i) {
				const param = params[i];
				//if it is a list (ie dropdown), copy all keys except 'ticked' + update list. Else just copy over
				if ($scope.lists.hasOwnProperty(param)) {
					if (!$scope.locals[param]) {
						$scope.locals[param] = {};
					}
					for (var key in $scope.values[param]) {
						if ($scope.values[param].hasOwnProperty(key)) {
							$scope.locals[param][key] = $scope.values[param][key];
						}
					}

					var key = LiveSyncConstants.OBJECT_KEY_MAPPING[param];
					if (!$scope.lists[param]) {
						switch (param) {
							case 'backupStoragePolicy':
								getStoragePolicies();
								break;
							case 'proxyClientGroup':
							case 'testFailoverProxyGroup':
							case 'testFailoverClientGroup':
								getClientGroups();
								break;
							default:
								console.debug('Unhandled parameter for list population');
						}
					}
					if ($scope.lists[param]) {
						for (var j = 0; j < $scope.lists[param].length; ++j) {
							if ($scope.lists[param][j][key] === $scope.locals[param][key]) {
								$scope.lists[param][j].ticked = true;
							} else {
								$scope.lists[param][j].ticked = false;
							}
						}
					}
				} else {
					$scope.locals[param] = $scope.values[param];
				}
			}
		};

		$scope.onInlineEdit = param => {
			$scope.updateLocals(param);
			$scope.edit[param] = true;
		};

		$scope.onInlineCancel = param => {
			$scope.edit[param] = false;
		};

		//Checks if parameter(s) was/were changed
		function isDirty(params) {
			params = getAsArray(params);
			for (var i = 0; i < params.length; ++i) {
				const param = params[i];
				if (LiveSyncConstants.OBJECT_KEY_MAPPING.hasOwnProperty(param)) {
					const value = LiveSyncConstants.OBJECT_KEY_MAPPING[param];
					if ($scope.locals[param][value] !== $scope.values[param][value]) {
						return true;
					}
				} else if ($scope.locals[param] !== $scope.values[param]) {
					return true;
				}
			}
			return false;
		}

		$scope.setFailOverConfig = obj => {
			return liveSyncService.setFailOverConfig(obj).then(
				resp => {
					if (!resp.data.errorResp || resp.data.errorResp.errorCode === 0) {
						$log.debug('Successfully updated CommServe LiveSync settings');
					} else {
						$log.error('Failed to update CommServe LiveSync settings');
						return resp.data.errorResp.errorMessage;
					}
				},
				err => {
					$log.error('Failed to update CommServe LiveSync settings');
					return err;
				}
			);
		};

		function onInlineSave(param, obj) {
			if (isDirty(param)) {
				$scope.setFailOverConfig(obj).then(err => {
					if (err) {
						cvToaster.showErrorMessage({
							ttl: '10000',
							message: err ? err : cvLoc('generic_error')
						});
						$scope.updateLocals(param);
					} else {
						$scope.updateValues(param);
					}
					$scope.edit[param] = false;
				});
			} else {
				$scope.edit[param] = false;
			}
		}

		$scope.onInlineSaveLiveSyncRPO = () => {
			$scope.configDetails.failoverScheduleDetails.liveSyncRPO = $scope.locals.liveSyncRPO;

			const obj = {
				csFailoverConfigInfo: {
					failoverScheduleDetails: $scope.configDetails.failoverScheduleDetails,
					//below params required to avoid getting reset
					networkInfo: $scope.configDetails.networkInfo
				}
			};
			onInlineSave('liveSyncRPO', obj);
		};

		$scope.onInlineSaveBackupStoragePolicy = () => {
			$scope.locals.backupStoragePolicy = $scope.getAsObject($scope.locals.backupStoragePolicy);
			$scope.configDetails.backupStoragePolicy.storagePolicyId = $scope.locals.backupStoragePolicy.storagePolicyId;
			$scope.configDetails.backupStoragePolicy.storagePolicyName = $scope.locals.backupStoragePolicy.storagePolicyName;

			const obj = {
				csFailoverConfigInfo: {
					backupStoragePolicy: $scope.configDetails.backupStoragePolicy,
					//below params required to avoid getting reset
					failoverScheduleDetails: $scope.configDetails.failoverScheduleDetails,
					networkInfo: $scope.configDetails.networkInfo
				}
			};
			onInlineSave('backupStoragePolicy', obj);
		};

		$scope.onInlineSaveProxyClientGroup = () => {
			$scope.locals.proxyClientGroup = $scope.getAsObject($scope.locals.proxyClientGroup);
			$scope.configDetails.networkInfo.proxyEntity.clientGroupId = $scope.locals.proxyClientGroup.clientGroupId;
			$scope.configDetails.networkInfo.proxyEntity.clientGroupName = $scope.locals.proxyClientGroup.clientGroupName;

			const obj = {
				csFailoverConfigInfo: {
					networkInfo: $scope.configDetails.networkInfo,
					//below params required to avoid getting reset
					failoverScheduleDetails: $scope.configDetails.failoverScheduleDetails
				}
			};
			onInlineSave('proxyClientGroup', obj);
		};

		$scope.onInlineSaveTestFailoverProxyGroup = () => {
			$scope.locals.testFailoverProxyGroup = $scope.getAsObject($scope.locals.testFailoverProxyGroup);
			$scope.configDetails.miscSettings.testFailoverProxyGroup.clientGroupId =
				$scope.locals.testFailoverProxyGroup.clientGroupId;
			$scope.configDetails.miscSettings.testFailoverProxyGroup.clientGroupName =
				$scope.locals.testFailoverProxyGroup.clientGroupName;

			const obj = {
				csFailoverConfigInfo: {
					miscSettings: $scope.configDetails.miscSettings,
					//below params required to avoid getting reset
					networkInfo: $scope.configDetails.networkInfo,
					failoverScheduleDetails: $scope.configDetails.failoverScheduleDetails
				}
			};
			onInlineSave('testFailoverProxyGroup', obj);
		};

		$scope.onInlineSaveTestFailoverClientGroup = () => {
			$scope.locals.testFailoverClientGroup = $scope.getAsObject($scope.locals.testFailoverClientGroup);
			$scope.configDetails.miscSettings.testFailoverClientGroup.clientGroupId =
				$scope.locals.testFailoverClientGroup.clientGroupId;
			$scope.configDetails.miscSettings.testFailoverClientGroup.clientGroupName =
				$scope.locals.testFailoverClientGroup.clientGroupName;

			const obj = {
				csFailoverConfigInfo: {
					miscSettings: $scope.configDetails.miscSettings,
					//below params required to avoid getting reset
					networkInfo: $scope.configDetails.networkInfo,
					failoverScheduleDetails: $scope.configDetails.failoverScheduleDetails
				}
			};
			onInlineSave('testFailoverClientGroup', obj);
		};

		$scope.clearEdit = () => {
			$scope.editing = '';
		};

		function updateStatus() {
			$scope.editing = 'replication';
			$scope.toggleValue('configStatus');
			$scope.configDetails.isAutomaticFailoverEnabled = $scope.values.enableAutomaticFailover;
			if ($scope.values.configStatus) {
				$scope.updateLocals('liveSyncRPO', 'backupStoragePolicy', 'enableAutomaticFailover');
				$scope.openModal();
			} else {
				const obj = {
					csFailoverConfigInfo: {
						configStatus: 0,
						//needs to be set as it gets cleared if not
						isAutomaticFailoverEnabled: $scope.configDetails.isAutomaticFailoverEnabled,
						failoverScheduleDetails: $scope.configDetails.failoverScheduleDetails,
						networkInfo: $scope.configDetails.networkInfo
					}
				};
				$scope.setFailOverConfig(obj).then(err => {
					if (err) {
						$scope.toggleValue('configStatus');
						cvToaster.showErrorMessage({
							ttl: '10000',
							message: err ? err : cvLoc('generic_error')
						});
					} else {
						$scope.edit.liveSyncRPO = false;
						$scope.edit.backupStoragePolicy = false;
						$scope.modal.showMonitoringNodeTile = $scope.values.configStatus && $scope.values.enableAutomaticFailover;
					}
					$scope.editing = '';
				});
			}
		}

		$scope.onToggleStatus = () => {
			if (!$scope.editing) {
				if ($scope.edit.liveSyncRPO || $scope.edit.backupStoragePolicy || $scope.edit.proxyClientGroup) {
					var callBackFunction = {
						noFunction: () => {
							//nothing to do. keep editing
						},
						yesFunction: () => {
							updateStatus();
						}
					};
					$dialogs.confirm(cvLoc('label.caution'), cvLoc('label.changeEdit'), callBackFunction);
				} else {
					updateStatus();
				}
			}
		};

		$scope.onToggleAutomaticFailover = () => {
			$scope.toggleValue('enableAutomaticFailover');
			$scope.configDetails.isAutomaticFailoverEnabled = $scope.values.enableAutomaticFailover;
			const obj = {
				csFailoverConfigInfo: {
					isAutomaticFailoverEnabled: $scope.configDetails.isAutomaticFailoverEnabled
				}
			};
			$scope.setFailOverConfig(obj).then(err => {
				if (err) {
					$scope.toggleValue('enableAutomaticFailover');
					cvToaster.showErrorMessage({
						ttl: '10000',
						message: err ? err : cvLoc('generic_error')
					});
				} else {
					if ($scope.values.enableAutomaticFailover) {
						$scope.getFailOverMonitoringNodes();
					}
					$scope.modal.showMonitoringNodeTile = $scope.values.configStatus && $scope.values.enableAutomaticFailover;
				}
			});
		};

		$scope.getFailOverMonitoringNodes = () => {
			liveSyncService
				.getFailOverConfig()
				.success(function(configDetails) {
					$scope.pageLoaded = true;

					if ((!configDetails.error || configDetails.error.errorCode === 0) && configDetails.csFailoverConfigInfo) {
						$scope.configDetails = configDetails.csFailoverConfigInfo;

						if ($scope.configDetails.isFailoverPackageConfigured) {
							//Show test failover tile only if additional settings is present
							$scope.bShowCommServeLiveSyncTestFailover =
								cv &&
								cv.additionalSettings &&
								cv.additionalSettings.AdminConsole &&
								cv.additionalSettings.AdminConsole.bShowCommServeLiveSyncTestFailover;

							$scope.isActiveConfigPending = $scope.configDetails.isActiveInstanceConfigurationPending;
							$scope.isDrConfigPending = $scope.configDetails.isDRInstanceConfigurationPending;
							$scope.failoverPackageInstalled = $scope.configDetails.isFailoverPackageConfigured;

							$scope.isConfigError =
								$scope.isActiveConfigPending || $scope.isDrConfigPending || !$scope.failoverPackageInstalled;

							if (!$scope.isConfigError) {
								populateTileMonitoringNodes();
								$scope.monitoringNodeGrid.setData($scope.MonitoringNodes);
							}
						}
					} else {
						$scope.isConfigError = true;
						$scope.failoverPackageInstalled = false;
						$log.error('Unable to get CommServe LiveSync settings');
						cvToaster.showErrorMessage({
							ttl: '10000',
							message: configDetails.error ? configDetails.error.errorMessage : cvLoc('generic_error')
						});
					}
				})
				.error(function(data) {
					$scope.pageLoaded = true;
					$scope.isConfigError = true;
					$scope.failoverPackageInstalled = false;
					$log.error('Failed to fetch CommServe LiveSync settings');
					cvToaster.showErrorMessage({
						ttl: '10000',
						message: data.message ? data.message : cvLoc('generic_error')
					});
				});
		};

		function updateProxyConnection() {
			$scope.editing = 'connectivity';
			$scope.toggleValue('useExternalGateway');

			if ($scope.values.useExternalGateway) {
				$scope.updateLocals('proxyClientGroup');
				$scope.openModal();
			} else {
				$scope.configDetails.networkInfo.proxyConnectivityOption = 1;
				const obj = {
					csFailoverConfigInfo: {
						networkInfo: $scope.configDetails.networkInfo,
						//needs to be set as it gets cleared if not
						failoverScheduleDetails: $scope.configDetails.failoverScheduleDetails
					}
				};
				$scope.setFailOverConfig(obj).then(err => {
					if (err) {
						$scope.toggleValue('useExternalGateway');
						cvToaster.showErrorMessage({
							ttl: '10000',
							message: err ? err : cvLoc('generic_error')
						});
					} else {
						$scope.edit.proxyClientGroup = false;
					}
					$scope.editing = '';
				});
			}
		}

		$scope.onToggleProxyConnection = () => {
			if (!$scope.editing) {
				if (!$scope.values.configStatus) {
					cvToaster.showErrorMessage({
						ttl: '10000',
						message: cvLoc('label.cannotEditWithoutReplication')
					});
				} else {
					if ($scope.edit.proxyClientGroup) {
						var callBackFunction = {
							noFunction: () => {
								//nothing to do. keep editing
							},
							yesFunction: () => {
								updateProxyConnection();
							}
						};
						$dialogs.confirm(cvLoc('label.caution'), cvLoc('label.changeEdit'), callBackFunction);
					} else {
						updateProxyConnection();
					}
				}
			}
		};

		$scope.getModalObjectReplication = () => {
			$scope.configDetails.failoverScheduleDetails.liveSyncRPO = $scope.locals.liveSyncRPO;
			$scope.locals.backupStoragePolicy = $scope.getAsObject($scope.locals.backupStoragePolicy);
			$scope.configDetails.backupStoragePolicy.storagePolicyId = $scope.locals.backupStoragePolicy.storagePolicyId;
			$scope.configDetails.backupStoragePolicy.storagePolicyName = $scope.locals.backupStoragePolicy.storagePolicyName;
			$scope.configDetails.isAutomaticFailoverEnabled = $scope.values.enableAutomaticFailover;
			const obj = {
				csFailoverConfigInfo: {
					configStatus: 1,
					isAutomaticFailoverEnabled: $scope.configDetails.isAutomaticFailoverEnabled,
					backupStoragePolicy: $scope.configDetails.backupStoragePolicy,
					failoverScheduleDetails: $scope.configDetails.failoverScheduleDetails,
					networkInfo: $scope.configDetails.networkInfo
				}
			};

			return obj;
		};

		$scope.updateMonitoringClients = () => {
			$scope.MonitoringNodes = $scope.local.monitoringNodes.map(function(node) {
				return {
					clientId: node.clientId,
					clientName: node.clientName,
					status: node.status,
					lastSyncTime: node.lastSyncTime
				};
			});
			$scope.availableMonitoringNodes = $scope.local.availableMonitoringNodes.map(function(node) {
				return {
					clientId: node.clientId,
					clientName: node.clientName,
					status: node.status,
					lastSyncTime: node.lastSyncTime
				};
			});
			setPermittedOptions($scope.MonitoringNodes);
			$scope.monitoringNodeGrid.setData($scope.MonitoringNodes);
		};
		$scope.getModalObjectMonitoringClients = action => {
			$scope.updateLocalMonitoringClients(action);
			$scope.configDetails.monitoringNodes.selectedClients = $scope.local.monitoringNodes.map(function(node) {
				var time = parseInt(node.lastSyncTime);
				return $scope.getAsObject({
					status: node.status === cvLoc('label.active') ? 1 : 0,
					lastSyncTime: isNaN(time) ? 0 : Math.floor(time / 1000),
					node: { clientId: node.clientId, clientName: node.clientName }
				});
			});

			const obj = {
				csFailoverConfigInfo: {
					monitoringNodes: { selectedClients: $scope.configDetails.monitoringNodes.selectedClients }
				}
			};

			return obj;
		};

		$scope.updateLocalMonitoringClients = action => {
			if (action === 'add') {
				// add action ==> add MonitoringNode in selectedMonitoringNode , remove from availabeMonitoringNode
				$scope.local.monitoringNodes = $scope.local.monitoringNodes.concat(
					$scope.local.selectedMonitoringNodes.map(function(node) {
						return {
							clientId: node.clientId,
							clientName: node.clientName,
							status: node.status,
							lastSyncTime: node.lastSyncTime
						};
					})
				);
				var indexList = []; // get all the index of the monitoringNode index to be removed & store in this list.
				for (var i = 0; i < $scope.local.selectedMonitoringNodes.length; i++) {
					indexList.push($scope.getIndexOfAvailableMonitorClient($scope.local.selectedMonitoringNodes[i].clientId));
				}
				indexList.sort(function(a, b) {
					return b - a;
				});
				indexList.forEach(element => {
					if (element != -1) {
						$scope.local.availableMonitoringNodes.splice(element, 1);
					}
				});
			} else {
				// delete action ==> delete monitoringNode from selectedMonitoringNode , add in availableMonitoringNode
				$scope.local.availableMonitoringNodes = $scope.local.availableMonitoringNodes.concat(
					$scope.local.selectedMonitoringNodes.map(function(node) {
						return {
							clientId: node.clientId,
							clientName: node.clientName,
							status: node.status,
							lastSyncTime: node.lastSyncTime
						};
					})
				);
				var indexList = []; // get all the index of the monitoringNode index to be removed & store in this list.
				for (var i = 0; i < $scope.local.selectedMonitoringNodes.length; i++) {
					indexList.push($scope.getIndexOfSelectedMonitorClient($scope.local.selectedMonitoringNodes[i].clientId));
				}
				indexList.sort(function(a, b) {
					return b - a;
				});
				indexList.forEach(element => {
					if (element != -1) {
						$scope.local.monitoringNodes.splice(element, 1);
					}
				});
			}
		};

		$scope.getIndexOfSelectedMonitorClient = clientId => {
			for (var i = 0; i < $scope.local.monitoringNodes.length; i++) {
				if (clientId === $scope.local.monitoringNodes[i].clientId) {
					return i;
				}
			}
			return -1;
		};
		$scope.getIndexOfAvailableMonitorClient = clientId => {
			for (var i = 0; i < $scope.local.availableMonitoringNodes.length; i++) {
				if (clientId === $scope.local.availableMonitoringNodes[i].clientId) {
					return i;
				}
			}
			return -1;
		};

		$scope.getModalObjectConnectivity = () => {
			$scope.configDetails.networkInfo.proxyConnectivityOption = 0;
			$scope.locals.proxyClientGroup = $scope.getAsObject($scope.locals.proxyClientGroup);
			$scope.configDetails.networkInfo.proxyEntity.clientGroupId = $scope.locals.proxyClientGroup.clientGroupId;
			$scope.configDetails.networkInfo.proxyEntity.clientGroupName = $scope.locals.proxyClientGroup.clientGroupName;
			//needs to be sent to prevent erasure
			$scope.configDetails.failoverScheduleDetails.liveSyncRPO = $scope.values.liveSyncRPO;

			const obj = {
				csFailoverConfigInfo: {
					failoverScheduleDetails: $scope.configDetails.failoverScheduleDetails,
					networkInfo: $scope.configDetails.networkInfo
				}
			};

			return obj;
		};
	}
];

liveSyncControllers.configureCvLiveSyncModalController = [
	'liveSyncService',
	'$scope',
	'$dialogs',
	'cvLoc',
	'$log',
	'cvUtil',
	'$state',
	'alertUIFactory',
	'LiveSyncConstants',
	'cvTableOptions',
	'cvToaster',
	function(
		liveSyncService,
		$scope,
		$dialogs,
		cvLoc,
		$log,
		cvUtil,
		$state,
		alertUIFactory,
		LiveSyncConstants,
		cvTableOptions,
		cvToaster
	) {
		$scope.serverMessage = cvUtil.emptyMsg();

		function getAsArray(value) {
			return angular.isArray(value) ? value : new Array(value);
		}

		$scope.alertNotifTypesError = {
			error: cvUtil.emptyMsg()
		};
		setTimeout(function() {
			alertUIFactory.initializeAddUserSelect($scope.alertNotifTypesError);
		}, 1);

		$scope.availableNodesGridOptions = () => {
			let gridOptions = {};
			gridOptions.data = $scope.availableMonitoringNodes;
			gridOptions.columns = getAvailableNodesGridColumns({ cvLoc });
			gridOptions.tableName = 'availableNodesTable';
			gridOptions.hasViews = true;
			gridOptions.pageSize = 10;
			gridOptions.idField = 'clientName';
			gridOptions.enableCheckBoxColumn = true;
			gridOptions.enableMultiSelect = true;
			gridOptions.hideToolbar = true;
			gridOptions.sortDirection = {
				field: 'clientName',
				dir: 'asc'
			};
			gridOptions.gridEmptyMessage = '<div class="text-align-center">' + cvLoc('info.noNodeInfoAvailable') + '</div>';
			gridOptions.beforeGridInitialize = ({ grid }) => {
				$scope.availableNodeGrid = grid;
			};
			$scope.availableClientsGridOptions = gridOptions;
		};

		$scope.availableNodesGridOptions();

		$scope.onSave = function() {
			switch ($scope.editing) {
				case 'replication':
					updateReplication();
					break;
				case 'alert':
					createAlert();
					break;
				case 'connectivity':
					updateConnectivity();
					break;
				case 'MonitoringClients':
					updateMonitoringClientsNodes();
					break;
				default:
					$log.error('Tile is not recognized');
			}
		};

		function updateReplication() {
			$scope.setFailOverConfig($scope.getModalObjectReplication()).then(err => {
				if (err) {
					$scope.toggleValue('configStatus');
					$scope.updateLocals('liveSyncRPO', 'backupStoragePolicy', 'enableAutomaticFailover');
					cvToaster.showErrorMessage({
						ttl: '10000',
						message: err ? err : cvLoc('generic_error')
					});
				} else {
					$scope.updateValues('liveSyncRPO', 'backupStoragePolicy', 'enableAutomaticFailover');
					if ($scope.values.enableAutomaticFailover) {
						$scope.getFailOverConfig();
					}
					$scope.modal.showMonitoringNodeTile = $scope.values.configStatus && $scope.values.enableAutomaticFailover;
				}
				$scope.clearEdit();
				$scope.dismissModal();
			});
		}

		function updateMonitoringClientsNodes() {
			$scope.local.selectedMonitoringNodes = [];
			$scope.selectedNodes = $scope.availableNodeGrid.getSelectedRows();
			$scope.local.selectedMonitoringNodes = $scope.local.selectedMonitoringNodes.concat(
				$scope.selectedNodes.values.map(function(node) {
					return {
						clientId: node.clientId,
						clientName: node.clientName,
						status: node.status,
						lastSyncTime: node.lastSyncTime
					};
				})
			);
			if ($scope.local.selectedMonitoringNodes.length == 0) {
				cvToaster.showErrorMessage({
					ttl: '10000',
					message: cvLoc('error.noNodeSelected')
				});
			} else {
				if (
					$scope.MonitoringNodes.length + $scope.local.selectedMonitoringNodes.length <=
					LiveSyncConstants.DEFAULT_MAX_MONITORING_NODE
				) {
					$scope.action = 'add';
					$scope.setFailOverConfig($scope.getModalObjectMonitoringClients($scope.action)).then(err => {
						if (err) {
							$scope.local.monitoringNodes = [];
							$scope.local.availableMonitoringNodes = [];
							cvToaster.showErrorMessage({
								ttl: '10000',
								message: err ? err : cvLoc('generic_error')
							});
						} else {
							$scope.updateMonitoringClients();
						}
						$scope.action = '';
						$scope.clearEdit();
						$scope.dismissModal();
					});
				} else {
					cvToaster.showErrorMessage({
						ttl: '10000',
						message: cvLoc('error.monitoringNodesAdditionNotAllowed')
					});
				}
			}
		}

		function updateConnectivity() {
			$scope.setFailOverConfig($scope.getModalObjectConnectivity()).then(err => {
				if (err) {
					$scope.toggleValue('useExternalGateway');
					$scope.updateLocals('proxyClientGroup');
					cvToaster.showErrorMessage({
						ttl: '10000',
						message: err ? err : cvLoc('generic_error')
					});
				} else {
					$scope.updateValues('proxyClientGroup');
				}
				$scope.clearEdit();
				$scope.dismissModal();
			});
		}

		function createAlert() {
			$scope.alertDef = {
				alertrule: {
					alertName: $scope.locals.alertName
				},
				alertType: LiveSyncConstants.DEFAULT_ALERT_TYPE,
				notifType: ['EMAIL'],
				alertStatus: {
					processDiscoveredVMs: false,
					isDefaultAlert: true
				},
				recipientUserList: [],
				recipientUserGroupList: [],
				recipientadUserGroupList: [],
				nonGalaxyList: { nonGalaxyUserList: [] },
				locale: {
					localeID: 0,
					localeName: 'en'
				},
				criteria: {
					paramsList: [],
					criteria: LiveSyncConstants.DEFAULT_ALERT_CRITERIA
				},
				EntityList: {
					associations: [
						{
							entityType: '2'
						}
					]
				}
			};

			alertUIFactory.getUsers($scope.alertDef, $('#toUserList'), 'TO');
			alertUIFactory.getUsers($scope.alertDef, $('#ccUserList'), 'CC');
			alertUIFactory.getUsers($scope.alertDef, $('#bccUserList'), 'BCC');

			liveSyncService
				.createAlertDefinition($scope.alertDef)
				.success(function(data) {
					$log.debug('Successfully created Alert for CommServe LiveSync');
					$scope.dismissModal();
					//reload required for getting auto generated alert id
					$state.forceReload();
				})
				.error(function(data) {
					$log.error('Failed to create Alert for CommServe LiveSync');
					$scope.serverMessage = cvUtil.errMsg(data);
				});
		}
	}
];

liveSyncMod.controller(liveSyncControllers);

export default liveSyncMod;
