(function() {
	'use strict';

	var settingsMod = angular.module('cvModule.settings');

	settingsMod.controller('currentDownloadsTrackerController', [
		'$scope',
		'cvLoc',
		'downloadJobsService',
		function($scope, cvLoc, downloadJobsService) {
			$scope.downloadTrackerHeader = cvLoc('label.downloadTrackerHeader');

			$scope.downloadsState = {
				isOpen: false,
				downloadsProcessing: false
			};

			$scope.downloadItems = [
				{
					name: cvLoc('Loading'),
					id: 0
				}
			];

			$scope.downloadTrackingToggled = function(open) {
				if (!open) {
					$scope.downloadsState = {
						isOpen: false,
						downloadsProcessing: false
					};
					$scope.downloadItems = [
						{
							name: cvLoc('Loading'),
							id: 0
						}
					];
				} else {
					$scope.downloadsState = {
						isOpen: true,
						downloadsProcessing: false
					};
				}
			};

			$scope.showCurrentDownloads = function() {
				return (
					$scope.downloadsState.downloadsProcessing ||
					downloadJobsService.downloadsProcessing ||
					localStorage.getItem('powerRestoreJobs') != null
				); // also include if local storage exists for cross-tab behavior
			};

			$scope.$watch('downloadsState', function() {
				if ($scope.downloadsState.isOpen) {
					downloadJobsService
						.getCurrentDownloads()
						.success(function(data) {
							if (data) {
								if (!data.downloadsProcessing) {
									$scope.downloadItems = [
										{
											name: cvLoc('label.noDownloadsProcessing'),
											id: 0
										}
									];

									setTimeout(function() {
										//this will automatically hide the show current downloads option after 3 seconds
										$scope.downloadsState.downloadsProcessing = false;
										downloadJobsService.downloadsProcessing = false;
									}, 3000);

									//At this point it is confirmed that there are no downloads processing,
									//can be used as an extra measure to clean-up local storage
									if (localStorage.getItem('powerRestoreJobs') === null) {
										return;
									}

									localStorage.removeItem('powerRestoreJobs');
								} else {
									if (data.downloadItems && data.downloadItems.length > 1) {
										data.downloadItems = data.downloadItems.substring(0, data.downloadItems.length - 2);
										var items = data.downloadItems.split(',');
										$scope.downloadItems = items.map(function(item, index) {
											return {
												name: item,
												id: index + 1
											};
										});
										$scope.downloadsState.downloadsProcessing = true;
									} else {
										$scope.downloadItems = [
											{
												name: cvLoc('label.noDownloadsProcessing'),
												id: 0
											}
										];

										setTimeout(function() {
											//this will hide the show current downloads option after 3 seconds
											$scope.downloadsState.downloadsProcessing = false;
											downloadJobsService.downloadsProcessing = false;
										}, 3000);
									}
								}
							}
						})
						.error(function(err) {
							console.log("can't get current downloads.");
						});
				}
			});
		}
	]);
})();
