<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<div class="form-group">
    <script nonce="${sessionScope.cspNonce}">
        <cv:cvMessages bundle="localization.security"></cv:cvMessages>
        <cv:cvMessages bundle="localization.collections"></cv:cvMessages>
    </script>
    <div class="setup-title"><h1 id="title" class="full-width">{{titleKMIP}}</h1>
    </div>
    <div class="setup-content margin-right-15">
        <span ng-if="serverErrorMessage" class="error serverMessage">{{serverErrorMessage}}</span>
        <form name="kmipForm" novalidate data-cv-submit="save()" autocomplete="off">
            <div class="form-group row margin-0 padding-top-10">
                <div class="col-xs-12 col-md-5 col-lg-5">
                    <label for="name">
                        <cv:msg key="label.name" bundle="security" />
                    </label>
                </div>
                <div class="col-xs-12 col-md-7 col-lg-7">
                    <input class="full-width" data-ng-readonly="false" type="text" id="name" name="name" data-ng-model="data.name.value" required maxlength="128"
                    data-ng-change="changedName()"
                    />
                    <span class="error float-left margin-0" data-ng-if="data.name.hasError">
                        <cv:msg key="error.name" bundle="security" />
                    </span>
                </div>
            </div>
            <div class="form-group row margin-0 padding-top-10">
                <div class="col-xs-12 col-md-5 col-lg-5">
                    <label for="cipher">
                        <cv:msg key="label.EncryptionType" bundle="security" />
                    </label>
                </div>
                <div class="col-xs-12 col-md-7 col-lg-7">
                    <select id="cipher" name="cipher" data-ng-model="data.cipher.value" data-ng-disabled="data.cipher.value === '3'" data-ng-change="changedCipher(data.cipher.value)">
                        <option value="2">
                            <cv:msg key="label.blowFish" bundle="security" />
                        </option>
                        <option value="3">
                            <cv:msg key="label.aes" bundle="security" />
                        </option>
                        <option value="4">
                            <cv:msg key="label.serpent" bundle="security" />
                        </option>
                        <option value="5">
                            <cv:msg key="label.twoFish" bundle="security" />
                        </option>
                        <option value="6">
                            <cv:msg key="label.des" bundle="security" />
                        </option>
                        <option value="7">
                            <cv:msg key="label.gost" bundle="security" />
                        </option>
                    </select>
                    <span class="error float-left margin-0" data-ng-if="data.cipher.hasError">
                        <cv:msg key="error.cipher" bundle="security" />
                    </span>
                </div>
            </div>
            <div class="form-group row margin-0 padding-top-10">
                <div class="col-xs-12 col-md-5 col-lg-5">
                    <label for="keyLength">
                        <cv:msg key="label.keyLength" bundle="security" />
                    </label>
                </div>
                <div class="col-xs-12 col-md-7 col-lg-7">
                    <select id="keyLength" name="keyLength" data-ng-model="data.keyLength.value" data-ng-disabled="false">
                        <option ng-repeat="option in keylengthValues" value="{{option.value}}">{{option.name}}</option>
                    </select>
                    <span class="error float-left margin-0" data-ng-if="data.keyLength.hasError">
                        <cv:msg key="error.keyLength" bundle="security" />
                    </span>
                </div>
            </div>
            <div class="form-group row margin-0 padding-top-10">
                <div class="col-xs-12 col-md-5 col-lg-5">
                    <label for="server">
                        <cv:msg key="label.server" bundle="security" />
                    </label>
                </div>
                <div class="col-xs-12 col-md-7 col-lg-7">
                    <input class="full-width" data-ng-readonly="false" type="text" name="server" id="server" data-ng-model="data.server.value" maxlength="128"
                    />
                    <span class="error float-left margin-0" data-ng-if="data.server.hasError">
                        <cv:msg key="error.server" bundle="security" />
                    </span>
                </div>
            </div>
            <div class="form-group row margin-0 padding-top-10">
                <div class="col-xs-12 col-md-5 col-lg-5">
                    <label for="port">
                        <cv:msg key="label.port" bundle="security" />
                    </label>
                </div>
                <div class="col-xs-12 col-md-7 col-lg-7">
                    <input class="full-width" data-ng-readonly="false" type="number" name="port" id="port" data-ng-model="data.port.value" maxlength="128"
                    />
                    <span class="error float-left margin-0" data-ng-if="data.port.hasError">
                        <cv:msg key="error.port" bundle="security" />
                    </span>
                </div>
            </div>         
            <div class="form-group row margin-0 padding-top-10">
                <div class="col-xs-12 col-md-5 col-lg-5">
                    <label for="certificate">
                        <cv:msg key="label.certificate" bundle="security" />
                    </label>
                </div>
                <div class="col-xs-12 col-md-7 col-lg-7">
                    <div class="input-group">
                        <input placeholder="" type="text" id="certificate" name="certificate" data-ng-model="data.certificate.value" maxlength="100" />
                        <span class="input-group-btn">
                            <button type="button" id="outputCertificate" class="btn btn-default"
                            data-ng-click="browseCertificates('certificate')">
                                <cv:msg key="action.browse" bundle="collections" />
                            </button>
                        </span>
                    </div>
                    <div class="margin-left-10">
                        <div class="row">
                            <span class="error float-left margin-0 padding-left-10" data-ng-if="data.certificate.hasError">
                                <cv:msg key="error.mountpath.invalid" bundle="storage" />
                            </span>
                        </div>
                    </div>
                </div>
            </div>
            <div class="form-group row margin-0 padding-top-10">
                <div class="col-xs-12 col-md-5 col-lg-5">
                    <label for="certificateKey">
                        <cv:msg key="label.certificateKey" bundle="security" />
                    </label>
                </div>
                <div class="col-xs-12 col-md-7 col-lg-7">
                    <div class="input-group">
                        <input placeholder="" type="text" id="certificateKey"
                        data-ng-model="data.certificateKey.value" maxlength="100" />
                        <span class="input-group-btn">
                            <button type="button" id="outputCertificateKey" class="btn btn-default"
                             data-ng-click="browseCertificates('certificate_key')">
                                <cv:msg key="action.browse" bundle="collections" />
                            </button>
                        </span>
                    </div>
                    <div class="margin-left-10">
                        <div class="row">
                            <span class="error float-left margin-0 padding-left-10" data-ng-if="data.certificateKey.hasError">
                                <cv:msg key="error.mountpath.invalid" bundle="storage" />
                            </span>
                        </div>
                    </div>
                </div>
            </div>
			<div class="form-group row margin-0 padding-top-10">
                <div class="col-xs-12 col-md-5 col-lg-5">
                    <label for="passphrase">
                        <cv:msg key="label.certificatePassword" bundle="security" />
                    </label>
                </div>
                <div class="col-xs-12 col-md-7 col-lg-7">
                    <input class="full-width" data-ng-readonly="false" type="password" name="passphrase" id="passphrase" data-ng-model="data.passphrase.value" maxlength="128"
                    data-ng-change="changedPassphrase()"
                    />
                    <span class="error float-left margin-0" data-ng-if="data.passphrase.hasError">
                        <cv:msg key="error.certificatePassword" bundle="security" />
                    </span>
                    <span class="error float-left margin-0" data-ng-if="errorSecret">
                        <cv:msg key="label.errorSecretKey" bundle="security" />
                    </span>
                </div>
            </div>
            <div class="form-group row margin-0 padding-top-10">
                <div class="col-xs-12 col-md-5 col-lg-5">
                    <label for="caCertificate">
                        <cv:msg key="label.caCertificate" bundle="security" />
                    </label>
                </div>
                <div class="col-xs-12 col-md-7 col-lg-7">
                    <div class="input-group">
                        <input placeholder="" type="text" id="caCertificate" name="caCertificate" data-ng-model="data.caCertificate.value" maxlength="100" />
                        <span class="input-group-btn">
                            <button type="button" id="outputCACertificate" class="btn btn-default"
                             data-ng-click="browseCertificates('certificate_ca')">
                                <cv:msg key="action.browse" bundle="collections" />
                            </button>
                        </span>
                    </div>
                    <div class="margin-left-10">
                        <div class="row">
                            <span class="error float-left margin-0 padding-left-10" data-ng-if="data.caCertificate.hasError">
                                <cv:msg key="error.mountpath.invalid" bundle="storage" />
                            </span>
                        </div>
                    </div>
                </div>
            </div>
            <div class="button-container">
                <button id="modalKmip_button_#2726" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="close()"> 
                    <cv:msg key="Cancel" />
                </button>
                <button id="modalKmip_button_#8850" type="submit" class="btn btn-primary cvBusyOnAjax"> 
                    <cv:msg key="Save" />
                </button>
            </div>
        </form>
    </div>
</div>