<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<div class="form-group">
	<script nonce="${sessionScope.cspNonce}">
		<cv:cvMessages bundle="localization.security"></cv:cvMessages>;
	</script>
	<div class="setup-title">
		<label for="title">
			<h1 id="title" class="full-width">
				{{ titleAzure }}
			</h1>
		</label>
	</div>
	<div class="setup-content margin-right-15">
		<span ng-if="serverErrorMessage" class="error serverMessage">{{ serverErrorMessage }}</span>
		<form name="azureForm" novalidate autocomplete="off">
			<div class="form-group row margin-0 padding-top-5">
				<div class="col-xs-12 col-md-5 col-lg-5">
					<label for="name">
						<cv:msg key="label.name" bundle="security" />
					</label>
				</div>
				<div class="col-xs-12 col-md-7 col-lg-7">
					<input
						class="full-width"
						data-ng-readonly="false"
						type="text"
						name="azureName"
						id="name"
						data-ng-model="data.name.value"
						required
						maxlength="128"
					/>
					<span class="error float-left margin-0" data-ng-if="data.name.hasError">
						<cv:msg key="error.name" bundle="security" />
					</span>
				</div>
			</div>
			<div class="form-group row margin-0 padding-top-5">
				<div class="col-xs-12 col-md-5 col-lg-5">
					<label for="keyLength">
						<cv:msg key="label.encruption" bundle="security" />
					</label>
				</div>
				<div class="col-xs-12 col-md-7 col-lg-7">
					<select id="keyLength" name="keyLength" data-ng-model="data.keylength.value" data-ng-disabled="false">
						<option ng-repeat="option in keylengthValues" value="{{ option.value }}">{{ option.name }}</option>
					</select>
					<span class="error float-left margin-0" data-ng-if="data.keylength.hasError">
						<cv:msg key="error.encruption" bundle="security" />
					</span>
				</div>
			</div>
			<div class="form-group row margin-0 padding-top-5">
				<div class="col-xs-12 col-md-5 col-lg-5">
					<label for="keyProviderType">
						<cv:msg key="label.EncryptionType" bundle="security" />
					</label>
				</div>
				<div class="col-xs-12 col-md-7 col-lg-7">
					<select
						id="keyProviderType"
						name="keyProviderType"
						data-ng-model="data.encryptionType.value"
						data-ng-disabled="false"
					>
						<option ng-repeat="option in encryptionType" value="{{ option.value }}">{{ option.name }}</option>
					</select>
					<span class="error float-left margin-0" data-ng-if="data.encryptionType.hasError">
						<cv:msg key="error.keyProviderType" bundle="security" />
					</span>
				</div>
			</div>
			<div class="form-group row margin-0 padding-top-5">
				<div class="col-xs-12 col-md-5 col-lg-5">
					<label for="keyVaultName">
						<cv:msg key="label.keyVaultName" bundle="servers" />
					</label>
				</div>
				<div class="col-xs-12 col-md-7 col-lg-7">
					<input
						class="full-width"
						data-ng-readonly="false"
						type="text"
						name="keyVaultName"
						id="name"
						data-ng-model="data.keyVaultName.value"
						required
						maxlength="128"
					/>
					<span class="error float-left margin-0" data-ng-if="data.keyVaultName.hasError">
						<cv:msg key="error.keyVaultName" bundle="servers" />
					</span>
				</div>
			</div>
			<div class="form-group row margin-0 padding-top-5">
				<div class="col-xs-12 col-md-5 col-lg-5">
					<label for="tenantId">
						<cv-help-text help-label="<cv:msg key="label.tenantId" bundle="servers" />" help-text="'<cv:msg key='label.tenantIdHelpText' bundle='servers' />'"/>
					</label>
				</div>
				<div class="col-xs-12 col-md-7 col-lg-7">
					<input
						class="full-width"
						data-ng-readonly="false"
						type="text"
						name="azureTenantId"
						id="name"
						data-ng-model="data.tenantId.value"
						required
						maxlength="128"
					/>
					<span class="error float-left margin-0" data-ng-if="data.tenantId.hasError">
						<cv:msg key="error.tenantId" bundle="servers" />
					</span>
				</div>
			</div>
			<div class="form-group row margin-0 padding-top-5">
				<div class="col-xs-12 col-md-5 col-lg-5">
					<label for="applicationId">
						<cv-help-text help-label="<cv:msg key="label.applicationId" bundle="servers" />" help-text="'<cv:msg key='label.applicationIdHelpText' bundle='servers' />'"/>
					</label>
				</div>
				<div class="col-xs-12 col-md-7 col-lg-7">
					<input
						class="full-width"
						data-ng-readonly="false"
						type="text"
						name="applicationId"
						id="name"
						data-ng-model="data.applicationId.value"
						required
						maxlength="128"
					/>
					<span class="error float-left margin-0" data-ng-if="data.applicationId.hasError">
						<cv:msg key="error.applicationId" bundle="servers" />
					</span>
				</div>
			</div>
			<div class="form-group row margin-0 padding-top-5">
				<div class="col-xs-12 col-md-5 col-lg-5">
					<label for="certificate">
						<cv:msg key="label.certificate" bundle="security" />
					</label>
				</div>
				<div class="col-xs-12 col-md-7 col-lg-7">
					<div class="input-group">
						<input
							placeholder=""
							type="text"
							id="certificate"
							name="certificate"
							data-ng-model="data.certificate.value"
							maxlength="100"
						/>
						<span class="input-group-btn">
							<button type="button" id="outputCertificate" class="btn btn-default" data-ng-click="browseCertificates()">
								<cv:msg key="action.browse" bundle="collections" />
							</button>
						</span>
					</div>
					<div class="margin-left-10">
						<div class="row">
							<span class="error float-left margin-0 padding-left-10" data-ng-if="data.certificate.hasError">
								<cv:msg key="error.certificate" bundle="servers" />
							</span>
						</div>
					</div>
				</div>
			</div>
			<div class="form-group row margin-0 padding-top-5">
				<div class="col-xs-12 col-md-5 col-lg-5">
					<label for="certificateThumbprint">
						<cv:msg key="label.certificateThumbprint" bundle="servers" />
					</label>
				</div>
				<div class="col-xs-12 col-md-7 col-lg-7">
					<input
						class="full-width"
						data-ng-readonly="false"
						type="text"
						name="certificateThumbprint"
						id="name"
						data-ng-model="data.certificateThumbprint.value"
						required
						maxlength="128"
					/>
					<span class="error float-left margin-0" data-ng-if="data.certificateThumbprint.hasError">
						<cv:msg key="error.certificateThumbprint" bundle="servers" />
					</span>
				</div>
			</div>
			<div class="form-group row margin-0 padding-top-5">
				<div class="col-xs-12 col-md-5 col-lg-5">
					<label for="certificatePassword">
						<cv:msg key="label.certificatePassword" bundle="servers" />
					</label>
				</div>
				<div class="col-xs-12 col-md-7 col-lg-7">
					<input
						class="full-width"
						data-ng-readonly="false"
						type="password"
						name="certificatePassword"
						id="name"
						data-ng-model="data.certificatePassword.value"
						required
						maxlength="128"
					/>
					<span class="error float-left margin-0" data-ng-if="data.certificatePassword.hasError">
						<cv:msg key="error.certificatePassword" bundle="servers" />
					</span>
				</div>
			</div>
			<div class="form-group row margin-0 padding-top-5">
    			<div class="col-xs-12 col-md-5 col-lg-5">
					<label for="environment">
                        <cv-help-text help-label="<cv:msg key="label.environment" bundle="servers" />" help-text="'<cv:msg key='label.environmentHelpText' bundle='servers' />'"/>
                    </label>
				</div>
				<div class="col-xs-12 col-md-7 col-lg-7">
                    <isteven-multi-select
                        directive-id="environment"
                        input-model="environment"
                        output-model="data.environment.value"
                        button-label="name"
                        item-label="name"
                        id="environment"
                        tick-property="selected"
                        class="grid-filter-isteven-multi-select isteven-multi-select user-group-select grid-column-filter"
                        helper-elements="filter"
                        selection-mode="single"
                        on-item-click="changeEnvironment(data)"
                        search-property="name"
                    >
                    </isteven-multi-select>
                    <span class="error float-left margin-0" data-ng-if="data.environment.hasError">
                        <cv:msg key="error.environment" bundle="servers"/>
                    </span>
                </div>
            </div>
            
            <div class="form-group row margin-0 padding-top-5">
                <small data-ng-click="showEndpoints()">
                    <a href=""><cv:msg key="label.showEndpoints" bundle="servers" /></a>
               </small>                  
           </div>
            
			<div class="form-group row margin-0 padding-top-5" data-ng-if="showEndpoint">
				<div class="col-xs-12 col-md-5 col-lg-5">
					<label for="authenticationEndpoint">
						<cv:msg key="label.authenticationEndpoint" bundle="servers" />
					</label>
				</div>
				<div class="col-xs-12 col-md-7 col-lg-7">
					<input
						class="full-width"
						data-ng-readonly="false"
						type="text"
						name="azureTenantId"
						id="name"
						data-ng-model="data.authenticationEndpoint.value"
						required
						maxlength="128"
					/>
					<span class="error float-left margin-0" data-ng-if="data.authenticationEndpoint.hasError">
						<cv:msg key="error.authenticationEndpoint" bundle="servers" />
					</span>
				</div>
			</div>
			<div class="form-group row margin-0 padding-top-5" data-ng-if="showEndpoint">
				<div class="col-xs-12 col-md-5 col-lg-5">
					<label for="keyVaultEndpoint">
						<cv:msg key="label.keyVaultEndpoint" bundle="servers" />
					</label>
				</div>
				<div class="col-xs-12 col-md-7 col-lg-7">
					<input
						class="full-width"
						data-ng-readonly="false"
						type="text"
						name="keyVaultEndpoint"
						id="name"
						data-ng-model="data.keyVaultEndpoint.value"
						required
						maxlength="128"
					/>
					<span class="error float-left margin-0" data-ng-if="data.keyVaultEndpoint.hasError">
						<cv:msg key="error.keyVaultEndpoint" bundle="servers" />
					</span>
				</div>
			</div>
			<div class="button-container">
				<button id="modalAzure_button_#1466" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="close()">
					<cv:msg key="Cancel" />
				</button>
				<button id="modalAzure_button_#9273" type="submit" class="btn btn-primary cvBusyOnAjax" data-ng-click="save()">
					<cv:msg key="Save" />
				</button>
			</div>
		</form>
	</div>
</div>
