<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<div class="form-group">
    <script nonce="${sessionScope.cspNonce}">
        <cv:cvMessages bundle="localization.security"></cv:cvMessages>
    </script>
    <div class="setup-title">
        <label for="title">
            <h1 id="title" class="full-width">
                {{titleAWS}}
            </h1>
        </label>
    </div>
    <div class="setup-content margin-right-15">
        <span ng-if="serverErrorMessage" class="error serverMessage">{{serverErrorMessage}}</span>
        <form name="awsForm" novalidate data-cv-submit="addAWS()" autocomplete="off">
            <div class="form-group row margin-0 padding-top-10">
                <div class="col-xs-12 col-md-5 col-lg-5">
                    <label for="name">
                        <cv:msg key="label.name" bundle="security" />
                    </label>
                </div>
                <div class="col-xs-12 col-md-7 col-lg-7">
                    <input data-ng-change="changedName()" class="full-width" data-ng-readonly="false" type="text" name="name" id="name" data-ng-model="data.name.value" required maxlength="128"
                    />
                    <span class="error float-left margin-0" data-ng-if="data.name.hasError">
                        <cv:msg key="error.name" bundle="security" />
                    </span>
                </div>
            </div>
            <div class="form-group row margin-0 padding-top-10">
                <div class="col-xs-12 col-md-5 col-lg-5">
                    <label for="region">
                        <cv:msg key="label.region" bundle="security" />
                    </label>
                </div>
                <div data-ng-class="{'hidden': isEditing}" class="col-xs-12 col-md-7 col-lg-7">
                    <isteven-multi-select
                        input-model="regions"
                        output-model="selectedRegion"
                        button-label="regionName"
                        item-label="regionName"
                        on-close="changedRegionItem()"
                        helper-elements="none"
                        id="region"
                        name="region"
                        hide-search-button="true"
                        tick-property="selected"
                        disable-property="disabled"
                        class="isteven-multi-select user-group-select"
                        selection-mode="single">
                    </isteven-multi-select>
                    <span class="error float-left margin-0" data-ng-if="data.regionName.hasError">
                        <cv:msg key="error.region" bundle="security" />
                    </span>
                </div>
                <div data-ng-class="{'hidden': !isEditing}" class="col-xs-12 col-md-7 col-lg-7">
                    <select id="region" name="region"  data-ng-disabled="true">
                        <option value="data.regionCode.value">{{data.regionName.value}}</option>
                    </select>
                </div>
            </div>
            <div class="form-group row margin-0 padding-top-10">
                <div class="col-xs-12 col-md-5 col-lg-5">
                    <label for="accessKey">
                        <cv:msg key="label.accessKey" bundle="security" />
                    </label>
                </div>
                <div class="col-xs-12 col-md-7 col-lg-7">
                    <input class="full-width" data-ng-readonly="false" type="text" id="accessKey" name="accessKey"
                    data-ng-model="data.accessKey.value" maxlength="128" />
                    <span class="error float-left margin-0" data-ng-if="data.accessKey.hasError">
                        <cv:msg key="error.accessKey" bundle="security" />
                    </span>
                </div>
            </div>
            <div class="form-group row margin-0 padding-top-10">
                <div class="col-xs-12 col-md-5 col-lg-5">
                    <label for="secretAccess">
                        <cv:msg key="label.secretAccess" bundle="security" />
                    </label>
                </div>
                <div class="col-xs-12 col-md-7 col-lg-7">
                    <input class="full-width" data-ng-readonly="false" type="password" id="secretAccess" name="secretAccess"
                    data-ng-model="data.secretAccess.value" maxlength="128" />
                    <span class="error float-left margin-0" data-ng-if="data.secretAccess.hasError">
                        <cv:msg key="error.confirmSecret" bundle="security" />
                    </span>
                    <span class="error float-left margin-0" data-ng-if="errorSecret && !error.confirmSecret">
                        <cv:msg key="label.errorSecretKey" bundle="security" />
                    </span>
                </div>
            </div>
            <div class="button-container">
                <button id="modalAws_button_#4755" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="close()"> 
                    <cv:msg key="Cancel" />
                </button>
                <button id="modalAws_button_#6794" type="submit" class="btn btn-primary cvBusyOnAjax" data-ng-click="save()"> 
                    <cv:msg key="Save" />
                </button>
            </div>
        </form>
    </div>
</div>