<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}">
    <cv:cvMessages bundle="localization.snapArray"></cv:cvMessages>
    <cv:cvMessages bundle="localization.servers"></cv:cvMessages>
    <cv:cvMessages bundle="localization.security"></cv:cvMessages>
</script>
<div class="row">
    <div class="col-md-12">
        <h1 class="float-left">{{keyName}}</h1>
        <span>
            <a class="page-action-item" href="" data-ng-click="deleteServerKey()">
                <cv:msg key="action.delete" bundle="snapArray" />
            </a>
        </span>
        <!-- <span>
            <a class="page-action-item" href="" data-ng-click="editKeyDetails(keyType)">
                <cv:msg key="action.edit" bundle="snapArray" />
            </a>
        </span> -->
    </div>
</div>
<div class="row">
    <div class="col-md-6">
        <cv-tile-component data-loader="dataDetails" data-ng-if="typeString[keyType] === 'KMIP'"
        data-title='<cv:msg key="label.general" bundle="snapArray"/>'>
            <div class="page-details-box-links">
                <a href="" data-ng-click="editKeyDetails(keyType)">
                    <cv:msg key="action.edit" bundle="snapArray" />
                </a>
            </div>
            <ul class="list-style-secondary">
                <li class="group">
                    <span class="pageDetailColumn">
                        <cv:msg key="label.type" bundle="security" />
                    </span>
                    <span class="pageDetailColumn">{{typeString[keyType]}}</span>
                </li>
                <li class="group">
                    <span class="pageDetailColumn">
                        <cv:msg key="label.EncryptionType" bundle="security" />
                    </span>
                    <span class="pageDetailColumn">{{typeCipher[dataDetails.encryptionType]}}</span>
                </li>
                <li class="group">
                    <span class="pageDetailColumn">
                        <cv:msg key="label.keyLength" bundle="security" />
                    </span>
                    <span class="pageDetailColumn">{{dataDetails.encryptionKeyLength}}</span>
                </li>
                <li class="group">
                    <span class="pageDetailColumn">
                        <cv:msg key="label.server" bundle="security" />
                    </span>
                    <span class="pageDetailColumn">{{dataDetails.properties.host}}</span>
                </li>
                <li class="group">
                    <span class="pageDetailColumn">
                        <cv:msg key="label.port" bundle="security" />
                    </span>
                    <span class="pageDetailColumn">{{dataDetails.properties.port}}</span>
                </li>
                <small data-ng-click="showListCertifications()">
                     <a href=""><cv:msg key="action.showCertificates" bundle="security" /></a>
                </small>
                <div data-ng-if="showCertifications">
                    <li class="group">
                    <span class="pageDetailColumn">
                        <cv:msg key="label.certificate" bundle="security" />
                    </span>
                    <span class="pageDetailColumn">{{dataDetails.properties.certFilePath}}</span>
                </li>
                <li class="group">
                    <span class="pageDetailColumn">
                        <cv:msg key="label.certificateKey" bundle="security" />
                    </span>
                    <span class="pageDetailColumn">{{dataDetails.properties.keyFilePath}}</span>
                </li>
                <li class="group">
                    <span class="pageDetailColumn">
                        <cv:msg key="label.caCertificate" bundle="security" />
                    </span>
                    <span class="pageDetailColumn">{{dataDetails.properties.caCertFilePath}}</span>
                </li>
                </div>
            </ul>
        </cv-tile-component>
        <cv-tile-component data-loader="dataDetails" data-ng-if="typeString[keyType] === 'AWS KMS'" data-title='<cv:msg key="label.general" bundle="snapArray"/>'>
            <div class="page-details-box-links">
                <a href="" data-ng-click="editKeyDetails(keyType)">
                    <cv:msg key="action.edit" bundle="snapArray" />
                </a>
            </div>
            <ul class="list-style-secondary">
                <li class="group">
                    <span class="pageDetailColumn">
                        <cv:msg key="label.type" bundle="security" />
                    </span>
                    <span class="pageDetailColumn">{{typeString[keyType]}}</span>
                </li>               
                <li class="group">
                    <span class="pageDetailColumn">
                        <cv:msg key="label.region" bundle="security" />
                    </span>
                    <span class="pageDetailColumn">{{dataDetails.properties.regionName}}</span>
                </li>
                <li class="group">
                    <span class="pageDetailColumn">
                        <cv:msg key="label.accessKey" bundle="security" />
                    </span>
                    <span class="pageDetailColumn">{{dataDetails.properties.userAccount.userName}}</span>
                </li> 
            </ul>
        </cv-tile-component>
        
        <cv-tile-component data-loader="dataDetails" data-ng-if="typeString[keyType] === 'PASSPHRASE'" data-title='<cv:msg key="label.general" bundle="snapArray"/>'>
            <div class="page-details-box-links">
                <a href="" data-ng-click="editKeyDetails(keyType)">
                    <cv:msg key="action.edit" bundle="snapArray" />
                </a>
            </div>
            <ul class="list-style-secondary">
                <li class="group">
                    <span class="pageDetailColumn">
                        <cv:msg key="label.type" bundle="security" />
                    </span>
                    <span class="pageDetailColumn">{{typeString[keyType]}}</span>
                </li>
                <li class="group">
                    <span class="pageDetailColumn">
                        <cv:msg key="label.EncryptionType" bundle="security" />
                    </span>
                    <span class="pageDetailColumn">{{typeCipher[dataDetails.encryptionType]}}</span>
                </li>
                <li class="group">
                    <span class="pageDetailColumn">
                       <cv:msg key="label.keyLength" bundle="security" />
                    </span>
                    <span class="pageDetailColumn">{{dataDetails.encryptionKeyLength}}</span>
                </li>
                
                 <li class="group">
                    <span class="pageDetailColumn">
                        <cv:msg key="label.passphraseFileName" bundle="security" />
                    </span>
                    <span class="pageDetailColumn">{{dataDetails.properties.passphraseFileName}}</span>
                </li>
                
                 <li class="group">
                    <span class="pageDetailColumn">
                        <cv:msg key="label.passphrase" bundle="security" />
                    </span>
                 	 <div class="pagedetailcolumn inline-editor">   
                    	<span class="inline-editor-text">*******</span>
                    	<span  class="inline-editor-buttons">
       						 <a href="" class="inline-editor-buttons text " data-ng-click="updatePassphrase()">
               					  <cv:msg key="action.edit" bundle="snapArray" />
       					 	</a>
  					 	</span>
              		</div>  
            	  </li>
            </ul>
        </cv-tile-component>
        <cv-tile-component data-loader="dataDetails" data-ng-if="typeString[keyType] === 'AZURE KEY VAULT'" data-title='<cv:msg key="label.general" bundle="snapArray"/>'>
            <div class="page-details-box-links">
                <a href="" data-ng-click="editKeyDetails(keyType)">
                    <cv:msg key="action.edit" bundle="snapArray" />
                </a>
            </div>
            <ul class="list-style-secondary">
                <li class="group">
                    <span class="pageDetailColumn">
                        <cv:msg key="label.type" bundle="security" />
                    </span>
                    <span class="pageDetailColumn">{{typeString[keyType]}}</span>
                </li>
                <li class="group">
                    <span class="pageDetailColumn">
                        <cv:msg key="label.name" bundle="security" />
                    </span>
                    <span class="pageDetailColumn">{{dataDetails.provider.keyProviderName}}</span>
                </li>
                <li class="group">
                    <span class="pageDetailColumn">
                        <cv:msg key="label.EncryptionType" bundle="security" />
                    </span>
                    <span class="pageDetailColumn">{{typeCipher[dataDetails.encryptionType]}}</span>
                </li>
                <li class="group">
                    <span class="pageDetailColumn">
                        <cv:msg key="label.keyLength" bundle="security" />
                    </span>
                    <span class="pageDetailColumn">{{dataDetails.encryptionKeyLength}}</span>
                </li>
            </ul>
        </cv-tile-component>
        <cv-tile-component data-loader="dataDetails" data-ng-if="typeString[keyType] === 'AZURE KEY VAULT'" data-title='<cv:msg key="label.keyVault" bundle="servers"/>'>
        <ul class="list-style-secondary">
            <li class="group">
                <span class="pageDetailColumn">
                    <cv:msg key="label.keyVaultName" bundle="servers" />
                </span>
                <span class="pageDetailColumn">{{dataDetails.properties.keyVaultCredential.resourceName}}</span>
            </li>
            <li class="group">
                <span class="pageDetailColumn">
                    <cv:msg key="label.tenantId" bundle="servers" />
                </span>
                <span class="pageDetailColumn">{{dataDetails.properties.keyVaultCredential.tenantId}}</span>
            </li>
            <li class="group">
                <span class="pageDetailColumn">
                    <cv:msg key="label.applicationId" bundle="servers" />
                </span>
                <span class="pageDetailColumn">{{dataDetails.properties.keyVaultCredential.applicationId}}</span>
            </li>
            <li class="group">
                <span class="pageDetailColumn">
                    <cv:msg key="label.environment" bundle="servers" />
                </span>
                <span class="pageDetailColumn">{{dataDetails.properties.keyVaultCredential.environment}}</span>
            </li>
            <li class="group">
                <span class="pageDetailColumn">
                    <cv:msg key="label.authenticationEndpoint" bundle="servers" />
                </span>
                <span class="pageDetailColumn">{{dataDetails.properties.keyVaultCredential.endpoints.activeDirectoryEndpoint}}</span>
            </li>
            <li class="group">
                <span class="pageDetailColumn">
                    <cv:msg key="label.keyVaultEndpoint" bundle="servers" />
                </span>
                <span class="pageDetailColumn">{{dataDetails.properties.keyVaultCredential.endpoints.keyVaultEndpoint}}</span>
            </li>                    
            <li class="group">
               <span class="pageDetailColumn">
                   <cv:msg key="label.certificate" bundle="security" />
               </span>
               <span class="pageDetailColumn">{{dataDetails.properties.keyVaultCredential.certificate}}</span>
           </li>
           <li class="group">
               <span class="pageDetailColumn">
                   <cv:msg key="label.certificateThumbprint" bundle="servers" />
               </span>
               <span class="pageDetailColumn">{{dataDetails.properties.keyVaultCredential.certificateThumbprint}}</span>
           </li>           
        </ul>
        </cv-tile-component>
        <cv-tile-component data-loader="dataDetails" data-ng-if="typeString[keyType] === 'BUILT-IN'" data-title='<cv:msg key="label.general" bundle="snapArray"/>'>
            <!-- <div class="page-details-box-links">
                <a href="" data-ng-click="editKeyDetails(keyType)">
                    <cv:msg key="action.edit" bundle="snapArray" />
                </a>
            </div> -->
            <ul class="list-style-secondary">
                <li class="group">
                    <span class="pageDetailColumn">
                        <cv:msg key="label.name" bundle="security" />
                    </span>
                    <span class="pageDetailColumn">{{dataDetails.provider.keyProviderName}}</span>
                </li>
                <li class="group">
                    <span class="pageDetailColumn">
                        <cv:msg key="label.type" bundle="security" />
                    </span>
                    <span class="pageDetailColumn">{{typeString[keyType]}}</span>
                </li>
                <li class="group">
                    <span class="pageDetailColumn">
                        <cv:msg key="label.EncryptionType" bundle="security" />
                    </span>
                    <span class="pageDetailColumn">{{typeCipher[dataDetails.encryptionType]}}</span>
                </li>
                <li class="group">
                    <span class="pageDetailColumn">
                        <cv:msg key="label.keyLength" bundle="security" />
                    </span>
                    <span class="pageDetailColumn">{{dataDetails.encryptionKeyLength}}</span>
                </li>
                
            </ul>
        </cv-tile-component>
        <div class="page-details-box" data-ng-if="typeString[keyType] === 'PASSPHRASE' && keyManagementGridOptions">
            <div class="page-details">
                <cv-grid cv-grid-options="keyManagementGridOptions"></cv-grid>
            </div>
        </div>
    </div>
    <div class="col-md-6">
        <cv-security-component show-edit='showEdit' entity-type='entityType' generic-entity='genericEntity' associations='formattedSecurityAssociations'
            associations-loaded='associationsLoaded'>
        </cv-security-component>
        <cv-tile-component associations-loaded='entities' data-title='<cv:msg key="title.associativeEntity" bundle="security"/>'>
        
            <ul data-ng-if="entities.length !== 0" class="list-style-secondary">
                <li class="group">
                    <span class="pageDetailColumn userGroupColumn">
                        <b>
                            <cv:msg key="label.EntityType" bundle="security" />
                        </b>
        
                    </span>
                    <span class="pageDetailColumn">
                        <b>
                            <cv:msg key="label.name" bundle="security" />
                        </b>
                    </span>
                </li>
            </ul>
        
            <ul data-ng-if="entities.length !== 0" class="list-style-secondary list-overflow-scroll">
                <li class="group" title="USER" data-ng-repeat="entity in entities">                  
                    <span class="pageDetailColumn inheritedSecurityAssociation userGroupColumn ellipsis-parent ellipsis-content" title="{{entity._type_}}">
                         <span data-ng-if="entity._type_ === 1">
                            <cv:msg key="label.commCell" bundle="security" />
                         </span>                      
                         <span data-ng-if="entity._type_ === 18">
                            <cv:msg key="label.storagePolicyCopy" bundle="security" />
                         </span>                        
                    </span>                    
                      <span class="inheritedSecurityAssociation ellipsis-parent ellipsis-content" title="{{entity.copyName}}">
                        <span data-ng-if="entity._type_ === 1">{{entity.commCellName}}</span>                        
                        <span data-ng-if="entity._type_ === 18">{{entity.storagePolicyName}}  >  {{entity.copyName}}</span> 
					</span>                      
                </li>
            </ul>
            <div class="margin-top-20" data-ng-if="entities.length == 0">
                <cv:msg key="label.noAssociation" bundle="security" />
            </div>
                
        </cv-tile-component>
        
    </div>
</div>