import { acAppSecurityModule } from 'common/js/modules';

acAppSecurityModule.service('keyManagementService', [
	'$http',
	function($http) {
		this.getAllServers = function(params) {
			const request = $http.get(`proxy/CommCell/KeyManagementServers`, httpHeader['jsonDefaultHeader']);
			return request;
		};

		this.getRegions = function(params) {
			const request = $http.get(`proxy/Cloud/Regions?vendor=${params.vendor}`, httpHeader['jsonDefaultHeader']);
			return request;
		};

		this.deleteKeyManagementServer = function(kmsId) {
			const request = $http.delete(`proxy/CommCell/KeyManagementServers/${kmsId}`, httpHeader['jsonDefaultHeader']);
			return request;
		};

		this.createAWS = function(payload) {
			const request = $http.post(`proxy/CommCell/KeyManagementServers`, payload, httpHeader['jsonDefaultHeader']);
			return request;
		};

		this.updateAWS = function(payload) {
			const request = $http.put(`proxy/CommCell/KeyManagementServers`, payload, httpHeader['jsonDefaultHeader']);
			return request;
		};

		this.createKMIP = function(payload) {
			const request = $http.post(`proxy/CommCell/KeyManagementServers`, payload, httpHeader['jsonDefaultHeader']);
			return request;
		};

		this.updateKMIP = function(payload) {
			const request = $http.put(`proxy/CommCell/KeyManagementServers`, payload, httpHeader['jsonDefaultHeader']);
			return request;
		};

		this.createPassphrase = function(payload) {
			const request = $http.post(`proxy/CommCell/KeyManagementServers`, payload, httpHeader['jsonDefaultHeader']);
			return request;
		};

		this.updatePassphrase = function(payload) {
			const request = $http.put(`proxy/CommCell/KeyManagementServers`, payload, httpHeader['jsonDefaultHeader']);
			return request;
		};

		this.createAzure = function(payload) {
			const request = $http.post(`proxy/CommCell/KeyManagementServers`, payload, httpHeader['jsonDefaultHeader']);
			return request;
		};

		this.updateAzure = function(payload) {
			const request = $http.put(`proxy/CommCell/KeyManagementServers`, payload, httpHeader['jsonDefaultHeader']);
			return request;
		};

		this.addLocation = function(payload) {
			const request = $http.post(``, payload, httpHeader['jsonDefaultHeader']);
			return request;
		};

		this.deleteLocation = function(payload) {
			//
		};

		this.getKeyDetails = function(payload) {
			const request = $http.get(
				`proxy/CommCell/KeyManagementServers/${payload.id}?propertyLevel=30`,
				httpHeader['jsonDefaultHeader']
			);
			return request;
		};
	}
]);

export default acAppSecurityModule;
