import 'commonForAllAgents/js/controllers/pushInstallSoftware.ctrl.js';
import 'modules/security/js/services/keyManagement.svc.js';
import 'adminConsole/js/directives/acDirectives.js';
import 'modules/security/js/keyManagement.ctrl.js';
import 'modules/security/js/updatePassphrase.ctrl.js';
import { acAppSecurityModule } from 'common/js/modules';

var securityMod = acAppSecurityModule;
var keyManagementControllers = {};

keyManagementControllers.keyManagementDetailsController = [
	'sharedData',
	'keyManagementFactory',
	'keyManagementService',
	'$stateParams',
	'cvTableOptions',
	'cvLoc',
	'$log',
	'cvUtil',
	'$scope',
	'cvBreadcrumbsTabsFactory',
	'$location',
	'$dialogs',
	'$state',
	'$uibModal',
	'$rootScope',
	'securityFactory',
	'updatePasswordFactory',
	function(
		sharedData,
		keyManagementFactory,
		keyManagementService,
		$stateParams,
		cvTableOptions,
		cvLoc,
		$log,
		cvUtil,
		$scope,
		cvBreadcrumbsTabsFactory,
		$location,
		$dialogs,
		$state,
		$modal,
		$rootScope,
		securityFactory,
		updatePasswordFactory
	) {
		$scope.keyId = $stateParams['keyId'];
		$scope.keyType = $stateParams['type'];
		$scope.keyName = $stateParams['name'];
		$scope.typeCipher = null;
		$scope.encryptionType;
		$scope.entities = [];
		$scope.showCertifications = false;

		// Service
		var objToSend = {
			id: $scope.keyId
		};
		$scope.keyManagementData = [];
		keyManagementService
			.getKeyDetails(objToSend)
			.success(function(data) {
				$scope.dataDetails = data.keyProviders[0];
				if ($scope.dataDetails.associations) {
					$scope.entities = $scope.dataDetails.associations.entity;
					$scope.entities = $scope.entities.filter(item => {
						var type = item._type_;
						return type === 1 || type === 9 || type === 18 || type === 61;
					});
				}
				if ($scope.dataDetails.keyProviderType !== 1) {
					if ($scope.dataDetails.properties.userAccount) {
						let password = $scope.dataDetails.properties.userAccount.password;
						try {
							password = password.replace('', '');
							$scope.dataDetails.properties.userAccount.password = atob(password);
						} catch (error) {
							$scope.dataDetails.properties.userAccount.password = password;
						}
					}
				}

				$scope.typeCipher = keyManagementFactory.encryptionTypeList(cvLoc);

				if ($scope.dataDetails.properties) {
					if ($scope.dataDetails.properties.passphraseClient) {
						$scope.keyManagementData = $scope.dataDetails.properties.passphraseClient;
					}
				}
			})
			.error(function(e) {
				$dialogs.error(cvLoc('label.error'), e.errorMessage);
				$scope.addServerMessage = cvUtil.errMsg(e);
			});

		// Functions table

		$scope.showListCertifications = () => {
			$scope.showCertifications = !$scope.showCertifications;
		};

		$scope.deleteLocation = function(entity) {
			var callBackFunctions = {
				noFunction: function() {},
				yesFunction: function() {
					if ($scope.keyManagementData.length > 2) {
						$scope.confirmDeleteLocation(entity.$$hashKey);
					} else {
						$dialogs.error(cvLoc('label.error'), cvLoc('error.minimunlocation'));
					}
				}
			};
			$dialogs.confirm(
				cvLoc('label.confirmDelete'),
				cvLoc('label.confirmationKeyManagement', '<b>' + entity.client.clientName + '</b>'),
				callBackFunctions
			);
		};

		$scope.confirmDeleteLocation = function(hash) {
			for (var i = 0; i < $scope.keyManagementData.length; i++) {
				const keyManagementItem = $scope.keyManagementData[i];
				if (keyManagementItem) {
					if (keyManagementItem.$$hashKey === hash) {
						delete $scope.keyManagementData[i];
						break;
					}
				}
			}
			let payload = {
				keyProvider: {
					encryptionKeyLength: $scope.dataDetails.encryptionKeyLength,
					encryptionType: $scope.dataDetails.encryptionType,
					keyProviderType: $scope.dataDetails.keyProviderType,
					provider: {
						keyProviderName: $scope.dataDetails.provider.keyProviderName
					},
					properties: {
						passphrase: btoa($scope.dataDetails.properties.passphraseFileName),
						passphraseClient: $scope.keyManagementData.filter(n => n)
					}
				}
			};
			payload = JSON.stringify(payload);
			keyManagementService
				.updatePassphrase(payload)
				.success(data => {
					if (data.errorCode === 0) {
						$log.debug(cvLoc('log.succesUpdatePassphrase'));
						$state.forceReload();
					} else {
						$log.error(cvLoc('error.toUpdatePassphrase'));
						$dialogs.error(cvLoc('label.error'), data.errorMessage);
						$state.forceReload();
					}
				})
				.error(function(data) {
					$dialogs.error(cvLoc('label.error'), data.message);
					$log.error(cvLoc('error.toUpdatePassphrase'));
				});
		};

		$scope.deleteServerKey = function() {
			var callBackFunctions = {
				noFunction: function() {},
				yesFunction: function() {
					$location.path('/keyManagement');
					keyManagementService
						.deleteKeyManagementServer($scope.dataDetails.provider.keyProviderId)
						.success(function(data) {
							$log.debug('Delete Operation success');
							$location.path('#keyManagementDetails');
						})
						.error(function(data) {
							$dialogs.error(cvLoc('label.error'), cvUtil.errMsg(data).message);
							$log.error('Delete Opeartion failed');
						});
				}
			};
			$dialogs.confirm(
				cvLoc('label.confirmDelete'),
				cvLoc('label.confirmationKeyManagement', '<b>' + $scope.dataDetails.provider.keyProviderName + '</b>'),
				callBackFunctions
			);
		};

		$scope.editKeyDetails = function(type) {
			switch (type) {
				case '2':
					keyManagementFactory.addKMIP($scope, $rootScope, $modal, cvLoc, $scope.dataDetails);
					break;
				case '3':
					keyManagementFactory.addAWS($scope, $rootScope, $modal, cvLoc, $scope.dataDetails);
					break;
				case '4':
					keyManagementFactory.addAzure($scope, $rootScope, $modal, cvLoc, $scope.dataDetails);
					break;
				case '6':
					$scope.dataDetails.typeToShow = 'general';
					keyManagementFactory.addPassphrase($scope, $rootScope, $modal, cvLoc, $scope.dataDetails);
					break;

				default:
					break;
			}
		};

		$scope.updatePassphrase = function() {
			updatePasswordFactory.updatePassphraseCredential($scope, $rootScope, $modal, cvLoc, $scope.dataDetails, true);
		};

		$scope.initPassphrase = function() {
			// Functions

			$scope.addLocation = function() {
				$scope.dataDetails.typeToShow = 'location';
				keyManagementFactory.addPassphrase($scope, $rootScope, $modal, cvLoc, $scope.dataDetails);
			};

			// For the Table
			var globalGridOptions = angular.copy(cvTableOptions.commonNgGridOptions);
			angular.extend(globalGridOptions, {
				data: 'keyManagementData',
				showGridFooter: true,
				enableGridMenu: false,
				columnDefs: [
					{
						field: 'client.clientName',
						sort: {
							direction: 'asc',
							priority: 0
						},
						displayName: cvLoc('label.client'),
						enableHiding: false,
						cellTemplate:
							'<a href="#/clientDetails/{{row.entity.client.clientId}}">{{row.entity.client.clientName}}</a>',
						width: '30%'
					},
					{
						field: 'filePath.path',
						displayName: cvLoc('label.path'),
						enableHiding: false,
						cellTemplate: '<span>{{row.entity.filePath.path}}</span>',
						width: '30%'
					},
					{
						name: 'action',
						displayName: cvLoc('label.actions'),
						enableHiding: false,
						enableFiltering: false,
						enableSorting: false,
						cellTemplate:
							'<div class="btn-group" uib-dropdown><a href class="uib-dropdown-toggle" uib-dropdown-toggle ng-disabled="disabled"><span class="grid-action-icon"></span></a><ul uib-dropdown-menu class="dropdown-menu" role="menu"><li><a href="" class="ui-grid-action-items" ng-click="grid.appScope.deleteLocation(row.entity)">' +
							cvLoc('label.deleteLocation') +
							'</a></li> </ul></div>',
						width: '20%'
					}
				]
			});

			$scope.keyManagementGridOptions = {
				cvPageLinks: [
					{
						label: cvLoc('label.edit'),
						onclick: $scope.addLocation
					}
				],
				cvGridTitle: cvLoc('title.exportLocation'),
				cvTableName: '',
				cvIsSearchable: false,
				cvIsPageTitle: false,
				cvSearchFields: ['provider.keyProviderName'],
				cvServerMessage: '',
				cvAppScope: $scope,
				gridOptions: globalGridOptions
			};
		};

		$scope.typeString = {
			'1': cvLoc('label.builtIn'),
			'2': cvLoc('label.kmip'),
			'3': cvLoc('label.AwsKms'),
			'4': cvLoc('label.AzureKey'),
			'5': cvLoc('label.safenet'),
			'6': cvLoc('label.passPhrase')
		};

		if ($scope.keyType === '6') {
			$scope.initPassphrase();
		}

		cvBreadcrumbsTabsFactory.addBreadCrumbs([
			{
				title: cvLoc('title.keyManagement'),
				link: '#keyManagement'
			}
		]);

		// Declarations

		// Security
		$scope.entityType = 'KEY_MANAGEMENT_SERVER_ENTITY';

		$scope.genericEntity = {
			keyProviderId: parseInt($scope.keyId) || null
		};

		$scope.formattedSecurityAssociations = securityFactory.createSecurityAssociationsObject();
		$scope.associationsLoaded = false;

		securityFactory.getSecurityAssociation($scope.entityType, parseInt($scope.keyId)).success(function(data) {
			$scope.formattedSecurityAssociations = securityFactory.formatSecurityAssociationsObject(
				data.securityAssociations
			);
			$scope.associationsLoaded = true;
		});
	}
];

securityMod.controller(keyManagementControllers);

export default securityMod;
