<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
	<cv:cvMessages bundle="localization.schedule"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1>{{title}}</h1>
</div> 
<div class="setup-content schedule">
	<div class="{{addScheduleServerMessage.type}} serverMessage">{{addScheduleServerMessage.message}}</div>
	<form name="addScheduleForm" data-cv-submit="addSchedule()" cv-hide-api novalidate autocomplete="off" class="schedules-form add-schedule select-server" id="schedules-form">
		<!-- // scrolling div start // -->
		<div >
		<div data-ng-disabled="!model.showEdit">
		<!-- // name // -->
		<div class="modal-wrapper" data-ng-if="!hideScheduleName && !isScheduleSettings">
			<label for="name" class="label wrap-normal"><cv:msg key="label.name" bundle="schedule"/></label>
			<div class="inline-wrapper">
				<input type="text" name="name" data-ng-model="model.name" id="name" />
			</div>
		</div>
		<!-- // backup level // -->
			<div class="modal-wrapper extra-top-spacing" data-ng-show="model.backupLevel && model.backupLevel != 'NONE' && !isSlaSchedule && !model.isVaultTrackerPlan && !isScheduleSettings && !isWorkflowSchedule">
			<label for="backupLevel" class="label wrap-normal"><cv:msg key="label.backupLevel" bundle="schedule"/></label>
			<div class="inline-wrapper">
				<div class="frequency">
				<label for="btIncremental" data-ng-if="isIncrementalSupported">
					<input id="btIncremental" type="radio" name="backupLevel" value="INCREMENTAL"
						data-ng-model="model.backupLevel" /><cv:msg bundle="schedule" key="option.incremental"/>
				</label>
				<label for="btFull">
					<input id="btFull" type="radio" name="backupLevel" value="FULL"
						data-ng-model="model.backupLevel" /><cv:msg bundle="schedule" key="option.full" />
				</label>
				<cv:comp name="show.synthFull">
					<label for="btSynthFull" data-ng-if="isSyntheticFullSupported">
						<input id="btSynthFull" type="radio" name="backupLevel" value="SYNTHETIC_FULL"
							data-ng-model="model.backupLevel" /><cv:msg bundle="schedule" key="option.synthfull" />
					</label>
				</cv:comp>
				<label for="btTransactionLog" data-ng-if="isTransactionLogSupported">
					<input id="btTransactionLog" type="radio" name="backupLevel" value="TRANSACTION_LOG"
						data-ng-model="model.backupLevel" /><cv:msg key="option.transactionlog" bundle="schedule"/>
				</label>
				<label for="btDifferential" data-ng-if="isDifferentialSupported">
					<input id="btDifferential" type="radio" name="backupLevel" value="DIFFERENTIAL"
						data-ng-model="model.backupLevel" /><cv:msg key="option.differential" bundle="schedule"/>
				</label>
				<label for="btCleanup" data-ng-if="isCleanupSupported">
					<input id="btCleanup" type="radio" name="backupLevel" value="STUBBING"
						data-ng-model="model.backupLevel" /><cv:msg key="option.cleanup" bundle="schedule"/>
				</label>
				</div>
			</div>
		</div>
        <!--          Install update       -->
       <div data-ng-if="isInstallUpdateSchedule">
        <uib-accordion close-others="true" class=" text-left">
			<div uib-accordion-group data-is-open="accordionStatus.serversList">   
				<uib-accordion-heading >
				<i class="float-right glyphicon" data-ng-class="{'glyphicon-chevron-down': accordionStatus.serversList, 'glyphicon-chevron-right': !accordionStatus.serversList}"></i>
				<cv:msg key="label.selectServers" bundle="schedule"/>  
				</uib-accordion-heading>      
				<div class="modal-list">
					<cv-entity-selection-tree-component
						data-mode="edit"
						data-tree-options="treeParams">
					</cv-entity-selection-tree-component>
				</div>
			</div>
		</uib-accordion>
		</div>
		<!-- Granular recovery -->
		<!-- hiding this setting as it has been moved to subclient level
		<div class="modal-wrapper extra-top-spacing">
			<div class="inline-wrapper">
				<cv:comp name="show.granularRecovery">
					<div class="frequency" data-ng-if="showGranularRecovery">
						<input id="backupOptionCollectMetadata" data-ng-model="model.collectMetadata" type="checkbox">
						<label for="backupOptionCollectMetadata"><cv:msg bundle="schedule" key="option.enableGranularRecovery" /></label>
					</div>
				</cv:comp>
			</div>
		</div>
 		-->
		<!-- // frequency // -->
		<div class="modal-wrapper extra-top-spacing" data-ng-hide="isSlaSchedule || isScheduleSettings">
		<label for="scheduleFrequency" class="label wrap-normal"><cv:msg key="label.scheduleFrequency" bundle="schedule"/></label>
			<div class="inline-wrapper">
				<isteven-multi-select id="addScheduleModal_isteven-multi-select_#5119" 
	   				  input-model="freqArr"
					  output-model="model.freqTypeObj"
	  				  button-label="label"
	  				  item-label="label"
	   				  tick-property="selected"
	   				  prevent-sort="true"
	   				  class="isteven-multi-select user-group-select"
	   				  directive-id="isteven-multi-select-freq"
					  selection-mode="single"
					  on-item-click="selectFreq( data )"
	   				  translation="localLang">
				</isteven-multi-select>
			</div>
		</div>
		<!-- Interval between two jobs-->
		<div class="modal-wrapper extra-top-spacing" data-ng-if="model.freqType == 'AFTER_JOB_COMPLETES'">
			<h4 style="margin:0px;"><cv:msg key="label.jobInterval" bundle="schedule"/></h4>
			<label for="intervalBetweenTwoJobs" class="label wrap-normal"><cv:msg key="label.intervalBetweenTwoJobs" bundle="schedule"/></label>
			<div class="inline-wrapper">
				<div data-ng-if="!isSlaSchedule" >
					<input type="number" min="0" name="intervalBetweenTwoJobs" id="intervalBetweenTwoJobs" data-ng-model="model.freq_interval"/>&nbsp;<label for="intervalBetweenTwoJobs" class="inline-label"><cv:msg key="label.minutes" bundle="schedule" /></label>
				</div>
				<label data-ng-if="isSlaSchedule" class="inline-label" data-ng-bind="model.freq_interval"></label>
			</div>
		</div>
  
		<!-- // time // -->
		<div class="modal-wrapper" data-ng-if="model.freqType == 'WEEKLY' || model.freqType == 'DAILY' || model.freqType == 'MONTHLY' || model.freqType == 'MONTHLY_RELATIVE' || model.freqType == 'YEARLY' || model.freqType == 'YEARLY_RELATIVE'">   
			<label for="scheduleTime" data-ng-if="!model.hideTimeInCommServeTimezone" class="label wrap-normal padding-top-20"><cv:msg key="label.clientTime" bundle="schedule"/></label>
			<label for="scheduleTime" data-ng-if=" model.hideTimeInCommServeTimezone" class="label wrap-normal padding-top-20"><cv:msg key="label.timeInAnyTimeZone" bundle="schedule"/></label>
			<div class="inline-wrapper">
				<div uib-timepicker id="scheduleTime" name="scheduleTime" data-ng-model="model.scheduleTime" hour-step="1" minute-step="15" show-meridian="true" show-spinners="false"></div>
				<span class="error cv-help-block ng-scope full-width margin-0" data-ng-show="cv.addScheduleForm.needsAttention(addScheduleForm.scheduleTime) && model.isVaultTrackerPlan">
					<cv:msg key="error.scheduleTime" bundle="schedule"/>
				</span>
			</div>
			<span class="help-block schedule-timer" data-ng-show="cv.addScheduleForm.needsAttention(addScheduleForm.scheduleTime) && !model.isVaultTrackerPlan">
				<cv:msg key="error.scheduleTime" bundle="schedule"/>
			</span>
   
		</div>
		<!-- // days // -->
		<div class="modal-wrapper" data-ng-if="model.freqType == 'WEEKLY'">
			<label for="daysOfWeek" class="label wrap-normal"><cv:msg key="label.daysOfWeek" bundle="settingsJs"/></label>
			<div class="inline-wrapper">
	  			<isteven-multi-select
	   				  input-model="model.daysOfWeek"
	  				  button-label="name"
	  				  item-label="name"
	   				  tick-property="ticked"
	   				  class="isteven-multi-select user-group-select"
	   				  id="isteven-multi-select2"
	   				  max-labels="2"
						 on-open="fOpen()"
						 prevent-sort="true"
	   				  on-close="fClose()" translation="localLang">
				</isteven-multi-select>
			</div>
		</div>
		<!-- // Months -->
		<div class="modal-wrapper extra-top-spacing" data-ng-if="model.freqType == 'MONTHLY' || model.freqType == 'MONTHLY_RELATIVE' || model.freqType == 'YEARLY' || model.freqType == 'YEARLY_RELATIVE'">
			<label for="monthly" class="label wrap-normal" ng-if="model.freqType == 'MONTHLY' || model.freqType == 'MONTHLY_RELATIVE'">
				<input id="monthly" type="radio" name="monthly" value="MONTHLY" data-ng-model="model.freqType" />
				<span class="block-indent"><cv:msg key="label.onDay" bundle="schedule"/></span></label>
			<label for="yearly" class="label wrap-normal" ng-if="model.freqType == 'YEARLY' || model.freqType == 'YEARLY_RELATIVE'">
				<input id="yearly" type="radio" name="yearly" value="YEARLY" data-ng-model="model.freqType"/>
				<span class="block-indent"><cv:msg key="label.onDay" bundle="schedule"/></span></label>
			<div class="inline-wrapper">
				<input data-ng-disabled="model.freqType=='MONTHLY_RELATIVE'" type="number" max="31" min="1" name="dayOfMonth" id="dayOfMonth" data-ng-model="model.dayOfMonth"/>
				<span class="help-block on-day" data-ng-show="cv.addScheduleForm.needsAttention(addScheduleForm.dayOfMonth)"><cv:msg key="error.invalidOnday" bundle="schedule"/></span>
			</div>
		</div>
		<div class="modal-wrapper" data-ng-if="model.freqType == 'MONTHLY' || model.freqType == 'MONTHLY_RELATIVE' || model.freqType == 'YEARLY' || model.freqType == 'YEARLY_RELATIVE'">
			<label for="monthly_relative" class="label wrap-normal" ng-if="model.freqType == 'MONTHLY' || model.freqType == 'MONTHLY_RELATIVE'">
				<input id="monthly_relative" type="radio" name="monthly_relative" value="MONTHLY_RELATIVE" data-ng-model="model.freqType" />
				<span class="block-indent"><cv:msg key="label.onThe" bundle="schedule"/></span></label>
			<label for="yearly_relative" class="label wrap-normal" ng-if="model.freqType == 'YEARLY' || model.freqType == 'YEARLY_RELATIVE'">
				<input id="yearly_relative" type="radio" name="yearly_relative" value="YEARLY_RELATIVE" data-ng-model="model.freqType" />
				<span class="block-indent"><cv:msg key="label.onThe" bundle="schedule"/></span></label>
			<div class="inline-wrapper">
				<label class="select-label week-days-label">
					<select data-ng-disabled="model.freqType=='MONTHLY'" id="weekOfMonth" name="weekOfMonth" data-ng-model="model.weekOfMonth"
						data-ng-options="day.name for day in model.prefixDayList" class="week-days-select">
					</select>
				</label>
				<label class="select-label week-days-label">
					<select data-ng-disabled="model.freqType=='MONTHLY'" id="dayOfWeek" name="dayOfWeek" data-ng-model="model.dayOfWeek"
						data-ng-options="day.name for day in model.days" class="week-days-select">
					</select>
				</label>
			</div>
		</div>
		<div class="modal-wrapper margin-top-10" data-ng-if="model.freqType == 'YEARLY' || model.freqType == 'YEARLY_RELATIVE'">
			<label for="repeat" class="label"><cv:msg key="label.rpo.month" bundle="profiles"/></label>
			<div class="inline-wrapper" ng-bind="model.monthName">
			</div>
		</div>
		<!--//  Job Interval start //-->
		<div data-ng-if="model.freqType == 'AUTOMATIC_SCHEDULE'" data-ng-hide="model.backupLevel=='SYNTHETIC_FULL' || model.isVaultTrackerPlan">
			<h4><cv:msg key="label.jobInterval" bundle="schedule"/></h4>


			<!-- // min intervals // -->
			<div class="modal-wrapper extra-top-spacing" data-ng-if="model.freqType == 'AUTOMATIC_SCHEDULE' && !model.isVaultTrackerPlan" data-ng-hide="model.backupLevel=='SYNTHETIC_FULL'">
				<label for="minBackupIntervalHours" class="label wrap-normal"><cv:msg key="label.min.detectFile" bundle="schedule"/></label>
				<div class="inline-wrapper">
					<div>
						<input type="number" name="minBackupIntervalHours" min="0" id="minBackupIntervalHours" data-ng-change="validateAndManageForceBackup()" data-ng-model="model.minBackupIntervalHours"/>
						<label for="minBackupIntervalHours" class="inline-label"><cv:msg key="label.hours" bundle="schedule" /></label>
						<input type="number" min="0" name="minBackupIntervalMinutes" id="minBackupIntervalMinutes" data-ng-change="validateAndManageForceBackup()" data-ng-model="model.minBackupIntervalMinutes"/>&nbsp;<label for="minBackupIntervalMinutes" class="inline-label"><cv:msg key="label.minutes" bundle="schedule" /></label>
					</div>
				</div>
			</div>
			<!-- // max intervals // -->
			<div class="modal-wrapper" data-ng-if="model.freqType == 'AUTOMATIC_SCHEDULE' && !model.isVaultTrackerPlan" data-ng-hide="model.backupLevel=='SYNTHETIC_FULL'">
				<label for="maxBackupIntervalHours" class="label wrap-normal"><cv:msg key="label.max.forceBackup" bundle="schedule"/></label>
				<div class="inline-wrapper">
					<div>
						<input type="number" min="0" name="maxBackupIntervalHours" id="maxBackupIntervalHours" data-ng-model="model.maxBackupIntervalHours"/>&nbsp;<label for="maxBackupIntervalHours" class="inline-label"><cv:msg key="label.hours" bundle="schedule" /></label>
						<input type="number" min="0" name="maxBackupIntervalMinutes" id="maxBackupIntervalMinutes" data-ng-model="model.maxBackupIntervalMinutes"/>&nbsp;<label for="maxBackupIntervalMinutes" class="inline-label"><cv:msg key="label.minutes" bundle="schedule" /></label>
					</div>
				</div>
			</div>

			<!--  
			<div class="modal-wrapper">
				<label for="minSyncIntervalHours" class="label wrap-normal"><cv:msg key="label.min.syncInterval" bundle="schedule"/></label>
					<div class="inline-wrapper">
						<div>
							<input type="number" min="0" name="minSyncIntervalHours" id="minSyncIntervalHours" data-ng-model="model.minSyncIntervalHours"/>&nbsp;<label for="minSyncIntervalHours" class="inline-label"><cv:msg key="label.hours" bundle="schedule" /></label>
							<input type="number" min="0" name="minSyncIntervalMinutes" id="minSyncIntervalMinutes" data-ng-model="model.minSyncIntervalMinutes"/>&nbsp;<label for="minSyncIntervalMinutes" class="inline-label"><cv:msg key="label.minutes" bundle="schedule" /></label>
						</div>
					</div>
			</div>
			<div class="modal-wrapper">
					<input id="ignoreAtMaxInterval" type="checkbox" name="ignoreAtMaxInterval" value="ignoreAtMaxInterval" data-ng-model="model.ignoreAtMaxInterval" />
					<label for="ignoreAtMaxInterval"><cv:msg bundle="schedule" key="option.ignoreAtMaxInterval"/></label>
			</div>
   
			-->
		</div>
		<!--//  Job Interval end //-->
		<!--//  Network Management start //-->
		<div data-ng-if="model.freqType == 'AUTOMATIC_SCHEDULE'" data-ng-hide="model.backupLevel=='SYNTHETIC_FULL' || model.isVaultTrackerPlan">
			<h4><cv:msg key="label.networkManagement" bundle="schedule"/></h4>
			<div class="modal-wrapper">
				<input id="onlyWiredWork" type="checkbox" name="onlyWiredWork" value="onlyWiredWork" data-ng-model="model.useOnlyWiredWork" />
				<label for="onlyWiredWork"><cv:msg bundle="schedule" key="option.onlyWiredWork"/></label>
			</div>
			<div class="modal-wrapper">
				<input id="minBandwidth" type="checkbox" name="minBandwidth" value="minBandwidth" data-ng-model="model.minNetworkBandwidth" />
				<label for="minBandwidth" class="label extra-left-padding"><cv:msg bundle="schedule" key="option.minBandwidth"/></label>
				<div class="inline-wrapper">
					<div>
						<input type="number" min="0" name="bandwidth" id="bandwidth" data-ng-model="model.networkBandwidth" data-ng-disabled="!model.minNetworkBandwidth"/>&nbsp;<label for="bandwidth" class="inline-label"><cv:msg key="label.bandwidth" bundle="schedule" /></label>
					</div>
				</div>
			</div>
			<div class="modal-wrapper">
				<input id="specificNetwork" type="checkbox" name="specificNetwork" value="specificNetwork"
						data-ng-model="model.useSpecificNetwork" />
						<label for="specificNetwork" class="label extra-left-padding"><cv-call-out placement="top" html-template="specificNetworkMessage" label="<cv:msg bundle="schedule" key="option.specificNetwork"/>" trigger="mouseenter"></cv-call-out></label>
				<div class="inline-wrapper">
					<div>
						<input type="text"
							class="ip-text-input"
							name="specificNetworkIpAddress" data-ng-model="model.specificNetworkIp"
							data-ng-disabled="!model.useSpecificNetwork" placeholder="___.___.___.___" />&nbsp;:&nbsp;
						<input type="number" min="0" name="specificNetwork" id="specificNetwork" data-ng-model="model.specificNetworkNumber" data-ng-disabled="!model.useSpecificNetwork"/>
					</div>
				</div>
			</div>
		</div>
		<!--//  Network Management end //-->
		<!--//  Power Management start //-->
		<div data-ng-if="model.freqType == 'AUTOMATIC_SCHEDULE'" data-ng-hide="model.backupLevel=='SYNTHETIC_FULL' || model.isVaultTrackerPlan">
			<h4><cv:msg key="label.powerManagement" bundle="schedule"/></h4>
			<div class="modal-wrapper">
				<input id="startOnAC" type="checkbox" name="startOnAC" value="startOnAC" data-ng-model="model.startOnlyOnAc" data-ng-change="model.changeStopTask()"/>
				<label for="startOnAC"><cv:msg bundle="schedule" key="option.startOnAC"/></label>
			</div>
			<div class="modal-wrapper">
				<input id="StopTask" type="checkbox" name="StopTask" value="StopTask" data-ng-model="model.stopIfBatteryMode" data-ng-disabled="!model.startOnlyOnAc"/>
				<label for="StopTask"><cv:msg bundle="schedule" key="option.stopTask"/></label>
			</div>
			<div class="modal-wrapper">
				<input id="preventSleep" type="checkbox" name="preventSleep" value="preventSleep"data-ng-model="model.preventSleep" />
				<label for="preventSleep" ><cv:msg bundle="schedule" key="option.preventSleep"/></label>
			</div>
		</div>
		<!--//  Power Management end //-->
		<!--//  Resource Utilization start //-->
		<div data-ng-if="model.freqType == 'AUTOMATIC_SCHEDULE'" data-ng-hide="model.backupLevel=='SYNTHETIC_FULL' || model.isVaultTrackerPlan">
			<h4><cv:msg key="label.resourceUtilization" bundle="schedule"/></h4>
			<div class="modal-wrapper">
				<input id="cpuBelowThresholdEnabled" type="checkbox" name="cpuBelowThresholdEnabled" value="cpuBelowThresholdEnabled" data-ng-model="model.cpuBelowThresholdEnabled" />
				<label for="cpuBelowThresholdEnabled" class="label extra-left-padding"><cv:msg bundle="schedule" key="option.cpuBelowThresholdEnabled"/></label>
				<div class="inline-wrapper">
					<div>
						<input type="number" min="0" name="cpuBelowThreshold" id="cpuBelowThreshold" data-ng-model="model.cpuBelowThreshold" data-ng-disabled="!model.cpuBelowThresholdEnabled"/>&nbsp;<label for="cpuBelowThreshold" class="inline-label"><cv:msg key="label.cpuBelowThreshold" bundle="schedule" /></label>
					</div>
				</div>
			</div>
		</div>
		<!--//  Resource Utilization end //-->
		<!--//  File Management start //-->
		<div data-ng-if="model.freqType == 'AUTOMATIC_SCHEDULE'" data-ng-hide="model.backupLevel=='SYNTHETIC_FULL'">
		<h4><cv:msg key="label.fileManagement" bundle="schedule"/></h4>
			<div class="modal-wrapper">
					<input id="startOnlyFileBackUp" type="checkbox" name="startOnlyFileBackUp" value="startOnlyFileBackUp" data-ng-model="model.startOnlyfileBackUp" />
					<label for="startOnlyFileBackUp"><cv:msg bundle="schedule" key="option.startOnlyFileBackUp"/></label>
			</div>
		</div>
		<!--//  File Management end //-->
		<!--// Synthetic Full Only //-->
		<div data-ng-if="model.freqType == 'AUTOMATIC_SCHEDULE' && model.backupLevel=='SYNTHETIC_FULL' && !model.isVaultTrackerPlan">
			<div class="modal-wrapper extra-top-spacing">
				<label for="daysBetweenSyntheticBackup" class="label wrap-normal"><cv:msg bundle="schedule" key="label.daysBetweenSyntheticBackup"/></label>
				<div class="inline-wrapper">
					<div>
						<input data-ng-if="!disablePrimaryRetentionDays" type="number" min="0" max="90" name="daysBetweenSyntheticBackup" id="daysBetweenSyntheticBackup" data-ng-model="model.daysBetweenSyntheticBackup" />
						<span data-ng-if="disablePrimaryRetentionDays">
							<span data-ng-if="model.daysBetweenSyntheticBackup <= 90">{{model.daysBetweenSyntheticBackup}}</span>
							<span data-ng-if="model.daysBetweenSyntheticBackup > 90">90</span>
						</span>
						<span class="help-block days-between-synthetic" data-ng-show="cv.addScheduleForm.needsAttention(addScheduleForm.daysBetweenSyntheticBackup)"><cv:msg key="error.daysBetweenSyntheticBackup" bundle="schedule"/></span>
					</div>
				</div>
			</div>
		</div>
		<!--//  Synthetic Full Only End//-->
		<!-- Repeat -->
		<div data-ng-if="model.freqType != 'AUTOMATIC_SCHEDULE' && model.freqType !== 'AFTER_JOB_COMPLETES'&& model.freqType != 'ONE_TIME' && !model.isVaultTrackerPlan">
			<h4 data-ng-if="!isSlaSchedule"><cv:msg key="label.repeat" bundle="schedule"/></h4>
			<h4 data-ng-if="isSlaSchedule"><cv:msg key="label.rpo" bundle="profiles"/></h4>
			<div class="modal-wrapper" data-ng-if="!isSlaSchedule">
				<label for="every" class="label"><cv:msg key="label.every" bundle="schedule"/></label>
				<div class="inline-wrapper">
					<input data-ng-if="model.freqType=='DAILY'" type="number" min="0" name="dayFrequency" id="dayFrequency" data-ng-model="model.repeat.duration"/><span data-ng-if="model.freqType=='DAILY'">&nbsp;</span><label data-ng-if="model.freqType=='DAILY'"  for="dayFrequency" class="inline-label"><cv:msg key="label.days" bundle="schedule" /></label>
					<input data-ng-if="model.freqType=='WEEKLY'" type="number" min="0" name="weekFrequency" id="weekFrequency" data-ng-model="model.repeat.duration"/><span data-ng-if="model.freqType=='WEEKLY'">&nbsp;</span><label data-ng-if="model.freqType=='WEEKLY'" for="weekFrequency" class="inline-label"><cv:msg key="label.weeks" bundle="schedule" /></label>
					<input data-ng-if="model.freqType=='MONTHLY'" type="number" min="0" name="monthFrequency" id="monthFrequency" data-ng-model="model.repeat.duration"/><span data-ng-if="model.freqType=='MONTHLY'">&nbsp;</span><label data-ng-if="model.freqType=='MONTHLY'" for="monthFrequency" class="inline-label"><cv:msg key="label.months" bundle="schedule" /></label>
					<input data-ng-if="model.freqType=='MONTHLY_RELATIVE'" type="number" min="0" name="monthRelativeFrequency" id="monthRelativeFrequency" data-ng-model="model.repeat.duration"/><span data-ng-if="model.freqType=='MONTHLY_RELATIVE'">&nbsp;</span><label data-ng-if="model.freqType=='MONTHLY_RELATIVE'" for="monthRelativeFrequency" class="inline-label"><cv:msg key="label.months" bundle="schedule" /></label>
				<!--   	<button id="addScheduleModal_button_#0602" type="button" class="btn btn-default" data-ng-click="openExceptionsModal()"><cv:msg key="label.exceptions" bundle="schedule"/></button>-->
			<!-- data-ng-if="false" --> 	<a data-ng-click="openExceptionsModal()" href="javascript:void(0);"><cv:msg key="label.exceptions" bundle="schedule"/></a>
				</div>
			</div>
			<div class="modal-wrapper" data-ng-if="!isSlaSchedule">
				<input id="repeat" type="checkbox" name="repeat" value="repeat" data-ng-model="model.repeat.enabled" />
				<label for="repeat" class="label extra-left-padding"><cv:msg bundle="schedule" key="label.repeat"/>&nbsp;<cv:msg bundle="schedule" key="label.every"/></label>
				<div class="inline-wrapper">
					<div>
						<input data-ng-disabled="!model.repeat.enabled" type="number" min="0" name="repeatHours" id="repeatHours" data-ng-model="model.repeat.hrs"/>&nbsp;<label for="repeatHours" class="inline-label schedule-repeat-label"><cv:msg key="label.hours" bundle="schedule" /></label>
						<input data-ng-disabled="!model.repeat.enabled" type="number" min="0" max="60" name="repeatMinutes" id="repeatMinutes" data-ng-model="model.repeat.mins"/>&nbsp;<label for="repeatMinutes" class="inline-label schedule-repeat-label"><cv:msg key="label.minutes" bundle="schedule" /></label>
					</div>
					<div>
						<label for="until" class="inline-label schedule-repeat-label"><cv:msg key="label.until" bundle="schedule" /></label>&nbsp;
						<div uib-timepicker data-ng-disabled="!model.repeat.enabled" id="repeatTime" name="repeatTime" data-ng-model="model.repeat.time"  hour-step="1" minute-step="15" show-meridian="true" show-spinners="false"></div>
						<span class="help-block repeat-time" data-ng-show="cv.addScheduleForm.needsAttention(addScheduleForm.repeatTime)"><cv:msg key="error.scheduleTime" bundle="schedule"/></span>
					</div>
				</div>
			</div>
			<div class="modal-wrapper" data-ng-if="isSlaSchedule">
				<label for="repeat" class="label"> <cv:msg key="label.rpo" bundle="profiles" /></label>
				<div class="inline-wrapper" >
					<span data-ng-show="model.freqType==='DAILY'">{{model.repeat.duration}}&nbsp;&nbsp; <cv:msg key="label.days" bundle="schedule" /></span>
					<span data-ng-show="model.freqType==='WEEKLY'">{{model.repeat.duration}}<span class="margin-left-10"><cv:msg key="label.weeks" bundle="schedule" /></span></span>
					<span data-ng-show="model.freqType==='MONTHLY' || model.freqType == 'MONTHLY_RELATIVE'">{{model.repeat.duration}}<span class="margin-left-10"><cv:msg key="label.incrementalRPOFreq.months" bundle="profiles" /></span></span>
					<span data-ng-show="model.freqType==='YEARLY' || model.freqType == 'YEARLY_RELATIVE'">1<span class="margin-left-10"><cv:msg key="label.incrementalRPOFreq.years" bundle="profiles" /></span></span>
					<span data-ng-show="model.freqType!=='DAILY' && model.freqType!=='WEEKLY' &&  model.freqType!=='MONTHLY' && model.freqType !== 'MONTHLY_RELATIVE' && model.freqType!=='YEARLY' && model.freqType !== 'YEARLY_RELATIVE'">{{model.repeat.hrs}}&nbsp;&nbsp;<cv:msg key="label.hours" bundle="schedule" /></span></label>
					<span class="help-block" style="top: 72%" data-ng-show="cv.addScheduleForm.needsAttention(addScheduleForm.rpoHours)"><cv:msg key="error.scheduleTime" bundle="schedule"/></span>
				</div>
			</div>
		</div>
		<!-- Repeat End -->
		<br /><br /></div>
		</div><!--//  scrolling div closes //-->
		<!-- One Time Schedule -->
		<div  data-ng-if="isOneTimeScheduleSupported && model.freqType == 'ONE_TIME'" id="full-width-calendar" class="date-time-picker">
			<label class="col-xs-12 col-sm-12 padding-bottom-10"><cv:msg key="label.selectDateAndTime" bundle="schedule" /></label>
			<div uib-datepicker data-ng-model="model.fromDate" class="date-picker" datepicker-options="model.options" ></div>
			<div class="modal-wrapper" >
				<label for="scheduleTime" data-ng-if="!model.context" class="label wrap-normal padding-top-30"><cv:msg key="label.clientTime" bundle="schedule"/></label>
				<label for="scheduleTime" data-ng-if="model.context === 'SCHEDULE_POLICY'" class="label wrap-normal padding-top-30"><cv:msg key="label.timeInAnyTimeZone" bundle="schedule"/></label>
				<div class="inline-wrapper">
					<div uib-timepicker id="scheduleTime" name="scheduleTime" data-ng-model="model.scheduleTime" hour-step="1" minute-step="15" show-meridian="true" show-spinners="false"></div>
				</div>
				<span class="help-block schedule-timer" data-ng-show="cv.addScheduleForm.needsAttention(addScheduleForm.scheduleTime)"><cv:msg key="error.scheduleTime" bundle="schedule"/></span>
			</div>
		</div>
		<div class="button-container">
			<button id="addScheduleModal_button_#5503" data-ng-disabled="nonBackupSchedule" type="button" class="btn btn-primary cvBusyOnAjax float-left" data-ng-if="model.opType == 'EDIT' && model.showEdit && !isSlaSchedule && !model.hideDelete" data-ng-click="deleteSchedule()"><cv:msg key="action.deleteSchedule" bundle="schedule"/></button> 
			<button id="addScheduleModal_button_#4772" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="cancel()"><cv:msg key="action.cancel" bundle="profiles"/></button> 
			<button id="addScheduleModal_button_#6833" type="submit" class="btn btn-primary cvBusyOnAjax" data-ng-if="model.showEdit"><cv:msg key="action.save" bundle="profiles"/></button> 
		</div>
	</form>
</div>
