<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}">
	<cv:cvMessages bundle="localization.reports"></cv:cvMessages>
</script>
<div data-ng-controller="orchestrationReplicationStatsController as repStatsPane">
	<div class="replicationStats">
		<div class="dash-pane">
			<div class="dash-pane-wrapper">
				<cv-reports-pane-header data-title="repStatsPane.replicationStats.paneData.title">
				</cv-reports-pane-header>
				<cv-reports-show-loader show-loader="repStatsPane.replicationStats.paneData.showLoader"></cv-reports-show-loader>
				<div data-ng-if="repStatsPane.rpo.showRPO">
					<div class="col-xs-12 col-sm-3 col-md-2">
						<div class="dash-pane-content sla-content">
							<div>
								<div class="sla-chart-title"><cv:msg key="sla.label.rpo" bundle="reports" /></div>
								<highchart config="repStatsPane.rpo.config"></highchart>
							</div>
							<div class="custom-legend-wrapper">
								<span class="custom-legend">
									<span class="legend-box background-color-success"></span>
									<span class="legend-name"><cv:msg key="sla.label.met" bundle="reports" /></span>
									<span class="legend-val" data-ng-bind="repStatsPane.rpoLegend.rpomet"></span>
								</span>
								<span class="custom-legend">
									<span class="legend-box background-color-critical"></span>
									<span class="legend-name"><cv:msg key="sla.label.missed" bundle="reports" /></span>
									<span class="legend-val" data-ng-bind="repStatsPane.rpoLegend.rponotmet"></span>
								</span>
							</div>
						</div>
					</div>
				</div>
				<div class="col-xs-12 col-sm-9 col-md-10">
					<cv-reports-pane-entity 
						data-ng-if="repStatsPane.replicationStats.paneData.entities.length > 0" 
						entities="repStatsPane.replicationStats.paneData.entities">
					</cv-reports-pane-entity>
				</div>
				<div class="col-xs-12 col-sm-12">
					<cv-reports-no-data 
						data-ng-if="repStatsPane.replicationStats.paneData.noData" 
						no-data="repStatsPane.replicationStats.paneData.noData">
					</cv-reports-no-data>
				</div>
			</div>
		</div>
	</div>
</div>