<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.reports"></cv:cvMessages>
</script>

<div class="new-dashboard-modal" data-ng-class='{"new-mode":!cloneMode}'>
	<div class="modal-header">
		<h1>
		  <label>{{modalOptions.headerText}}
			<cv-help-component help-text='{{modalOptions.headerInfo}}'></cv-help-component>
		</label>
		</h1>
	</div>
	<div class="modal-body">
		<div>
			<label class="modal-label" for="dashboardName"><cv:msg key='dashboard.nameDashboard' bundle='reports'/></label>
			<div class="modal-value">
				<input
					name="dashboardName"
					id="dashboardName"
					type="text"
					placeholder="<cv:msg key='dashboard.enterDashboardName' bundle='reports'/>"
					data-ng-model="model.dashboardName"
					maxlength="60"
					data-ng-keypress="validateNameInput($event)"
					data-ng-click="nameError=false"	/>
					<span class="help-block" data-ng-class="{'input-error': nameError}"><cv:msg key="dashboard.error.dashboardName" bundle="reports"/></span>
			</div>
		</div>
		<div data-ng-if="!cloneMode">
			<label class="modal-label">
				<cv-help-text help-label="<cv:msg key="dashboard.dashboardToClone" bundle="reports" />" help-text="'<cv:msg key='dashboard.newDashNote' bundle='reports' />'">
				</cv-help-text>
			</label>
			<div class="modal-value">
				<isteven-multi-select id="newDashboardModal_isteven-multi-select_{{$id}}"
								input-model="model.defaultDashboards"
								output-model="model.selectedDashboard"
								button-label="title"
								item-label="title"
								name="dashboardList"
								translation="model.dropdownLocal"
								tick-property="selected"
								class="isteven-multi-select user-group-select"
								selection-mode="single"
								helper-elements="filter"
								on-item-click="dashboardError=false"
								required = "true">
				</isteven-multi-select>
				<span class="help-block" data-ng-class="{'input-error': dashboardError}"><cv:msg key="dashboard.selectDashboard" bundle="reports"/></span>
			</div>
		</div>
	</div>

	<div class="modal-footer">
		<button  type="button" class="btn btn-default" data-ng-click="modalOptions.close()">
	  		{{modalOptions.cancelButtonText}}
  		</button>
  		<button class="btn btn-primary " data-ng-click="modalOptions.cloneDashboard();">
  			{{modalOptions.okButtonText}}
		</button>
	</div>
</div>


