<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.reports"></cv:cvMessages>
</script>
<fmt:bundle basename="localization.reports">
<div class="need-attention-detail server-detail" data-ng-controller="NeedsAttentionServersController as ctrl" >
	<h2><fmt:message key="servers.detail.title"/></h2>
	<div class="detail-row row" data-ng-repeat="server in ctrl.data.servers">
		<div class="col-lg-2 col-md-2 col-sm-6">
				<div class="entity-name server-name" data-ng-class="{'big-row': server.anomalyDetails.length > 2, 'two-rows': server.anomalyDetails.length == 2}" title="{{server.entity.clientName}}"><img data-ng-src="{{ctrl.serverImg}}"/><a data-ng-href="{{server.detailsLink}}" >{{server.entity.clientName}}</a></div>
		</div>
		<div class="col-lg-10 col-md-10 col-sm-6 detail-wrapper">
			<table>
				<tbody>
					<tr data-ng-repeat="detail in server.anomalyDetails">
						<td class="col-lg-3 col-md-3 col-sm-3">
							<label class="prop-label server-prop-label"><fmt:message key="servers.detail.reason"/></label>
							<label class="prop-value server-prop-value">{{detail.reason}}</label>
						</td>
						<td class="prop-value col-lg-4 col-md-3 col-sm-3">
							<label class="prop-label server-prop-label">{{detail.countLabel}}</label>
							<label  data-ng-if="detail.drillURL" class="prop-value server-prop-value"><a href="{{detail.drillURL}}">{{detail.formattedCount}}</a></label>
							<label  data-ng-if="!detail.drillURL" class="prop-value server-prop-value">{{detail.formattedCount}}</label>
						</td>
					</tr>
				</tbody>
			</table>
		</div>
	</div>
	<cv-reports-show-loader show-loader="ctrl.data.showLoader"></cv-reports-show-loader>
	<cv-reports-no-data data-ng-if="ctrl.data.noData" no-data="ctrl.data.noData"></cv-reports-no-data>
</div>
</fmt:bundle>